<?php
/**
 * This file is used to markup the quick view modal.
 *
 * This template can be overridden by copying it to yourtheme/xt-woo-quick-view/parts/product.php.
 *
 * HOWEVER, on occasion we will need to update template files and you (the theme developer).
 * will need to copy the new files to your theme to maintain compatibility. We try to do this.
 * as little as possible, but it does happen. When this occurs the version of the template file will.
 * be bumped and the readme will list any important changes.
 *
 * @see         https://docs.xplodedthemes.com/article/127-template-structure
 * @author 		XplodedThemes
 * @package     XT_Woo_Quick_View/Templates
 * @version     1.0.0
 */
 
if ( ! defined( 'ABSPATH' ) ) {
	exit; // Exit if accessed directly
}

$variation_id = !empty($variation_id) ? $variation_id : null;
?>

<div id="xt_wooqv-product-<?php the_ID(); ?>" <?php post_class('product xt_wooqv-product'); ?>>

    <span class="<?php echo xt_wooqv_modal_close_icon_class();?>"></span>
    <span class="<?php echo xt_wooqv_modal_close_icon_class(true);?>"></span>
	<?php xt_woo_quick_view()->get_template('parts/product-slider', array('variation_id' => $variation_id)); ?>
	<?php xt_woo_quick_view()->get_template('parts/product-info'); ?>

	<?php
        $id            = $product->get_id();
        $nome          = $product->get_name(); // Nome do produto
        $regular_price = $product->get_regular_price();
        $sale_price    = $product->get_sale_price();
        $sku           = $product->get_sku(); // SKU do produto
        $estoque       = $product->get_stock_quantity(); // Quantidade em estoque

        $txt = '';
        $txt .= '<div class="info-produto hidden">';

        $txt .= '<small class="attr attr-product-id">' .$id . '</small>';
        $txt .= '<small class="attr attr-product-regular-price">' . $regular_price . '</small>';
        $txt .= '<small class="attr attr-product-sale-price">' . $sale_price . '</small>';

        $txt .= '</div>';

        echo $txt;
    ?>

</div>

