<?php

/**
 * This file is used to markup the cart list no product items.
 *
 * This template can be overridden by copying it to yourtheme/xt-woo-floating-cart/parts/cart/list/empty.php.
 *
 * HOWEVER, on occasion we will need to update template files and you (the theme developer).
 * will need to copy the new files to your theme to maintain compatibility. We try to do this.
 * as little as possible, but it does happen. When this occurs the version of the template file will.
 * be bumped and the readme will list any important changes.
 *
 * @see         https://docs.xplodedthemes.com/article/127-template-structure
 * @author 		XplodedThemes
 * @package     XT_Woo_Floating_Cart/Templates
 * @version     1.0.0
 */

if ( ! defined( 'ABSPATH' ) ) {
	exit; // Exit if accessed directly
}
?>

<li class="xt_woofc-no-product">
	<?php esc_html_e( 'Your cart is empty!', 'woo-floating-cart' ); ?>
    <a href="<?php echo esc_url(get_permalink( wc_get_page_id( 'shop' ) )); ?>">
        <?php esc_html_e( 'Return to shop', 'woo-floating-cart' ); ?>
    </a>
</li>