<?php
// INCLUIR CONFIGURAÇÃO DO WP
require_once __DIR__ . '/../wp-config.php';

// CONECTAR USANDO CONSTANTES DO WP
$conn = new mysqli(DB_HOST, DB_USER, DB_PASSWORD, DB_NAME);
if ($conn->connect_error) {
    die('Erro na conexão: ' . $conn->connect_error);
}

// PEGAR PARÂMETROS
$sku_param = isset($_GET['sku']) ? trim($_GET['sku']) : '';

if (empty($sku_param)) {
    die('Erro: Informe os parâmetros ?sku=SKU1;SKU2');
}

// PROCESSAR CADA SKU
$skus = array_filter(array_map('trim', explode(';', $sku_param)));

if (empty($skus)) {
    die("Erro: Nenhum SKU válido informado.");
}

$resultados = [];
$nao_encontrados = [];

foreach ($skus as $sku) {
    // Buscar post_id pelo SKU
    $sql = "
        SELECT post_id FROM wp_postmeta
        WHERE meta_key = '_sku' AND meta_value = ?
        LIMIT 1
    ";
    $stmt = $conn->prepare($sql);
    $stmt->bind_param('s', $sku);
    $stmt->execute();
    $result = $stmt->get_result();

    if ($result->num_rows === 0) {
        $nao_encontrados[] = $sku;
        continue;
    }

    $post_id = $result->fetch_assoc()['post_id'];

    // Obter nome do produto
    $sql_title = "SELECT post_title FROM wp_posts WHERE ID = ?";
    $stmt_title = $conn->prepare($sql_title);
    $stmt_title->bind_param('i', $post_id);
    $stmt_title->execute();
    $result_title = $stmt_title->get_result();
    $product_name = $result_title->fetch_assoc()['post_title'] ?? '(sem nome)';

    // Obter o status atual
    $sql_status = "
        SELECT meta_value FROM wp_postmeta
        WHERE post_id = ? AND meta_key = '_stock_status'
        LIMIT 1
    ";
    $stmt_status = $conn->prepare($sql_status);
    $stmt_status->bind_param('i', $post_id);
    $stmt_status->execute();
    $result_status = $stmt_status->get_result();
    $stock_status = $result_status->fetch_assoc()['meta_value'] ?? '(desconhecido)';

    $resultados[] = [
        'sku' => $sku,
        'nome' => $product_name,
        'status' => $stock_status
    ];
}

// RESPOSTA
echo "<strong>Estoque atual:</strong><br><br>";

if (!empty($resultados)) {
    foreach ($resultados as $item) {
        echo "SKU: <strong>{$item['sku']}</strong> | Nome: <em>{$item['nome']}</em> | Status: <code>{$item['status']}</code><br>";
    }
    echo "<br>";
}

if (!empty($nao_encontrados)) {
    echo "❌ Não encontrados:<br>" . implode('<br>', $nao_encontrados);
}

$conn->close();
?>