<?php
header('Content-Type: application/json');
require_once __DIR__ . '/../wp-load.php';

$conn = new mysqli(DB_HOST, DB_USER, DB_PASSWORD, DB_NAME);
if ($conn->connect_error) {
    echo json_encode(['erro' => 'Erro na conexão com o banco de dados']);
    exit;
}

$sku_param = isset($_GET['sku']) ? trim($_GET['sku']) : '';
$status    = isset($_GET['status']) ? trim($_GET['status']) : '';

if (empty($sku_param) || empty($status)) {
    echo json_encode(['erro' => 'Parâmetros "sku" e "status" são obrigatórios']);
    exit;
}

$valores_validos = ['instock', 'onbackorder', 'outofstock'];
if (!in_array($status, $valores_validos)) {
    echo json_encode(['erro' => 'Status inválido. Use instock, onbackorder ou outofstock']);
    exit;
}

$skus = array_filter(array_map('trim', explode(';', $sku_param)));
if (empty($skus)) {
    echo json_encode(['erro' => 'Nenhum SKU válido informado']);
    exit;
}

$atualizados = [];
$nao_encontrados = [];

foreach ($skus as $sku) {
    $sql = "SELECT post_id FROM wp_postmeta WHERE meta_key = '_sku' AND meta_value = ? LIMIT 1";
    $stmt = $conn->prepare($sql);
    $stmt->bind_param('s', $sku);
    $stmt->execute();
    $result = $stmt->get_result();

    if ($result->num_rows === 0) {
        $nao_encontrados[] = $sku;
        continue;
    }

    $post_id = $result->fetch_assoc()['post_id'];

    $sql_title = "SELECT post_title FROM wp_posts WHERE ID = ?";
    $stmt_title = $conn->prepare($sql_title);
    $stmt_title->bind_param('i', $post_id);
    $stmt_title->execute();
    $result_title = $stmt_title->get_result();
    $product_name = $result_title->fetch_assoc()['post_title'] ?? '(sem nome)';

    $sql_update = "UPDATE wp_postmeta SET meta_value = ? WHERE post_id = ? AND meta_key = '_stock_status'";
    $stmt_update = $conn->prepare($sql_update);
    $stmt_update->bind_param('si', $status, $post_id);
    $stmt_update->execute();

    if (function_exists('w3tc_pgcache_flush_post')) {
        w3tc_pgcache_flush_post($post_id);
    }

    $atualizados[] = [
        'sku' => $sku,
        'nome' => $product_name,
        'status' => $status
    ];
}

$response = [
    'status' => 'ok',
    'atualizados' => $atualizados,
    'nao_encontrados' => $nao_encontrados
];

echo json_encode($response);
$conn->close();
?>
