<?php
// INCLUIR WORDPRESS COMPLETO PARA USAR w3tc_pgcache_flush_post
require_once __DIR__ . '/../wp-load.php';

// CONECTAR USANDO CONSTANTES DO WP
$conn = new mysqli(DB_HOST, DB_USER, DB_PASSWORD, DB_NAME);
if ($conn->connect_error) {
    die('Erro na conexão: ' . $conn->connect_error);
}

// PEGAR PARÂMETROS
$sku_param = isset($_GET['sku']) ? trim($_GET['sku']) : '';
$status    = isset($_GET['status']) ? trim($_GET['status']) : '';

// VALIDAR
if (empty($sku_param) || empty($status)) {
    die('Erro: Informe os parâmetros ?sku=SKU1;SKU2&status=instock|outofstock|onbackorder');
}

$valores_validos = ['instock', 'onbackorder', 'outofstock'];
if (!in_array($status, $valores_validos)) {
    die("Erro: status inválido. Use apenas: " . implode(', ', $valores_validos));
}

// PROCESSAR CADA SKU
$skus = array_filter(array_map('trim', explode(';', $sku_param)));

if (empty($skus)) {
    die("Erro: Nenhum SKU válido informado.");
}

$atualizados = [];
$nao_encontrados = [];

foreach ($skus as $sku) {
    // Buscar post_id pelo SKU
    $sql = "
        SELECT post_id FROM wp_postmeta
        WHERE meta_key = '_sku' AND meta_value = ?
        LIMIT 1
    ";
    $stmt = $conn->prepare($sql);
    $stmt->bind_param('s', $sku);
    $stmt->execute();
    $result = $stmt->get_result();

    if ($result->num_rows === 0) {
        $nao_encontrados[] = $sku;
        continue;
    }

    $post_id = $result->fetch_assoc()['post_id'];

    // Obter nome do produto
    $sql_title = "SELECT post_title FROM wp_posts WHERE ID = ?";
    $stmt_title = $conn->prepare($sql_title);
    $stmt_title->bind_param('i', $post_id);
    $stmt_title->execute();
    $result_title = $stmt_title->get_result();
    $product_name = $result_title->fetch_assoc()['post_title'] ?? '(sem nome)';

    // Atualizar o status
    $sql_update = "
        UPDATE wp_postmeta
        SET meta_value = ?
        WHERE post_id = ? AND meta_key = '_stock_status'
    ";
    $stmt_update = $conn->prepare($sql_update);
    $stmt_update->bind_param('si', $status, $post_id);
    $stmt_update->execute();

    // LIMPAR CACHE DO PRODUTO SE POSSÍVEL
    if (function_exists('w3tc_pgcache_flush_post')) {
        w3tc_pgcache_flush_post($post_id);
    }

    $atualizados[] = [
        'sku' => $sku,
        'nome' => $product_name,
        'status' => $status
    ];
}

// RESPOSTA
echo "<strong>Status aplicado:</strong> <code>$status</code><br><br>";

if (!empty($atualizados)) {
    echo "✅ Atualizados:<br>";
    foreach ($atualizados as $item) {
        echo "SKU: <strong>{$item['sku']}</strong> | Nome: <em>{$item['nome']}</em> | Status: <code>{$item['status']}</code><br>";
    }
    echo "<br>";
}

if (!empty($nao_encontrados)) {
    echo "❌ Não encontrados:<br>" . implode('<br>', $nao_encontrados);
}

$conn->close();
?>
