<?php

libxml_use_internal_errors(true);

function get_currency_variants($url) {
	$parsed_url = parse_url($url);
	$currency_params = ['USD', 'BRL'];
	$variants = [];

	foreach ($currency_params as $currency) {
		if (isset($parsed_url['query']) && $parsed_url['query']) {
			$variants[] = $url . '&currency=' . $currency;
		} else {
			$variants[] = $url . '?currency=' . $currency;
		}
	}

	return $variants;
}

function crawl_page(
	$url_start,
	$arr_ignore_href,
	$arr_ignore_class,
	$url,
	$depth = 5,
	$initial = true
) {
	static $seen = [];

	if (isset($seen[$url])) {
		return;
	}
	$seen[$url] = true;

	echo '<a href="'. $url .'" target="_blank" >' . $url . '</a><br>';

	$arr_context_options = [
		"ssl"=>[
			"verify_peer"=>false,
			"verify_peer_name"=>false,
		],
	];

// 	$url_variants = get_currency_variants( $url );

// 	foreach ( $url_variants as $url_2 ) {

// 		echo '<a href="'. $url_2 .'" target="_blank" >' . $url_2 . '</a><br>';

// 		$html2 = @file_get_contents($url_2, false, stream_context_create($arr_context_options));
// 	}

	$html = @file_get_contents($url, false, stream_context_create($arr_context_options));
	if ($html === false) {
		echo '<span style="color:red;">Erro ao acessar: ' . $url . '</span><br>';
		return;
	}

	$dom = new DOMDocument('1.0');
	@$dom->loadHTML($html);

	$anchors = $dom->getElementsByTagName('a');
	$options = $dom->getElementsByTagName('option');

	$elements = [];
	foreach ($anchors as $element) $elements[] = $element;
	foreach ($options as $option) $elements[] = $option;

	if (--$depth < 0) return;

	foreach ($elements as $element) {
		$href  = $element->getAttribute('href');
		$value = $element->getAttribute('value');
		$class = $element->getAttribute('class');
		$href = !empty($href) ? $href : $value;

		if (!$href || strpos($href, 'javascript:') === 0) continue;

		// Corrigir hrefs relativas
		if (strpos($href, 'http') !== 0) {
			$path = '/' . ltrim($href, '/');

			$parts = parse_url($url);
			$href = $parts['scheme'] . '://';
			if (isset($parts['user'], $parts['pass'])) {
				$href .= $parts['user'] . ':' . $parts['pass'] . '@';
			}
			$href .= $parts['host'];
			if (isset($parts['port'])) {
				$href .= ':' . $parts['port'];
			}
			if (!empty($parts['path'])) {
				$href .= dirname($parts['path'], 1);
			}
			$href .= $path;
		}

		if (strpos($href, $url_start) === false) continue;

		$is_ignore = false;

		foreach ($arr_ignore_href as $ignore) {
			if (strpos($href, $ignore) !== false) {
				$is_ignore = true;
				break;
			}
		}

		foreach ($arr_ignore_class as $ignore) {
			if (strpos($class, $ignore) !== false) {
				$is_ignore = true;
				break;
			}
		}

		if ($is_ignore) continue;

		if ( !isset( $seen[$href] ) ) {
			crawl_page(
				$url_start,
				$arr_ignore_href,
				$arr_ignore_class,
				$href,
				$depth,
				false
			);
		}
	}
}

// CONFIGURAÇÕES
$url_base = 'https://catalogo.movingfitness.com.br/';
// $url_base = 'http://127.0.0.1:7433/moving_catalogo/dev/';


$configs = [
	[
		'url_start' => "{$url_base}",
		'url'       => "{$url_base}",
		'depth'     => 2
	],
	[
		'url_start' => "{$url_base}catalog/page/",
		'url'       => "{$url_base}catalog/",
		'depth'     => 40
	],
	[
		'url_start' => "{$url_base}catalog/cat/all-categories/",
		'url'       => "{$url_base}catalog/cat/all-categories/",
		'depth'     => 100
	],
	[
		'url_start' => "{$url_base}catalog/tag/",
		'url'       => "{$url_base}catalog/",
		'depth'     => 2
	]
];

$arr_ignore_href = [
	'?add-to-cart',
	'purchase',
	'#',
	'mailto:',
	'wp-content',
	'edit-account',
	'wp-admin'
];

$arr_ignore_class = [
	'woocommerce-loop-product__link',
	'init-quick-view',
	'xt_wooqv-trigger'
];

foreach ($configs as $config) {
	$tempo_inicial = microtime(true);

	crawl_page(
		$config['url_start'],
		$arr_ignore_href,
		$arr_ignore_class,
		$config['url'],
		$config['depth']
	);

	$tempo_final = microtime(true);
	$tempo_total = $tempo_final - $tempo_inicial;

	echo '<br>Processado em: ' . round($tempo_total, 2) . ' segundos (' . round($tempo_total/60, 2) . ' minutos)<br>';
}

?>
